/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows;

import java.sql.Connection;
import java.util.logging.Level;
import oracle.dbtools.extension.rcv.check.CheckResult;
import oracle.dbtools.extension.rcv.check.onboarding.EncryptionWalletCheck;
import oracle.dbtools.extension.rcv.commands.RCVCommand;
import oracle.dbtools.extension.rcv.commands.RCVOptions;
import oracle.dbtools.extension.rcv.workflows.ConfigureRMANWorkflow;
import oracle.dbtools.extension.rcv.workflows.ProtectedDatabaseWorkflow;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.Status;
import oracle.dbtools.extension.rcv.workflows.WorkflowLogger;
import oracle.dbtools.extension.rcv.workflows.fetchtask.FetchTaskWorkflow;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;

public class BackupProtectedDatabaseWorkflow
extends ProtectedDatabaseWorkflow {
    int level = 1;
    private ParsedCommand command;

    public BackupProtectedDatabaseWorkflow(ParsedCommand command, Connection conn, ScriptRunnerContext ctx) {
        super(RCVCommand.SubCommand.BACKUP_DATABASE, conn, ctx);
        this.command = command;
    }

    @Override
    public void initState() {
        if (this.command.getOptionValue((Id)RCVOptions.Options.LEVEL) != null) {
            this.level = (Integer)this.command.getOptionValue((Id)RCVOptions.Options.LEVEL);
        }
    }

    @Override
    public Result run(boolean verbose) {
        WorkflowLogger logger = this.getWorkflowLogger();
        if (verbose) {
            logger.info("Log file: " + logger.getLogFile());
        }
        this.initState();
        EncryptionWalletCheck walletCheck = new EncryptionWalletCheck(this.getConnection(), this.getContext());
        walletCheck.setLogger(logger);
        CheckResult checkResult = walletCheck.run();
        if (checkResult.getStatus().equals((Object)CheckResult.Status.FAIL)) {
            if (checkResult.getActionPlan() != null) {
                logger.log(Level.FINE, checkResult.getActionPlan());
            }
            return new Result(Status.FAILED, checkResult.getMessage());
        }
        Result result = this.setBackupFlag();
        if (result.getStatus().equals((Object)Status.FAILED)) {
            return result;
        }
        return this.takeBackup();
    }

    private Result setBackupFlag() {
        WorkflowLogger logger = this.getWorkflowLogger();
        String configName = this.level == 0 ? "backup_level_zero_database" : "backup_level_one_database";
        String configValue = "true";
        ConfigureRMANWorkflow configureRMANWorkflow = new ConfigureRMANWorkflow.Builder(configName, configValue).fetchLatestConfig(true).build(this.getConnection());
        configureRMANWorkflow.setLogger(logger);
        return configureRMANWorkflow.runWithLock(false);
    }

    private Result takeBackup() {
        Connection conn = this.getConnection();
        WorkflowLogger logger = this.getWorkflowLogger();
        FetchTaskWorkflow fetchTaskWorkflow = new FetchTaskWorkflow(conn, this.getContext(), false, false);
        fetchTaskWorkflow.setLogger(logger);
        return fetchTaskWorkflow.runWithLock(false);
    }
}

