/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.utils;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.ArrayList;
import oracle.dbtools.extension.rcv.models.RMANScript;
import oracle.dbtools.extension.rcv.utils.Utils;

public class ScriptFactory {
    public static boolean shouldCreateScript(Script script, String scriptsDirectory) {
        String scriptPath = String.join((CharSequence)File.separator, scriptsDirectory, script.scriptName);
        File scriptFile = new File(scriptPath);
        try {
            return !scriptFile.exists() || !Utils.getMD5Sum(scriptPath).equals(script.md5sum);
        }
        catch (IOException | NoSuchAlgorithmException e) {
            return true;
        }
    }

    public static RMANScript generateScriptFromClob(String scriptPath, Clob content) throws IOException, SQLException {
        Utils.createParentDirectoryForFile(scriptPath);
        Reader reader = content.getCharacterStream();
        try (FileWriter writer = new FileWriter(scriptPath);){
            int bytesRead;
            char[] buffer = new char[8192];
            while ((bytesRead = reader.read(buffer)) != -1) {
                writer.write(buffer, 0, bytesRead);
            }
        }
        reader.close();
        return new RMANScript(scriptPath);
    }

    public static RMANScript generateRegisterDatabaseScript(String scriptsDirectory) throws IOException {
        String scriptPath = String.join((CharSequence)File.separator, scriptsDirectory, Script.REGISTER_DATABASE.scriptName);
        if (ScriptFactory.shouldCreateScript(Script.REGISTER_DATABASE, scriptsDirectory)) {
            Utils.createParentDirectoryForFile(scriptPath);
            try (FileWriter fWriter = new FileWriter(scriptPath);){
                fWriter.write("set event for resync_option to 2;\n");
                fWriter.write("register database;\n");
            }
        }
        return new RMANScript(scriptPath);
    }

    public static RMANScript generateArchivedRedoLogsBackupScript(String scriptsDirectory) throws IOException {
        String scriptPath = String.join((CharSequence)File.separator, scriptsDirectory, Script.ARCHIVED_REDO_LOG_BACKUP.scriptName);
        File script = new File(scriptPath);
        if (!script.exists()) {
            try (FileWriter fWriter = new FileWriter(scriptPath);){
                fWriter.write("RUN {\n");
                fWriter.write(String.format("ALLOCATE CHANNEL 'T0' DEVICE TYPE 'SBT_TAPE' PARMS \"SBT_LIBRARY=%s, ENV=(RA_WALLET='location=file:%s credential_alias=%s',RA_FORMAT=TRUE)\";\n", "&1", "&2", "&3"));
                fWriter.write("BACKUP AS BACKUPSET ARCHIVELOG ALL NOT BACKED UP  FILESPERSET 1;\n");
                fWriter.write("}\n");
            }
        }
        return new RMANScript(scriptPath);
    }

    public static RMANScript generateControlFileBackupScript(String scriptsDirectory) throws IOException {
        String scriptPath = String.join((CharSequence)File.separator, scriptsDirectory, Script.CONTROLFILE_BACKUP.scriptName);
        if (ScriptFactory.shouldCreateScript(Script.CONTROLFILE_BACKUP, scriptsDirectory)) {
            Utils.createParentDirectoryForFile(scriptPath);
            try (FileWriter fWriter = new FileWriter(scriptPath);){
                fWriter.write("SET EVENT FOR RESYNC_OPTION TO 2;\n");
                fWriter.write("SET ENCRYPTION ON;\n");
                fWriter.write("RUN {\n");
                fWriter.write(String.format("ALLOCATE CHANNEL 'T0' DEVICE TYPE 'SBT_TAPE' PARMS \"SBT_LIBRARY=%s, ENV=(RA_WALLET='location=file:%s credential_alias=%s',RA_FORMAT=TRUE)\";\n", "&1", "&2", "&3"));
                fWriter.write("BACKUP CURRENT CONTROLFILE;\n");
                fWriter.write("}\n");
            }
        }
        return new RMANScript(scriptPath);
    }

    public static RMANScript generateSpfileBackupScript(String scriptsDirectory) throws IOException {
        String scriptPath = String.join((CharSequence)File.separator, scriptsDirectory, Script.SPFILE_BACKUP.scriptName);
        File script = new File(scriptPath);
        if (!script.exists()) {
            try (FileWriter fWriter = new FileWriter(scriptPath);){
                fWriter.write("RUN {\n");
                fWriter.write(String.format("ALLOCATE CHANNEL 'T0' DEVICE TYPE 'SBT_TAPE' PARMS \"SBT_LIBRARY=%s, ENV=(RA_WALLET='location=file:%s credential_alias=%s',RA_FORMAT=TRUE)\";\n", "&1", "&2", "&3"));
                fWriter.write("BACKUP SPFILE;\n");
                fWriter.write("}\n");
            }
        }
        return new RMANScript(scriptPath);
    }

    public static RMANScript generateShowEncryptionRMANScript(String scriptsDirectory) throws IOException {
        String scriptPath = String.join((CharSequence)File.separator, scriptsDirectory, Script.SHOW_ENCRYPTION.scriptName);
        if (ScriptFactory.shouldCreateScript(Script.SHOW_ENCRYPTION, scriptsDirectory)) {
            Utils.createParentDirectoryForFile(scriptPath);
            FileWriter fWriter = new FileWriter(scriptPath);
            fWriter.write("RUN {\n");
            fWriter.write("show encryption for database;\n");
            fWriter.write("}\n");
            fWriter.close();
        }
        return new RMANScript(scriptPath);
    }

    public static String generateCreateSysbackupScript(String scriptsDirectory) {
        String scriptPath = String.join((CharSequence)File.separator, scriptsDirectory, Script.CREATE_SYSBACKUP.scriptName);
        if (ScriptFactory.shouldCreateScript(Script.CREATE_SYSBACKUP, scriptsDirectory)) {
            Utils.createParentDirectoryForFile(scriptPath);
            ArrayList<String> lines = new ArrayList<String>();
            lines.add("DECLARE");
            lines.add("v_db_unique_name    VARCHAR(30);");
            lines.add("v_username          VARCHAR(128);");
            lines.add("v_user_exists       NUMBER := 0;");
            lines.add("v_is_multitenant    VARCHAR2(3) := 'NO';");
            lines.add("BEGIN\n");
            lines.add("SELECT UPPER(db_unique_name) INTO v_db_unique_name FROM v$database;");
            lines.add("IF v_db_unique_name != UPPER('&&db_unique_name')");
            lines.add("THEN");
            lines.add("     RAISE_APPLICATION_ERROR(-20001, 'DB_UNIQUE_NAME does not match');");
            lines.add("END IF;");
            lines.add("SELECT DECODE(COUNT(*), 0, 'NO', 'YES') INTO v_is_multitenant FROM V$PDBS;");
            lines.add("IF v_is_multitenant = 'YES' THEN v_username := 'c##' || '&&username';");
            lines.add("ELSE v_username := '&&username';");
            lines.add("END IF;");
            lines.add("SELECT COUNT(*) INTO v_user_exists FROM ALL_USERS WHERE USERNAME = UPPER(v_username);");
            lines.add("IF v_user_exists > 0 THEN");
            lines.add("\tEXECUTE IMMEDIATE 'ALTER USER ' || v_username || ' IDENTIFIED BY \"&&password\"';");
            lines.add("ELSE");
            lines.add("EXECUTE IMMEDIATE 'CREATE USER ' || v_username || ' IDENTIFIED BY \"&&password\"';");
            lines.add("END IF;");
            lines.add("EXECUTE IMMEDIATE 'GRANT SYSBACKUP TO ' || v_username;");
            lines.add("EXECUTE IMMEDIATE 'GRANT CONNECT TO ' || v_username;");
            lines.add("EXCEPTION WHEN OTHERS");
            lines.add("          THEN");
            lines.add("          DBMS_OUTPUT.PUT_LINE('An error occurred: ' || SQLERRM);");
            lines.add("          RAISE;");
            lines.add("END;");
            lines.add("/");
            lines.add("exit;");
            try (BufferedWriter writer = Files.newBufferedWriter(Paths.get(scriptPath, new String[0]), StandardCharsets.UTF_8, new OpenOption[0]);){
                for (String line : lines) {
                    writer.write(line);
                    writer.newLine();
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create sql script to create sysbackup user.", e);
            }
        }
        return scriptPath;
    }

    public static enum Script {
        ARCHIVED_REDO_LOG_BACKUP("backup_archived_redo_logs.rman", ""),
        CONTROLFILE_BACKUP("backup_controlfile.rman", "94a42fbc596cd02d5bfd6719d4a6b861"),
        CREATE_SYSBACKUP("create_sysbackup_user.sql", "13cbe98d8d540df930d5968f508f9e68"),
        REGISTER_DATABASE("register_database.rman", "76ae5ca3511aeff791c858dbbbf459a6"),
        SPFILE_BACKUP("backup_spfile.rman", "4dc71ea1128608266cb0412b91fd5e91"),
        SHOW_ENCRYPTION("show_encryption.rman", "b26080a835790ed1d2974fa1a1703901");

        private String scriptName;
        private String md5sum;

        private Script(String scriptName, String md5sum) {
            this.scriptName = scriptName;
            this.md5sum = md5sum;
        }
    }
}

