/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.utils;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import oracle.dbtools.extension.rcv.models.commandengine.FleetEngineRequest;
import oracle.dbtools.extension.rcv.models.commandengine.FleetEngineResponse;
import oracle.dbtools.extension.rcv.models.commandengine.UpdateActionStatusRequest;
import oracle.dbtools.extension.rcv.models.database.Database;
import oracle.dbtools.extension.rcv.models.database.FleetAgentContext;
import oracle.dbtools.extension.rcv.models.database.ProtectedDatabaseCache;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.jdbc.datasource.impl.OracleDataSource;

public class FleetEngine {
    private static final String DBMS_RA_CMD_ENGINE = "dbms_ra_cmd_engine";
    private static final String INIT = "dbms_ra_cmd_engine.init(?, ?, ?, ?, ?)";
    private static final String CONFIGURE = "dbms_ra_cmd_engine.configure(?, ?, ?, ?)";
    private static final String CONFIGURE_WALLET_LOCATION = "dbms_ra_cmd_engine.configure_wallet(?, ?, ?)";
    private static final String CONFIGURE_CREDENTIAL_ALIAS = "dbms_ra_cmd_engine.configure_credential_alias(?, ?, ?)";
    private static final String CONFIGURE_MAX_CHANNELS = "dbms_ra_cmd_engine.configure_maxChannels(?, ?, ?)";
    private static final String CONFIGURE_LIBRA_LOCATION = "dbms_ra_cmd_engine.configure_libra(?, ?, ?)";
    private static final String UPDATE_ACTION_STATUS = "dbms_ra_cmd_engine.action_status(?, ?, ?, ?, ?)";
    private static final String NEXT_ACTION = "dbms_ra_cmd_engine.next_action(?, ?, ?, ?, ?)";
    private static final String GET_ACTION = "dbms_ra_cmd_engine.get_action(?, ?, ?, ?)";
    public static final int DATABASE_NOT_REGISTERED = 5;
    public static final int FAIL = 100;
    public static final int SUCCESS = 200;
    public static final Map<Integer, String> returnCodes = new HashMap<Integer, String>(){
        {
            this.put(100, "FAIL");
            this.put(200, "SUCCESS");
            this.put(5, "DATABASE_NOT_REGISTERED");
        }
    };

    public static String getMessage(int returnCode) {
        return returnCodes.get(returnCode);
    }

    public static Connection getEngineConnection(String tnsAdmin, String walletLocation, String credentialAlias) {
        Connection conn = null;
        int maxRetry = 3;
        while (maxRetry > 0) {
            block6: {
                try {
                    String url = "jdbc:oracle:thin:@" + credentialAlias;
                    OracleDataSource ods = new OracleDataSource();
                    Properties connectionProperties = new Properties();
                    connectionProperties.setProperty("oracle.net.tns_admin", tnsAdmin);
                    connectionProperties.setProperty("oracle.net.wallet_location", walletLocation);
                    ods.setConnectionProperties(connectionProperties);
                    ods.setURL(url);
                    conn = ods.getConnection();
                }
                catch (SQLException e) {
                    if (!e.getMessage().contains("ORA-01017") && maxRetry != 1) break block6;
                    throw Result.fengDatabaseConnectionException(credentialAlias, tnsAdmin, walletLocation, e);
                }
            }
            if (conn != null) {
                return conn;
            }
            --maxRetry;
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return conn;
    }

    public static Connection getEngineConnection(String dbUniqueName) {
        FleetAgentContext fleetAgentContext = FleetAgentContext.get(dbUniqueName);
        ProtectedDatabaseCache protectedDatabaseCache = fleetAgentContext.getProtectedDatabaseCache();
        return FleetEngine.getEngineConnection(fleetAgentContext.getTnsAdmin(), protectedDatabaseCache.getWalletLocation(), protectedDatabaseCache.getCredentialAlias());
    }

    public static Connection getEngineConnection(Database database) {
        FleetAgentContext fleetAgentContext = database.getFleetAgentContext();
        return FleetEngine.getEngineConnection(fleetAgentContext.getTnsAdmin(), fleetAgentContext.getProtectedDatabaseCache().getWalletLocation(), fleetAgentContext.getProtectedDatabaseCache().getCredentialAlias());
    }

    public static FleetEngineResponse updateActionStatus(UpdateActionStatusRequest request) throws SQLException {
        CallableStatement cs = request.getCallableStatement();
        cs.execute();
        int statusCode = cs.getInt("O_STATUS_CODE");
        String statusMessage = cs.getString("O_STATUS_MESSAGE");
        return new FleetEngineResponse<Object>(statusCode, statusMessage, null);
    }

    public static <T extends FleetEngineRequest, R> FleetEngineResponse<R> retry(int maxErrorCount, T request) throws SQLException {
        FleetEngineResponse response = null;
        for (int errorCount = 0; errorCount < maxErrorCount; ++errorCount) {
            response = request.execute();
            FleetEngineResponse.Status status = response.getStatus();
            if (status.equals((Object)FleetEngineResponse.Status.SUCCESS)) {
                return response;
            }
            if (status.equals((Object)FleetEngineResponse.Status.FAIL_DATABASE_NOT_CONFIGURED) || status.equals((Object)FleetEngineResponse.Status.FAIL_DATABASE_NOT_REGISTERED) || status.equals((Object)FleetEngineResponse.Status.FAIL_INCORRECT_ACTION_ID)) continue;
            return response;
        }
        return response;
    }
}

