/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.oci;

import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.recovery.DatabaseRecoveryClient;
import com.oracle.bmc.recovery.model.LifecycleState;
import com.oracle.bmc.recovery.model.ProtectedDatabaseSummary;
import com.oracle.bmc.recovery.model.ProtectionPolicySummary;
import com.oracle.bmc.recovery.model.RecoveryServiceSubnetSummary;
import com.oracle.bmc.recovery.requests.ListProtectedDatabasesRequest;
import com.oracle.bmc.recovery.requests.ListProtectionPoliciesRequest;
import com.oracle.bmc.recovery.requests.ListRecoveryServiceSubnetsRequest;
import com.oracle.bmc.recovery.responses.ListProtectedDatabasesResponse;
import com.oracle.bmc.recovery.responses.ListProtectionPoliciesResponse;
import com.oracle.bmc.recovery.responses.ListRecoveryServiceSubnetsResponse;
import java.util.List;
import oracle.dbtools.core.oci.AuthenticationProvider;
import oracle.dbtools.core.oci.OCIClient;
import oracle.dbtools.core.oci.OCIProfile;

public class OCIDatabaseRecoveryClient
extends OCIClient {
    private final DatabaseRecoveryClient client;

    public static Builder builder(OCIProfile ociProfile) {
        return new Builder((AuthenticationProvider)ociProfile);
    }

    private OCIDatabaseRecoveryClient(Builder builder) {
        super((OCIClient.Builder)builder);
        DatabaseRecoveryClient.Builder dBuilder = DatabaseRecoveryClient.builder();
        this.configureClient((RegionalClientBuilder)dBuilder);
        this.client = dBuilder.build(this.getAuthenticationProvider().getAuthenticationProvider());
        String endpoint = this.getEndpoint();
        if (endpoint != null) {
            this.client.setEndpoint(endpoint);
        }
    }

    public List<RecoveryServiceSubnetSummary> listRecoverySubnets(String compartmentId) {
        ListRecoveryServiceSubnetsRequest request = ListRecoveryServiceSubnetsRequest.builder().compartmentId(compartmentId).lifecycleState(LifecycleState.Active).build();
        ListRecoveryServiceSubnetsResponse response = (ListRecoveryServiceSubnetsResponse)OCIDatabaseRecoveryClient.executeRequest(() -> this.client.listRecoveryServiceSubnets(request));
        return response.getRecoveryServiceSubnetCollection().getItems();
    }

    public List<ProtectedDatabaseSummary> listProtectedDatabases(String compartmentId) {
        ListProtectedDatabasesRequest request = ListProtectedDatabasesRequest.builder().compartmentId(compartmentId).lifecycleState(LifecycleState.Active).build();
        ListProtectedDatabasesResponse response = (ListProtectedDatabasesResponse)OCIDatabaseRecoveryClient.executeRequest(() -> this.client.listProtectedDatabases(request));
        return response.getProtectedDatabaseCollection().getItems();
    }

    public List<ProtectionPolicySummary> listProtectionPolicies(String compartmentId) {
        ListProtectionPoliciesRequest request = ListProtectionPoliciesRequest.builder().compartmentId(compartmentId).lifecycleState(LifecycleState.Active).build();
        ListProtectionPoliciesResponse response = (ListProtectionPoliciesResponse)OCIDatabaseRecoveryClient.executeRequest(() -> this.client.listProtectionPolicies(request));
        return response.getProtectionPolicyCollection().getItems();
    }

    public static class Builder
    extends OCIClient.Builder<Builder, OCIDatabaseRecoveryClient> {
        protected Builder(AuthenticationProvider authenticationProvider) {
            super(authenticationProvider);
        }

        public OCIDatabaseRecoveryClient build() {
            return new OCIDatabaseRecoveryClient(this);
        }
    }
}

