/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.models.rcvconf;

import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import java.util.Optional;
import oracle.dbtools.extension.rcv.models.LogArchiveDestination;
import oracle.dbtools.extension.rcv.models.rcvconf.Action;
import oracle.dbtools.extension.rcv.utils.ConfigurationManager;

public class LogArchiveDestinationGroupAction
extends Action<LogArchiveDestination> {
    private LogArchiveDestinationGroupAction(String operationType, LogArchiveDestination[] payload, String dbUniqueName) {
        super(operationType, payload, dbUniqueName);
    }

    public static Optional<LogArchiveDestinationGroupAction> getAction(JsonObject jsonObject, String dbUniqueName) {
        if (jsonObject.containsKey((Object)"operationType") && jsonObject.containsKey((Object)"payload")) {
            String opType = jsonObject.getString("operationType");
            JsonArray jsonArray = jsonObject.getJsonArray("payload");
            if (!jsonArray.isEmpty()) {
                JsonArray firstElement = jsonArray.getJsonArray(0);
                LogArchiveDestination[] dests = new LogArchiveDestination[firstElement.size()];
                for (int i = 0; i < firstElement.size(); ++i) {
                    JsonObject destinationJsonObject = firstElement.getJsonObject(i);
                    dests[i] = LogArchiveDestination.createInstance(destinationJsonObject);
                    String serviceName = ConfigurationManager.updateAliasWithDbUniqueName(dbUniqueName, dests[i].getService());
                    dests[i].setService(serviceName);
                    dests[i].setDbUniqueName(serviceName);
                }
                LogArchiveDestinationGroupAction action = new LogArchiveDestinationGroupAction(opType, dests, dbUniqueName);
                return Optional.of(action);
            }
        }
        return Optional.empty();
    }
}

