/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.models.rcvconf;

import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import java.util.Optional;
import oracle.dbtools.extension.rcv.models.rcvconf.Action;
import oracle.dbtools.extension.rcv.models.rcvconf.LogArchiveDestinationGroupAction;
import oracle.dbtools.extension.rcv.utils.ConfigurationManager;

public class Actions {
    protected static final String OPERATION_TYPE = "operationType";
    protected static final String PAYLOAD = "payload";
    protected static final String RMAN_CATALOG_CONNECTION = "rmanCatalogConnection";
    protected static final String TNSNAMES_ORA = "tnsNamesOra";
    protected static final String WALLET_ENTRIES = "walletEntries";
    protected static final String LOG_ARCHIVE_CONFIG = "logArchiveConfig";
    protected static final String LOG_ARCHIVE_DESTINATION_GROUPS = "logArchiveDestinationGroups";
    protected static final String HOST_FILE_ENTRIES = "hostFileEntries";
    private Action<String> rmanCatalogConnectionAction;
    private Action<String> walletEntriesAction;
    private Action<String> logArchiveConfigAction;
    private LogArchiveDestinationGroupAction logArchiveDestinationGroupsAction;

    public static Actions getActions(JsonObject jsonObject, String dbUniqueName) {
        Actions actions = new Actions();
        for (String actionType : jsonObject.keySet()) {
            int i;
            String[] payload;
            JsonArray jsonArray = jsonObject.getJsonArray(actionType);
            if (jsonArray.isEmpty()) continue;
            JsonObject firstElement = jsonArray.getJsonObject(0);
            JsonArray payloadArray = firstElement.getJsonArray(PAYLOAD);
            if (actionType.equalsIgnoreCase(RMAN_CATALOG_CONNECTION)) {
                payload = Actions.getPayloadArray(payloadArray);
                for (i = 0; i < payload.length; ++i) {
                    payload[i] = ConfigurationManager.updateAliasWithDbUniqueName(dbUniqueName, payload[i]);
                }
                actions.rmanCatalogConnectionAction = new Action<String>(firstElement.getString(OPERATION_TYPE), payload, dbUniqueName);
                continue;
            }
            if (actionType.equalsIgnoreCase(WALLET_ENTRIES)) {
                payload = Actions.getPayloadArray(payloadArray);
                for (i = 0; i < payload.length; ++i) {
                    payload[i] = ConfigurationManager.updateAliasWithDbUniqueName(dbUniqueName, payload[i]);
                }
                actions.walletEntriesAction = new Action<String>(firstElement.getString(OPERATION_TYPE), payload, dbUniqueName);
                continue;
            }
            if (actionType.equalsIgnoreCase(LOG_ARCHIVE_CONFIG)) {
                payload = Actions.getPayloadArray(payloadArray);
                for (i = 0; i < payload.length; ++i) {
                    payload[i] = ConfigurationManager.updateAliasWithDbUniqueName(dbUniqueName, payload[i]);
                }
                actions.logArchiveConfigAction = new Action<String>(firstElement.getString(OPERATION_TYPE), payload, dbUniqueName);
                continue;
            }
            if (!actionType.equalsIgnoreCase(LOG_ARCHIVE_DESTINATION_GROUPS)) continue;
            Optional<LogArchiveDestinationGroupAction> actionOptional = LogArchiveDestinationGroupAction.getAction(firstElement, dbUniqueName);
            actionOptional.ifPresent(logArchiveDestinationGroupAction -> {
                actions.logArchiveDestinationGroupsAction = logArchiveDestinationGroupAction;
            });
        }
        return actions;
    }

    protected static String[] getPayloadArray(JsonArray payloadArray) {
        String[] payload = new String[payloadArray.size()];
        for (int i = 0; i < payload.length; ++i) {
            payload[i] = payloadArray.getString(i);
        }
        return payload;
    }

    public Optional<Action<String>> getRmanCatalogConnectionAction() {
        return Optional.ofNullable(this.rmanCatalogConnectionAction);
    }

    public Optional<Action<String>> getWalletEntriesAction() {
        return Optional.ofNullable(this.walletEntriesAction);
    }

    public Optional<Action<String>> getLogArchiveConfigAction() {
        return Optional.ofNullable(this.logArchiveConfigAction);
    }

    public Optional<LogArchiveDestinationGroupAction> getLogArchiveDestinationGroupsAction() {
        return Optional.ofNullable(this.logArchiveDestinationGroupsAction);
    }
}

