/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.models.jobs;

import java.nio.file.Path;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.Optional;
import oracle.dbtools.extension.rcv.commands.RCVCommand;
import oracle.dbtools.extension.rcv.commands.RCVOptions;
import oracle.dbtools.extension.rcv.models.database.FleetAgentContext;
import oracle.dbtools.extension.rcv.models.jobs.FleetAgentJob;
import oracle.dbtools.extension.rcv.models.jobs.JobType;
import oracle.dbtools.extension.rcv.models.jobs.TimeUnit;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.raptor.scheduler.job.Job;

public class RotateVpcCredentialsJob
extends FleetAgentJob {
    private static final JobType type = JobType.ROTATE_VPC_CREDS;
    private static final int INTERVAL = 3;
    private String dbUniqueName;

    public RotateVpcCredentialsJob(String dbUniqueName) {
        super(FleetAgentContext.getJobName(dbUniqueName, type), new RCVCommand(RCVCommand.SubCommand.CONFIGURE_DATABASE).addFlag(RCVOptions.Options.PASSWORD).addFlag(RCVOptions.Options.SCHEDULED));
        this.dbUniqueName = dbUniqueName;
    }

    @Override
    public Optional<Path> getLastExecutedLog() {
        return Optional.empty();
    }

    @Override
    public boolean isLocalOnly() {
        return true;
    }

    @Override
    public TimeUnit getTimeUnit() {
        return TimeUnit.DAY;
    }

    @Override
    public int getDefaultInterval() {
        return 3;
    }

    @Override
    public Job createJob(Integer start, Integer interval) {
        if (interval != null && (interval == 0 || interval > 31)) {
            String error = String.format("Invalid interval %d. The password rotation job interval must be between 1 to 31 days.", interval);
            throw Result.invalidOptionException(error);
        }
        if (start != null && (start <= 0 || start > 31)) {
            String error = String.format("Invalid start day %d. The password rotation job's start day must be between 1 to 31.", start);
            throw Result.invalidOptionException(error);
        }
        if (interval == null) {
            interval = 3;
        }
        if (start == null) {
            LocalDate today = LocalDate.now();
            int day = today.getDayOfMonth();
            int month = today.getMonthValue();
            int year = today.getYear();
            int days = YearMonth.of(year, month).lengthOfMonth();
            start = (day + interval) % days % interval;
            if (start == 0) {
                start = interval;
            }
        }
        String cron = String.format("0 0 0 %d/%d * ?", start, interval);
        return new Job(this.getJobName(), cron, this.getCommand().toString(), FleetAgentContext.get(this.dbUniqueName).getConnectionName());
    }

    public String getDbUniqueName() {
        return this.dbUniqueName;
    }
}

