/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.models.jobs;

import java.nio.file.Path;
import java.util.Optional;
import oracle.dbtools.extension.rcv.commands.RCVCommand;
import oracle.dbtools.extension.rcv.models.database.FleetAgentContext;
import oracle.dbtools.extension.rcv.models.jobs.FleetAgentJob;
import oracle.dbtools.extension.rcv.models.jobs.TimeUnit;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.raptor.scheduler.job.Job;

public class RemoveLogsJob
extends FleetAgentJob {
    private String dbUniqueName;

    public RemoveLogsJob(String dbUniqueName) {
        super("clean_logs", new RCVCommand(RCVCommand.SubCommand.REMOVE_LOG));
        this.dbUniqueName = dbUniqueName;
    }

    @Override
    public Optional<Path> getLastExecutedLog() {
        return Optional.empty();
    }

    @Override
    public boolean isLocalOnly() {
        return false;
    }

    @Override
    public TimeUnit getTimeUnit() {
        return TimeUnit.DAY;
    }

    @Override
    public int getDefaultInterval() {
        return 1;
    }

    @Override
    public Job createJob(Integer start, Integer interval) {
        if (interval != null && (interval == 0 || interval > 31)) {
            String error = String.format("Invalid interval %d. The log cleanup job interval must be between 1 to 31 days.", interval);
            throw Result.invalidOptionException(error);
        }
        if (start != null && (start <= 0 || start > 31)) {
            String error = String.format("Invalid start day %d. The log cleanup job's start day must be between 1 to 31.", start);
            throw Result.invalidOptionException(error);
        }
        if (start == null) {
            start = 1;
        }
        if (interval == null) {
            interval = this.getDefaultInterval();
        }
        String cron = String.format("0 0 0 %d/%d * ?", start, interval);
        return new Job(this.getJobName(), cron, this.getCommand().toString(), FleetAgentContext.getConnectionName(this.dbUniqueName));
    }
}

