/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.models.commandengine;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.extension.rcv.commands.RCVCommandBase;
import oracle.dbtools.extension.rcv.commands.RcvMessages;
import oracle.dbtools.extension.rcv.models.commandengine.FleetEngineRequest;
import oracle.dbtools.extension.rcv.models.commandengine.FleetEngineResponse;
import oracle.dbtools.extension.rcv.workflows.Result;

public class InitRequest
extends FleetEngineRequest {
    private static final String INIT = "call dbms_ra_cmd_engine.init(?, ?, ?, ?, ?, ?)";
    private int instanceId;

    private InitRequest(Builder builder) {
        super(builder);
        String dbUniqueName = super.getDbUniqueName();
        this.instanceId = builder.instanceId;
        this.getLogger().log(Level.FINE, "DbUniqueName: " + dbUniqueName.toUpperCase());
        this.getLogger().log(Level.FINE, "AgentVersion: " + RCVCommandBase.AGENT_VERSION);
        this.getLogger().log(Level.FINE, "InstanceId  : " + this.instanceId);
        try {
            CallableStatement cs = super.getCallableStatement();
            cs.setString("db_unique_name", dbUniqueName.toUpperCase());
            cs.setString("agent_version", "" + RCVCommandBase.AGENT_VERSION);
            cs.setInt("instance_id", this.instanceId);
            cs.registerOutParameter("session_id_out", 4);
            cs.registerOutParameter("status_code_out", 4);
            cs.registerOutParameter("status_mesg_out", 12);
        }
        catch (SQLException e) {
            throw Result.fengDatabaseSqlException(RcvMessages.format("FENG_INIT_CONNECTION_ERROR_MSG", new Object[0]), e);
        }
    }

    public FleetEngineResponse<Integer> execute() throws SQLException {
        CallableStatement cs = super.getCallableStatement();
        cs.execute();
        int returnCode = cs.getInt("STATUS_CODE_OUT");
        String statusMessage = cs.getString("STATUS_MESG_OUT");
        int sessionId = cs.getInt("SESSION_ID_OUT");
        this.getLogger().log(Level.FINE, "StatusCode: " + returnCode);
        this.getLogger().log(Level.FINE, "StatusMesg: " + statusMessage);
        this.getLogger().log(Level.FINE, "SessionId   : " + sessionId);
        return new FleetEngineResponse<Integer>(returnCode, statusMessage, Integer.valueOf(sessionId));
    }

    public static class Builder
    extends FleetEngineRequest.Builder<Builder> {
        private int instanceId;

        public Builder(Connection conn, String dbUniqueName, int instanceId, Logger logger) {
            super(conn, dbUniqueName, InitRequest.INIT, logger);
            this.instanceId = instanceId;
        }

        @Override
        public InitRequest build() {
            return new InitRequest(this);
        }

        public Builder logger(Logger logger) {
            super.setLogger(logger);
            return this;
        }

        @Override
        public Builder self() {
            return this;
        }
    }
}

