/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.commands.completer;

import com.oracle.bmc.recovery.model.RecoveryServiceSubnetSummary;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import oracle.dbtools.extension.rcv.commands.RCVOptions;
import oracle.dbtools.extension.rcv.commands.completer.BaseOCIDatabaseRecoveryCompleter;
import oracle.dbtools.extension.rcv.oci.OCIDatabaseRecoveryClient;

public class RecoverySubnetCompleter
extends BaseOCIDatabaseRecoveryCompleter<RecoveryServiceSubnetSummary> {
    private RecoverySubnetCompleter(Function<RecoveryServiceSubnetSummary, String> mapper) {
        super(mapper);
    }

    public static RecoverySubnetCompleter of(Function<RecoveryServiceSubnetSummary, String> mapper) {
        return new RecoverySubnetCompleter(mapper);
    }

    public static RecoverySubnetCompleter ofIds() {
        return RecoverySubnetCompleter.of(RecoveryServiceSubnetSummary::getId);
    }

    public static RecoverySubnetCompleter ofNames() {
        return RecoverySubnetCompleter.of(RecoveryServiceSubnetSummary::getDisplayName);
    }

    protected List<RecoveryServiceSubnetSummary> listItems(OCIDatabaseRecoveryClient client, String tenantId, Map<String, Object> transformedOptionsMap) {
        Object compartmentId = transformedOptionsMap.get(RCVOptions.COMPARTMENT_ID_O.getId().toString());
        return client.listRecoverySubnets(compartmentId == null ? tenantId : (String)compartmentId);
    }
}

