/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.commands;

import com.oracle.bmc.recovery.model.ProtectedDatabase;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import oracle.dbtools.extension.SQLCLService;
import oracle.dbtools.extension.rcv.commands.RCVCommandHandler;
import oracle.dbtools.extension.rcv.commands.RCVGrammar;
import oracle.dbtools.extension.rcv.commands.RcvMessages;
import oracle.dbtools.extension.rcv.models.GlobalMetadata;
import oracle.dbtools.extension.rcv.models.database.Database;
import oracle.dbtools.extension.rcv.models.database.FleetAgentContext;
import oracle.dbtools.extension.rcv.models.database.ProtectedDatabaseCache;
import oracle.dbtools.extension.rcv.oci.RecoveryClientManager;
import oracle.dbtools.extension.rcv.utils.DatabaseUtils;
import oracle.dbtools.extension.rcv.utils.LogManager;
import oracle.dbtools.extension.rcv.utils.Utils;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.Status;
import oracle.dbtools.extension.rcv.workflows.Workflow;
import oracle.dbtools.extension.rcv.workflows.WorkflowLogger;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.command.ParsedCommandListener;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Type;
import oracle.dbtools.raptor.utils.TNSHelper;

public class RCVCommandBase
extends ParsedCommandListener
implements SQLCLService {
    private static WorkflowLogger logger;
    public static int AGENT_VERSION;
    private static ConcurrentHashMap<String, ProtectedDatabaseCache> protectedDatabaseCacheMap;
    private static ConcurrentHashMap<String, String> OcidToDbUniqueName;
    private static ConcurrentHashMap<Connection, Database> databaseMap;
    private static GlobalMetadata globalMetadata;
    private static Map<Connection, String> dbUniqueNameMap;
    private static String ORACLE_HOME;
    private static String ORACLE_BASE;
    private static final String LOG_NAME = "rcv.log";

    public static String getOracleHome() {
        if (ORACLE_HOME == null) {
            ORACLE_HOME = TNSHelper.getOracleHome();
        }
        return ORACLE_HOME;
    }

    public static String getOracleBase() {
        if (ORACLE_BASE == null) {
            ORACLE_BASE = Utils.getOracleBase();
        }
        return ORACLE_BASE;
    }

    public static String getDbUniqueName(Connection conn) {
        if (!dbUniqueNameMap.containsKey(conn)) {
            String dbUniqueName = DatabaseUtils.getDbUniqueName(conn);
            dbUniqueNameMap.put(conn, dbUniqueName);
        }
        return dbUniqueNameMap.get(conn);
    }

    public static String getAgentBaseDirectory() {
        if (RCVCommandBase.getOracleBase() == null) {
            return null;
        }
        return String.join((CharSequence)File.separator, RCVCommandBase.getOracleBase(), "rcv");
    }

    public static String getGlobalMetadataDirectory() {
        String agentBaseDirectory = RCVCommandBase.getAgentBaseDirectory();
        if (agentBaseDirectory == null) {
            return null;
        }
        return String.join((CharSequence)File.separator, agentBaseDirectory, "metadata");
    }

    public static String getDatabasesDirectory() {
        String agentBaseDirectory = RCVCommandBase.getAgentBaseDirectory();
        if (agentBaseDirectory == null) {
            return null;
        }
        return String.join((CharSequence)File.separator, agentBaseDirectory, "dbs");
    }

    public static String getProtectedDatabaseMetadataDirectory(String dbUniqueName) {
        String databasesDirectory = RCVCommandBase.getDatabasesDirectory();
        if (databasesDirectory == null) {
            return null;
        }
        return String.join((CharSequence)File.separator, databasesDirectory, dbUniqueName);
    }

    public static String getNetworkDirectory(String dbUniqueName) {
        String metadataDirectory = RCVCommandBase.getProtectedDatabaseMetadataDirectory(dbUniqueName);
        if (metadataDirectory == null) {
            return null;
        }
        return String.join((CharSequence)File.separator, metadataDirectory, "network");
    }

    public static String getWalletDirectory(String dbUniqueName) {
        String metadataDirectory = RCVCommandBase.getProtectedDatabaseMetadataDirectory(dbUniqueName);
        if (metadataDirectory == null) {
            return null;
        }
        return String.join((CharSequence)File.separator, metadataDirectory, "wallet");
    }

    public static String getScriptsDirectory(String dbUniqueName) {
        String metadataDirectory = RCVCommandBase.getProtectedDatabaseMetadataDirectory(dbUniqueName);
        if (metadataDirectory == null) {
            return null;
        }
        return String.join((CharSequence)File.separator, metadataDirectory, "scripts");
    }

    public static String getLogDirectory(String dbUniqueName) {
        String metadataDirectory = RCVCommandBase.getProtectedDatabaseMetadataDirectory(dbUniqueName);
        if (metadataDirectory == null) {
            return null;
        }
        return String.join((CharSequence)File.separator, metadataDirectory, "log");
    }

    public static String getLocksDirectory(String dbUniqueName) {
        String metadataDirectory = RCVCommandBase.getProtectedDatabaseMetadataDirectory(dbUniqueName);
        if (metadataDirectory == null) {
            return null;
        }
        return String.join((CharSequence)File.separator, metadataDirectory, "lock");
    }

    public static String getMetadataPath(String dbUniqueName) {
        String metadataDirectory = RCVCommandBase.getProtectedDatabaseMetadataDirectory(dbUniqueName);
        if (metadataDirectory == null) {
            return null;
        }
        return String.join((CharSequence)File.separator, metadataDirectory, dbUniqueName + ".json");
    }

    public static void createAgentDirectory(String dbUniqueName) throws IOException {
        ArrayList<String> directories = new ArrayList<String>();
        directories.add(RCVCommandBase.getAgentBaseDirectory());
        directories.add(RCVCommandBase.getNetworkDirectory(dbUniqueName));
        directories.add(RCVCommandBase.getWalletDirectory(dbUniqueName));
        directories.add(RCVCommandBase.getLogDirectory(dbUniqueName));
        directories.add(RCVCommandBase.getScriptsDirectory(dbUniqueName));
        for (String directory : directories) {
            if (Files.exists(Paths.get(directory, new String[0]), new LinkOption[0])) continue;
            Files.createDirectories(Paths.get(directory, new String[0]), new FileAttribute[0]);
        }
    }

    public static boolean isSysBackupConnection(Connection conn) {
        if (conn == null) {
            return false;
        }
        String user = DatabaseUtils.getUser(conn);
        return user != null && (user.equalsIgnoreCase("sysbackup") || user.equalsIgnoreCase("sys"));
    }

    public static ProtectedDatabaseCache getProtectedDatabaseCache(String dbUniqueName) {
        File f;
        ProtectedDatabaseCache cache = protectedDatabaseCacheMap.computeIfAbsent(dbUniqueName, ProtectedDatabaseCache::load);
        String metadataFile = cache.getMetadataFile();
        if (Files.exists(Paths.get(metadataFile, new String[0]), new LinkOption[0]) && (f = new File(metadataFile)).lastModified() != cache.getLastModified()) {
            RCVCommandBase.getLogger().log(Level.FINE, "rereading " + metadataFile);
            cache.refresh();
        }
        return cache;
    }

    public static Optional<String> getDbUniqueNameFromOcid(String protectedDatabaseId) {
        String dbUniqueName = OcidToDbUniqueName.computeIfAbsent(protectedDatabaseId, id -> {
            File directory;
            File[] subdirectories;
            for (String k : protectedDatabaseCacheMap.keySet()) {
                ProtectedDatabaseCache cache = protectedDatabaseCacheMap.get(k);
                if (cache.getOcid() == null || !cache.getOcid().equals(id)) continue;
                return k;
            }
            String dbsDirectory = RCVCommandBase.getDatabasesDirectory();
            if (dbsDirectory != null && (subdirectories = (directory = new File(dbsDirectory)).listFiles(File::isDirectory)) != null) {
                for (File subdirectory : subdirectories) {
                    ProtectedDatabaseCache cache;
                    String dbName = subdirectory.getName();
                    String metadataFile = RCVCommandBase.getMetadataPath(dbName);
                    if (metadataFile == null || !Files.exists(Paths.get(metadataFile, new String[0]), new LinkOption[0]) || (cache = FleetAgentContext.get(dbName).getProtectedDatabaseCache()).getOcid() == null || !cache.getOcid().equals(protectedDatabaseId)) continue;
                    return dbName;
                }
            }
            RecoveryClientManager recoveryClientManager = new RecoveryClientManager(RCVCommandBase.getLogger().getLogger());
            try {
                ProtectedDatabase db = recoveryClientManager.getProtectedDatabase(protectedDatabaseId);
                ProtectedDatabaseCache cache = RCVCommandBase.getProtectedDatabaseCache(db.getDbUniqueName());
                cache.setVpcUserName(db.getVpcUserName());
                return db.getDbUniqueName();
            }
            catch (Exception e) {
                return null;
            }
        });
        if (dbUniqueName == null) {
            return Optional.empty();
        }
        return Optional.of(dbUniqueName);
    }

    public static Database getDatabase(Connection conn) {
        return databaseMap.computeIfAbsent(conn, Database::new);
    }

    public static Optional<Connection> getConnection(String dbUniqueName) {
        for (Connection conn : databaseMap.keySet()) {
            if (!databaseMap.get(conn).getDbUniqueName().equals(dbUniqueName)) continue;
            return Optional.of(conn);
        }
        return Optional.empty();
    }

    public static GlobalMetadata getGlobalMetadata() {
        if (globalMetadata == null) {
            globalMetadata = GlobalMetadata.load();
        }
        return globalMetadata;
    }

    public static synchronized void removeProtectedDatabaseMetadata(Connection conn) {
        String dbUniqueName = RCVCommandBase.getDbUniqueName(conn);
        ProtectedDatabaseCache protectedDatabaseCache = protectedDatabaseCacheMap.get(dbUniqueName);
        protectedDatabaseCache.clearCache();
        protectedDatabaseCacheMap.remove(dbUniqueName);
    }

    public Class<? extends CommandListener> getCommandListener() {
        return ((Object)((Object)this)).getClass();
    }

    public String getExtensionDescription() {
        return RcvMessages.getString("RCV_CMD_DESC");
    }

    public String getExtensionName() {
        return RcvMessages.getString("RCV_CMD_NAME");
    }

    public String getExtensionVersion() {
        return RcvMessages.getString("SQLclVersion.VERSION");
    }

    private static void setLogger() {
        String logFile = String.join((CharSequence)File.separator, RCVCommandBase.getAgentBaseDirectory(), "log", "agent.log");
        logger = LogManager.getLogger(logFile);
    }

    public static WorkflowLogger getLogger() {
        if (logger == null) {
            RCVCommandBase.setLogger();
        }
        return logger;
    }

    protected boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd, ParsedCommand parsedCommand) {
        block18: {
            String oracleHome = RCVCommandBase.getOracleHome();
            if (oracleHome == null || !Files.exists(Paths.get(oracleHome, new String[0]), new LinkOption[0])) {
                ctx.writeln(RcvMessages.format("NO_ORACLE_HOME", new Object[]{RCVGrammar.Base.RCV}));
                return true;
            }
            RCVCommandHandler rcvCommandHandler = RCVCommandHandler.getHandler(parsedCommand);
            if (rcvCommandHandler == null) {
                ctx.writeln("Invalid command: " + cmd.getSql());
                return true;
            }
            if (rcvCommandHandler.requiresConnection()) {
                if (!RCVCommandBase.isSysBackupConnection(conn)) {
                    ctx.writeln(RcvMessages.format("INSUFFICIENT_PRIVILEGE", new Object[]{RCVGrammar.Base.RCV, rcvCommandHandler.getSubCommand().getName()}));
                    return true;
                }
                if (DatabaseUtils.isMultitenant(conn) && DatabaseUtils.isPDB(conn)) {
                    ctx.writeln(RcvMessages.format("INVALID_CONNECTION", new Object[]{RCVGrammar.Base.RCV, rcvCommandHandler.getSubCommand().getName()}));
                    return true;
                }
            }
            try {
                Workflow wf = rcvCommandHandler.getWorkflowGenerator().generateWorkflow(parsedCommand, conn, ctx);
                try {
                    if (wf.isApplicable()) {
                        Result result = wf.run();
                        if (result.getStatus().equals((Object)Status.FAILED) || result.getStatus().equals((Object)Status.TIMED_OUT)) {
                            wf.handleFailure();
                            wf.logResult(result);
                        } else if (result.getStatus().equals((Object)Status.SUCCESS)) {
                            if (result.getMessage() != null) {
                                wf.getWorkflowLogger().log(Level.INFO, result.getMessage());
                            }
                            wf.getWorkflowLogger().log(Level.INFO, "rcv " + wf.getRcvCommand().toString().toLowerCase() + " completed successfully");
                        } else {
                            wf.logResult(result);
                        }
                        break block18;
                    }
                    wf.getWorkflowLogger().log(Level.FINE, cmd.getSql().replaceAll("\\r|\\n", "") + " is not applicable.");
                }
                catch (Exception e) {
                    wf.logExceptionMessage(e.getCause());
                    wf.getWorkflowLogger().log(Level.INFO, Status.FAILED.toString());
                    wf.getWorkflowLogger().getLogger().log(Level.FINE, "-".repeat(50), e);
                    String error = Objects.toString(e.getMessage(), e.toString());
                    if (!Result.isHandled(error)) {
                        error = Utils.getFirstString(error);
                        error = RcvMessages.format("WF_UNHANDLED_EXCEPTION", Result.getMessage(error, "00015"));
                    }
                    wf.getWorkflowLogger().log(Level.WARNING, error);
                    wf.handleFailure();
                }
            }
            catch (Exception e) {
                if (logger == null) {
                    RCVCommandBase.setLogger();
                }
                logger.log(Level.INFO, Status.FAILED.toString());
                logger.getLogger().log(Level.FINE, "-".repeat(50), e);
                String error = Objects.toString(e.getMessage(), e.toString());
                if (!Result.isHandled(error)) {
                    error = Utils.getFirstString(error);
                    error = RcvMessages.format("FA_UNHANDLED_EXCEPTION", Result.getMessage(error, "00005"));
                }
                logger.log(Level.WARNING, error);
            }
        }
        return true;
    }

    protected Type createType() {
        return RCVGrammar.createType();
    }

    static {
        AGENT_VERSION = 1;
        protectedDatabaseCacheMap = new ConcurrentHashMap();
        OcidToDbUniqueName = new ConcurrentHashMap();
        databaseMap = new ConcurrentHashMap();
        dbUniqueNameMap = new HashMap<Connection, String>();
    }
}

