/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.check.rtrt;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import oracle.dbtools.extension.rcv.check.Check;
import oracle.dbtools.extension.rcv.check.CheckResult;
import oracle.dbtools.extension.rcv.commands.RCVCommandBase;
import oracle.dbtools.extension.rcv.models.database.Database;
import oracle.dbtools.extension.rcv.utils.WalletManager;
import oracle.dbtools.extension.rcv.workflows.WorkflowLogger;
import oracle.dbtools.extension.rcv.workflows.check.rtrt.CheckMessages;

public class ServerSepsWalletCheck
extends Check {
    private Connection conn;
    public static final String ID = "server_seps_wallet";
    public static final String SUCCESS_MESSAGE = "server_seps wallet is accessible.";
    private Database database;

    public ServerSepsWalletCheck(Connection conn) {
        super(conn, "Server Seps Wallet Check", ID);
        this.conn = conn;
        this.database = RCVCommandBase.getDatabase(conn);
    }

    @Override
    public CheckResult run() {
        return this.run(this.getLogger());
    }

    public CheckResult run(WorkflowLogger logger) {
        String serverSeps;
        if (logger == null) {
            logger = this.getLogger();
        }
        if ((serverSeps = this.database.getDatabaseMetadataCache().getServerSeps()) == null) {
            String error = CheckMessages.get("UNCONFIGURED_WALLET_ROOT");
            return new CheckResult(CheckResult.Status.FAIL, error);
        }
        Path serverSepsPath = Paths.get(serverSeps, new String[0]);
        if (Files.exists(serverSepsPath, new LinkOption[0])) {
            if (!Files.isDirectory(serverSepsPath, new LinkOption[0])) {
                String error = String.format("%s exists but is not a directory. Please either remove this file or convert it to a directory.", serverSeps);
                return new CheckResult(CheckResult.Status.FAIL, error);
            }
            if (!WalletManager.walletIsAccessible(serverSeps)) {
                String error = String.format("%s is not accessible.", serverSeps);
                String actionPlan = "Please verify the wallet is readable and writable to the database owner and that it is NOT password protected.";
                return new CheckResult(CheckResult.Status.FAIL, error, actionPlan);
            }
        } else {
            return new CheckResult(CheckResult.Status.SKIPPED, serverSeps + " does not exist. Skipping check.");
        }
        return new CheckResult(CheckResult.Status.PASS, SUCCESS_MESSAGE);
    }
}

