/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.tns;

import java.net.URI;
import java.util.Objects;
import oracle.dbtools.core.tns.OracleConfiguration;
import oracle.dbtools.core.tns.OracleConfigurationDoesNotExistException;
import oracle.dbtools.core.tns.OracleConfigurationFileEncodingException;
import oracle.dbtools.core.tns.OracleConfigurationInvalidFilenameException;
import oracle.dbtools.core.tns.OracleConfigurationUnbalancedParensException;

public class OracleConfigurationSyntaxException
extends IllegalStateException {
    protected final OracleConfiguration.SyntaxError error;

    OracleConfigurationSyntaxException(OracleConfiguration.SyntaxError error, Throwable cause) {
        super(OracleConfigurationSyntaxException.message(error, cause), cause);
        this.error = error;
    }

    static OracleConfigurationSyntaxException of(OracleConfiguration.SyntaxError error) {
        return OracleConfigurationSyntaxException.of(error, null);
    }

    static OracleConfigurationSyntaxException of(OracleConfiguration.SyntaxError error, Throwable cause) {
        OracleConfiguration.SyntaxError.Kind kind = OracleConfiguration.SyntaxError.Kind.GENERAL == error.kind() ? OracleConfiguration.SyntaxError.Kind.of(cause) : error.kind();
        switch (kind) {
            case FILE_ENCODING: {
                return new OracleConfigurationFileEncodingException(error, cause);
            }
            case CONFIGURATION_DOES_NOT_EXIST: {
                return new OracleConfigurationDoesNotExistException(error, cause);
            }
            case UNBALANCED_PARENS: {
                return new OracleConfigurationUnbalancedParensException(error, cause);
            }
            case INVALID_FILENAME: {
                return new OracleConfigurationInvalidFilenameException(error, cause);
            }
        }
        return new OracleConfigurationSyntaxException(error, cause);
    }

    private static String message(OracleConfiguration.SyntaxError error, Throwable cause) {
        StringBuilder text = new StringBuilder();
        URI uri = error.location();
        OracleConfiguration.Position position = error.position();
        CharSequence message = error.message();
        if (uri != null) {
            text.append(uri);
            text.append(": ");
        }
        if (position != null) {
            text.append(position);
            text.append(": ");
        }
        text.append(message);
        return text.toString();
    }

    public OracleConfiguration.SyntaxError error() {
        return this.error;
    }

    OracleConfigurationSyntaxException with(URI location) {
        if (Objects.equals(location, this.error.location())) {
            return this;
        }
        return new OracleConfigurationSyntaxException(this.error.with(location), this.getCause());
    }
}

