/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.tns;

import java.io.IOException;
import java.net.URI;
import java.nio.file.InvalidPathException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.StreamSupport;
import oracle.dbtools.core.tns.EntryStream;
import oracle.dbtools.core.tns.FileResolver;
import oracle.dbtools.core.tns.OracleConfiguration;
import oracle.dbtools.core.tns.OracleConfigurationSyntaxException;
import oracle.dbtools.core.util.Throwables;

class IncludeFiles {
    private static final String IFILE = "IFILE";
    private final FileResolver resolver;
    private final Consumer<OracleConfigurationSyntaxException> errorHandler;
    private final URI location;

    private IncludeFiles(URI location, FileResolver resolver, Consumer<OracleConfigurationSyntaxException> errorHandler) {
        this.location = location;
        this.resolver = resolver;
        this.errorHandler = errorHandler;
    }

    static IncludeFiles of(URI location, FileResolver resolver, Consumer<OracleConfigurationSyntaxException> errorHandler) {
        return new IncludeFiles(location, resolver, errorHandler);
    }

    EntryStream read(EntryStream entries) {
        Spliterator<OracleConfiguration.Entry> source = entries.spliterator();
        return EntryStream.of(StreamSupport.stream(new IncludeFilesSpliterator(this.errorHandler, this.location, this.resolver, source), false), this.errorHandler).onClose(entries::close);
    }

    private static class IncludeFilesSpliterator
    extends Spliterators.AbstractSpliterator<OracleConfiguration.Entry>
    implements Consumer<OracleConfiguration.Entry> {
        private final URI location;
        private final FileResolver resolver;
        private final Spliterator<OracleConfiguration.Entry> source;
        private final Consumer<OracleConfigurationSyntaxException> errorHandler;
        private OracleConfiguration.Entry entry;

        private IncludeFilesSpliterator(Consumer<OracleConfigurationSyntaxException> errorHandler, URI location, FileResolver resolver, Spliterator<OracleConfiguration.Entry> source) {
            super(Long.MAX_VALUE, 1040);
            this.errorHandler = errorHandler;
            this.location = location;
            this.resolver = resolver;
            this.source = source;
        }

        private boolean isIncludeFile(OracleConfiguration.Entry entry) {
            Set<String> names = entry.names();
            return names.size() == 1 && IncludeFiles.IFILE.equalsIgnoreCase(names.iterator().next());
        }

        private OracleConfiguration.Position position(OracleConfiguration.Entry entry) {
            OracleConfiguration.Position rhs = entry.valuePosition();
            if (rhs == null) {
                return OracleConfiguration.Position.of(0, 0);
            }
            return rhs;
        }

        private OracleConfigurationSyntaxException syntaxError(OracleConfiguration.Position position, String message, Throwable cause) {
            OracleConfiguration.SyntaxError syntaxError = OracleConfiguration.SyntaxError.builder().kind(OracleConfiguration.SyntaxError.Kind.of(cause)).location(this.location).position(position).message(message).build();
            return OracleConfigurationSyntaxException.of(syntaxError, cause);
        }

        private OracleConfigurationSyntaxException syntaxError(OracleConfiguration.SyntaxError.Kind kind, OracleConfiguration.Position position, String message, Throwable cause) {
            OracleConfiguration.SyntaxError syntaxError = OracleConfiguration.SyntaxError.builder().kind(kind).location(this.location).position(position).message(message).build();
            return OracleConfigurationSyntaxException.of(syntaxError, cause);
        }

        @Override
        public boolean tryAdvance(Consumer<? super OracleConfiguration.Entry> action) {
            try {
                if (this.source.tryAdvance(this)) {
                    OracleConfiguration.Entry entry = this.entry;
                    if (this.isIncludeFile(entry)) {
                        if (this.resolver != null) {
                            String fileName = entry.valueAsString(true);
                            OracleConfiguration.Position position = this.position(entry);
                            if (!this.isValidFilename(fileName)) {
                                String pattern = "Invalid file name: {0}";
                                String message = MessageFormat.format("Invalid file name: {0}", fileName);
                                throw this.syntaxError(OracleConfiguration.SyntaxError.Kind.INVALID_FILENAME, position, message, null);
                            }
                            try (EntryStream contents = this.resolver.resolve(fileName);){
                                contents.forEach(action);
                            }
                            catch (NoSuchFileException e) {
                                String pattern = "File does not exist: {0}";
                                String message = MessageFormat.format("File does not exist: {0}", fileName);
                                throw this.syntaxError(position, message, e);
                            }
                            catch (IOException e) {
                                String pattern = "Error reading: {0}, cause: {1}";
                                String cause = Throwables.message(e);
                                String message = MessageFormat.format("Error reading: {0}, cause: {1}", fileName, cause);
                                throw this.syntaxError(position, message, e);
                            }
                        }
                    } else {
                        action.accept(entry);
                    }
                    return true;
                }
                return false;
            }
            catch (OracleConfigurationSyntaxException e) {
                this.errorHandler.accept(e);
                return true;
            }
        }

        @Override
        public void accept(OracleConfiguration.Entry entry) {
            this.entry = entry;
        }

        private boolean isValidFilename(String fileName) {
            if (fileName == null || fileName.isEmpty()) {
                return false;
            }
            try {
                Paths.get(fileName, new String[0]);
            }
            catch (InvalidPathException e) {
                return false;
            }
            return true;
        }
    }
}

