/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.tns;

import java.util.Optional;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Stream;
import oracle.dbtools.core.tns.OracleConfiguration;
import oracle.dbtools.core.tns.OracleConfigurationSyntaxException;

public class EntryStream
implements AutoCloseable {
    private final Stream<OracleConfiguration.Entry> entries;
    private final Consumer<OracleConfigurationSyntaxException> errorHandler;

    private EntryStream(Stream<OracleConfiguration.Entry> entries, Consumer<OracleConfigurationSyntaxException> errorHandler) {
        this.entries = entries;
        this.errorHandler = errorHandler;
    }

    static EntryStream of(Stream<OracleConfiguration.Entry> entries, Consumer<OracleConfigurationSyntaxException> errorHandler) {
        return new EntryStream(entries, errorHandler);
    }

    public static EntryStream empty() {
        return EntryStream.of(Stream.empty(), e -> {});
    }

    @Override
    public void close() {
        this.entries.close();
    }

    Spliterator<OracleConfiguration.Entry> spliterator() {
        return this.entries.spliterator();
    }

    public void forEach(Consumer<? super OracleConfiguration.Entry> action) {
        try {
            this.entries.forEach((? super T entry) -> {
                try {
                    action.accept((OracleConfiguration.Entry)entry);
                }
                catch (OracleConfigurationSyntaxException e) {
                    this.errorHandler.accept(e);
                }
            });
        }
        catch (OracleConfigurationSyntaxException e) {
            this.errorHandler.accept(e);
        }
    }

    public <R, A> R collect(Collector<? super OracleConfiguration.Entry, A, R> collector) {
        return this.entries.collect(collector);
    }

    public EntryStream onClose(Runnable task) {
        return EntryStream.of((Stream)this.entries.onClose(task), this.errorHandler);
    }

    public Optional<OracleConfiguration.Entry> findFirst() {
        return this.entries.findFirst();
    }

    public EntryStream filter(Predicate<? super OracleConfiguration.Entry> predicate) {
        return EntryStream.of(this.entries.filter(predicate), this.errorHandler);
    }
}

