/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.text;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.util.stream.Stream;
import oracle.dbtools.core.io.InputOutputStreams;

public abstract class Lines {
    public static Stream<String> of(Reader text) {
        BufferedReader buffer = Lines.buffered(text);
        return (Stream)buffer.lines().onClose(() -> Lines.close(buffer));
    }

    public static Stream<String> of(Readable text) {
        return Lines.of(InputOutputStreams.instance().asReader(text));
    }

    public static Stream<String> of(CharSequence text) {
        return Lines.of(InputOutputStreams.instance().asReader(text));
    }

    private static BufferedReader buffered(Reader reader) {
        if (reader instanceof BufferedReader) {
            return (BufferedReader)reader;
        }
        return new BufferedReader(reader);
    }

    private static void close(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

