/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.proxy;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class ProxyChecker {
    public static final ProxyChecker NO_PROXIES = new ProxyChecker(ProxyChecker.builder()){

        @Override
        public URI getProxy(URI uri) {
            return null;
        }
    };
    private static final Pattern PORT_PATTERN = Pattern.compile("\\(\\s*PORT\\s*=\\s*([^\\s)]+)\\s*\\)");
    private static final Pattern HOST_PATTERN = Pattern.compile("\\(\\s*HOST\\s*=\\s*([^\\s)]+)\\s*\\)");

    public static Builder builder() {
        return new Builder();
    }

    private ProxyChecker(Builder builder) {
    }

    public abstract URI getProxy(URI var1);

    public URI getProxy(String connectDescriptor) {
        URI uri = null;
        String hostname = null;
        String port = null;
        String copy = connectDescriptor.toUpperCase();
        Matcher matcher = HOST_PATTERN.matcher(copy);
        if (matcher.find()) {
            hostname = connectDescriptor.substring(matcher.start(1), matcher.end(1));
            matcher = PORT_PATTERN.matcher(copy);
            if (matcher.find()) {
                port = connectDescriptor.substring(matcher.start(1), matcher.end(1));
            }
        }
        if (hostname != null && port != null) {
            try {
                uri = new URI("https://" + hostname + ":" + port);
            }
            catch (URISyntaxException e) {
                uri = null;
            }
        }
        return uri != null ? this.getProxy(uri) : null;
    }

    public static final class Builder {
        private URI proxy;
        private String nonProxyHosts;

        public Builder proxy(URI proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder nonProxyHosts(String nonProxyHosts) {
            this.nonProxyHosts = nonProxyHosts;
            return this;
        }

        public ProxyChecker build() {
            return this.proxy != null ? new ExplicitProxyChecker(this) : new DynamicProxyChecker(this);
        }
    }

    private static class DynamicProxyChecker
    extends ProxyChecker {
        private DynamicProxyChecker(Builder builder) {
            super(builder);
        }

        @Override
        public URI getProxy(URI uri) {
            URI proxy = null;
            ProxySelector ps = ProxySelector.getDefault();
            List<Proxy> proxies = ps.select(uri);
            if (proxies != null) {
                for (Proxy p : proxies) {
                    SocketAddress address;
                    if (p.type() != Proxy.Type.HTTP || !((address = p.address()) instanceof InetSocketAddress)) continue;
                    String proxyHost = ((InetSocketAddress)address).getHostString();
                    int proxyPort = ((InetSocketAddress)address).getPort();
                    if (proxyHost == null || proxyPort <= 0) continue;
                    proxy = URI.create("https://" + proxyHost + ":" + proxyPort);
                    break;
                }
            }
            return proxy;
        }
    }

    private static class ExplicitProxyChecker
    extends ProxyChecker {
        private final URI proxy;
        private final String nonProxyHosts;

        private ExplicitProxyChecker(Builder builder) {
            super(builder);
            this.proxy = builder.proxy;
            this.nonProxyHosts = builder.nonProxyHosts;
        }

        @Override
        public URI getProxy(URI uri) {
            boolean useProxy = true;
            if (this.nonProxyHosts != null && !this.nonProxyHosts.isEmpty()) {
                String host = uri.getHost();
                for (String check : this.nonProxyHosts.split("\\s*\\|\\s*")) {
                    if (!check.equals(host)) continue;
                    useProxy = false;
                    break;
                }
            }
            return useProxy ? this.proxy : null;
        }
    }
}

