/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.l8n;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class MessagesBase {
    private final ResourceBundle m_bundle;

    protected MessagesBase(String bundleName, ClassLoader cl) {
        this.m_bundle = ResourceBundle.getBundle(bundleName, Locale.getDefault(), cl);
    }

    protected ResourceBundle getResourceBundle() {
        return this.m_bundle;
    }

    protected String getStringImpl(String key) {
        try {
            return this.m_bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return "!" + key + "!";
        }
    }

    protected String formatImpl(String key, Object ... arguments) {
        try {
            return MessageFormat.format(this.m_bundle.getString(key), arguments);
        }
        catch (MissingResourceException e) {
            return "!" + key + "!";
        }
    }

    public final Integer getIntegerImpl(String key) {
        String s = this.getStringImpl(key);
        if (s.length() == 1 && Character.isLetter(s.charAt(0))) {
            return s.charAt(0);
        }
        return Integer.valueOf(s);
    }
}

