/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.io.file;

import java.io.IOException;
import java.nio.file.Path;
import oracle.dbtools.core.io.file.AccessPermission;
import oracle.dbtools.core.io.file.AclAccessPermission;
import oracle.dbtools.core.io.file.PosixAccessPermission;

class CrossPlatformAccessPermission
implements AccessPermission {
    static final CrossPlatformAccessPermission SECURE_FOLDER = CrossPlatformAccessPermission.of(PosixAccessPermission.SECURE_FOLDER, AclAccessPermission.SECURE_FOLDER);
    static final CrossPlatformAccessPermission SECURE_FILE = CrossPlatformAccessPermission.of(PosixAccessPermission.SECURE_FILE, AclAccessPermission.SECURE_FILE);
    private final AclAccessPermission aclPermission;
    private final PosixAccessPermission posixPermission;

    private CrossPlatformAccessPermission(Builder builder) {
        this.aclPermission = builder.aclPermission;
        this.posixPermission = builder.posixPermission;
        if (this.aclPermission.type() != this.posixPermission.type()) {
            throw new IllegalArgumentException("ACL permission type and POSIX permission type do not match");
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CrossPlatformAccessPermission of(PosixAccessPermission posixPermission, AclAccessPermission aclPermission) {
        return CrossPlatformAccessPermission.builder().posixPermission(posixPermission).aclPermission(aclPermission).build();
    }

    private static IllegalArgumentException unsupportedFileSystem(Path path) {
        return new IllegalArgumentException("Filesystem lacks capability to configure file permissions");
    }

    @Override
    public Path create(Path path) throws IOException {
        if (this.supportsPosix(path)) {
            return this.posixPermission.create(path);
        }
        if (this.supportsAcls(path)) {
            return this.aclPermission.create(path);
        }
        throw CrossPlatformAccessPermission.unsupportedFileSystem(path);
    }

    @Override
    public Path configure(Path path) throws IOException {
        if (this.supportsPosix(path)) {
            return this.posixPermission.configure(path);
        }
        if (this.supportsAcls(path)) {
            return this.aclPermission.configure(path);
        }
        throw CrossPlatformAccessPermission.unsupportedFileSystem(path);
    }

    @Override
    public boolean verify(Path path) throws IOException {
        if (this.supportsPosix(path)) {
            return this.posixPermission.verify(path);
        }
        if (this.supportsAcls(path)) {
            return this.aclPermission.verify(path);
        }
        throw CrossPlatformAccessPermission.unsupportedFileSystem(path);
    }

    private boolean supportsAcls(Path folder) {
        return folder.getFileSystem().supportedFileAttributeViews().contains("acl");
    }

    private boolean supportsPosix(Path folder) {
        return folder.getFileSystem().supportedFileAttributeViews().contains("posix");
    }

    public static final class Builder {
        private AclAccessPermission aclPermission;
        private PosixAccessPermission posixPermission;

        private Builder() {
        }

        public Builder aclPermission(AclAccessPermission aclPermission) {
            this.aclPermission = aclPermission;
            return this;
        }

        public Builder posixPermission(PosixAccessPermission posixPermission) {
            this.posixPermission = posixPermission;
            return this;
        }

        public CrossPlatformAccessPermission build() {
            return new CrossPlatformAccessPermission(this);
        }
    }
}

