/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.jdbc;

import com.fasterxml.jackson.core.TreeCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.jr.ob.JSON;
import com.fasterxml.jackson.jr.ob.JSONObjectException;
import com.fasterxml.jackson.jr.stree.JacksonJrsTreeCodec;
import com.fasterxml.jackson.jr.stree.JrsNull;
import com.fasterxml.jackson.jr.stree.JrsString;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.jdbc.CLOB;
import oracle.dbtools.jdbc.Connection;
import oracle.dbtools.jdbc.ParameterMetaData;
import oracle.dbtools.jdbc.PreparedStatement;
import oracle.dbtools.jdbc.ResultSet;
import oracle.dbtools.jdbc.RowId;
import oracle.dbtools.jdbc.util.DateTimestampsUtil;
import oracle.dbtools.jdbc.util.ExceptionUtil;
import oracle.dbtools.jdbc.util.OracleTypes;
import oracle.dbtools.jdbc.util.RestJdbcNotImplementedException;
import oracle.dbtools.jdbc.util.RestJdbcUnsupportedException;
import oracle.dbtools.jdbc.util.RestjdbcResources;
import oracle.dbtools.jdbc.util.SQLStateMapping;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;

public class CallableStatement
extends PreparedStatement
implements java.sql.CallableStatement {
    Logger LOGGER = Logger.getLogger(CallableStatement.class.getName());
    private java.sql.ResultSet currentResultSet = null;
    private boolean closed = false;
    private TreeNode node = null;
    String timeZoneID = null;
    private Map<Integer, Integer> isNullable = new HashMap<Integer, Integer>();
    private Map<Integer, Boolean> isSigned = new HashMap<Integer, Boolean>();
    private Map<Integer, Integer> precision = new HashMap<Integer, Integer>();
    private Map<Integer, Integer> scale = new HashMap<Integer, Integer>();
    private Map<Integer, Integer> parameterType = new HashMap<Integer, Integer>();
    private Map<Integer, String> parameterTypeName = new HashMap<Integer, String>();
    private Map<Integer, String> parameterClassName = new HashMap<Integer, String>();

    protected CallableStatement(Connection conn, String sql) {
        this.conn = conn;
        this.sql = sql;
    }

    private String getVal(Object parameterIndex) throws SQLException {
        String column = null;
        try {
            JSON json = JSON.std.with((TreeCodec)new JacksonJrsTreeCodec());
            column = json.asString((Object)this.extractResult(parameterIndex).get("result"));
            if (column == null) {
                return null;
            }
        }
        catch (NullPointerException ne) {
            if (ne.getMessage() != null) {
                this.LOGGER.log(Level.SEVERE, ne.getMessage());
            }
            int errorCode = 17003;
            throw new SQLException(ExceptionUtil.getErrorMessage(errorCode), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
        catch (JSONObjectException e) {
            int errorCode = 17089;
            throw new SQLException(e.getMessage(), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
        catch (IOException e) {
            int errorCode = 17089;
            throw new SQLException(e.getMessage(), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
        return column;
    }

    private TreeNode extractResult(Object parameterIndex) throws SQLException {
        this.ensureOpen();
        int i = 0;
        TreeNode result = null;
        JrsString s = (JrsString)this.node.get("env").get("defaultTimeZone");
        this.timeZoneID = s.getValue();
        while (true) {
            block15: {
                String result_index;
                JSON json;
                if ((result = this.node.get("items").get(0).get("binds").get(i)) == null) {
                    this.handleErrors(this.node);
                    if (this.node.get("items").get(0).get("binds") == null) {
                        int errorCode = 17426;
                        throw new SQLException(RestjdbcResources.getString("ORA_17426"), SQLStateMapping.getSQLState(errorCode), errorCode);
                    }
                    if (this.outTypes.containsKey(parameterIndex)) {
                        int errorCode = 17046;
                        throw new SQLException(RestjdbcResources.getString("ORA_17046"), SQLStateMapping.getSQLState(errorCode), errorCode);
                    }
                    if (!this.outTypes.containsKey(parameterIndex)) {
                        int errorCode = 17041;
                        throw new SQLException(ExceptionUtil.getErrorMessage(errorCode, () -> RestjdbcResources.getString("ORA_17041") + String.valueOf(parameterIndex)), SQLStateMapping.getSQLState(errorCode), errorCode);
                    }
                    int errorCode = 17001;
                    throw new SQLException(ExceptionUtil.getErrorMessage(errorCode), SQLStateMapping.getSQLState(errorCode), errorCode);
                }
                if (parameterIndex instanceof Integer && !result.get("index").isMissingNode()) {
                    json = JSON.std.with((TreeCodec)new JacksonJrsTreeCodec());
                    try {
                        result_index = json.asString((Object)result.get("index"));
                        if (Integer.parseInt(result_index) == (Integer)parameterIndex) {
                            return result;
                        }
                        break block15;
                    }
                    catch (JSONObjectException e) {
                        int errorCode = 17089;
                        throw new SQLException(e.getMessage(), SQLStateMapping.getSQLState(errorCode), errorCode);
                    }
                    catch (IOException e) {
                        int errorCode = 17089;
                        throw new SQLException(e.getMessage(), SQLStateMapping.getSQLState(errorCode), errorCode);
                    }
                }
                if (parameterIndex instanceof String && !result.get("name").isMissingNode()) {
                    json = JSON.std.with((TreeCodec)new JacksonJrsTreeCodec());
                    try {
                        result_index = json.asString((Object)result.get("name"));
                        if (result_index.equals((String)parameterIndex)) {
                            return result;
                        }
                    }
                    catch (JSONObjectException e) {
                        int errorCode = 17089;
                        throw new SQLException(e.getMessage(), SQLStateMapping.getSQLState(errorCode), errorCode);
                    }
                    catch (IOException e) {
                        int errorCode = 17089;
                        throw new SQLException(e.getMessage(), SQLStateMapping.getSQLState(errorCode), errorCode);
                    }
                }
            }
            ++i;
        }
    }

    @Override
    public java.sql.ResultSet executeQuery() throws SQLException {
        CloseableHttpResponse response = this.executeInternal(this.sql);
        this.currentResultSet = new ResultSet(response, this, this.conn);
        return this.currentResultSet;
    }

    @Override
    public java.sql.ResultSet executeQuery(String sql) throws SQLException {
        CloseableHttpResponse response = this.executeInternal(sql);
        this.currentResultSet = new ResultSet(response, this, this.conn);
        return this.currentResultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate() throws SQLException {
        int result = 0;
        this.node = null;
        CloseableHttpResponse response = null;
        try {
            response = this.executeInternal(this.sql);
            this.node = this.createJsonNode(response);
            this.handleErrors(this.node);
            result = this.getResult(this.node);
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    this.LOGGER.log(Level.SEVERE, e.getMessage());
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String sql) throws SQLException {
        boolean result = false;
        CloseableHttpResponse response = null;
        try {
            response = this.executeInternal(sql);
            this.node = this.createJsonNode(response);
            if (this.node.get("items").get(0).get("resultSet") != null) {
                result = true;
            }
            this.handleErrors(this.node);
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    this.LOGGER.log(Level.SEVERE, e.getMessage(), e.getStackTrace());
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() throws SQLException {
        boolean result = false;
        CloseableHttpResponse response = null;
        try {
            response = this.executeInternal(this.sql);
            this.node = this.createJsonNode(response);
            if (this.node.get("items").get(0).get("resultSet") != null) {
                result = true;
            }
            this.handleErrors(this.node);
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    this.LOGGER.log(Level.SEVERE, e.getMessage());
                }
            }
        }
        return result;
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        super.setNull(parameterIndex, sqlType);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.LOGGER.finest("Setting Date");
        DateTimestampsUtil ts = new DateTimestampsUtil();
        Calendar cal = Calendar.getInstance(TimeZone.getDefault());
        this.updateList(parameterIndex, ts.setDate(x, this.conn.getTimeZoneID(), cal));
        this.types.put(parameterIndex, "DATE");
    }

    @Override
    public void setDate(String parameterName, Date x) throws SQLException {
        this.ensureOpen();
        this.LOGGER.finest("Setting Date with parameterName: " + parameterName);
        Calendar cal = Calendar.getInstance(TimeZone.getDefault());
        DateTimestampsUtil ts = new DateTimestampsUtil();
        this.updateList(parameterName, ts.setDate(x, this.conn.getTimeZoneID(), cal));
        this.types.put(parameterName, "DATE");
    }

    @Override
    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        this.LOGGER.finest("Setting Date");
        DateTimestampsUtil ts = new DateTimestampsUtil();
        this.updateList(parameterName, ts.setDate(x, this.conn.getTimeZoneID(), cal));
        this.types.put(parameterName, "DATE");
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.LOGGER.finest("Setting Time");
        String timeZoneID = this.conn.getTimeZoneID();
        Calendar cal = Calendar.getInstance(TimeZone.getDefault());
        DateTimestampsUtil ts = new DateTimestampsUtil();
        this.updateList(parameterIndex, ts.setTime(x, timeZoneID, cal));
        this.types.put(parameterIndex, "DATE");
    }

    @Override
    public void setTime(String parameterName, Time x) throws SQLException {
        this.ensureOpen();
        this.LOGGER.finest("Setting Time with parameterName: " + parameterName);
        String timeZoneID = this.conn.getTimeZoneID();
        Calendar cal = Calendar.getInstance(TimeZone.getDefault());
        DateTimestampsUtil ts = new DateTimestampsUtil();
        this.updateList(parameterName, ts.setTime(x, timeZoneID, cal));
        this.types.put(parameterName, "TIMESTAMP");
    }

    @Override
    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        this.LOGGER.finest("Setting Time");
        String timeZoneID = this.conn.getTimeZoneID();
        DateTimestampsUtil ts = new DateTimestampsUtil();
        this.updateList(parameterName, ts.setTime(x, timeZoneID, cal));
        this.types.put(parameterName, "DATE");
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.LOGGER.finest("Setting Timestamp");
        String timeZoneID = this.conn.getTimeZoneID();
        Calendar cal = Calendar.getInstance(TimeZone.getDefault());
        DateTimestampsUtil ts = new DateTimestampsUtil();
        this.updateList(parameterIndex, ts.setTimeStamp(x, timeZoneID, cal));
        this.types.put(parameterIndex, "TIMESTAMP");
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        this.ensureOpen();
        this.LOGGER.finest("Setting Timestamp with parameterName: " + parameterName);
        Calendar cal = Calendar.getInstance(TimeZone.getDefault());
        String timeZoneID = this.conn.getTimeZoneID();
        DateTimestampsUtil ts = new DateTimestampsUtil();
        this.updateList(parameterName, ts.setTimeStamp(x, timeZoneID, cal));
        this.types.put(parameterName, "TIMESTAMP");
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        this.LOGGER.finest("Setting Timestamp");
        String timeZoneID = this.conn.getTimeZoneID();
        DateTimestampsUtil ts = new DateTimestampsUtil();
        this.updateList(parameterName, ts.setTimeStamp(x, timeZoneID, cal));
        this.types.put(parameterName, "TIMESTAMP");
    }

    @Override
    public void setRowId(int parameterIndex, java.sql.RowId x) throws SQLException {
        this.LOGGER.finest("Setting RowID");
        this.updateList(parameterIndex, x.toString());
    }

    @Override
    public void setRowId(String parameterName, java.sql.RowId x) throws SQLException {
        this.LOGGER.finest("Setting RowID");
        this.updateList(parameterName, x.toString());
    }

    @Override
    public void setURL(String parameterName, URL val) throws SQLException {
        this.LOGGER.finest("Setting URL");
        this.updateList(parameterName, val.toString());
        this.types.put(parameterName, "VARCHAR2");
    }

    @Override
    public void setBoolean(String parameterName, boolean x) throws SQLException {
        this.LOGGER.finest("Setting Boolean with parameterName: " + parameterName);
        this.updateList(parameterName, x);
        this.types.put(parameterName, "BOOLEAN");
    }

    @Override
    public void setInt(String parameterName, int x) throws SQLException {
        this.ensureOpen();
        this.LOGGER.finest("Setting Int for parameterName: " + parameterName);
        this.updateList(parameterName, x);
        this.types.put(parameterName, "INTEGER");
    }

    @Override
    public void setShort(String parameterName, short x) throws SQLException {
        this.ensureOpen();
        this.LOGGER.finest("Setting Short for parameterName: " + parameterName);
        this.updateList(parameterName, x);
        this.types.put(parameterName, "NUMBER");
    }

    @Override
    public void setLong(String parameterName, long x) throws SQLException {
        this.ensureOpen();
        this.LOGGER.finest("Setting Long with parameterName: " + parameterName);
        this.updateList(parameterName, x);
        this.types.put(parameterName, "NUMBER");
    }

    @Override
    public void setFloat(String parameterName, float x) throws SQLException {
        this.ensureOpen();
        this.LOGGER.finest("Setting Float with parameterName: " + parameterName);
        this.updateList(parameterName, Float.valueOf(x));
        this.types.put(parameterName, "FLOAT");
    }

    @Override
    public void setDouble(String parameterName, double x) throws SQLException {
        this.ensureOpen();
        this.LOGGER.finest("Setting Double with parameterName: " + parameterName);
        this.updateList(parameterName, x);
        this.types.put(parameterName, "NUMBER");
    }

    @Override
    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        this.ensureOpen();
        this.LOGGER.finest("Setting BigDecimal with parameterName: " + parameterName);
        this.updateList(parameterName, x);
        this.types.put(parameterName, "BIGDECIMAL");
    }

    @Override
    public void setString(String parameterName, String x) throws SQLException {
        this.ensureOpen();
        this.LOGGER.finest("Setting String with parameterName: " + parameterName);
        this.updateList(parameterName, x);
        this.types.put(parameterName, "VARCHAR2");
    }

    @Override
    public void clearParameters() throws SQLException {
        this.types.clear();
        this.data.clear();
        this.outTypes.clear();
        this.outParams = false;
        this.node = null;
    }

    @Override
    public java.sql.ParameterMetaData getParameterMetaData() throws SQLException {
        int parameterCount = this.types.size() + this.outTypes.size();
        int[] parameterMode = new int[parameterCount];
        for (int i = 0; i < parameterCount; ++i) {
            parameterMode[i] = 1;
        }
        return new ParameterMetaData(this.isNullable, this.isSigned, this.precision, this.scale, this.parameterType, this.parameterTypeName, this.parameterClassName, parameterMode, parameterCount);
    }

    @Override
    protected final void ensureOpen() throws SQLException {
        if (this.closed) {
            throw new SQLException(ExceptionUtil.getErrorMessage(17009));
        }
        if (this.conn == null) {
            throw new SQLException(ExceptionUtil.getErrorMessage(17008));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        Connection connection = this.conn;
        synchronized (connection) {
            this.closed = true;
            if (this.currentResultSet != null) {
                this.currentResultSet = null;
            }
            this.outTypes = null;
            this.data = null;
            this.types = null;
            this.outParams = false;
            this.sql = null;
        }
    }

    @Override
    public void setNull(String parameterName, int sqlType) throws SQLException {
        this.LOGGER.finest("Setting Null");
        this.updateList(parameterName, null);
        this.types.put(parameterName, OracleTypes.getSQLTypeName(sqlType));
    }

    @Override
    public void setClob(String parameterName, Clob x) throws SQLException {
        this.LOGGER.finest("Setting Clob");
        this.updateList(parameterName, x.getSubString(1L, (int)x.length()));
        this.types.put(parameterName, "CLOB");
    }

    @Override
    public void setByte(String parameterName, byte x) throws SQLException {
    }

    @Override
    public void setBytes(String parameterName, byte[] x) throws SQLException {
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        this.setAsciiStream(parameterName, x, (long)length);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
    }

    @Override
    public void setObject(String parameterName, Object x) throws SQLException {
        if (x instanceof Boolean) {
            this.setBoolean(parameterName, (boolean)((Boolean)x));
        } else if (x instanceof Integer) {
            this.setInt(parameterName, (int)((Integer)x));
        } else if (x instanceof Short) {
            this.setShort(parameterName, (short)((Short)x));
        } else if (x instanceof Long) {
            this.setLong(parameterName, (long)((Long)x));
        } else if (x instanceof Float) {
            this.setFloat(parameterName, ((Float)x).floatValue());
        } else if (x instanceof Double) {
            this.setDouble(parameterName, (double)((Double)x));
        } else if (x instanceof String) {
            this.setString(parameterName, (String)x);
        } else if (x instanceof Date) {
            this.setDate(parameterName, (Date)x);
        } else if (x instanceof Time) {
            this.setTime(parameterName, (Time)x);
        } else if (x instanceof Timestamp) {
            this.setTimestamp(parameterName, (Timestamp)x);
        } else if (x instanceof BigDecimal) {
            this.setBigDecimal(parameterName, (BigDecimal)x);
        }
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
    }

    @Override
    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
    }

    @Override
    public void setBlob(String parameterName, Blob x) throws SQLException {
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, long length) throws SQLException {
        try {
            int bytes;
            if (length < 0L) {
                int errorCode = 17068;
                throw new SQLException(ExceptionUtil.getErrorMessage(errorCode, RestjdbcResources.getString("RESTJDBC_019")), SQLStateMapping.getSQLState(errorCode), errorCode);
            }
            StringBuilder sb = new StringBuilder();
            for (long bytesRead = 0L; bytesRead < length && (bytes = x.read()) >= 0; ++bytesRead) {
                sb.append((char)bytes);
            }
            this.updateList(parameterName, sb.toString());
            this.types.put(parameterName, "VARCHAR");
        }
        catch (SQLException e) {
            throw e;
        }
        catch (IOException ioe) {
            this.LOGGER.log(Level.SEVERE, ioe.getMessage());
        }
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, long length) throws SQLException {
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, long length) throws SQLException {
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x) throws SQLException {
        try {
            StringBuilder sb = new StringBuilder();
            int bytes = 0;
            while (bytes != -1 && (bytes = x.read()) >= 0) {
                sb.append((char)bytes);
            }
            this.updateList(parameterName, sb.toString());
            this.types.put(parameterName, "CLOB");
        }
        catch (IOException ioe) {
            this.LOGGER.log(Level.SEVERE, ioe.getMessage());
        }
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "setBinaryStream(String parameterName, InputStream x)", this.getClass().getSimpleName()));
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "setCharacterStream(String parameterName, Reader reader)", this.getClass().getSimpleName()));
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "setNCharacterStream(String parameterName, Reader value)", this.getClass().getSimpleName()));
    }

    @Override
    public void setClob(String parameterName, Reader reader) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "setClob(String parameterName, Reader reader)", this.getClass().getSimpleName()));
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "setBlob(String parameterName, InputStream inputStream)", this.getClass().getSimpleName()));
    }

    @Override
    public void setNClob(String parameterName, Reader reader) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "setNClob(String parameterName, Reader reader)", this.getClass().getSimpleName()));
    }

    @Override
    public java.sql.Connection getConnection() throws SQLException {
        return this.conn;
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        this.ensureOpen();
        this.outTypes.put(parameterIndex, sqlType);
        this.outParams = true;
    }

    protected Map<Object, Integer> getOutTypes() {
        return this.outTypes;
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "registerOutParameter(int parameterIndex, int sqlType, int scale)", this.getClass().getSimpleName()));
    }

    @Override
    public boolean wasNull() throws SQLException {
        return false;
    }

    private void getIndexValidator(Object parameterIndex) throws SQLException {
        if ((parameterIndex instanceof Integer || parameterIndex instanceof String) && !this.outTypes.containsKey(parameterIndex)) {
            if (parameterIndex instanceof Integer) {
                int errorCode = 17310;
                throw new SQLException(RestjdbcResources.getString("ORA_17310"), SQLStateMapping.getSQLState(errorCode), errorCode);
            }
            if (parameterIndex instanceof String) {
                int errorCode = 17310;
                throw new SQLException(RestjdbcResources.getString("RESTJDBC_015"), SQLStateMapping.getSQLState(errorCode), errorCode);
            }
            int errorCode = 17323;
            throw new SQLException(RestjdbcResources.getString("ORA_17323"), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
    }

    @Override
    public String getString(int parameterIndex) throws SQLException {
        int errorCode = 17003;
        try {
            TreeNode resultJsonNode;
            TreeNode parameterResult = this.extractResult(parameterIndex);
            if (parameterResult != null && (resultJsonNode = parameterResult.get("result")) != null) {
                JSON json = JSON.std.with((TreeCodec)new JacksonJrsTreeCodec());
                if (resultJsonNode instanceof JrsNull) {
                    return null;
                }
                return json.asString((Object)resultJsonNode);
            }
            throw new SQLException(ExceptionUtil.getErrorMessage(errorCode), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException(ExceptionUtil.getErrorMessage(errorCode), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
    }

    @Override
    public boolean getBoolean(int parameterIndex) throws SQLException {
        TreeNode result = this.extractResult(parameterIndex).get("result");
        JSON json = JSON.std.with((TreeCodec)new JacksonJrsTreeCodec());
        try {
            return Boolean.parseBoolean(json.asString((Object)result));
        }
        catch (JSONObjectException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public byte getByte(int parameterIndex) throws SQLException {
        return 0;
    }

    @Override
    public short getShort(int parameterIndex) throws SQLException {
        this.ensureOpen();
        try {
            if (this.getVal(parameterIndex) == null) {
                return 0;
            }
            return (short)Double.parseDouble(this.getVal(parameterIndex));
        }
        catch (NumberFormatException e) {
            int errorCode = 17004;
            throw new SQLException(ExceptionUtil.getErrorMessage(errorCode), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
    }

    @Override
    public int getInt(int parameterIndex) throws SQLException {
        try {
            if (this.getVal(parameterIndex) == null) {
                return 0;
            }
            return (int)Double.parseDouble(this.getVal(parameterIndex));
        }
        catch (NumberFormatException e) {
            int errorCode = 17004;
            throw new SQLException(ExceptionUtil.getErrorMessage(errorCode), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
    }

    @Override
    public long getLong(int parameterIndex) throws SQLException {
        this.ensureOpen();
        try {
            if (this.getVal(parameterIndex) == null) {
                return 0L;
            }
            return Long.parseLong(this.getVal(parameterIndex));
        }
        catch (NumberFormatException e) {
            int errorCode = 17004;
            throw new SQLException(ExceptionUtil.getErrorMessage(errorCode), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
    }

    @Override
    public float getFloat(int parameterIndex) throws SQLException {
        this.ensureOpen();
        try {
            if (this.getVal(parameterIndex) == null) {
                return 0.0f;
            }
            return Float.parseFloat(this.getVal(parameterIndex));
        }
        catch (NumberFormatException e) {
            int errorCode = 17004;
            throw new SQLException(ExceptionUtil.getErrorMessage(errorCode), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
    }

    @Override
    public double getDouble(int parameterIndex) throws SQLException {
        this.ensureOpen();
        try {
            if (this.getVal(parameterIndex) == null) {
                return 0.0;
            }
            return Double.parseDouble(this.getVal(parameterIndex));
        }
        catch (NumberFormatException e) {
            int errorCode = 17004;
            throw new SQLException(ExceptionUtil.getErrorMessage(errorCode), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        if (this.closed) {
            int errorCode = 17009;
            throw new SQLException(ExceptionUtil.getErrorMessage(errorCode), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
        try {
            JSON json = JSON.std.with((TreeCodec)new JacksonJrsTreeCodec());
            String bigdecimal = json.asString((Object)this.extractResult(parameterIndex).get("result"));
            return new BigDecimal(bigdecimal);
        }
        catch (NumberFormatException e) {
            int errorCode = 17004;
            throw new SQLException(ExceptionUtil.getErrorMessage(errorCode), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
        catch (Exception e) {
            this.LOGGER.log(Level.SEVERE, e.getCause().toString());
            throw new SQLException(RestjdbcResources.get("RESTJDBC_010"));
        }
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        return null;
    }

    @Override
    public byte[] getBytes(int parameterIndex) throws SQLException {
        return null;
    }

    @Override
    public Date getDate(int parameterIndex) throws SQLException {
        this.ensureOpen();
        try {
            DateTimestampsUtil dtsUtil = new DateTimestampsUtil();
            return dtsUtil.getDate(this.getVal(parameterIndex), this.timeZoneID);
        }
        catch (IllegalArgumentException e) {
            int errorCode = 17004;
            throw new SQLException(ExceptionUtil.getErrorMessage(errorCode), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
    }

    @Override
    public Time getTime(int parameterIndex) throws SQLException {
        this.ensureOpen();
        try {
            Calendar cal = Calendar.getInstance(TimeZone.getDefault());
            DateTimestampsUtil dtsUtil = new DateTimestampsUtil();
            return dtsUtil.getTime(this.getVal(parameterIndex), this.timeZoneID, cal);
        }
        catch (IllegalArgumentException e) {
            int errorCode = 17004;
            throw new SQLException(ExceptionUtil.getErrorMessage(errorCode), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
        catch (SQLException e) {
            if (e.getMessage() != null) {
                throw new SQLException(e.getMessage(), e.getSQLState(), e.getErrorCode());
            }
            int errorCode = 17001;
            throw new SQLException(ExceptionUtil.getErrorMessage(errorCode), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        this.ensureOpen();
        try {
            DateTimestampsUtil ts = new DateTimestampsUtil();
            return ts.getTimestamp(this.getVal(parameterIndex), this.timeZoneID);
        }
        catch (IllegalArgumentException e) {
            int errorCode = 17004;
            throw new SQLException(ExceptionUtil.getErrorMessage(errorCode), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
    }

    @Override
    public Date getDate(String parameterName) throws SQLException {
        this.ensureOpen();
        try {
            DateTimestampsUtil dtsUtil = new DateTimestampsUtil();
            return dtsUtil.getDate(this.getVal(parameterName), "PST8PDT");
        }
        catch (IllegalArgumentException e) {
            int errorCode = 17004;
            throw new SQLException(ExceptionUtil.getErrorMessage(errorCode), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
    }

    @Override
    public Time getTime(String parameterName) throws SQLException {
        this.ensureOpen();
        try {
            Calendar cal = Calendar.getInstance(TimeZone.getDefault());
            DateTimestampsUtil dtsUtil = new DateTimestampsUtil();
            return dtsUtil.getTime(this.getVal(parameterName), this.timeZoneID, cal);
        }
        catch (IllegalArgumentException e) {
            int errorCode = 17004;
            throw new SQLException(ExceptionUtil.getErrorMessage(errorCode), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
        catch (SQLException e) {
            if (e.getMessage() != null) {
                throw new SQLException(e.getMessage(), e.getSQLState(), e.getErrorCode());
            }
            int errorCode = 17001;
            throw new SQLException(ExceptionUtil.getErrorMessage(errorCode), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
    }

    @Override
    public Timestamp getTimestamp(String parameterName) throws SQLException {
        this.ensureOpen();
        try {
            DateTimestampsUtil ts = new DateTimestampsUtil();
            return ts.getTimestamp(this.getVal(parameterName), this.timeZoneID);
        }
        catch (IllegalArgumentException e) {
            int errorCode = 17004;
            throw new SQLException(ExceptionUtil.getErrorMessage(errorCode), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
    }

    @Override
    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        try {
            DateTimestampsUtil ts = new DateTimestampsUtil();
            return ts.getDate(this.getVal(parameterIndex), this.timeZoneID, cal);
        }
        catch (IllegalArgumentException e) {
            int errorCode = 17004;
            throw new SQLException(ExceptionUtil.getErrorMessage(errorCode, "getDate"), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
    }

    @Override
    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        try {
            DateTimestampsUtil ts = new DateTimestampsUtil();
            return ts.getTime(this.getVal(parameterIndex), this.timeZoneID, cal);
        }
        catch (IllegalArgumentException e) {
            int errorCode = 17004;
            throw new SQLException(ExceptionUtil.getErrorMessage(errorCode, "getTime"), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        try {
            DateTimestampsUtil ts = new DateTimestampsUtil();
            return ts.getTimestamp(this.getVal(parameterIndex), this.timeZoneID, cal);
        }
        catch (IllegalArgumentException e) {
            int errorCode = 17004;
            throw new SQLException(ExceptionUtil.getErrorMessage(errorCode, "getTimestamp"), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
    }

    @Override
    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        try {
            DateTimestampsUtil ts = new DateTimestampsUtil();
            return ts.getDate(this.getVal(parameterName), this.timeZoneID, cal);
        }
        catch (IllegalArgumentException e) {
            int errorCode = 17004;
            throw new SQLException(ExceptionUtil.getErrorMessage(errorCode, "getDate"), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
    }

    @Override
    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        try {
            DateTimestampsUtil ts = new DateTimestampsUtil();
            return ts.getTime(this.getVal(parameterName), this.timeZoneID, cal);
        }
        catch (IllegalArgumentException e) {
            int errorCode = 17004;
            throw new SQLException(ExceptionUtil.getErrorMessage(errorCode, "getTime"), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
    }

    @Override
    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        try {
            DateTimestampsUtil ts = new DateTimestampsUtil();
            return ts.getTimestamp(this.getVal(parameterName), this.timeZoneID, cal);
        }
        catch (IllegalArgumentException e) {
            int errorCode = 17004;
            throw new SQLException(ExceptionUtil.getErrorMessage(errorCode, "getTimestamp"), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
    }

    @Override
    public Clob getClob(int parameterIndex) throws SQLException {
        JSON json = JSON.std.with((TreeCodec)new JacksonJrsTreeCodec());
        String result = null;
        try {
            result = json.asString((Object)this.extractResult(parameterIndex).get("result"));
            if (result == null) {
                return null;
            }
        }
        catch (JSONObjectException e) {
            int errorCode = 17089;
            throw new SQLException(e.getMessage(), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
        catch (IOException e) {
            int errorCode = 17089;
            throw new SQLException(e.getMessage(), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
        return new CLOB(result);
    }

    @Override
    public Object getObject(int parameterIndex) throws SQLException {
        try {
            this.getIndexValidator(parameterIndex);
            Object obj = this.getObjectHelper(parameterIndex);
            return obj;
        }
        catch (Exception e) {
            throw new SQLException(ExceptionUtil.getErrorMessage(17005), SQLStateMapping.getSQLState(17005), 17005);
        }
    }

    private Object getObjectHelper(Object parameterIndex) throws SQLException, JSONObjectException, IOException {
        block22: {
            try {
                if (this.closed) {
                    int errorCode = 17010;
                    throw new SQLException(ExceptionUtil.getErrorMessage(errorCode), SQLStateMapping.getSQLState(errorCode), errorCode);
                }
                JSON json = JSON.std.with((TreeCodec)new JacksonJrsTreeCodec());
                String type = json.asString((Object)this.extractResult(parameterIndex).get("data_type"));
                String value = json.asString((Object)this.extractResult(parameterIndex).get("result"));
                if (type.contains("NUMBER")) {
                    return Integer.parseInt(value);
                }
                if (type.contains("BINARY_DOUBLE")) {
                    return Double.parseDouble(value);
                }
                if (type.contains("BINARY_FLOAT")) {
                    return Float.valueOf(Float.parseFloat(value));
                }
                if (type.contains("LONG")) {
                    return Long.parseLong(value);
                }
                if (type.contains("CHAR") || type.contains("VARCHAR") || type.contains("VARCHAR2")) {
                    return value;
                }
                if (type.contains("DATE")) {
                    if (parameterIndex instanceof Integer) {
                        Date date_value = this.getDate((Integer)parameterIndex);
                        return date_value;
                    }
                    if (parameterIndex instanceof String) {
                        Date date_value = this.getDate((String)parameterIndex);
                        return date_value;
                    }
                } else if (type.contains("TIMESTAMP")) {
                    if (parameterIndex instanceof Integer) {
                        Timestamp timestamp_value = this.getTimestamp((Integer)parameterIndex);
                        return timestamp_value;
                    }
                    if (parameterIndex instanceof String) {
                        Timestamp timestamp_value = this.getTimestamp((String)parameterIndex);
                        return timestamp_value;
                    }
                } else if (type.contains("TIME")) {
                    if (parameterIndex instanceof Integer) {
                        Time time_value = this.getTime((Integer)parameterIndex);
                        return time_value;
                    }
                    if (parameterIndex instanceof String) {
                        Time time_value = this.getTime((String)parameterIndex);
                        return time_value;
                    }
                }
            }
            catch (NullPointerException ne) {
                if (ne.getMessage() != null) {
                    this.LOGGER.log(Level.SEVERE, ne.getMessage());
                }
                int errorCode = 17003;
                throw new SQLException(ExceptionUtil.getErrorMessage(errorCode), SQLStateMapping.getSQLState(errorCode), errorCode);
            }
            catch (NumberFormatException e) {
                int errorCode = 17004;
                throw new SQLException(ExceptionUtil.getErrorMessage(errorCode), SQLStateMapping.getSQLState(errorCode), errorCode);
            }
            catch (SQLException e) {
                if (e.getMessage() == null) break block22;
                throw new SQLException(e.getMessage(), e.getSQLState(), e.getErrorCode());
            }
        }
        int errorCode = 17005;
        throw new SQLException(ExceptionUtil.getErrorMessage(17005), SQLStateMapping.getSQLState(17005), 17005);
    }

    @Override
    public java.sql.RowId getRowId(int parameterIndex) throws SQLException {
        String rowID = null;
        try {
            this.getIndexValidator(parameterIndex);
            JSON json = JSON.std.with((TreeCodec)new JacksonJrsTreeCodec());
            rowID = json.asString((Object)this.extractResult(parameterIndex).get("result"));
        }
        catch (IllegalArgumentException e) {
            int errorCode = 17004;
            throw new SQLException(ExceptionUtil.getErrorMessage(errorCode, "getRowId"), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
        catch (JSONObjectException e) {
            int errorCode = 17089;
            throw new SQLException(e.getMessage(), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
        catch (IOException e) {
            int errorCode = 17089;
            throw new SQLException(e.getMessage(), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
        return new RowId(rowID);
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, String typeName) throws SQLException {
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        this.ensureOpen();
        this.outTypes.put(parameterName, sqlType);
        this.outParams = true;
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
    }

    @Override
    public URL getURL(int parameterIndex) throws SQLException {
        String str_url = null;
        if (this.closed) {
            int errorCode = 17009;
            throw new SQLException(ExceptionUtil.getErrorMessage(errorCode), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
        try {
            this.getIndexValidator(parameterIndex);
            JSON json = JSON.std.with((TreeCodec)new JacksonJrsTreeCodec());
            try {
                str_url = json.asString((Object)this.extractResult(parameterIndex).get("result"));
                str_url = str_url.substring(1, str_url.length() - 1);
            }
            catch (JSONObjectException e) {
                int errorCode = 17089;
                throw new SQLException(e.getMessage(), SQLStateMapping.getSQLState(errorCode), errorCode);
            }
            catch (IOException e) {
                int errorCode = 17089;
                throw new SQLException(e.getMessage(), SQLStateMapping.getSQLState(errorCode), errorCode);
            }
            return new URL(str_url);
        }
        catch (MalformedURLException e) {
            int errorCode = 17004;
            throw new SQLException(ExceptionUtil.getErrorMessage(errorCode, "getURL"), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
    }

    @Override
    public String getString(String parameterName) throws SQLException {
        String result = null;
        try {
            JSON json = JSON.std.with((TreeCodec)new JacksonJrsTreeCodec());
            return json.asString((Object)this.extractResult(parameterName).get("result"));
        }
        catch (SQLException e) {
            if (e.getMessage() != null) {
                throw new SQLException(e.getMessage(), e.getSQLState(), e.getErrorCode());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            int errorCode = 17001;
            throw new SQLException(e.getMessage(), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
        return result;
    }

    @Override
    public boolean getBoolean(String parameterName) throws SQLException {
        JSON json = JSON.std.with((TreeCodec)new JacksonJrsTreeCodec());
        TreeNode result = this.extractResult(parameterName).get("result");
        String bool = null;
        try {
            bool = json.asString((Object)result);
            if (bool.equalsIgnoreCase("true")) {
                return true;
            }
        }
        catch (JSONObjectException e) {
            int errorCode = 17089;
            throw new SQLException(e.getMessage(), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
        catch (IOException e) {
            int errorCode = 17089;
            throw new SQLException(e.getMessage(), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
        return Boolean.parseBoolean(bool);
    }

    @Override
    public short getShort(String parameterName) throws SQLException {
        this.ensureOpen();
        try {
            if (this.getVal(parameterName) == null) {
                return 0;
            }
            return (short)Double.parseDouble(this.getVal(parameterName));
        }
        catch (NumberFormatException e) {
            int errorCode = 17004;
            throw new SQLException(ExceptionUtil.getErrorMessage(errorCode), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
    }

    @Override
    public int getInt(String parameterName) throws SQLException {
        try {
            if (this.getVal(parameterName) == null) {
                return 0;
            }
            return (int)Double.parseDouble(this.getVal(parameterName));
        }
        catch (NumberFormatException e) {
            int errorCode = 17004;
            throw new SQLException(ExceptionUtil.getErrorMessage(errorCode), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
    }

    @Override
    public long getLong(String parameterName) throws SQLException {
        this.ensureOpen();
        try {
            if (this.getVal(parameterName) == null) {
                return 0L;
            }
            return Long.parseLong(this.getVal(parameterName));
        }
        catch (NumberFormatException e) {
            int errorCode = 17004;
            throw new SQLException(ExceptionUtil.getErrorMessage(errorCode), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
    }

    @Override
    public float getFloat(String parameterName) throws SQLException {
        this.ensureOpen();
        try {
            if (this.getVal(parameterName) == null) {
                return 0.0f;
            }
            return Float.parseFloat(this.getVal(parameterName));
        }
        catch (NumberFormatException e) {
            int errorCode = 17004;
            throw new SQLException(ExceptionUtil.getErrorMessage(errorCode), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
    }

    @Override
    public double getDouble(String parameterName) throws SQLException {
        this.ensureOpen();
        try {
            if (this.getVal(parameterName) == null) {
                return 0.0;
            }
            return Double.parseDouble(this.getVal(parameterName));
        }
        catch (NumberFormatException e) {
            int errorCode = 17004;
            throw new SQLException(ExceptionUtil.getErrorMessage(errorCode), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
    }

    @Override
    public Object getObject(String parameterName) throws SQLException {
        if (this.closed) {
            int errorCode = 17009;
            throw new SQLException(ExceptionUtil.getErrorMessage(errorCode), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
        try {
            this.getIndexValidator(parameterName);
            Object obj = this.getObjectHelper(parameterName);
            return obj;
        }
        catch (Exception e) {
            int errorCode = 17005;
            throw new SQLException(ExceptionUtil.getErrorMessage(17005), SQLStateMapping.getSQLState(17005), 17005);
        }
    }

    @Override
    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        try {
            if (this.getVal(parameterName) == null) {
                return BigDecimal.valueOf(0.0);
            }
            return BigDecimal.valueOf(Double.parseDouble(this.getVal(parameterName)));
        }
        catch (NumberFormatException e) {
            int errorCode = 17004;
            throw new SQLException(ExceptionUtil.getErrorMessage(errorCode), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
    }

    @Override
    public Clob getClob(String parameterName) throws SQLException {
        JSON json = JSON.std.with((TreeCodec)new JacksonJrsTreeCodec());
        String result = null;
        try {
            result = json.asString((Object)this.extractResult(parameterName).get("result"));
            if (result == null) {
                return null;
            }
        }
        catch (JSONObjectException e) {
            int errorCode = 17089;
            throw new SQLException(e.getMessage(), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
        catch (IOException e) {
            int errorCode = 17089;
            throw new SQLException(e.getMessage(), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
        return new CLOB(result);
    }

    @Override
    public URL getURL(String parameterName) throws SQLException {
        String str_url = null;
        if (this.closed) {
            int errorCode = 17009;
            throw new SQLException(ExceptionUtil.getErrorMessage(errorCode), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
        try {
            this.getIndexValidator(parameterName);
            JSON json = JSON.std.with((TreeCodec)new JacksonJrsTreeCodec());
            try {
                str_url = json.asString((Object)this.extractResult(parameterName).get("result"));
            }
            catch (JSONObjectException e) {
                int errorCode = 17089;
                throw new SQLException(e.getMessage(), SQLStateMapping.getSQLState(errorCode), errorCode);
            }
            catch (IOException e) {
                int errorCode = 17089;
                throw new SQLException(e.getMessage(), SQLStateMapping.getSQLState(errorCode), errorCode);
            }
            return new URL(str_url);
        }
        catch (MalformedURLException e) {
            int errorCode = 17004;
            throw new SQLException(ExceptionUtil.getErrorMessage(errorCode, "getURL"), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
    }

    @Override
    public java.sql.RowId getRowId(String parameterName) throws SQLException {
        String rowID = null;
        try {
            this.getIndexValidator(parameterName);
            JSON json = JSON.std.with((TreeCodec)new JacksonJrsTreeCodec());
            try {
                rowID = json.asString((Object)this.extractResult(parameterName).get("result"));
            }
            catch (JSONObjectException e) {
                int errorCode = 17089;
                throw new SQLException(e.getMessage(), SQLStateMapping.getSQLState(errorCode), errorCode);
            }
            catch (IOException e) {
                int errorCode = 17089;
                throw new SQLException(e.getMessage(), SQLStateMapping.getSQLState(errorCode), errorCode);
            }
            return new RowId(rowID);
        }
        catch (IllegalArgumentException e) {
            int errorCode = 17004;
            throw new SQLException(ExceptionUtil.getErrorMessage(errorCode, "getRowId"), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_NOTIMPLEMENTED", "executeUpdate(String sql, int autoGeneratedKeys)", this.getClass().getSimpleName()));
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_NOTIMPLEMENTED", "executeUpdate(String sql, int[] columnIndexes)", this.getClass().getSimpleName()));
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_NOTIMPLEMENTED", "executeUpdate(String sql, String[] columnNames)", this.getClass().getSimpleName()));
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_NOTIMPLEMENTED", "execute(String sql, int autoGeneratedKeys)", this.getClass().getSimpleName()));
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_NOTIMPLEMENTED", "execute(String sql, int[] columnIndexes)", this.getClass().getSimpleName()));
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_NOTIMPLEMENTED", "execute(String sql, String[] columnNames) ", this.getClass().getSimpleName()));
    }

    @Override
    public Object getObject(int parameterIndex, Map<String, Class<?>> map) throws SQLException {
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_NOTIMPLEMENTED", "getObject(int parameterIndex, Map<String, Class<?>> map)", this.getClass().getSimpleName()));
    }

    @Override
    public Ref getRef(int parameterIndex) throws SQLException {
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_NOTIMPLEMENTED", "getRef(int parameterIndex)", this.getClass().getSimpleName()));
    }

    @Override
    public Blob getBlob(int parameterIndex) throws SQLException {
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_NOTIMPLEMENTED", "getBlob(int parameterIndex)", this.getClass().getSimpleName()));
    }

    @Override
    public Array getArray(int parameterIndex) throws SQLException {
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_NOTIMPLEMENTED", "getArray(int parameterIndex)", this.getClass().getSimpleName()));
    }

    @Override
    public byte[] getBytes(String parameterName) throws SQLException {
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_NOTIMPLEMENTED", "getBytes(String parameterName)", this.getClass().getSimpleName()));
    }

    @Override
    public byte getByte(String parameterName) throws SQLException {
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_NOTIMPLEMENTED", "getByte(String parameterName)", this.getClass().getSimpleName()));
    }

    @Override
    public Object getObject(String parameterName, Map<String, Class<?>> map) throws SQLException {
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_NOTIMPLEMENTED", "getObject(String parameterName, Map<String, Class<?>> map)", this.getClass().getSimpleName()));
    }

    @Override
    public Ref getRef(String parameterName) throws SQLException {
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_NOTIMPLEMENTED", "getRef(String parameterName)", this.getClass().getSimpleName()));
    }

    @Override
    public Blob getBlob(String parameterName) throws SQLException {
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_NOTIMPLEMENTED", "getBlob(String parameterName)", this.getClass().getSimpleName()));
    }

    @Override
    public Array getArray(String parameterName) throws SQLException {
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_NOTIMPLEMENTED", "getArray(String parameterName)", this.getClass().getSimpleName()));
    }

    @Override
    public void setNString(String parameterName, String value) throws SQLException {
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_NOTIMPLEMENTED", "setNString(String parameterName, String value)", this.getClass().getSimpleName()));
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_NOTIMPLEMENTED", "setNCharacterStream(String parameterName, Reader value,long length)", this.getClass().getSimpleName()));
    }

    @Override
    public void setNClob(String parameterName, NClob value) throws SQLException {
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_NOTIMPLEMENTED", "setNClob(String parameterName, NClob value)", this.getClass().getSimpleName()));
    }

    @Override
    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_NOTIMPLEMENTED", "setClob(String parameterName, Reader reader, long length)", this.getClass().getSimpleName()));
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_NOTIMPLEMENTED", "setBlob(String parameterName, InputStream inputStream,long length)", this.getClass().getSimpleName()));
    }

    @Override
    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_NOTIMPLEMENTED", "setNClob(String parameterName, Reader reader, long length)", this.getClass().getSimpleName()));
    }

    @Override
    public NClob getNClob(int parameterIndex) throws SQLException {
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_NOTIMPLEMENTED", "getNClob(int parameterIndex)", this.getClass().getSimpleName()));
    }

    @Override
    public NClob getNClob(String parameterName) throws SQLException {
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_NOTIMPLEMENTED", "getNClob(String parameterName)", this.getClass().getSimpleName()));
    }

    @Override
    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_NOTIMPLEMENTED", "setSQLXML(String parameterName, SQLXML xmlObject)", this.getClass().getSimpleName()));
    }

    @Override
    public SQLXML getSQLXML(int parameterIndex) throws SQLException {
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_NOTIMPLEMENTED", "getSQLXML(int parameterIndex)", this.getClass().getSimpleName()));
    }

    @Override
    public SQLXML getSQLXML(String parameterName) throws SQLException {
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_NOTIMPLEMENTED", "getSQLXML(String parameterName)", this.getClass().getSimpleName()));
    }

    @Override
    public String getNString(int parameterIndex) throws SQLException {
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_NOTIMPLEMENTED", "getNString(int parameterIndex)", this.getClass().getSimpleName()));
    }

    @Override
    public String getNString(String parameterName) throws SQLException {
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_NOTIMPLEMENTED", "getNString(String parameterName)", this.getClass().getSimpleName()));
    }

    @Override
    public Reader getNCharacterStream(int parameterIndex) throws SQLException {
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_NOTIMPLEMENTED", "getNCharacterStream(int parameterIndex)", this.getClass().getSimpleName()));
    }

    @Override
    public Reader getNCharacterStream(String parameterName) throws SQLException {
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_NOTIMPLEMENTED", "getNCharacterStream(String parameterName)", this.getClass().getSimpleName()));
    }

    @Override
    public Reader getCharacterStream(int parameterIndex) throws SQLException {
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_NOTIMPLEMENTED", "getCharacterStream(int parameterIndex)", this.getClass().getSimpleName()));
    }

    @Override
    public Reader getCharacterStream(String parameterName) throws SQLException {
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_NOTIMPLEMENTED", "getCharacterStream(String parameterName)", this.getClass().getSimpleName()));
    }

    @Override
    public <T> T getObject(int parameterIndex, Class<T> type) throws SQLException {
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_NOTIMPLEMENTED", "getObject(int parameterIndex, Class<T> type)", this.getClass().getSimpleName()));
    }

    @Override
    public <T> T getObject(String parameterName, Class<T> type) throws SQLException {
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_NOTIMPLEMENTED", "getObject(String parameterName, Class<T> type)", this.getClass().getSimpleName()));
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    protected Integer truncateInt(String numString) {
        String theString = numString;
        if (theString == null) {
            return null;
        }
        int theDot = theString.lastIndexOf(46);
        if (theDot != -1) {
            theString = theString.substring(0, theDot);
        }
        return Integer.parseInt(theString);
    }
}

