/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.jobs;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicReference;
import oracle.dbtools.extension.jobs.JobsMessages;
import oracle.dbtools.extension.jobs.exceptions.JobNotFoundException;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskStatus;
import oracle.dbtools.raptor.backgroundTask.ITaskTracker;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.command.CommandTask;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.dbtools.util.SqlId;

public class JobsProcessor {
    static List<Job> jobs = new ArrayList<Job>();
    private static JobsTaskTracker<?> jobsTaskTracker = new JobsTaskTracker();
    private static Object _waitLock = new Object();

    public static void init(ScriptRunnerContext ctx) {
        RaptorTaskManager.getInstance().setIDETaskTracker(jobsTaskTracker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void list(ScriptRunnerContext ctx, Integer id, String taskName) {
        if (jobs.size() == 0) {
            ctx.writeln(JobsMessages.getString("Jobs.NoJobs"));
            return;
        }
        if (!JobsProcessor.details(ctx, id, taskName)) {
            int cnt = 0;
            List<Job> list = jobs;
            synchronized (list) {
                for (Job job : jobs) {
                    int logFileLength;
                    int taskStatusLength;
                    int taskIdLength;
                    int lineSize;
                    int taskNameMaxLength;
                    ++cnt;
                    RaptorTask<?> task = job.getTask();
                    Object logFile = "";
                    if (job.getTask() instanceof CommandTask) {
                        logFile = "(" + ((CommandTask)job.getTask()).getLog().toString() + ")";
                    }
                    if ((taskNameMaxLength = (lineSize = Integer.parseInt(ctx.getProperty("script.runner.setlinesize").toString())) - (taskIdLength = 4) - (taskStatusLength = 14) - (logFileLength = ((String)logFile).length())) < 5) {
                        taskNameMaxLength = 5;
                    }
                    if (taskNameMaxLength > task.getDescriptor().getName().length()) {
                        taskNameMaxLength = task.getDescriptor().getName().length();
                    }
                    String taskName2 = task.getDescriptor().getName().substring(0, taskNameMaxLength);
                    String line = String.format("%1$2d: [ %2$-8s ] %3$s %4$s", job.getId(), task.getStatus().value(), taskName2, logFile);
                    ctx.writeln(line);
                }
            }
            if (cnt == 0) {
                ctx.writeln(JobsMessages.getString("Jobs.NoJobs"));
            }
        }
    }

    private static void printDetail(ScriptRunnerContext ctx, String msgKey, Object value) {
        ctx.writeln(String.format("%1$-18s: %2$s", JobsMessages.get(msgKey), value));
    }

    private static boolean details(ScriptRunnerContext ctx, Integer id, String taskName) {
        if (id == null && (taskName == null || taskName.isEmpty())) {
            return false;
        }
        try {
            List<Job> foundJobs = JobsProcessor.checkGetJobs(id, taskName);
            int foundJobsSize = foundJobs.size();
            int lastJobIndex = foundJobsSize - 1;
            for (int i = 0; i < foundJobsSize; ++i) {
                JobsProcessor.printTaskDetails(ctx, foundJobs.get(i));
                if (i >= lastJobIndex) continue;
                JobsProcessor.printSeparator(ctx);
            }
        }
        catch (JobNotFoundException e) {
            ctx.writeln(e.getMessage());
        }
        return true;
    }

    private static void printTaskDetails(ScriptRunnerContext ctx, Job job) {
        if (job == null) {
            return;
        }
        RaptorTask<?> task = job.getTask();
        JobsProcessor.printDetail(ctx, "Jobs.Details.Id", job.getId());
        JobsProcessor.printDetail(ctx, "Jobs.Details.Name", task.getDescriptor().getName());
        JobsProcessor.printDetail(ctx, "Jobs.Details.Status", task.getDescriptor().getStatus().value());
        JobsProcessor.printDetail(ctx, "Jobs.Details.Message", task.getDescriptor().getMessage());
        JobsProcessor.printDetail(ctx, "Jobs.Details.Throwable", task.getDescriptor().getThrowable());
        JobsProcessor.printDetail(ctx, "Jobs.Details.StartedAt", JobsProcessor.toDateTimeString(task.getDescriptor().getStartTime()));
        JobsProcessor.printDetail(ctx, "Jobs.Details.Progress", task.getDescriptor().getProgress());
        JobsProcessor.printDetail(ctx, "Jobs.Details.ProgressAt", JobsProcessor.toDateTimeString(task.getDescriptor().getLastProgressTime()));
        JobsProcessor.printDetail(ctx, "Jobs.Details.ElapsedTime", task.getDescriptor().getElapsedTime());
        JobsProcessor.printDetail(ctx, "Jobs.Details.Waiting4", JobsProcessor.getWaitingFor(task));
        if (task instanceof CommandTask) {
            Connection conn;
            CommandTask commandTask = (CommandTask)task;
            JobsProcessor.printDetail(ctx, "Jobs.Details.Logfile", commandTask.getLog());
            ScriptRunnerContext tctx = commandTask.getCtx();
            if (tctx != null) {
                JobsProcessor.printDetail(ctx, "Jobs.Details.Context", tctx.toString());
            }
            if ((conn = commandTask.getConn()) != null) {
                JobsProcessor.printDetail(ctx, "Jobs.Details.Connection", conn.toString());
                String url = commandTask.getConnUrl();
                String user = commandTask.getConnUser();
                String role = ctx.getPrivilege(ScriptRunnerContext.SqlplusVariable._PRIVILEGE.toString());
                JobsProcessor.printDetail(ctx, "Jobs.Details.Connection", user + "@" + url + " " + role);
                String conid = ctx.getConnectionID(ScriptRunnerContext.SqlplusVariable._CONNECT_IDENTIFIER.toString());
                if (conid != null && !conid.equals("")) {
                    JobsProcessor.printDetail(ctx, "Jobs.Details.ConnectionIdentifier", conid);
                }
            }
            JobsProcessor.printDetail(ctx, "Jobs.Details.Command", commandTask.getCmd());
            try {
                JobsProcessor.printDetail(ctx, "Jobs.Details.Sqlid", SqlId.stmt2sqlid((String)commandTask.getCmd()));
            }
            catch (Exception url) {
                // empty catch block
            }
            ParsedCommand parsedCmd = commandTask.getParsedCmd();
            if (parsedCmd != null) {
                JobsProcessor.printDetail(ctx, "Jobs.Details.ParsedCommand", parsedCmd);
            }
        }
        JobsProcessor.printDetail(ctx, "Jobs.Details.InDeterminate", task.getDescriptor().isInDeterminate());
        JobsProcessor.printDetail(ctx, "Jobs.Details.Cancellable", task.isCancellable());
        JobsProcessor.printDetail(ctx, "Jobs.Details.Pausable", task.getRaptorTaskProgressUpdater().isPausable());
    }

    private static void printSeparator(ScriptRunnerContext ctx) {
        int terminalWidth = ctx.getSQLPlusConsoleReader().getWidth();
        ctx.writeln("-".repeat(terminalWidth / 2));
    }

    private static String getWaitingFor(RaptorTask<?> task) {
        Object w4taskString = "";
        for (String w4task : task.getTasksToWait4()) {
            if (((String)w4taskString).length() > 0) {
                w4taskString = (String)w4taskString + ", ";
            }
            w4taskString = (String)w4taskString + w4task;
        }
        return w4taskString;
    }

    public static void cancel(ScriptRunnerContext ctx, Integer id, String taskName) {
        try {
            List<Job> foundJobs = JobsProcessor.checkGetJobs(id, taskName);
            for (Job job : foundJobs) {
                JobsProcessor.cancelTask(ctx, job.getTask());
            }
        }
        catch (JobNotFoundException e) {
            ctx.writeln(e.getMessage());
        }
    }

    private static void cancelTask(ScriptRunnerContext ctx, RaptorTask<?> task) {
        if (task != null) {
            IRaptorTaskStatus status = task.getStatus();
            if (status == IRaptorTaskStatus.FINISHED) {
                ctx.writeln(JobsMessages.getString("Jobs.Cancel.Finished"));
            } else if (status == IRaptorTaskStatus.FAILED) {
                ctx.writeln(JobsMessages.getString("Jobs.Cancel.Failed"));
            } else if (status == IRaptorTaskStatus.PAUSED) {
                ctx.writeln(JobsMessages.getString("Jobs.Cancel.Paused"));
            } else if (!task.isCancellable()) {
                ctx.writeln(JobsMessages.getString("Jobs.Cancel.NotCancellable"));
            } else {
                task.requestCancel();
                ctx.writeln(JobsMessages.getString("Jobs.Cancel.Request"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delete(ScriptRunnerContext ctx, Integer id, String taskName, boolean all, boolean finished) {
        if (!all && !finished && id == null && taskName == null) {
            ctx.writeln(JobsMessages.getString("Jobs.Delete.NoJobs"));
            return;
        }
        try {
            JobsProcessor.checkGetJobs(id, taskName);
        }
        catch (JobNotFoundException e) {
            ctx.writeln(e.getMessage());
            return;
        }
        int cnt = 0;
        List<Job> list = jobs;
        synchronized (list) {
            Iterator<Job> iter = jobs.iterator();
            while (iter.hasNext()) {
                Job job = iter.next();
                if (!(all || finished && job.getTask().getStatus() == IRaptorTaskStatus.FINISHED || id != null && job.getId() == id.intValue()) && (taskName == null || !job.getTask().getDescriptor().getName().equals(taskName))) continue;
                iter.remove();
                ++cnt;
            }
        }
        ctx.writeln(JobsMessages.format("Jobs.Delete.Deleted", cnt));
    }

    public static void showLogs(ScriptRunnerContext ctx, Integer id, String taskName) {
        try {
            List<Job> foundJobs = JobsProcessor.checkGetJobs(id, taskName);
            int foundJobsSize = foundJobs.size();
            int lastJobIndex = foundJobsSize - 1;
            for (int i = 0; i < foundJobsSize; ++i) {
                JobsProcessor.showTaskLogs(ctx, foundJobs.get(i).getTask());
                if (i >= lastJobIndex) continue;
                JobsProcessor.printSeparator(ctx);
            }
        }
        catch (JobNotFoundException e) {
            ctx.writeln(e.getMessage());
        }
    }

    private static void showTaskLogs(ScriptRunnerContext ctx, RaptorTask<?> task) {
        if (task != null && task instanceof CommandTask) {
            CommandTask commandTask = (CommandTask)task;
            try {
                commandTask.getCtx().getOutputStream().flush();
                Files.copy((File)commandTask.getLog(), (OutputStream)ctx.getOutputStream());
            }
            catch (IOException e) {
                ctx.writeln(JobsMessages.format("Jobs.Logs.ShowError", e.getMessage()));
            }
        }
    }

    public static void deleteLogs(ScriptRunnerContext ctx) {
        try {
            Files.fileTraverser().depthFirstPostOrder((Object)new File(CommandTask.getLogPath())).forEach(File::delete);
            ctx.writeln(JobsMessages.format("Jobs.Logs.DeleteOk", CommandTask.getLogPath()));
        }
        catch (Exception e) {
            ctx.writeln(JobsMessages.format("Jobs.Logs.DeleteError", e.getMessage()));
        }
    }

    public static void run(ScriptRunnerContext ctx, Connection conn, ISQLCommand cmd, final String cmdToRun, String taskname, final List<String> wait4) {
        if (cmdToRun == null || cmdToRun.isBlank()) {
            ctx.writeln(JobsMessages.format("Jobs.Run.NoCommand", new Object[0]));
            return;
        }
        String tname = taskname;
        if (tname == null || tname.isBlank()) {
            tname = cmdToRun.replaceAll("[^a-zA-Z0-9]+", "");
        }
        CommandTask task = new CommandTask(tname, false){

            protected Void doWork() throws TaskException {
                if (wait4 != null && !wait4.isEmpty()) {
                    this.wait4(wait4);
                    JobsProcessor.checkFailedTasks(this, wait4);
                    try {
                        this.checkCanProceed();
                    }
                    catch (ExecutionException e) {
                        return null;
                    }
                }
                ScriptExecutor scriptExecutor = new ScriptExecutor(this.getConn());
                scriptExecutor.setScriptRunnerContext(this.getCtx());
                scriptExecutor.setStmt(cmdToRun);
                scriptExecutor.run();
                if (((Boolean)this.getCtx().getProperty("sqldev.error")).booleanValue()) {
                    String errorMsg = (String)this.getCtx().getProperty("sqldev.last.err.message");
                    this.getDescriptor().setMessage(errorMsg);
                    throw new TaskException(errorMsg);
                }
                this.getDescriptor().setMessage(JobsMessages.getString("Jobs.Run.Successful"));
                this.getDescriptor().makeProgress(1);
                return null;
            }
        };
        task.setCancellable(true);
        task.setPausable(true);
        task.setCtx(ctx);
        task.setConn(conn);
        task.setCmd(cmdToRun);
        RaptorTaskManager.getInstance().addTask((RaptorTask)task);
        JobsProcessor.showIdForNewTask(ctx, task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkFailedTasks(CommandTask commandTask, List<String> tasks) throws TaskException {
        for (String task : tasks) {
            List<Job> list = jobs;
            synchronized (list) {
                for (Job job : jobs) {
                    if (!task.equals(job.getTask().getDescriptor().getName()) || job.getTask().getStatus() != IRaptorTaskStatus.FAILED) continue;
                    String message = JobsMessages.format("Jobs.Run.FailDependent", job.getTask().getDescriptor().getName());
                    commandTask.getDescriptor().setMessage(message);
                    commandTask.getCtx().writeln(message);
                    throw new TaskException(message);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void showIdForNewTask(ScriptRunnerContext ctx, CommandTask task) {
        boolean found = false;
        while (!found) {
            List<Job> list = jobs;
            synchronized (list) {
                for (Job job : jobs) {
                    if (task != job.getTask()) continue;
                    ctx.writeln(JobsMessages.format("Jobs.Run.Started", job.getId()));
                    found = true;
                    break;
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static void wait4(List<String> taskList, Integer delay) {
        if (delay != null && delay > 0) {
            try {
                Thread.sleep(delay.intValue());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (taskList != null && !taskList.isEmpty()) {
            RaptorTaskManager.getInstance().wait4(taskList, _waitLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Job> checkGetJobs(Integer id, String taskName) {
        AtomicReference foundJobs = new AtomicReference(new ArrayList());
        if (id != null) {
            List<Job> list = jobs;
            synchronized (list) {
                for (Job job : jobs) {
                    if (job.getId() != id.intValue()) continue;
                    ((List)foundJobs.get()).add(job);
                    return foundJobs.get();
                }
                throw new JobNotFoundException(JobsMessages.format("Jobs.NoJobWithId", id));
            }
        }
        if (taskName != null && !taskName.isBlank()) {
            List<Job> list = jobs;
            synchronized (list) {
                for (Job job : jobs) {
                    if (!job.getTask().getDescriptor().getName().equals(taskName)) continue;
                    ((List)foundJobs.get()).add(job);
                }
                if (((List)foundJobs.get()).isEmpty()) {
                    throw new JobNotFoundException(JobsMessages.format("Jobs.NoJobWithName", taskName));
                }
            }
        }
        return foundJobs.get();
    }

    private static String toDateTimeString(long millis) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(millis), ZoneId.systemDefault()).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Integer> getExistingJobIds() {
        ArrayList<Integer> jobsIds = new ArrayList<Integer>();
        List<Job> list = jobs;
        synchronized (list) {
            for (Job job : jobs) {
                jobsIds.add(job.getId());
            }
        }
        return jobsIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getExistingJobNames() {
        ArrayList<String> jobsNames = new ArrayList<String>();
        List<Job> list = jobs;
        synchronized (list) {
            for (Job job : jobs) {
                jobsNames.add(job.getTask().getDescriptor().getName());
            }
        }
        return jobsNames;
    }

    private static class JobsTaskTracker<V>
    implements ITaskTracker<V> {
        private JobsTaskTracker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(RaptorTask<V> task, FutureTask<V> rfTask) {
            if (!this.isRaptorTaskCleanup(task)) {
                List<Job> list = jobs;
                synchronized (list) {
                    jobs.add(new Job(task, rfTask));
                }
            }
        }

        private boolean isRaptorTaskCleanup(RaptorTask<?> task) {
            return task.getClass().getName().equals("oracle.dbtools.raptor.backgroundTask.RaptorTaskManager$RaptorFutureTask$1$1");
        }
    }

    static class Job {
        private final RaptorTask<?> task;
        private final FutureTask<?> rfTask;
        private final int id = nextId++;
        private static int nextId = 0;

        public Job(RaptorTask<?> task, FutureTask<?> rfTask) {
            this.task = task;
            this.rfTask = rfTask;
        }

        public int getId() {
            return this.id;
        }

        public RaptorTask<?> getTask() {
            return this.task;
        }

        public FutureTask<?> getRfTask() {
            return this.rfTask;
        }
    }
}

