/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.oci.objectstorage;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import oracle.dbtools.core.oci.Messages;
import oracle.dbtools.core.oci.OCIUtils;
import oracle.dbtools.core.oci.objectstorage.ObjectDetails;
import oracle.dbtools.core.oci.objectstorage.ObjectStorageException;
import oracle.dbtools.core.oci.objectstorage.ObjectStorageUtils;

public class ObjectPutOptions
extends ObjectDetails {
    private final Long contentLength;
    private final Path filePath;
    private final boolean noOverwrite;
    private final String objectName;
    private static final String NEW_LINE = System.getProperty("line.separator");

    private ObjectPutOptions(Builder builder) {
        super(builder);
        this.validate(builder);
        this.filePath = builder.filePath;
        this.noOverwrite = builder.noOverwrite;
        this.objectName = builder.objectName != null ? builder.objectName : this.filePath.getFileName().toString();
        this.contentLength = this.getFileSize(builder.filePath);
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    public InputStream getInputStream() {
        try {
            return Files.newInputStream(this.filePath, new OpenOption[0]);
        }
        catch (IOException e) {
            String putMsg = Messages.format("OBJECTSTORAGE_ERROR_PUT_OBJECT", this.getObjectName(), this.getBucketName());
            ObjectStorageUtils.rethrowException(e.getCause(), e.getLocalizedMessage(), putMsg);
            return null;
        }
    }

    public Path getFilePath() {
        return this.filePath;
    }

    public boolean noOverwrite() {
        return this.noOverwrite;
    }

    public String getObjectName() {
        return this.objectName;
    }

    private void validate(Builder builder) {
        String errMsg;
        StringBuilder sb = new StringBuilder();
        if (OCIUtils.isEmpty(builder.namespace)) {
            sb.append(Messages.getString("OBJECTSTORAGE_ERROR_REQUIRE_NAMESPACE")).append(NEW_LINE);
        }
        if (OCIUtils.isEmpty(builder.bucketName)) {
            sb.append(Messages.getString("OBJECTSTORAGE_ERROR_REQUIRE_BUCKETNAME")).append(NEW_LINE);
        }
        if ((errMsg = this.checkFile(builder.filePath)) != null) {
            sb.append(errMsg);
        }
        if (builder.noOverwrite && !OCIUtils.isEmpty(builder.eTag)) {
            sb.append(Messages.format("OBJECTSTORAGE_ERROR_ETAG_NO_OVERWRITE_PARAM", builder.eTag)).append(NEW_LINE);
        }
        if (sb.length() > 0) {
            throw new ObjectStorageException(sb.toString());
        }
    }

    private String checkFile(Path file) {
        StringBuilder sb = new StringBuilder();
        if (file == null) {
            sb.append(Messages.getString("OBJECTSTORAGE_ERROR_REQUIRE_FILE")).append(NEW_LINE);
        } else if (!Files.exists(file, new LinkOption[0])) {
            sb.append(Messages.format("OBJECTSTORAGE_ERROR_FILE_NOT_EXIST", file.toString())).append(NEW_LINE);
        } else if (Files.isDirectory(file, new LinkOption[0])) {
            sb.append(Messages.format("OBJECTSTORAGE_ERROR_FILE_IS_DIR", file.toString())).append(NEW_LINE);
        } else if (!Files.isReadable(file)) {
            sb.append(Messages.format("OBJECTSTORAGE_ERROR_FILE_NOT_READABLE", file.toString())).append(NEW_LINE);
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return null;
    }

    private long getFileSize(Path filePath) {
        try {
            return Files.size(filePath);
        }
        catch (IOException e) {
            String putMsg = Messages.format("OBJECTSTORAGE_ERROR_PUT_OBJECT", this.getObjectName(), this.getBucketName());
            ObjectStorageUtils.rethrowException(e.getCause(), e.getLocalizedMessage(), putMsg);
            return 0L;
        }
    }

    public static Builder builder(String namespace, String bucketName, Path filePath) {
        return new Builder(namespace, bucketName, filePath);
    }

    public static final class Builder
    extends ObjectDetails.Builder<Builder, ObjectPutOptions> {
        private final Path filePath;
        private boolean noOverwrite;
        private String objectName;

        private Builder(String namespace, String bucketName, Path filePath) {
            super(namespace, bucketName);
            this.filePath = filePath;
        }

        @Override
        public ObjectPutOptions build() {
            return new ObjectPutOptions(this);
        }

        public Builder noOverwrite(boolean noOverwrite) {
            this.noOverwrite = noOverwrite;
            return this;
        }

        public Builder objectName(String objectName) {
            this.objectName = objectName;
            return this;
        }
    }
}

