/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.oci.objectstorage;

import com.oracle.bmc.objectstorage.responses.DeleteObjectResponse;
import java.time.Instant;

public class ObjectDeleteResult {
    private final String bucketName;
    private final Instant lastModified;
    private final String namespace;
    private final String objectName;
    private final String opcClientRequestId;
    private final int statusCode;
    private final String versionId;

    private ObjectDeleteResult(Builder builder) {
        this.bucketName = builder.bucketName;
        this.lastModified = builder.lastModified;
        this.namespace = builder.namespace;
        this.objectName = builder.objectName;
        this.opcClientRequestId = builder.opcClientRequestId;
        this.statusCode = builder.statusCode;
        this.versionId = builder.versionId;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public Instant getLastModified() {
        return this.lastModified;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public String getVersionId() {
        return this.versionId;
    }

    static Builder builder(DeleteObjectResponse response, String namespace, String bucketName, String objectName) {
        return new Builder(namespace, bucketName, objectName).lastModified(response.getLastModified() != null ? response.getLastModified().toInstant() : null).statusCode(response.get__httpStatusCode__()).opcClientRequestId(response.getOpcClientRequestId()).versionId(response.getVersionId());
    }

    static class Builder {
        private final String bucketName;
        private final String namespace;
        private final String objectName;
        private Instant lastModified;
        private String opcClientRequestId;
        private int statusCode;
        private String versionId;

        private Builder(String namespace, String bucketName, String objectName) {
            this.namespace = namespace;
            this.bucketName = bucketName;
            this.objectName = objectName;
        }

        public ObjectDeleteResult build() {
            return new ObjectDeleteResult(this);
        }

        public Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public Builder statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }
    }
}

