/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.oci;

import com.oracle.bmc.ConfigFileReader;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.AuthenticationDetailsProvider;
import com.oracle.bmc.auth.ConfigFileAuthenticationDetailsProvider;
import com.oracle.bmc.auth.SessionTokenAuthenticationDetailsProvider;
import java.io.IOException;
import java.nio.file.Path;
import oracle.dbtools.core.collections.ConfigurationProperties;
import oracle.dbtools.core.oci.AuthenticationProvider;
import oracle.dbtools.core.oci.Messages;
import oracle.dbtools.core.oci.OCIUtils;
import oracle.dbtools.core.oci.OverrideAuthenticationDetailsProvider;

public final class OCIProfile
implements AuthenticationProvider {
    public static final String PROFILE_TYPE = "PROFILE";
    public static final String PROFILE_NAME_KEY = "ProfileName";
    private final String profileName;
    private final ConfigFileReader.ConfigFile configFile;
    private final AuthenticationDetailsProvider provider;

    public static Builder builder() {
        return new Builder();
    }

    private OCIProfile(Builder builder) throws IOException {
        this.profileName = builder.profileName;
        String configFilePath = builder.configFile.toAbsolutePath().toString();
        try {
            this.configFile = ConfigFileReader.parse((String)configFilePath, (String)this.profileName);
            String key_file = this.configFile.get("key_file");
            this.provider = OCIUtils.isEmpty(key_file) ? new SessionTokenAuthenticationDetailsProvider(this.configFile) : new ConfigFileAuthenticationDetailsProvider(this.configFile);
        }
        catch (IllegalStateException | NullPointerException e) {
            throw new IOException(Messages.format("OCI_INVALID_PROFILE", configFilePath, e.getLocalizedMessage()));
        }
    }

    private OCIProfile(String profileName, ConfigFileReader.ConfigFile configFile, AuthenticationDetailsProvider provider) {
        this.profileName = profileName;
        this.configFile = configFile;
        this.provider = provider;
    }

    @Override
    public AbstractAuthenticationDetailsProvider getAuthenticationProvider() {
        return this.provider;
    }

    @Override
    public String getAuthenticationType() {
        return PROFILE_TYPE;
    }

    @Override
    public String getTenantId() {
        return this.provider.getTenantId();
    }

    @Override
    public String getAuthenticationProperty(String propertyName) {
        return PROFILE_NAME_KEY.equals(propertyName) ? this.profileName : this.configFile.get(propertyName);
    }

    public OCIProfile wrap(ConfigurationProperties overrides) {
        OverrideAuthenticationDetailsProvider overrideProvider = OverrideAuthenticationDetailsProvider.of(overrides, this.provider);
        return new OCIProfile(this.profileName, this.configFile, overrideProvider);
    }

    public static final class Builder {
        private String profileName;
        private Path configFile;

        private Builder() {
        }

        public Builder profileName(String profileName) {
            this.profileName = profileName;
            return this;
        }

        public Builder configFile(Path configFile) {
            this.configFile = configFile;
            return this;
        }

        public OCIProfile build() throws IOException {
            return new OCIProfile(this);
        }
    }
}

