/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.oci;

import com.oracle.bmc.database.DatabaseClient;
import com.oracle.bmc.database.model.GenerateAutonomousDatabaseWalletDetails;
import com.oracle.bmc.database.requests.GenerateAutonomousDatabaseWalletRequest;
import com.oracle.bmc.database.requests.GetAutonomousDatabaseRequest;
import com.oracle.bmc.database.responses.GenerateAutonomousDatabaseWalletResponse;
import com.oracle.bmc.database.responses.GetAutonomousDatabaseResponse;
import com.oracle.bmc.http.client.Options;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Random;
import java.util.stream.IntStream;
import oracle.dbtools.core.jdbc.wallet.OracleWalletArchive;
import oracle.dbtools.core.oci.AuthenticationProvider;
import oracle.dbtools.core.oci.OCIClient;
import oracle.dbtools.core.oci.OCIClientException;

public class OCIDatabaseServiceClient
extends OCIClient {
    private final DatabaseClient databaseClient = (DatabaseClient)this.createClient(DatabaseClient.builder());

    public static Builder builder(AuthenticationProvider profile) {
        return new Builder(profile);
    }

    private OCIDatabaseServiceClient(Builder builder) {
        super(builder);
    }

    public OracleWalletArchive getWallet(String autonomousDatabaseId) {
        OracleWalletArchive oracleWalletArchive;
        block8: {
            Options.shouldAutoCloseResponseInputStream((boolean)false);
            GenerateAutonomousDatabaseWalletResponse walletResponse = OCIDatabaseServiceClient.executeRequest(() -> this.databaseClient.generateAutonomousDatabaseWallet(GenerateAutonomousDatabaseWalletRequest.builder().autonomousDatabaseId(autonomousDatabaseId).generateAutonomousDatabaseWalletDetails(GenerateAutonomousDatabaseWalletDetails.builder().password(OCIDatabaseServiceClient.generatePassword()).build()).build()));
            InputStream is = walletResponse.getInputStream();
            try {
                OracleWalletArchive.Builder walletBuilder = OracleWalletArchive.builder((InputStream)is);
                oracleWalletArchive = walletBuilder.build();
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw OCIClientException.of(ex);
                }
            }
            is.close();
        }
        return oracleWalletArchive;
    }

    public String getPrivateEndpointIp(String autonomousDatabaseId) {
        GetAutonomousDatabaseRequest autonomousDatabaseRequest = GetAutonomousDatabaseRequest.builder().autonomousDatabaseId(autonomousDatabaseId).build();
        GetAutonomousDatabaseResponse autonomousDatabaseResponse = OCIDatabaseServiceClient.executeRequest(() -> this.databaseClient.getAutonomousDatabase(autonomousDatabaseRequest));
        return autonomousDatabaseResponse.getAutonomousDatabase().getPrivateEndpointIp();
    }

    private static String generatePassword() {
        Random random = new Random();
        ArrayList<Character> chars = new ArrayList<Character>();
        for (int i = 0; i < 2; ++i) {
            chars.add(Character.valueOf('@'));
            chars.add(Character.valueOf('#'));
        }
        IntStream ints = random.ints(2L, 48, 57);
        ints.forEach(value -> chars.add(Character.valueOf((char)value)));
        IntStream upperAlphas = random.ints(8L, 65, 90);
        upperAlphas.forEach(value -> chars.add(Character.valueOf((char)value)));
        StringBuilder buff = new StringBuilder();
        IntStream lowerAlphas = random.ints(12L, 97, 122);
        lowerAlphas.forEach(value -> {
            if (buff.length() == 0) {
                buff.append((char)value);
            } else {
                chars.add(Character.valueOf((char)value));
            }
        });
        Collections.shuffle(chars, random);
        Iterator iterator = chars.iterator();
        while (iterator.hasNext()) {
            char ch = ((Character)iterator.next()).charValue();
            buff.append(ch);
        }
        return buff.toString();
    }

    public static final class Builder
    extends OCIClient.Builder<Builder, OCIDatabaseServiceClient> {
        private Builder(AuthenticationProvider profile) {
            super(profile);
        }

        @Override
        public OCIDatabaseServiceClient build() {
            return new OCIDatabaseServiceClient(this);
        }
    }
}

