/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.jdv.ddl;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.crest.model.PropertiesObject;
import oracle.dbtools.crest.model.scheduling.JSONToPropertiesObject;
import oracle.dbtools.jdv.ddl.Quoting;
import oracle.dbtools.jdv.ddl.SQLProcessor;
import oracle.dbtools.jdv.ddl.SqlGenerator;
import oracle.dbtools.jdv.model.JDVConstants;
import oracle.dbtools.jdv.model.JDVElement;
import oracle.dbtools.jdv.model.JDVView;
import oracle.dbtools.mle_js.ExpNode;

public class GqlGenerator
implements JDVConstants {
    private static Set<String> conflicts = new HashSet<String>();

    public static String getGQLQuery(String json, boolean includeSchema, boolean queryOnly) {
        JDVView view = GqlGenerator.getView(json);
        return GqlGenerator.getGQLQuery(view, includeSchema, queryOnly);
    }

    public static String getGQLQuery(JDVView view, boolean includeSchema, boolean queryOnly) {
        ExpNode.StringAdd res = new ExpNode.StringAdd();
        GqlGenerator.addTable(view.getDefinition(), 0, res, includeSchema, queryOnly);
        return res.toString();
    }

    public static String getGQLQueryOnRoot(JDVElement rootTable, boolean includeSchema, boolean queryOnly) {
        ExpNode.StringAdd res = new ExpNode.StringAdd();
        GqlGenerator.addTable(rootTable, 0, res, includeSchema, queryOnly);
        return res.toString();
    }

    public static String getViewDefinition(String json, boolean update, boolean includeSchema) {
        return GqlGenerator.getViewDefinition(json, update, includeSchema, false, false);
    }

    public static String getViewDefinition(String json, boolean update, boolean includeSchema, boolean queryOnly, boolean checkMixedCase) {
        JDVView view = GqlGenerator.getView(json);
        return GqlGenerator.getViewDefinition(view, update, includeSchema, queryOnly, checkMixedCase);
    }

    public static String getViewDefinition(JDVView view, boolean update, boolean includeSchema) {
        return GqlGenerator.getViewDefinition(view, update, includeSchema, false, false);
    }

    public static String getViewDefinition(JDVView view, boolean update, boolean includeSchema, boolean queryOnly, boolean checkMixedCase) {
        view.applyViewOwnerToTables();
        if (!queryOnly) {
            return GqlGenerator.getCreatePart(view, update, includeSchema, checkMixedCase) + "\n" + GqlGenerator.getGQLQuery(view, includeSchema, queryOnly) + "\n;" + (String)(view.hasCommentInRdbmsDefined() ? "\n\n" + SqlGenerator.getCommentDDL(view, checkMixedCase) : "");
        }
        return "SELECT * from GRAPHQL('" + GqlGenerator.getGQLQuery(view, includeSchema, queryOnly) + "')\n;";
    }

    private static String getCreatePart(JDVView view, boolean update, boolean includeSchema, boolean checkMixedCase) {
        Object res = "CREATE";
        if (update) {
            res = (String)res + " OR REPLACE";
        }
        res = (String)res + " FORCE";
        res = GqlGenerator.getBoolean(view.getEditionable(), true) ? (String)res + " EDITIONABLE" : (String)res + " NONEDITIONABLE";
        res = (String)res + " JSON RELATIONAL DUALITY VIEW ";
        if (includeSchema && view.getView_owner() != null) {
            res = (String)res + GqlGenerator.getName(view.getView_owner()) + ".";
        }
        res = (String)res + GqlGenerator.getName(view.getView_name(), checkMixedCase);
        res = (String)res + "\n AS ";
        return res;
    }

    private static void addTable(JDVElement table, int position, ExpNode.StringAdd res, boolean includeSchema, boolean queryOnly) {
        String filter;
        String tableName = table.getName();
        String key = GqlGenerator.getKey(table.getJson_key_name());
        boolean addSchema = includeSchema || table.getTable_owner() != null && !table.getTable_owner().equals(table.getView_owner());
        boolean unnested = GqlGenerator.getBoolean(table.getUnnested(), false);
        String tableDDLName = GqlGenerator.getTable_DDL_Name(table, addSchema);
        if (!unnested) {
            if (key != null && !key.isEmpty()) {
                res.addTabs(key, position);
                res.addText(tableDDLName);
            } else {
                res.addTabs(tableDDLName, position);
            }
        } else {
            res.addTabs(GqlGenerator.getName(tableName), position);
            res.addText(" @unnest");
        }
        if (!queryOnly) {
            if (table.isCheckSet() && !GqlGenerator.getBoolean(table.getCheck(), true)) {
                res.addText(" @nocheck");
            }
            if (table.isInsertSet() && GqlGenerator.getBoolean(table.getAllow_insert(), false)) {
                res.addText(" @insert");
            }
            if (table.isUpdateSet() && GqlGenerator.getBoolean(table.getAllow_update(), false)) {
                res.addText(" @update");
            }
            if (table.isDeleteSet() && GqlGenerator.getBoolean(table.getAllow_delete(), false)) {
                res.addText(" @delete");
            }
        }
        if ((filter = table.getTableFilter()) != null) {
            if (!table.isGqlTablefilter()) {
                filter = GqlGenerator.removeDoubleQuotes(filter);
            }
            if (queryOnly) {
                filter = GqlGenerator.replaceSingleQuote(filter);
            }
        }
        if (filter != null && !filter.isEmpty()) {
            res.addNL_Tabs("@where (sql: \"" + filter + "\")", position + 1);
        }
        if (table.getFkColumns() != null) {
            if (!unnested || !table.isOneToOneCardinality()) {
                res.addNL_Tabs(" @link (to : [" + table.getFkColumns() + "])", position + 2);
            }
        } else if (table.getOther_FkColumns() != null) {
            res.addNL_Tabs(" @link (from : [" + table.getOther_FkColumns() + "])", position + 2);
        }
        res.addText(" {");
        GqlGenerator.addElements(table, GqlGenerator.getName(tableName), table.getElements(), position, res, includeSchema, queryOnly);
        res.addNL_Tabs("}", position);
    }

    public static String replaceSingleQuote(String input) {
        return input.replaceAll("\\'", "\\'\\'");
    }

    public static String removeDoubleQuotes(String input) {
        String ch = "\"";
        String res = input;
        while (res.indexOf(34) > -1) {
            res = res.replace(ch, "");
        }
        return res;
    }

    static String shiftWithoutFirstLine(String expr, int pos) {
        List<String> exprLlines = SQLProcessor.stringToList(expr);
        if (exprLlines.size() > 1) {
            Object res = exprLlines.get(0);
            Object res2 = "";
            for (int i = 1; i < exprLlines.size(); ++i) {
                res2 = (String)res2 + exprLlines.get(i);
            }
            res = (String)res + SQLProcessor.indentString((String)res2, pos);
            return res;
        }
        return expr;
    }

    private static void addColumn(JDVElement element, int position, ExpNode.StringAdd res, JDVElement table, boolean queryOnly) {
        boolean tableCheck = GqlGenerator.getBoolean(table.getCheck(), true);
        boolean tableUpdate = GqlGenerator.getBoolean(table.getAllow_update(), false);
        String key = GqlGenerator.getKey(element.getJson_key_name());
        if (!(key == null || key.isEmpty() || element.isFlexColumn() || element.isGenerated())) {
            res.addTabs(key, position);
            res.addText(GqlGenerator.getName(element.getColumn_name()));
        } else if (element.isGenerated()) {
            key = GqlGenerator.getName(element.getJson_keyOrColumn_name());
            res.addTabs(key, position);
        } else {
            res.addTabs(GqlGenerator.getName(element.getColumn_name()), position);
        }
        if (element.isGenerated()) {
            String type = element.getGenerateType();
            String expr = element.getGeneratedExpression();
            Object gen = " @generated ";
            if (!(type == null || type.isEmpty() || type.equalsIgnoreCase("directive") || expr == null || expr.isEmpty())) {
                gen = (String)gen + "(" + type.toLowerCase(Locale.ROOT) + " : \"" + GqlGenerator.shiftWithoutFirstLine(expr, position * 4 + key.length() + 20).stripTrailing() + "\")";
                res.addText((String)gen);
            }
        }
        Object withClause = "";
        if (!queryOnly && !element.isGenerated()) {
            String update;
            String check = element.getCheck();
            if (check != null) {
                if ("false".equalsIgnoreCase(check)) {
                    if (tableCheck) {
                        withClause = " @nocheck";
                    }
                } else if (!tableCheck) {
                    withClause = " @check";
                }
            }
            if ((update = element.getAllow_update()) != null) {
                if ("false".equalsIgnoreCase(update)) {
                    if (tableUpdate) {
                        withClause = (String)withClause + " @noupdate";
                    }
                } else if (!tableUpdate) {
                    withClause = (String)withClause + " @update";
                }
            }
        }
        if (GqlGenerator.getBoolean(element.getIs_flex_col(), false)) {
            withClause = (String)withClause + " @flex " + GqlGenerator.getFlexConflictResolution(element);
        } else if (GqlGenerator.getBoolean(element.getHidden(), false)) {
            withClause = (String)withClause + " @hidden ";
        }
        if (!((String)withClause).isEmpty()) {
            res.addText((String)withClause);
        }
    }

    private static String getFlexConflictResolution(JDVElement element) {
        if (GqlGenerator.getBoolean(element.getIs_flex_col(), false)) {
            String choice = element.getConflictResolutionOnFlex();
            if (choice != null) {
                choice = choice.toUpperCase(Locale.ROOT);
            }
            if (conflicts.contains(choice)) {
                return "(conflict: " + choice + ")";
            }
        }
        return "";
    }

    private static void addElements(JDVElement table, String tableName, List<JDVElement> list, int position, ExpNode.StringAdd res, boolean includeSchema, boolean queryOnly) {
        HashSet<String> addedNested = new HashSet<String>();
        Map<String, List<JDVElement>> nested = GqlGenerator.createNestingMap(list);
        for (JDVElement el : list) {
            if (!el.isTable()) {
                if (el.getNestedKey() != null && !el.getNestedKey().isEmpty()) {
                    if (addedNested.contains(el.getJson_key_name())) continue;
                    GqlGenerator.addNestedColumns(tableName, el.getNestedKey(), nested, addedNested, position + 1, res, table, queryOnly);
                    addedNested.add(el.getJson_key_name());
                    continue;
                }
                res.addNL();
                GqlGenerator.addColumn(el, position + 1, res, table, queryOnly);
                continue;
            }
            res.addNL();
            GqlGenerator.addTable(el, position + 1, res, includeSchema, queryOnly);
        }
    }

    private static void addNestedColumns(String tableName, String nestedKey, Map<String, List<JDVElement>> nested, Set<String> addedNested, int position, ExpNode.StringAdd res, JDVElement table, boolean queryOnly) {
        String key = GqlGenerator.getKey(nestedKey);
        List<JDVElement> list = nested.get(nestedKey);
        if (key != null && !key.isEmpty() && list != null && list.size() > 0) {
            res.addNL_Tabs(key, position);
            res.addText(tableName).addText(" @nest {");
            for (JDVElement el : list) {
                res.addNL();
                GqlGenerator.addColumn(el, position + 1, res, table, queryOnly);
                addedNested.add(el.getJson_key_name());
            }
            res.addNL_Tabs("}", position);
        }
    }

    private static Map<String, List<JDVElement>> createNestingMap(List<JDVElement> list) {
        HashMap<String, List<JDVElement>> map = new HashMap<String, List<JDVElement>>();
        for (JDVElement el : list) {
            if (el.getNestedKey() == null || el.getNestedKey().isEmpty()) continue;
            ArrayList<JDVElement> nested = (ArrayList<JDVElement>)map.get(el.getNestedKey());
            if (nested == null) {
                nested = new ArrayList<JDVElement>();
                map.put(el.getNestedKey(), nested);
            }
            nested.add(el);
        }
        return map;
    }

    private static boolean getBoolean(String value, boolean defValue) {
        if (value == null) {
            return defValue;
        }
        return "true".equalsIgnoreCase(value) || "1".equalsIgnoreCase(value);
    }

    private static String getName(String name) {
        return GqlGenerator.getName(name, false);
    }

    private static String getName(String name, boolean checkMixedCase) {
        if (!Quoting.isValidIdentifier(name) || checkMixedCase && Quoting.isMixedCase(name)) {
            if (!Quoting.isQuoted(name)) {
                return "\"" + name + "\"";
            }
            return name;
        }
        if (Quoting.isQuoted(name)) {
            return name;
        }
        return name.toLowerCase(Locale.ROOT);
    }

    private static String getKey(String key) {
        if (key != null && !key.isEmpty()) {
            return key + " : ";
        }
        return "";
    }

    public static String getTable_DDL_Name(JDVElement table, boolean includeSchema) {
        if (includeSchema) {
            Object longName = "";
            if (table.getTable_owner() != null) {
                longName = GqlGenerator.getName(table.getTable_owner()) + ".";
            }
            longName = (String)longName + GqlGenerator.getName(table.getTable_name());
            return longName;
        }
        return GqlGenerator.getName(table.getTable_name());
    }

    public static JsonObject getJSON(String json) {
        ByteArrayInputStream stream = new ByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8));
        return Json.createReader((InputStream)stream).readObject();
    }

    public static JDVView getView(String json) {
        JDVView view = new JDVView();
        JSONToPropertiesObject transformer = new JSONToPropertiesObject();
        transformer.transformToObject((PropertiesObject)view, json);
        return view;
    }

    static {
        conflicts.add("KEEP_NESTED");
        conflicts.add("IGNORE");
        conflicts.add("ARRAY");
        conflicts.add("ERROR");
    }
}

