/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.jdv.dbimport;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.jdv.dbimport.MOHJDViewHandler;
import oracle.dbtools.jdv.dbimport.Transform;
import oracle.dbtools.jdv.model.JDVView;
import oracle.dbtools.util.Closeables;

public class DBMExtractionHandlerJDV {
    int release = 0;
    int version = 11;
    double dbVersion = 11.0;
    private Boolean dba = null;

    public DBMExtractionHandlerJDV(Connection conn) {
        this.init(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void init(Connection conn) {
        ResultSet rs;
        PreparedStatement statement;
        block5: {
            String sql = "with\nfunction ver return number is\nbegin\n return dbms_db_version.version;\nend;\nfunction rel return number is\nbegin \n return dbms_db_version.release;\nend;\nselect ver version , rel release from dual";
            statement = null;
            rs = null;
            try {
                String rel;
                String[] parts;
                String ver;
                int ind;
                statement = conn.prepareStatement(sql);
                rs = statement.executeQuery();
                if (rs == null || !rs.next()) break block5;
                this.version = rs.getInt(1);
                this.release = rs.getInt(2);
                this.dbVersion = (double)this.version + (double)this.release / 10.0;
                if (this.release == 0 && (ind = (ver = conn.getMetaData().getDatabaseProductVersion()).indexOf("Version " + this.version + ".")) > 0 && (parts = (rel = ver.substring(ind + 8)).split("\\.")).length > 1) {
                    this.dbVersion += (double)Integer.valueOf(parts[1]).intValue() / 10.0;
                }
                rs.close();
            }
            catch (Throwable throwable) {
                Closeables.close((Object[])new AutoCloseable[]{rs, statement});
                catch (Throwable throwable2) {
                    Closeables.close((Object[])new AutoCloseable[]{rs, statement});
                    throw throwable2;
                }
            }
        }
        Closeables.close((Object[])new AutoCloseable[]{rs, statement});
    }

    public boolean hasDbaAccess(Connection conn, List<String> names) throws SQLException {
        if (this.getDBVersion() >= 12.2 && names.size() > 0) {
            String sql1 = "WITH\n    FUNCTION HAS_DBA_ACCESS RETURN VARCHAR2 AS\n        NAME VARCHAR2(200);\n        TYPE TNAMES IS\n            VARRAY(40) OF VARCHAR2(128);\n        NAMES TNAMES := TNAMES(";
            String sql2 = ");\n    BEGIN\n        FOR I IN 1..NAMES.COUNT LOOP\n            NAME := SYS.DBMS_ASSERT.SQL_OBJECT_NAME(NAMES(I));\n        END LOOP;\n        RETURN 'true';\n    EXCEPTION\n        WHEN OTHERS THEN\n            RETURN 'false';\n    END;\nSELECT HAS_DBA_ACCESS FROM DUAL";
            String sql = null;
            for (String name : names) {
                if (sql == null) {
                    sql = sql1 + "'" + name + "'";
                    continue;
                }
                sql = (String)sql + ",'" + name + "'";
            }
            sql = sql + sql2;
            try (PreparedStatement statement = conn.prepareStatement(sql);
                 ResultSet rs = statement.executeQuery();){
                if (rs != null && rs.next()) {
                    String dba = rs.getString(1);
                    rs.close();
                    boolean bl = "TRUE".equalsIgnoreCase(dba);
                    return bl;
                }
            }
        }
        return false;
    }

    public boolean hasDbaAccess(Connection conn) throws SQLException {
        if (this.dba == null) {
            ArrayList<String> list = new ArrayList<String>();
            list.add("SYS.DBA_JSON_DUALITY_VIEWS");
            list.add("SYS.DBA_JSON_DUALITY_VIEW_TABS");
            list.add("SYS.DBA_JSON_DUALITY_VIEW_TAB_COLS");
            list.add("SYS.DBA_JSON_DUALITY_VIEW_LINKS");
            this.dba = this.hasDbaAccess(conn, list) ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.dba;
    }

    public static void main(String[] args) {
    }

    public int getRelease() {
        return this.release;
    }

    public int getVersion() {
        return this.version;
    }

    public double getDBVersion() {
        return this.dbVersion;
    }

    public JDVView getJDVView(Connection conn, String schema, String name) throws SQLException, IOException {
        MOHJDViewHandler moh = new MOHJDViewHandler(this);
        return moh.getJDVView(conn, schema, name);
    }

    public String getJDVViewAndUsedTablesDetails(Connection conn, String schema, String name) throws SQLException, IOException {
        MOHJDViewHandler moh = new MOHJDViewHandler(this);
        return moh.getJDVViewAndUsedTablesDetails(conn, schema, name);
    }

    public String getDualitViewJsonSchema(Connection conn, String schema, String name) throws SQLException, IOException {
        MOHJDViewHandler moh = new MOHJDViewHandler(this);
        JDVView view = moh.getDualityViewWithJsonSchema(conn, schema, name);
        String jsonSchema = null;
        if (view.getParsedRoot() != null) {
            jsonSchema = Transform.rootToJsonSchema(view.getDefinition());
        }
        if (jsonSchema == null) {
            jsonSchema = view.getJsonSchema();
        }
        return jsonSchema;
    }
}

