/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle.v10g;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexGlobalPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexGlobalPartitionsListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UniqueOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexGlobalPartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexGlobalPartitionsListOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexHashPartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.SegmentOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableProxySetOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableSpaceOraclev10g;

public class UniqueOraclev10g
extends UniqueOracle {
    public static final String LOCAL = "LOCAL";
    public static final String GLOBAL_BY_RANGE = "GLOBAL BY RANGE";
    public static final String GLOBAL_HASH_PARTITIONED_BY_QUANTITY = "GLOBAL HASH PARTITIONED BY QUANTITY";
    public static final String GLOBAL_HASH_PARTITIONED_BY_LIST = "GLOBAL HASH PARTITIONED BY LIST";
    public static final String BY_INDEX_NAME = "BY INDEX NAME";
    public static final String BY_CREATE_INDEX_STATEMENT = "BY CREATE INDEX STATEMENT";
    public static final String SORTED = "SORTED";
    public static final String REVERSE = "REVERSE";
    private static final String[] USING_INDEX = new String[]{"NO", "LOCAL", "GLOBAL BY RANGE", "GLOBAL HASH PARTITIONED BY QUANTITY", "GLOBAL HASH PARTITIONED BY LIST", "BY INDEX NAME", "BY CREATE INDEX STATEMENT"};
    private static Set usingIndexSet = null;
    private String usingIndex = "NO";
    private String createIndexStatement = "";
    private static final String[] INDEX_SORT = new String[]{"NO", "SORTED", "REVERSE"};
    private static Set indexSortSet = null;
    private String indexSort = "SORTED";
    private String computeStatistics = "NO";

    public UniqueOraclev10g(Index index, StorageDesign storageDesign) {
        super(index, storageDesign);
    }

    public UniqueOraclev10g(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
    }

    @Override
    protected void initPartitions(StorageDesignOracle storageDesign) {
        super.initPartitions(storageDesign);
        ((StorageDesignOraclev10g)storageDesign).getIndexHashPartitionSet().addSetListener(this);
    }

    public static String[] getUsingIndexChoices() {
        return USING_INDEX;
    }

    private boolean checkUsingIndex(String value) {
        if (usingIndexSet == null) {
            usingIndexSet = new HashSet();
            usingIndexSet.addAll(Arrays.asList(UniqueOraclev10g.getUsingIndexChoices()));
        }
        return usingIndexSet.contains(value);
    }

    @Override
    public void setUsingIndex(String using) {
        if (this.checkUsingIndex(using)) {
            if (!this.usingIndex.equalsIgnoreCase(using)) {
                this.partitions.removeAll();
            }
            this.usingIndex = using;
            if (this.usingIndex.equalsIgnoreCase(GLOBAL_BY_RANGE)) {
                this.enableSubPartitionsByRange();
            } else if (this.usingIndex.equalsIgnoreCase(GLOBAL_HASH_PARTITIONED_BY_LIST)) {
                this.enableSubPartitionsByHash();
            } else {
                this.partitions.setForbiddenCreateElement(true);
                this.partitions.removeAll();
            }
            this.fireDataFieldChange();
        }
    }

    private void enableSubPartitionsByRange() {
        for (IndexGlobalPartitionOraclev10g part : ((StorageDesignOraclev10g)this.getStorageDesign()).getIndexGlobalPartitionSet()) {
            if (part.getIndexGlobalPartList() == null || part.getIndexGlobalPartList() != this.getUsingIndexGlobalPL()) continue;
            this.partitions.setForbiddenCreateElement(true);
        }
    }

    private void enableSubPartitionsByHash() {
        for (IndexHashPartitionOraclev10g part : ((StorageDesignOraclev10g)this.getStorageDesign()).getIndexHashPartitionSet()) {
            if (part.getIndexGlobalPartList() == null || part.getIndexGlobalPartList() != this.getUsingIndexGlobalPL()) continue;
            this.partitions.setForbiddenCreateElement(true);
        }
    }

    @Override
    public String getUsingIndex() {
        return this.usingIndex;
    }

    @Override
    public void showPropertyDialog() {
    }

    @Override
    public void changed(StorageObject object, ObjectChangeEvent event) {
        if (event.getAffected() instanceof IndexGlobalPartitionOracle) {
            IndexGlobalPartitionOracle igp = (IndexGlobalPartitionOracle)event.getAffected();
            if (igp.getIndexGlobalPartList() != null && igp.getIndexGlobalPartList() == this.getUsingIndexGlobalPL()) {
                igp.setParent(this.partitions);
                this.partitions.add(igp);
            } else {
                this.partitions.remove(igp);
            }
        } else if (event.getAffected() instanceof IndexHashPartitionOraclev10g) {
            IndexHashPartitionOraclev10g ihp = (IndexHashPartitionOraclev10g)event.getAffected();
            if (ihp.getIndexGlobalPartList() != null && ihp.getIndexGlobalPartList() == this.getUsingIndexGlobalPL()) {
                ihp.setParent(this.partitions);
                this.partitions.add(ihp);
            } else {
                this.partitions.remove(ihp);
            }
        }
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
        if (event.isType(1)) {
            if (event.getAffected() instanceof IndexGlobalPartitionOracle) {
                IndexGlobalPartitionOracle igp = (IndexGlobalPartitionOracle)event.getAffected();
                if (igp.getIndexGlobalPartList() != null && igp.getIndexGlobalPartList() == this.getIndexGlobalPartitionsList()) {
                    if (!this.partitions.contains(igp)) {
                        igp.addObjectListener(this);
                        igp.setParent(this.partitions);
                        this.partitions.add(igp);
                    }
                } else {
                    this.partitions.remove(igp);
                }
            } else if (event.getAffected() instanceof IndexHashPartitionOraclev10g) {
                IndexHashPartitionOraclev10g ihp = (IndexHashPartitionOraclev10g)event.getAffected();
                if (ihp.getIndexGlobalPartList() != null && ihp.getIndexGlobalPartList() == this.getIndexGlobalPartitionsList()) {
                    if (!this.partitions.contains(ihp)) {
                        ihp.addObjectListener(this);
                        ihp.setParent(this.partitions);
                        this.partitions.add(ihp);
                    }
                } else {
                    this.partitions.remove(ihp);
                }
            }
        } else if (event.isType(0)) {
            if (event.getAffected() instanceof IndexGlobalPartitionOracle) {
                IndexGlobalPartitionOracle igp = (IndexGlobalPartitionOracle)event.getAffected();
                this.partitions.remove(igp);
                igp.removeObjectListener(this);
            } else if (event.getAffected() instanceof IndexHashPartitionOraclev10g) {
                IndexHashPartitionOraclev10g igp = (IndexHashPartitionOraclev10g)event.getAffected();
                this.partitions.remove(igp);
                igp.removeObjectListener(this);
            }
        }
    }

    @Override
    public void setUsingIndexGlobalPL(IndexGlobalPartitionsListOracle indexGlobalPartitionList) {
        if (this.indexGlobalPartitionList != null && this.indexGlobalPartitionList != indexGlobalPartitionList) {
            this.partitions.removeAll();
            this.partitions.setForbiddenCreateElement(true);
        }
        if (indexGlobalPartitionList != null) {
            this.indexGlobalPartitionList = indexGlobalPartitionList;
            this.indexGlobalPartitionList.setIndex(this);
            this.partitions.setForbiddenCreateElement(false);
            this.partitions.setLogicalParent(indexGlobalPartitionList);
            if (((UniqueOracle)indexGlobalPartitionList.getIndex()).getUsingIndex().equalsIgnoreCase(USING_INDEX[2])) {
                this.partitions.setStorageObjectSet(((StorageDesignOraclev10g)this.getStorageDesign()).getIndexGlobalPartitionSet());
                this.addIGPFromDesign(((StorageDesignOraclev10g)this.getStorageDesign()).getIndexGlobalPartitionSet());
            } else if (((UniqueOracle)indexGlobalPartitionList.getIndex()).getUsingIndex().equalsIgnoreCase(USING_INDEX[4])) {
                this.partitions.setStorageObjectSet(((StorageDesignOraclev10g)this.getStorageDesign()).getIndexHashPartitionSet());
                this.addIndexHashPartitionFromDesign(((StorageDesignOraclev10g)this.getStorageDesign()).getIndexHashPartitionSet());
            } else {
                this.partitions.removeAll();
                this.partitions.setForbiddenCreateElement(true);
            }
        }
        this.fireDataFieldChange();
    }

    protected void addIndexHashPartitionFromDesign(StorageObjectSet set) {
        for (IndexHashPartitionOraclev10g ihp : set) {
            ihp.addObjectListener(this);
            if (ihp.getIndexGlobalPartList() != null && ihp.getIndexGlobalPartList() == this.getUsingIndexGlobalPL()) {
                ihp.setParent(this.partitions);
                this.partitions.add(ihp);
                continue;
            }
            this.partitions.remove(ihp);
        }
    }

    public static String[] getIndexSortChoices() {
        return INDEX_SORT;
    }

    private boolean checkIndexSort(String value) {
        if (indexSortSet == null) {
            indexSortSet = new HashSet();
            indexSortSet.addAll(Arrays.asList(UniqueOraclev10g.getIndexSortChoices()));
        }
        return indexSortSet.contains(value);
    }

    @Override
    public void setIndexSort(String using) {
        if (this.checkIndexSort(using)) {
            this.indexSort = using;
            this.fireDataFieldChange();
        }
    }

    @Override
    public String getIndexSort() {
        return this.indexSort;
    }

    public String getCreateIndexStatement() {
        return this.createIndexStatement;
    }

    public void setCreateIndexStatement(String createIndexStatement) {
        this.createIndexStatement = createIndexStatement;
        this.fireDataFieldChange();
    }

    @Override
    public String getComputeStatistics() {
        return this.computeStatistics;
    }

    @Override
    public void setComputeStatistics(String computeStatistics) {
        if (ConstantsOracle.checkYesNo(computeStatistics)) {
            this.computeStatistics = computeStatistics;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        Index unIndex = (Index)targetDesign.getPhysicalDesign().getTableSet().getGlobalIndexSet().getByName(this.getObject().getName());
        UniqueOraclev10g unique = null;
        RelationalObjectProxy storageObject = ((StorageDesignOraclev10g)targetDesign).getUniqueSet().getProxy(unIndex.getObjectID());
        if (storageObject != null && !this.isRawObject()) {
            unique = (UniqueOraclev10g)storageObject;
        }
        if (unique != null) {
            unique.setName(this.getName());
            unique.setDeferrable(this.getDeferrable());
            unique.setInitially(this.getInitially());
            unique.setEnable(this.getEnable());
            unique.setValidate(this.getValidate());
            unique.setRely(this.getRely());
            unique.setUsingIndex(this.getUsingIndex());
            if (this.getExceptionsTable() != null) {
                Table table = (Table)targetDesign.getPhysicalDesign().getTableSet().getByName(this.getExceptionsTable().getObject().getName());
                TableProxyOraclev10g tableProxy = (TableProxyOraclev10g)((StorageDesignOraclev10g)targetDesign).getTableProxySet().getProxy(table.getObjectID());
                if (tableProxy == null) {
                    TableProxyOraclev10g newTableProxy = (TableProxyOraclev10g)((TableProxySetOraclev10g)((StorageDesignOraclev10g)targetDesign).getTableProxySet()).createProxy(table);
                    newTableProxy.setName(this.getExceptionsTable().getName());
                    newTableProxy.setRawObject(true);
                    unique.setExceptionsTable(newTableProxy);
                } else {
                    unique.setExceptionsTable(tableProxy);
                }
            }
            if (this.getUsingIndexGlobalPL() != null) {
                IndexGlobalPartitionsListOraclev10g list = (IndexGlobalPartitionsListOraclev10g)((StorageDesignOraclev10g)targetDesign).getIndexGlobalPartitionsListSet().getByName(this.getUsingIndexGlobalPL().getName());
                if (list == null) {
                    IndexGlobalPartitionsListOraclev10g newList = (IndexGlobalPartitionsListOraclev10g)((StorageDesignOraclev10g)targetDesign).getIndexGlobalPartitionsListSet().createIndexGlobalPartitionsList();
                    newList.setName(this.getName());
                    newList.setRawObject(true);
                    unique.setUsingIndexGlobalPL(newList);
                } else {
                    unique.setUsingIndexGlobalPL(list);
                }
            }
            unique.setIndexSort(this.getIndexSort());
            if (this.getTableSpace() != null) {
                TableSpaceOraclev10g tablespace = (TableSpaceOraclev10g)((StorageDesignOraclev10g)targetDesign).getTableSpaceSet().getByName(this.getTableSpace().getName());
                if (tablespace == null) {
                    TableSpaceOraclev10g newTablespace = (TableSpaceOraclev10g)((StorageDesignOraclev10g)targetDesign).getTableSpaceSet().createTableSpace();
                    newTablespace.setName(this.getTableSpace().getName());
                    newTablespace.setRawObject(true);
                    unique.setTableSpace(newTablespace);
                } else {
                    unique.setTableSpace(tablespace);
                }
            }
            unique.setLogging(this.getLogging());
            if (this.getIndexSegment() != null) {
                SegmentOraclev10g segment = (SegmentOraclev10g)((StorageDesignOraclev10g)targetDesign).getSegmentSet().getByName(this.getIndexSegment().getName());
                if (segment == null) {
                    SegmentOraclev10g newSegment = (SegmentOraclev10g)((StorageDesignOraclev10g)targetDesign).getSegmentSet().createSegment();
                    newSegment.setName(this.getIndexSegment().getName());
                    newSegment.setRawObject(true);
                    unique.setIndexSegment(newSegment);
                } else {
                    unique.setIndexSegment(segment);
                }
            }
            unique.setComment(this.getComment());
            unique.setCommentInRDBMS(this.getCommentInRDBMS());
            unique.setRawObject(false);
        }
    }
}

