/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.Arrays;
import java.util.List;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DataBaseOracle;

public abstract class RedoLogGroupOracle
extends AbstractStorageObjectOracle {
    private String fileName = "";
    private int size = 0;
    private String reuse = "YES";
    private String measureUnit = ConstantsOracle.UNITS_CHOICES[1];
    private DataBaseOracle dataBase = null;
    public static final String TYPE_NAME = "RLGrp";
    public static final String OLD_TYPE_NAME = "RedoLogGroup";

    @Override
    public String getIDPrefix() {
        return "RLG";
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getOldObjectTypeName() {
        return OLD_TYPE_NAME;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
        this.fireDataFieldChange();
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
        this.fireDataFieldChange();
    }

    public void setReuse(String value) {
        if (ConstantsOracle.checkYesNo(value)) {
            this.reuse = value;
            this.fireDataFieldChange();
        }
    }

    public String getReuse() {
        return this.reuse;
    }

    public void setMeasureUnit(String value) {
        if (ConstantsOracle.checkUnit(value)) {
            this.measureUnit = value;
            this.fireDataFieldChange();
        }
    }

    public String getMeasureUnit() {
        return this.measureUnit;
    }

    public static List getMeasureUnitValues() {
        return Arrays.asList(ConstantsOracle.UNITS_CHOICES);
    }

    public void setDataBase(DataBaseOracle dataBase) {
        if (this.dataBase != dataBase) {
            this.dataBase = dataBase;
            this.setPAC_Element(dataBase);
            this.fireDataFieldChange();
        }
    }

    public DataBaseOracle getDataBase() {
        return this.dataBase;
    }

    @Override
    public void showPropertyDialog() {
    }

    @Override
    public boolean isTopLevelObject() {
        return false;
    }
}

