/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.CollectionTypeProxySet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StructuredTypeProxySet;
import oracle.dbtools.crest.model.design.storage.TableProxySet;
import oracle.dbtools.crest.model.design.storage.TableViewProxySet;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.CollectionTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DirectoryOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ExternalTableOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ExternalTableSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.FunctionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.FunctionSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.OwnedObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PackageBodyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PackageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PackageSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RoleOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SequenceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SequenceSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StoredProcedureOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StoredProcedureSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableViewProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.StorageDesignOraclev12c;

public abstract class PermissionsOracle
extends AbstractStorageObjectOracle
implements OwnedObjectOracle {
    private static final String[] TABLE_PRIVS_12c = new String[]{"ALL PRIVILEGES", "ALTER", "DELETE", "INDEX", "INSERT", "READ", "REFERENCES", "SELECT", "UPDATE", "DEBUG"};
    private static final String[] TABLE_PRIVS_10g = new String[]{"ALL PRIVILEGES", "ALTER", "DELETE", "INDEX", "INSERT", "REFERENCES", "SELECT", "UPDATE", "DEBUG"};
    private static final String[] VIEW_PRIVS_12c = new String[]{"ALL PRIVILEGES", "DELETE", "INSERT", "READ", "REFERENCES", "SELECT", "UPDATE", "MERGE VIEW", "DEBUG", "UNDER"};
    private static final String[] VIEW_PRIVS_11g = new String[]{"ALL PRIVILEGES", "DELETE", "INSERT", "REFERENCES", "SELECT", "UPDATE", "MERGE VIEW", "DEBUG", "UNDER"};
    private static final String[] VIEW_PRIVS_10g = new String[]{"ALL PRIVILEGES", "DELETE", "INSERT", "REFERENCES", "SELECT", "UPDATE", "DEBUG", "UNDER"};
    private static final String[] SEQ_PRIVS_12c = new String[]{"ALL PRIVILEGES", "ALTER", "SELECT", "KEEP SEQUENCE"};
    private static final String[] SEQ_PRIVS_10g = new String[]{"ALL PRIVILEGES", "ALTER", "SELECT"};
    private static final String[] SNAPSHOT_PRIVS_12c = new String[]{"ALL PRIVILEGES", "DELETE", "INSERT", "READ", "SELECT", "UPDATE", "ON COMMIT REFRESH", "QUERY REWRITE"};
    private static final String[] SNAPSHOT_PRIVS_10g = new String[]{"ALL PRIVILEGES", "DELETE", "INSERT", "SELECT", "UPDATE", "ON COMMIT REFRESH", "QUERY REWRITE"};
    private static final String[] PROCEDURE_PRIVILEGES = new String[]{"ALL PRIVILEGES", "EXECUTE", "DEBUG"};
    private static final String[] COLUMNS_PRIVILEGES = new String[]{"INSERT", "UPDATE", "REFERENCES"};
    private static final String[] PACKAGE_PRIVILEGES = new String[]{"ALL PRIVILEGES", "EXECUTE", "DEBUG"};
    private static final String[] DIRECTORY_PRIVILEGES = new String[]{"ALL PRIVILEGES", "READ", "WRITE", "EXECUTE"};
    private static final String[] ST_PRIVILEGES = new String[]{"ALL PRIVILEGES", "EXECUTE", "DEBUG", "UNDER"};
    private static final String[] CT_PRIVILEGES = new String[]{"ALL PRIVILEGES", "EXECUTE", "DEBUG"};
    private static final String[] EXT_TAB_PRIVS_12c = new String[]{"ALL PRIVILEGES", "ALTER", "READ", "SELECT"};
    private static final String[] EXT_TAB_PRIVS_10g = new String[]{"ALL PRIVILEGES", "ALTER", "SELECT"};
    protected PermissionsSet privilegesSet = null;
    protected PermissionsSet privilegesWithGrantOptionSet = null;
    protected PermissionsSet privilegesWithHierarchyOptionSet = null;
    protected TableProxyOracle table = null;
    protected TableViewProxyOracle view = null;
    protected SequenceOracle sequence = null;
    protected SnapshotOracle snapshot = null;
    protected StoredProcedureOracle proc = null;
    protected PackageOracle packageOracle = null;
    protected FunctionOracle functionOracle = null;
    protected DirectoryOracle directoryOracle = null;
    protected StructuredTypeProxyOracle structuredTypeOracle = null;
    protected CollectionTypeProxyOracle collectionTypeOracle = null;
    protected ExternalTableOracle externalTableOracle = null;
    private String tableLongName = "";
    private String viewLongName = "";
    private String sequenceLongName = "";
    private String snapshotLongName = "";
    private String procLongName = "";
    private String packageLongName = "";
    private String functionLongName = "";
    private String directoryName = "";
    private String structuredTypeLongName = "";
    private String collectionTypeLongName = "";
    private String externalTableLongName = "";
    protected TableProxyOracle columnsTable = null;
    private String columnsTableLongName = "";
    protected String privileges = "";
    protected String privilegesWithGrantOption = "";
    protected String privilegesWithHierarchyOption = "";
    protected String columnList = "";
    protected String columnWithGrantOptionList = "";
    protected String isPublic = "NO";
    protected UserOracle user;
    protected RoleOracle role;
    public static final String TYPE_NAME = "Permissions";

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    public void setTable(TableProxyOracle table) {
        this.table = table;
        if (table != null) {
            this.view = null;
            this.sequence = null;
            this.proc = null;
            this.snapshot = null;
        }
        this.fireDataFieldChange();
    }

    public TableProxyOracle getTable() {
        return this.table;
    }

    public void setView(TableViewProxyOracle view) {
        this.view = view;
        if (view != null) {
            this.table = null;
            this.sequence = null;
            this.proc = null;
            this.snapshot = null;
        }
        this.fireDataFieldChange();
    }

    public TableViewProxyOracle getView() {
        return this.view;
    }

    public StoredProcedureOracle getProc() {
        return this.proc;
    }

    public void setProc(StoredProcedureOracle proc) {
        this.proc = proc;
        if (proc != null) {
            this.table = null;
            this.view = null;
            this.sequence = null;
            this.snapshot = null;
        }
        this.fireDataFieldChange();
    }

    public PackageOracle getPackage() {
        return this.packageOracle;
    }

    public void setPackage(PackageOracle packageOracle) {
        this.packageOracle = packageOracle;
        this.fireDataFieldChange();
    }

    public FunctionOracle getFunctionOracle() {
        return this.functionOracle;
    }

    public void setFunctionOracle(FunctionOracle functionOracle) {
        this.functionOracle = functionOracle;
        this.fireDataFieldChange();
    }

    public DirectoryOracle getDirectoryOracle() {
        return this.directoryOracle;
    }

    public void setDirectoryOracle(DirectoryOracle directoryOracle) {
        this.directoryOracle = directoryOracle;
        this.fireDataFieldChange();
    }

    public StructuredTypeProxyOracle getStructuredTypeOracle() {
        return this.structuredTypeOracle;
    }

    public void setStructuredTypeOracle(StructuredTypeProxyOracle structuredTypeOracle) {
        this.structuredTypeOracle = structuredTypeOracle;
        this.fireDataFieldChange();
    }

    public CollectionTypeProxyOracle getCollectionTypeOracle() {
        return this.collectionTypeOracle;
    }

    public void setCollectionTypeOracle(CollectionTypeProxyOracle collectionTypeOracle) {
        this.collectionTypeOracle = collectionTypeOracle;
        this.fireDataFieldChange();
    }

    public ExternalTableOracle getExternalTableOracle() {
        return this.externalTableOracle;
    }

    public void setExternalTableOracle(ExternalTableOracle externalTableOracle) {
        this.externalTableOracle = externalTableOracle;
        this.fireDataFieldChange();
    }

    public SnapshotOracle getSnapshot() {
        return this.snapshot;
    }

    public void setSnapshot(SnapshotOracle snapshot) {
        this.snapshot = snapshot;
        if (snapshot != null) {
            this.table = null;
            this.view = null;
            this.sequence = null;
            this.proc = null;
        }
        this.fireDataFieldChange();
    }

    public StorageObject getObject() {
        StorageObject storageObject = null;
        if (this.columnsTable == null) {
            if (this.table != null) {
                storageObject = this.table;
            } else if (this.view != null) {
                storageObject = this.view;
            } else if (this.sequence != null) {
                storageObject = this.sequence;
            } else if (this.snapshot != null) {
                storageObject = this.snapshot;
            } else if (this.proc != null) {
                storageObject = this.proc;
            } else if (this.functionOracle != null) {
                storageObject = this.functionOracle;
            } else if (this.packageOracle != null) {
                storageObject = this.packageOracle;
            } else if (this.directoryOracle != null) {
                storageObject = this.directoryOracle;
            } else if (this.structuredTypeOracle != null) {
                storageObject = this.structuredTypeOracle;
            } else if (this.collectionTypeOracle != null) {
                storageObject = this.collectionTypeOracle;
            } else if (this.externalTableOracle != null) {
                storageObject = this.externalTableOracle;
            }
        }
        return storageObject;
    }

    public String getPrivileges() {
        return this.privileges;
    }

    public String getPrivilegesWithGrantOption() {
        return this.privilegesWithGrantOption;
    }

    public String getPrivilegesWithHierarchyOption() {
        return this.privilegesWithHierarchyOption;
    }

    public String getColumnList() {
        return this.columnList;
    }

    public String getColumnWithGrantOptionList() {
        return this.columnWithGrantOptionList;
    }

    public void setSequence(SequenceOracle sequence) {
        this.sequence = sequence;
        if (sequence != null) {
            this.view = null;
            this.table = null;
            this.proc = null;
            this.snapshot = null;
        }
        this.fireDataFieldChange();
    }

    public SequenceOracle getSequence() {
        return this.sequence;
    }

    protected void addPrivilege(String privilege) {
        if (!this.getPrivilegesSet().contains(privilege)) {
            this.getPrivilegesSet().add(privilege);
            this.getPrivilegesWithGrantOptionSet().remove(privilege);
        }
    }

    protected void addPrivilegeWithGrantOption(String privilege) {
        if (!this.getPrivilegesWithGrantOptionSet().contains(privilege)) {
            this.getPrivilegesWithGrantOptionSet().add(privilege);
            this.getPrivilegesSet().remove(privilege);
        }
    }

    protected void addPrivilegeWithHierarchyOption(String privilege) {
        if (!this.getPrivilegesWithHierarchyOptionSet().contains(privilege)) {
            this.getPrivilegesWithHierarchyOptionSet().add(privilege);
            this.getPrivilegesSet().remove(privilege);
        }
    }

    public void addColumn(String column) {
        if (!this.columnList.trim().equalsIgnoreCase("")) {
            this.columnList = this.columnList + "|";
        }
        this.columnList = this.columnList + column;
    }

    public void addColumnWithGrantOption(String column) {
        if (!this.columnWithGrantOptionList.trim().equalsIgnoreCase("")) {
            this.columnWithGrantOptionList = this.columnWithGrantOptionList + "|";
        }
        this.columnWithGrantOptionList = this.columnWithGrantOptionList + column;
    }

    public abstract void setPrivileges(String var1);

    public void setPrivilegesWithGrantOption(String privilege) {
        if (this.getStorageDesign().isLoading()) {
            this.recreatePrivilegesWithGrantOptionSet(privilege);
        } else {
            this.addPrivilegeWithGrantOption(privilege);
        }
        this.privilegesWithGrantOption = this.getPrivilegesWithGrantOptionSet().toString();
        this.privileges = this.getPrivilegesSet().toString();
        this.fireDataFieldChange();
    }

    public void setPrivilegesWithHierarchyOption(String privilege) {
        if (this.getStorageDesign().isLoading()) {
            this.recreatePrivilegesWithHierarchyOptionSet(privilege);
        } else {
            this.addPrivilegeWithHierarchyOption(privilege);
        }
        this.privilegesWithHierarchyOption = this.getPrivilegesWithHierarchyOptionSet().toString();
        this.privileges = this.getPrivilegesSet().toString();
        this.fireDataFieldChange();
    }

    protected void recreatePrivilegesSet(String privs) {
        this.getPrivilegesSet().clear();
        StringTokenizer st = new StringTokenizer(privs, ",");
        while (st.hasMoreTokens()) {
            this.getPrivilegesSet().add(st.nextToken().trim());
        }
    }

    protected void recreatePrivilegesWithGrantOptionSet(String privs) {
        this.getPrivilegesWithGrantOptionSet().clear();
        StringTokenizer st = new StringTokenizer(privs, ",");
        while (st.hasMoreTokens()) {
            this.getPrivilegesWithGrantOptionSet().add(st.nextToken().trim());
        }
    }

    protected void recreatePrivilegesWithHierarchyOptionSet(String privs) {
        this.getPrivilegesWithHierarchyOptionSet().clear();
        StringTokenizer st = new StringTokenizer(privs, ",");
        while (st.hasMoreTokens()) {
            this.getPrivilegesWithHierarchyOptionSet().add(st.nextToken().trim());
        }
    }

    private void recreateColumnList(String columns) {
        this.columnList = columns;
    }

    private void recreateColumnWithGranOptionList(String columns) {
        this.columnWithGrantOptionList = columns;
    }

    public void setColumnList(String column) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateColumnList(column);
        } else {
            this.addColumn(column);
        }
        this.fireDataFieldChange();
    }

    public void setColumnListWithGrantOption(String column) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateColumnWithGranOptionList(column);
        } else {
            this.addColumnWithGrantOption(column);
        }
        this.fireDataFieldChange();
    }

    public static String[] getValidPrivilegeValues(StorageObject storageObject) {
        StorageDesign storageDesign = storageObject.getStorageDesign();
        if (storageObject instanceof TableProxyOracle) {
            if (!"EXTERNAL".equals(((TableProxyOracle)storageObject).getOrganization())) {
                if (storageDesign instanceof StorageDesignOraclev12c) {
                    return TABLE_PRIVS_12c;
                }
                return TABLE_PRIVS_10g;
            }
        } else {
            if (storageObject instanceof TableViewProxyOracle) {
                if (storageDesign instanceof StorageDesignOraclev12c) {
                    return VIEW_PRIVS_12c;
                }
                if (storageDesign instanceof StorageDesignOraclev11g) {
                    return VIEW_PRIVS_11g;
                }
                return VIEW_PRIVS_10g;
            }
            if (storageObject instanceof SequenceOracle) {
                if (storageDesign instanceof StorageDesignOraclev12c) {
                    return SEQ_PRIVS_12c;
                }
                return SEQ_PRIVS_10g;
            }
            if (storageObject instanceof SnapshotOracle) {
                if (storageDesign instanceof StorageDesignOraclev12c) {
                    return SNAPSHOT_PRIVS_12c;
                }
                return SNAPSHOT_PRIVS_10g;
            }
            if (storageObject instanceof ColumnProxyOracle) {
                return COLUMNS_PRIVILEGES;
            }
            if (storageObject instanceof FunctionOracle || storageObject instanceof StoredProcedureOracle) {
                return PROCEDURE_PRIVILEGES;
            }
            if (storageObject instanceof PackageOracle) {
                return PACKAGE_PRIVILEGES;
            }
            if (storageObject instanceof DirectoryOracle) {
                return DIRECTORY_PRIVILEGES;
            }
            if (storageObject instanceof StructuredTypeProxyOracle) {
                return ST_PRIVILEGES;
            }
            if (storageObject instanceof CollectionTypeProxyOracle) {
                return CT_PRIVILEGES;
            }
        }
        if (storageObject instanceof TableProxyOracle || storageObject instanceof ExternalTableOracle) {
            if (storageDesign instanceof StorageDesignOraclev12c) {
                return EXT_TAB_PRIVS_12c;
            }
            return EXT_TAB_PRIVS_10g;
        }
        return new String[0];
    }

    public void setPublic(String value) {
        if (ConstantsOracle.checkYesNo(value)) {
            this.isPublic = value;
            this.fireDataFieldChange();
        }
    }

    public String getPublic() {
        return this.isPublic;
    }

    public PermissionsSet getPrivilegesSet() {
        if (this.privilegesSet == null) {
            this.privilegesSet = new PermissionsSet();
        }
        return this.privilegesSet;
    }

    public PermissionsSet getPrivilegesWithGrantOptionSet() {
        if (this.privilegesWithGrantOptionSet == null) {
            this.privilegesWithGrantOptionSet = new PermissionsSet();
        }
        return this.privilegesWithGrantOptionSet;
    }

    public PermissionsSet getPrivilegesWithHierarchyOptionSet() {
        if (this.privilegesWithHierarchyOptionSet == null) {
            this.privilegesWithHierarchyOptionSet = new PermissionsSet();
        }
        return this.privilegesWithHierarchyOptionSet;
    }

    public void clear() {
        this.getPrivilegesSet().removeAllElements();
        this.getPrivilegesWithGrantOptionSet().removeAllElements();
        this.getPrivilegesWithHierarchyOptionSet().removeAllElements();
        this.privileges = "";
        this.privilegesWithGrantOption = "";
        this.privilegesWithHierarchyOption = "";
    }

    public void clearColPermissions() {
        this.columnList = "";
        this.columnWithGrantOptionList = "";
    }

    public RoleOracle getRole() {
        return this.role;
    }

    public void setRole(RoleOracle role) {
        if (this.role != role) {
            this.role = role;
            if (role != null) {
                this.setPAC_Element(role);
            }
            this.fireDataFieldChange();
        }
    }

    @Override
    public UserOracle getUser() {
        return this.user;
    }

    @Override
    public void setUser(UserOracle user) {
        if (this.user != user) {
            this.user = user;
            if (user != null) {
                this.setPAC_Element(user);
            }
            this.fireChange(ObjectChangeEvent.NAME_CHANGED);
        }
    }

    public static String[] getColumnPermissionsValues() {
        return COLUMNS_PRIVILEGES;
    }

    public String getPrivs(ColumnProxyOracle col) {
        return this.getPrivs(col.getName());
    }

    public String getPrivs(String cname) {
        StringTokenizer st = new StringTokenizer(this.getColumnList(), "|");
        Object privs = "";
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            String[] parts = token.split(",");
            if (!cname.equalsIgnoreCase(parts[0])) continue;
            if (((String)privs).length() > 0) {
                privs = (String)privs + "," + parts[1];
                continue;
            }
            privs = parts[1];
        }
        return ((String)privs).trim();
    }

    public String getPrivsWithGrantOption(String cname) {
        StringTokenizer st = new StringTokenizer(this.getColumnWithGrantOptionList(), "|");
        Object privs = "";
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            String[] parts = token.split(",");
            if (!cname.equalsIgnoreCase(parts[0])) continue;
            if (((String)privs).length() > 0) {
                privs = (String)privs + "," + parts[1];
                continue;
            }
            privs = parts[1];
        }
        return ((String)privs).trim();
    }

    public String getPrivsWithGrantOption(ColumnProxyOracle col) {
        return this.getPrivsWithGrantOption(col.getName());
    }

    public List<String> getColumnEntries() {
        ArrayList<String> entries = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(this.getColumnList(), "|");
        while (st.hasMoreTokens()) {
            entries.add(st.nextToken());
        }
        return entries;
    }

    public ArrayList<String> getColumnWithGrantOptionEntries() {
        ArrayList<String> entries = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(this.getColumnWithGrantOptionList(), "|");
        while (st.hasMoreTokens()) {
            entries.add(st.nextToken());
        }
        return entries;
    }

    public ArrayList getColumns() {
        ArrayList<String> cols = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(this.getColumnList(), "|");
        while (st.hasMoreTokens()) {
            String col = st.nextToken();
            if (col.indexOf(44) > -1) {
                col = col.substring(0, col.indexOf(44));
            }
            if (cols.contains(col)) continue;
            cols.add(col);
        }
        return cols;
    }

    public ArrayList getColumnsWithGrantOption() {
        ArrayList<String> cols = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(this.getColumnWithGrantOptionList(), "|");
        while (st.hasMoreTokens()) {
            String col = st.nextToken();
            if (col.indexOf(44) > -1) {
                col = col.substring(0, col.indexOf(44));
            }
            if (cols.contains(col)) continue;
            cols.add(col);
        }
        return cols;
    }

    @Override
    public boolean isTopLevelObject() {
        return false;
    }

    public TableProxyOracle getColumnsTable() {
        return this.columnsTable;
    }

    public void setColumnsTable(TableProxyOracle columnsTable) {
        this.columnsTable = columnsTable;
        this.table = null;
        this.view = null;
        this.sequence = null;
        this.proc = null;
        this.snapshot = null;
    }

    @Override
    public Object translateIdToObject(String propertyName, String id) {
        if (id == null) {
            return null;
        }
        StorageObject result = this.getStorageDesign().getStorageObject(id);
        if (result == null) {
            ModelIDObject obj;
            String newID = null;
            Map map = this.getStorageDesign().getCorrespondenceMap();
            if (map != null && (obj = (ModelIDObject)map.get(id)) != null) {
                newID = obj.getObjectID();
                result = this.getStorageDesign().getStorageObject(newID);
            }
        }
        if (result != null) {
            PackageOracle pkg;
            if ("package".equals(propertyName) && result instanceof PackageBodyOracle && id.equals((pkg = ((PackageBodyOracle)result).getPackageOracle()).getObjectID())) {
                result = pkg;
            }
            return result;
        }
        if (!("table".equals(propertyName) || "view".equals(propertyName) || "columnsTable".equals(propertyName))) {
            return super.translateIdToObject(propertyName, id);
        }
        return null;
    }

    public String getTableLongName() {
        TableProxyOracle tableProxy = this.getTable();
        if (tableProxy != null) {
            return tableProxy.getLongName();
        }
        return this.tableLongName;
    }

    public void setTableLongName(String tableLongName) {
        if (tableLongName != null) {
            this.tableLongName = tableLongName;
            TableProxyOracle tableProxy = null;
            if (!tableLongName.isEmpty()) {
                TableProxySet proxySet = this.getStorageDesign().getTableProxySet();
                int dotIndex = tableLongName.indexOf(46);
                if (dotIndex != -1) {
                    String userName = tableLongName.substring(0, dotIndex);
                    String tableName = tableLongName.substring(dotIndex + 1);
                    tableProxy = (TableProxyOracle)proxySet.getByUserSchemaAndName(userName, tableName);
                } else {
                    tableProxy = (TableProxyOracle)proxySet.getByName(tableLongName);
                }
            }
            this.setTable(tableProxy);
        }
    }

    public String getViewLongName() {
        TableViewProxyOracle viewProxy = this.getView();
        if (viewProxy != null) {
            return viewProxy.getLongName();
        }
        return this.viewLongName;
    }

    public void setViewLongName(String viewLongName) {
        if (viewLongName != null) {
            this.viewLongName = viewLongName;
            TableViewProxyOracle viewProxy = null;
            if (!viewLongName.isEmpty()) {
                TableViewProxySet proxySet = this.getStorageDesign().getTableViewProxySet();
                int dotIndex = viewLongName.indexOf(46);
                if (dotIndex != -1) {
                    String userName = viewLongName.substring(0, dotIndex);
                    String viewName = viewLongName.substring(dotIndex + 1);
                    viewProxy = (TableViewProxyOracle)proxySet.getBySchemaAndName(userName, viewName);
                } else {
                    viewProxy = (TableViewProxyOracle)proxySet.getByName(viewLongName);
                }
            }
            this.setView(viewProxy);
        }
    }

    public String getSequenceLongName() {
        SequenceOracle sequence = this.getSequence();
        if (sequence != null) {
            return sequence.getLongName();
        }
        return this.sequenceLongName;
    }

    public void setSequenceLongName(String sequenceLongName) {
        if (sequenceLongName != null) {
            this.sequenceLongName = sequenceLongName;
            SequenceOracle sequence = null;
            if (!sequenceLongName.isEmpty()) {
                SequenceSetOracle sequenceSet = this.getStorageDesignOracle().getSequenceSet();
                int dotIndex = sequenceLongName.indexOf(46);
                if (dotIndex != -1) {
                    String userName = sequenceLongName.substring(0, dotIndex);
                    String sequenceName = sequenceLongName.substring(dotIndex + 1);
                    sequence = (SequenceOracle)sequenceSet.getByUserSchemaAndName(userName, sequenceName);
                } else {
                    sequence = (SequenceOracle)sequenceSet.getByName(sequenceLongName);
                }
            }
            this.setSequence(sequence);
        }
    }

    public String getSnapshotLongName() {
        SnapshotOracle snapshot = this.getSnapshot();
        if (snapshot != null) {
            return snapshot.getLongName();
        }
        return this.snapshotLongName;
    }

    public void setSnapshotLongName(String snapshotLongName) {
        if (snapshotLongName != null) {
            this.snapshotLongName = snapshotLongName;
            SnapshotOracle snapshot = null;
            if (!snapshotLongName.isEmpty()) {
                SnapshotSetOracle snapshotSet = this.getStorageDesignOracle().getSnapshotSet();
                int dotIndex = snapshotLongName.indexOf(46);
                if (dotIndex != -1) {
                    String userName = snapshotLongName.substring(0, dotIndex);
                    String snapshotName = snapshotLongName.substring(dotIndex + 1);
                    snapshot = (SnapshotOracle)snapshotSet.getBySchemaAndName(userName, snapshotName);
                } else {
                    snapshot = (SnapshotOracle)snapshotSet.getByName(snapshotLongName);
                }
            }
            this.setSnapshot(snapshot);
        }
    }

    public String getFunctionLongName() {
        FunctionOracle function = this.getFunctionOracle();
        if (function != null) {
            return function.getLongName();
        }
        return this.functionLongName;
    }

    public void setFunctionLongName(String functionLongName) {
        if (functionLongName != null) {
            this.functionLongName = functionLongName;
            FunctionOracle function = null;
            if (!functionLongName.isEmpty()) {
                FunctionSetOracle functionSet = this.getStorageDesignOracle().getFunctionSet();
                int dotIndex = functionLongName.indexOf(46);
                if (dotIndex != -1) {
                    String userName = functionLongName.substring(0, dotIndex);
                    String functionName = functionLongName.substring(dotIndex + 1);
                    function = functionSet.getByOwnerAndName(userName, functionName);
                } else {
                    function = (FunctionOracle)functionSet.getByName(functionLongName);
                }
            }
            this.setFunctionOracle(function);
        }
    }

    public String getProcLongName() {
        StoredProcedureOracle proc = this.getProc();
        if (proc != null) {
            return proc.getLongName();
        }
        return this.procLongName;
    }

    public void setProcLongName(String procLongName) {
        if (procLongName != null) {
            this.procLongName = procLongName;
            StoredProcedureOracle proc = null;
            if (!procLongName.isEmpty()) {
                StoredProcedureSetOracle procSet = this.getStorageDesignOracle().getStoredProcedureSet();
                int dotIndex = procLongName.indexOf(46);
                if (dotIndex != -1) {
                    String userName = procLongName.substring(0, dotIndex);
                    String procName = procLongName.substring(dotIndex + 1);
                    proc = procSet.getByOwnerAndName(userName, procName);
                } else {
                    proc = (StoredProcedureOracle)procSet.getByName(procLongName);
                }
            }
            this.setProc(proc);
        }
    }

    public String getPackageLongName() {
        PackageOracle packageOracle = this.getPackage();
        if (packageOracle != null) {
            return packageOracle.getLongName();
        }
        return this.packageLongName;
    }

    public void setPackageLongName(String packageLongName) {
        if (packageLongName != null) {
            this.packageLongName = packageLongName;
            PackageOracle packageOracle = null;
            if (!packageLongName.isEmpty()) {
                PackageSetOracle packageSet = this.getStorageDesignOracle().getPackageSet();
                int dotIndex = packageLongName.indexOf(46);
                if (dotIndex != -1) {
                    String userName = packageLongName.substring(0, dotIndex);
                    String packageName = packageLongName.substring(dotIndex + 1);
                    packageOracle = packageSet.getByOwnerAndName(userName, packageName);
                } else {
                    packageOracle = (PackageOracle)packageSet.getByName(packageLongName);
                }
            }
            this.setPackage(packageOracle);
        }
    }

    public String getDirectoryName() {
        DirectoryOracle directoryOracle = this.getDirectoryOracle();
        if (directoryOracle != null) {
            return directoryOracle.getName();
        }
        return this.directoryName;
    }

    public void setDirectoryName(String directoryName) {
        if (directoryName != null) {
            this.directoryName = directoryName;
            DirectoryOracle directoryOracle = null;
            if (!directoryName.isEmpty()) {
                directoryOracle = (DirectoryOracle)this.getStorageDesignOracle().getDirectorySet().getByName(directoryName);
            }
            this.setDirectoryOracle(directoryOracle);
        }
    }

    public String getStructuredTypeLongName() {
        StructuredTypeProxyOracle structuredTypeProxy = this.getStructuredTypeOracle();
        if (structuredTypeProxy != null) {
            return structuredTypeProxy.getLongName();
        }
        return this.structuredTypeLongName;
    }

    public void setStructuredTypeLongName(String structuredTypeLongName) {
        if (structuredTypeLongName != null) {
            this.structuredTypeLongName = structuredTypeLongName;
            StructuredTypeProxyOracle structuredTypeProxy = null;
            if (!structuredTypeLongName.isEmpty()) {
                StructuredTypeProxySet proxySet = this.getStorageDesign().getStructuredTypeProxySet();
                int dotIndex = structuredTypeLongName.indexOf(46);
                if (dotIndex != -1) {
                    String userName = structuredTypeLongName.substring(0, dotIndex);
                    String structuredTypeName = structuredTypeLongName.substring(dotIndex + 1);
                    structuredTypeProxy = (StructuredTypeProxyOracle)proxySet.getBySchemaAndName(userName, structuredTypeName);
                } else {
                    structuredTypeProxy = (StructuredTypeProxyOracle)proxySet.getByName(structuredTypeLongName);
                }
            }
            this.setStructuredTypeOracle(structuredTypeProxy);
        }
    }

    public String getCollectionTypeLongName() {
        CollectionTypeProxyOracle collectionTypeProxy = this.getCollectionTypeOracle();
        if (collectionTypeProxy != null) {
            return collectionTypeProxy.getLongName();
        }
        return this.collectionTypeLongName;
    }

    public void setCollectionTypeLongName(String collectionTypeLongName) {
        if (collectionTypeLongName != null) {
            this.collectionTypeLongName = collectionTypeLongName;
            CollectionTypeProxyOracle collectionTypeProxy = null;
            if (!collectionTypeLongName.isEmpty()) {
                CollectionTypeProxySet proxySet = this.getStorageDesign().getCollectionTypeProxySet();
                int dotIndex = collectionTypeLongName.indexOf(46);
                if (dotIndex != -1) {
                    String userName = collectionTypeLongName.substring(0, dotIndex);
                    String collectionTypeName = collectionTypeLongName.substring(dotIndex + 1);
                    collectionTypeProxy = (CollectionTypeProxyOracle)proxySet.getByOwnerAndName(userName, collectionTypeName);
                } else {
                    collectionTypeProxy = (CollectionTypeProxyOracle)proxySet.getByName(collectionTypeLongName);
                }
            }
            this.setCollectionTypeOracle(collectionTypeProxy);
        }
    }

    public String getExternalTableLongName() {
        ExternalTableOracle externalTable = this.getExternalTableOracle();
        if (externalTable != null) {
            return externalTable.getLongName();
        }
        return this.externalTableLongName;
    }

    public void setExternalTableLongName(String externalTableLongName) {
        if (externalTableLongName != null) {
            this.externalTableLongName = externalTableLongName;
            ExternalTableOracle externalTable = null;
            if (!externalTableLongName.isEmpty()) {
                ExternalTableSetOracle externalTableSet = this.getStorageDesignOracle().getExternalTableSet();
                int dotIndex = externalTableLongName.indexOf(46);
                if (dotIndex != -1) {
                    String userName = externalTableLongName.substring(0, dotIndex);
                    String externalTableName = externalTableLongName.substring(dotIndex + 1);
                    externalTable = externalTableSet.getByOwnerAndName(userName, externalTableName);
                } else {
                    externalTable = (ExternalTableOracle)externalTableSet.getByName(externalTableLongName);
                }
            }
            this.setExternalTableOracle(externalTable);
        }
    }

    public String getColumnsTableLongName() {
        TableProxyOracle columnsTableProxy = this.getColumnsTable();
        if (columnsTableProxy != null) {
            return columnsTableProxy.getLongName();
        }
        return this.columnsTableLongName;
    }

    public void setColumnsTableLongName(String columnsTableLongName) {
        if (columnsTableLongName != null) {
            this.columnsTableLongName = columnsTableLongName;
            TableProxyOracle columnsTableProxy = null;
            if (!columnsTableLongName.isEmpty()) {
                TableProxySet proxySet = this.getStorageDesign().getTableProxySet();
                int dotIndex = columnsTableLongName.indexOf(46);
                if (dotIndex != -1) {
                    String userName = columnsTableLongName.substring(0, dotIndex);
                    String columnsTableName = columnsTableLongName.substring(dotIndex + 1);
                    columnsTableProxy = (TableProxyOracle)proxySet.getByUserSchemaAndName(userName, columnsTableName);
                } else {
                    columnsTableProxy = (TableProxyOracle)proxySet.getByName(columnsTableLongName);
                }
            }
            this.setColumnsTable(columnsTableProxy);
        }
    }

    public class PermissionsSet
    extends Vector {
        @Override
        public String toString() {
            StringBuffer result = new StringBuffer();
            Iterator it = this.iterator();
            boolean b = false;
            while (it.hasNext()) {
                if (b) {
                    result.append(", ");
                } else {
                    b = true;
                }
                String obj = (String)it.next();
                result.append(obj);
            }
            return result.toString();
        }
    }

    static class StringComparator
    implements Comparator {
        StringComparator() {
        }

        public int compare(Object one, Object two) {
            return String.valueOf(one).compareTo(String.valueOf(two));
        }
    }
}

