/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;

public abstract class PartitionListOracle
extends AbstractStorageObjectOracle
implements ModelObjectSetListener,
StorageObjectListener {
    public static final String PARTITION_TYPE_RANGE = "RANGE";
    public static final String PARTITION_TYPE_HASH_BY_QUANTITY = "HASH BY QUANTITY";
    public static final String PARTITION_TYPE_HASH_BY_LIST_OF_PARTITIONS = "HASH BY LIST OF PARTITIONS";
    private InlineList columnsSet = null;
    private InlineList hashPartitionsTableSpacesSet = null;
    private InlineList subPartitionsColumnsSet = null;
    private InlineList subPartitionsTableSpacesSet = null;
    private TableProxyOracle table = null;
    private SnapshotOracle snapshot = null;
    protected String partitionType = "RANGE";
    protected String subpartitionType = "";
    private String columnList = "";
    private int hashpQuantity = 1;
    private String hashpTableSpaces = "";
    private String subPartitionsColumnList = "";
    private int subPartitionsQuantity = 1;
    private String subPartitionsTableSpaces = "";
    public static final String TYPE_NAME = "PartList";
    public static final String OLD_TYPE_NAME = "PartitionList";

    public PartitionListOracle(StorageDesign storageDesign) {
        this.setStorageDesign(storageDesign);
        ((StorageDesignOracle)storageDesign).getPartitionSet().addSetListener(this);
    }

    @Override
    public String getIDPrefix() {
        return "PL";
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getOldObjectTypeName() {
        return OLD_TYPE_NAME;
    }

    public void setTable(TableProxyOracle table) {
        if (this.table != table) {
            this.table = table;
            if (table != null) {
                this.setPAC_Element(table);
            }
            if (this.getStorageDesign().isLoading()) {
                String token;
                StringTokenizer st;
                if (this.columnList.length() > 0) {
                    this.getColumnSet().clear();
                    st = new StringTokenizer(this.columnList, ",");
                    while (st.hasMoreTokens()) {
                        token = st.nextToken().trim();
                        if (table.getColumnProxy(token) != null) {
                            this.getColumnSet().add(token);
                            continue;
                        }
                        this.addColumn(token);
                    }
                    this.columnList = this.getColumnSet().toString();
                }
                if (this.subPartitionsColumnList.length() > 0) {
                    this.getSubPartitionsColumnsSet().clear();
                    st = new StringTokenizer(this.subPartitionsColumnList, ",");
                    while (st.hasMoreTokens()) {
                        token = st.nextToken().trim();
                        if (table.getColumnProxy(token) != null) {
                            this.getSubPartitionsColumnsSet().add(token);
                            continue;
                        }
                        this.addSubPartitionsColumn(token);
                    }
                    this.subPartitionsColumnList = this.getSubPartitionsColumnsSet().toString();
                }
            }
            this.fireDataFieldChange();
        }
    }

    public TableProxyOracle getTable() {
        return this.table;
    }

    public void setSnapshot(SnapshotOracle snapshot) {
        if (this.snapshot != snapshot) {
            this.snapshot = snapshot;
            if (snapshot != null) {
                this.setPAC_Element(snapshot);
            }
            this.fireDataFieldChange();
        }
    }

    public SnapshotOracle getSnapshot() {
        return this.snapshot;
    }

    public abstract void setPartitionType(String var1);

    public String getPartitionType() {
        return this.partitionType;
    }

    public abstract void setSubpartitionType(String var1);

    public String getSubpartitionType() {
        return this.subpartitionType;
    }

    public String getColumnIDs() {
        return this.columnList;
    }

    public void setColumnIDs(String columnID) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateColumnsSet(columnID);
        } else {
            this.addColumnID(columnID);
        }
        String newValue = this.getColumnSet().toString();
        if (!this.columnList.equals(newValue)) {
            this.columnList = newValue;
            this.fireDataFieldChange();
        }
    }

    private void addColumnID(String columnID) {
        if (!this.getColumnSet().contains(columnID)) {
            this.getColumnSet().add(columnID);
        }
    }

    public String getColumnList() {
        StringBuffer result = new StringBuffer();
        if (this.table != null) {
            StringTokenizer st = new StringTokenizer(this.columnList, ",");
            while (st.hasMoreTokens()) {
                String colID = st.nextToken().trim();
                ColumnProxy columnProxy = this.table.getColumnProxy(colID);
                if (columnProxy == null) continue;
                if (result.length() > 0) {
                    result.append(", ");
                }
                result.append(columnProxy.getName());
            }
        }
        return result.toString();
    }

    public void setColumnList(String columnName) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateColumnsSet(columnName);
        } else {
            this.addColumn(columnName);
        }
        String newValue = this.getColumnSet().toString();
        if (!this.columnList.equals(newValue)) {
            this.columnList = newValue;
            this.fireDataFieldChange();
        }
    }

    public int getHashPQuantity() {
        return this.hashpQuantity;
    }

    public void setHashPQuantity(int hashpQuantity) {
        if (this.hashpQuantity != hashpQuantity) {
            this.hashpQuantity = hashpQuantity;
            this.fireDataFieldChange();
        }
    }

    public String getHashPTableSpaces() {
        return this.hashpTableSpaces;
    }

    public String getAllHashPTableSpaces() {
        StringBuffer result = new StringBuffer();
        StringTokenizer st = new StringTokenizer(this.hashpTableSpaces, ",");
        while (st.hasMoreTokens()) {
            String tsID = st.nextToken().trim();
            TableSpaceOracle ts = (TableSpaceOracle)((StorageDesignOracle)this.getStorageDesign()).getTableSpaceSet().getById(tsID);
            if (ts == null) continue;
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(ts.getName());
        }
        return result.toString();
    }

    public void setHashPTableSpaces(String hashpTableSpaces) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateHashPartitionsTSSet(hashpTableSpaces);
        } else {
            this.addHashPartitionsTS(hashpTableSpaces);
        }
        String newValue = this.getHashPartitionsTableSpacesSet().toString();
        if (!this.hashpTableSpaces.equals(newValue)) {
            this.hashpTableSpaces = newValue;
            this.fireDataFieldChange();
        }
    }

    public String getSubPartitionsColumnIDs() {
        return this.subPartitionsColumnList;
    }

    public void setSubPartitionsColumnIDs(String columnID) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateSubPartitionsColumnsSet(columnID);
        } else {
            this.addSubPartitionColumnID(columnID);
        }
        String newValue = this.getSubPartitionsColumnsSet().toString();
        if (!this.subPartitionsColumnList.equals(newValue)) {
            this.subPartitionsColumnList = newValue;
            this.fireDataFieldChange();
        }
    }

    private void addSubPartitionColumnID(String columnID) {
        if (!this.getSubPartitionsColumnsSet().contains(columnID)) {
            this.getSubPartitionsColumnsSet().add(columnID);
        }
    }

    public String getSubPartitionsColumnList() {
        StringBuffer result = new StringBuffer();
        if (this.table != null) {
            StringTokenizer st = new StringTokenizer(this.subPartitionsColumnList, ",");
            while (st.hasMoreTokens()) {
                String colID = st.nextToken().trim();
                ColumnProxy columnProxy = this.table.getColumnProxy(colID);
                if (columnProxy == null) continue;
                if (result.length() > 0) {
                    result.append(", ");
                }
                result.append(columnProxy.getName());
            }
        }
        return result.toString();
    }

    public void setSubPartitionsColumnList(String columnName) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateSubPartitionsColumnsSet(columnName);
        } else {
            this.addSubPartitionsColumn(columnName);
        }
        String newValue = this.getSubPartitionsColumnsSet().toString();
        if (!this.subPartitionsColumnList.equals(newValue)) {
            this.subPartitionsColumnList = newValue;
            this.fireDataFieldChange();
        }
    }

    public int getSubPartitionsQuantity() {
        return this.subPartitionsQuantity;
    }

    public void setSubPartitionsQuantity(int subPartitionsQuantity) {
        if (this.subPartitionsQuantity != subPartitionsQuantity) {
            this.subPartitionsQuantity = subPartitionsQuantity;
            this.fireDataFieldChange();
        }
    }

    public String getSubPartitionsTableSpaces() {
        return this.subPartitionsTableSpaces;
    }

    public String getAllSubPartitionsTableSpaces() {
        StringBuffer result = new StringBuffer();
        StringTokenizer st = new StringTokenizer(this.subPartitionsTableSpaces, ",");
        while (st.hasMoreTokens()) {
            String tsID = st.nextToken().trim();
            TableSpaceOracle ts = (TableSpaceOracle)((StorageDesignOracle)this.getStorageDesign()).getTableSpaceSet().getById(tsID);
            if (ts == null) continue;
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(ts.getName());
        }
        return result.toString();
    }

    public void setSubPartitionsTableSpaces(String subPartitionsTableSpaces) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateSubPartitionsTSSet(subPartitionsTableSpaces);
        } else {
            this.addSubPartitionsTS(subPartitionsTableSpaces);
        }
        String newValue = this.getSubPartitionsTableSpacesSet().toString();
        if (!this.subPartitionsTableSpaces.equals(newValue)) {
            this.subPartitionsTableSpaces = newValue;
            this.fireDataFieldChange();
        }
    }

    private void addColumn(String column) {
        String columnName = column.substring(column.lastIndexOf(46) + 1);
        String columnID = "";
        if (this.table != null) {
            ColumnProxy columnProxy = this.table.getColumnProxyByName(columnName);
            if (columnProxy != null) {
                columnID = columnProxy.getObjectID();
            }
        } else {
            columnID = columnName;
        }
        if (!columnID.equals("") && !this.getColumnSet().contains(columnID)) {
            this.getColumnSet().add(columnID);
        }
    }

    private void addHashPartitionsTS(String tableSpace) {
        if (!this.getHashPartitionsTableSpacesSet().contains(tableSpace)) {
            this.getHashPartitionsTableSpacesSet().add(tableSpace);
        }
    }

    private void addSubPartitionsColumn(String column) {
        String columnName = column.substring(column.lastIndexOf(46) + 1);
        String columnID = "";
        if (this.table != null) {
            ColumnProxy columnProxy = this.table.getColumnProxyByName(columnName);
            if (columnProxy != null) {
                columnID = columnProxy.getObjectID();
            }
        } else {
            columnID = columnName;
        }
        if (!columnID.equals("") && !this.getSubPartitionsColumnsSet().contains(columnID)) {
            this.getSubPartitionsColumnsSet().add(columnID);
        }
    }

    private void addSubPartitionsTS(String tableSpace) {
        if (!this.getSubPartitionsTableSpacesSet().contains(tableSpace)) {
            this.getSubPartitionsTableSpacesSet().add(tableSpace);
        }
    }

    public void recreateColumnsSet(String columns) {
        this.getColumnSet().clear();
        StringTokenizer st = new StringTokenizer(columns, ",");
        while (st.hasMoreTokens()) {
            this.getColumnSet().add(st.nextToken().trim());
        }
    }

    public void recreateHashPartitionsTSSet(String tableSpaces) {
        this.getHashPartitionsTableSpacesSet().clear();
        StringTokenizer st = new StringTokenizer(tableSpaces, ",");
        while (st.hasMoreTokens()) {
            this.getHashPartitionsTableSpacesSet().add(st.nextToken().trim());
        }
    }

    public void recreateSubPartitionsColumnsSet(String columns) {
        this.getSubPartitionsColumnsSet().clear();
        StringTokenizer st = new StringTokenizer(columns, ",");
        while (st.hasMoreTokens()) {
            this.getSubPartitionsColumnsSet().add(st.nextToken().trim());
        }
    }

    public void recreateSubPartitionsTSSet(String tableSpaces) {
        this.getSubPartitionsTableSpacesSet().clear();
        StringTokenizer st = new StringTokenizer(tableSpaces, ",");
        while (st.hasMoreTokens()) {
            this.getSubPartitionsTableSpacesSet().add(st.nextToken().trim());
        }
    }

    public InlineList getColumnSet() {
        if (this.columnsSet == null) {
            this.columnsSet = new InlineList();
        }
        return this.columnsSet;
    }

    public InlineList getHashPartitionsTableSpacesSet() {
        if (this.hashPartitionsTableSpacesSet == null) {
            this.hashPartitionsTableSpacesSet = new InlineList();
        }
        return this.hashPartitionsTableSpacesSet;
    }

    public InlineList getSubPartitionsColumnsSet() {
        if (this.subPartitionsColumnsSet == null) {
            this.subPartitionsColumnsSet = new InlineList();
        }
        return this.subPartitionsColumnsSet;
    }

    public InlineList getSubPartitionsTableSpacesSet() {
        if (this.subPartitionsTableSpacesSet == null) {
            this.subPartitionsTableSpacesSet = new InlineList();
        }
        return this.subPartitionsTableSpacesSet;
    }

    public void clear() {
        this.getColumnSet().clear();
        this.getHashPartitionsTableSpacesSet().clear();
        this.getSubPartitionsColumnsSet().clear();
        this.getSubPartitionsTableSpacesSet().clear();
        this.columnList = "";
        this.hashpTableSpaces = "";
        this.subPartitionsColumnList = "";
        this.subPartitionsTableSpaces = "";
    }

    @Override
    public boolean isTopLevelObject() {
        return false;
    }

    public class InlineList
    extends Vector {
        @Override
        public String toString() {
            StringBuffer result = new StringBuffer();
            Iterator it = this.iterator();
            boolean b = false;
            while (it.hasNext()) {
                if (b) {
                    result.append(", ");
                } else {
                    b = true;
                }
                String obj = (String)it.next();
                result.append(obj);
            }
            return result.toString();
        }

        public boolean contains(String colName) {
            for (String col : this) {
                if (!col.equalsIgnoreCase(colName)) continue;
                return true;
            }
            return false;
        }
    }
}

