/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DataBaseOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;

public class DataFileOracle
extends AbstractStorageObjectOracle {
    private static final String[] SWITCH_STATES = new String[]{"UNDEFINED", "ON", "OFF"};
    protected String fileName = "";
    protected long size = 0L;
    protected String measureUnit = ConstantsOracle.UNITS_CHOICES[1];
    protected String reuse = "YES";
    protected static Set switchSet = null;
    protected String autoextend = SWITCH_STATES[0];
    protected int nextBlockSize = 1;
    protected String nextBlockSizeUnit = ConstantsOracle.UNITS_CHOICES[1];
    protected String maxSize = "UNLIMITED";
    protected String maxSizeUnit = ConstantsOracle.UNITS_CHOICES[1];
    protected DataBaseOracle dataBase = null;
    protected TableSpaceOracle tableSpace = null;
    public static final String TYPE_NAME = "DataFile";

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
        this.fireDataFieldChange();
    }

    public void setReuse(String value) {
        if (ConstantsOracle.checkYesNo(value)) {
            this.reuse = value;
            this.fireDataFieldChange();
        }
    }

    public String getReuse() {
        return this.reuse;
    }

    public static String[] getSwitchChoices() {
        return SWITCH_STATES;
    }

    protected boolean checkSwitch(String value) {
        if (switchSet == null) {
            switchSet = new HashSet();
            switchSet.addAll(Arrays.asList(DataFileOracle.getSwitchChoices()));
        }
        return switchSet.contains(value);
    }

    public void setMeasureUnit(String value) {
        if (ConstantsOracle.checkUnit(value)) {
            this.measureUnit = value;
            this.fireDataFieldChange();
        }
    }

    public String getMeasureUnit() {
        return this.measureUnit;
    }

    public void setAutoextend(String value) {
        if (this.checkSwitch(value)) {
            this.autoextend = value;
            this.fireDataFieldChange();
        }
    }

    public String getAutoextend() {
        return this.autoextend;
    }

    public int getNextBlockSize() {
        return this.nextBlockSize;
    }

    public void setNextBlockSize(int nextBlockSize) {
        this.nextBlockSize = nextBlockSize;
        this.fireDataFieldChange();
    }

    public void setNextBlockSizeUnit(String value) {
        if (ConstantsOracle.checkUnit(value)) {
            this.nextBlockSizeUnit = value;
            this.fireDataFieldChange();
        }
    }

    public String getNextBlockSizeUnit() {
        return this.nextBlockSizeUnit;
    }

    public String getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(String value) {
        int dotIndex = value.indexOf(46);
        if (dotIndex > -1) {
            value = value.substring(0, dotIndex);
        }
        try {
            this.maxSize = Long.parseLong(value) > 0L ? value : "UNLIMITED";
        }
        catch (Exception E) {
            this.maxSize = "UNLIMITED";
        }
        this.fireDataFieldChange();
    }

    public void setMaxSizeUnit(String value) {
        if (ConstantsOracle.checkUnit(value)) {
            this.maxSizeUnit = value;
            this.fireDataFieldChange();
        }
    }

    public String getMaxSizeUnit() {
        return this.maxSizeUnit;
    }

    public static List getMeasureUnitValues() {
        return Arrays.asList(ConstantsOracle.UNITS_CHOICES);
    }

    public void setDataBase(DataBaseOracle dataBase) {
        this.dataBase = dataBase;
        if (dataBase != null) {
            this.setPAC_Element(dataBase);
            this.tableSpace = null;
        }
        this.fireDataFieldChange();
    }

    public DataBaseOracle getDataBase() {
        return this.dataBase;
    }

    public void setTableSpace(TableSpaceOracle tableSpace) {
        this.tableSpace = tableSpace;
        if (tableSpace != null) {
            this.setPAC_Element(tableSpace);
            this.dataBase = null;
        }
        this.fireDataFieldChange();
    }

    public TableSpaceOracle getTableSpace() {
        return this.tableSpace;
    }

    @Override
    public void showPropertyDialog() {
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
        this.fireDataFieldChange();
    }

    @Override
    public boolean isTopLevelObject() {
        return false;
    }
}

