/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.relational;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.crest.model.MaskTemplate;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.constraint.AVT;
import oracle.dbtools.crest.model.design.constraint.AbstractConstraint;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.ConstraintEnumeration;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociationReference;
import oracle.dbtools.crest.model.design.relational.FK_And_Delegate_Holder;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.util.GUID;

public class Column
extends FKElement {
    private String abbreviation = "";
    private Boolean computed = false;
    private Boolean containsPII;
    private Boolean containsSensitiveInformation;
    private String defaultdisplayAs = "Text";
    private boolean defaultdisplayedOnForms = true;
    private boolean defaultdisplayedOnReports = true;
    private Integer defaultFormdisplayWidth;
    private Integer defaultFormHeight;
    private Integer defaultFormMaximumWidth;
    private String defaultFormatMask;
    private String defaultHelpText;
    private String defaultLabel;
    private boolean defaultReadOnly = false;
    private Boolean maskData;
    private String maskingType = "";
    private MaskTemplate maskTemplate;
    private boolean previousColumn = true;
    private boolean autoIncrementColumn = false;
    private boolean identityColumn = false;
    private boolean autoIncrementGenerateAlways = false;
    private String autoIncrementStartWith = "";
    private Integer autoIncrementIncrementBy = 1;
    private String autoIncrementMinValue = "";
    private String autoIncrementMaxValue = "";
    private boolean autoIncrementCycle = false;
    private boolean autoIncrementDisableCache = false;
    private Integer autoIncrementCache;
    private boolean autoIncrementOrder = false;
    private boolean defaultOnNull = false;
    private String autoIncrementSequenceName;
    private String autoIncrementTriggerName;
    private boolean autoIncrementGenerateTrigger = true;
    private String notNullConstraintName;
    private String generateConstraintInDDL = "YES";
    private boolean isDiscriminatorColumn = false;
    private boolean isSurrogateColumn = false;
    private boolean isRelationshipColumn = false;
    private String dependOnForeignKeyID;
    private boolean dependOnFK_Mandatory = false;
    private List associations;
    private List dependentColumns;
    private Collection allrefs = new ArrayList();
    private String fkAssociationId;
    private FKIndexAssociationReference fkAssociationReference;
    private String referencedColumnId;
    private FKElement delegate = null;
    private boolean jsonColumn = false;
    private String jsonDataGuide = "";
    private FKIndexAssociation dependOnForeignKey;
    public static final String IDENTITY_GENERATION_ALWAYS = "ALWAYS";
    public static final String IDENTITY_GENERATION_BY_DEFAULT = "BY DEFAULT";
    public static final String IDENTITY_GENERATION_BY_DEFAULT_ON_NULL = "BY DEFAULT ON NULL";
    public static final String MT_NOT_DEFINED = "";
    public static final String MT_NO = "NO";
    public static final String MT_NONE = "NONE";
    public static final String MT_FULL = "FULL";
    public static final String MT_PARTIAL = "PARTIAL";
    public static final String MT_RANDOM = "RANDOM";
    public static final String MT_REGEXP = "REGEXP";
    public static final String MT_TEST = "TEST";
    public static final String[] MASKING_TYPES = new String[]{"", "FULL", "NO", "PARTIAL", "RANDOM", "REGEXP", "TEST"};
    private boolean nncDeferrable = false;
    private boolean nncInitiallyImediate = true;
    private boolean nncEnable = true;
    private boolean nncValidate = true;
    private boolean checkDeferrable = false;
    private boolean checkInitiallyImediate = true;
    private boolean checkEnable = true;
    private boolean checkValidate = true;
    public static final String TYPE_NAME = "Column";

    public Column(DesignPart designPart) {
        super(designPart);
    }

    public Column(DesignPart designPart, FKElement refColumn, FKIndexAssociationReference fkReference) {
        super(designPart);
        this.fkAssociationReference = fkReference;
        this.referencedColumnId = refColumn.getObjectID();
        FKElement.FKColRefNode ref = new FKElement.FKColRefNode(this);
        ref.fkAssociationRef = fkReference;
        ref.refColumnId = refColumn.getObjectID();
        this.allrefs.add(ref);
        this.setPreviousColumn(false);
    }

    public Column(DesignPart designPart, FKElement refColumn, FKIndexAssociation fkAssoc) {
        super(designPart);
        this.fkAssociationId = fkAssoc.getObjectID();
        this.referencedColumnId = refColumn.getObjectID();
        FKElement.FKColRefNode ref = new FKElement.FKColRefNode(this);
        ref.fkAssocId = fkAssoc.getObjectID();
        ref.refColumnId = refColumn.getObjectID();
        this.allrefs.add(ref);
        this.setPreviousColumn(false);
    }

    @Override
    public String getAbbreviation() {
        return this.abbreviation;
    }

    public void setAbbreviation(String abbreviation) {
        this.abbreviation = abbreviation;
    }

    public Boolean isComputed() {
        return this.computed;
    }

    public void setComputed(Boolean computed) {
        this.computed = computed;
    }

    public Boolean isContainsPII() {
        return this.containsPII;
    }

    public void setContainsPII(Boolean containsPII) {
        this.containsPII = containsPII;
    }

    public Boolean isContainsSensitiveInformation() {
        return this.containsSensitiveInformation;
    }

    public void setContainsSensitiveInformation(Boolean containsSensitiveInformation) {
        this.containsSensitiveInformation = containsSensitiveInformation;
    }

    public String getDefaultDisplayAs() {
        return this.defaultdisplayAs;
    }

    public void setDefaultDisplayAs(String defaultdisplayAs) {
        this.defaultdisplayAs = defaultdisplayAs;
    }

    public boolean isDefaultDisplayedOnForms() {
        return this.defaultdisplayedOnForms;
    }

    public void setDefaultDisplayedOnForms(boolean defaultdisplayedOnForms) {
        this.defaultdisplayedOnForms = defaultdisplayedOnForms;
    }

    public boolean isDefaultDisplayedOnReports() {
        return this.defaultdisplayedOnReports;
    }

    public void setDefaultDisplayedOnReports(boolean defaultdisplayedOnReports) {
        this.defaultdisplayedOnReports = defaultdisplayedOnReports;
    }

    public Integer getDefaultFormDisplayWidth() {
        return this.defaultFormdisplayWidth;
    }

    public void setDefaultFormDisplayWidth(Integer defaultFormdisplayWidth) {
        this.defaultFormdisplayWidth = defaultFormdisplayWidth;
    }

    public Integer getDefaultFormHeight() {
        return this.defaultFormHeight;
    }

    public void setDefaultFormHeight(Integer defaultFormHeight) {
        this.defaultFormHeight = defaultFormHeight;
    }

    public Integer getDefaultFormMaximumWidth() {
        return this.defaultFormMaximumWidth;
    }

    public void setDefaultFormMaximumWidth(Integer defaultFormMaximumWidth) {
        this.defaultFormMaximumWidth = defaultFormMaximumWidth;
    }

    public String getDefaultFormatMask() {
        return this.defaultFormatMask;
    }

    public void setDefaultFormatMask(String defaultFormatMask) {
        this.defaultFormatMask = defaultFormatMask;
    }

    public String getDefaultHelpText() {
        return this.defaultHelpText;
    }

    public void setDefaultHelpText(String defaultHelpText) {
        this.defaultHelpText = defaultHelpText;
    }

    public String getDefaultLabel() {
        return this.defaultLabel;
    }

    public void setDefaultLabel(String defaultLabel) {
        this.defaultLabel = defaultLabel;
    }

    public boolean isDefaultReadOnly() {
        return this.defaultReadOnly;
    }

    public void setDefaultReadOnly(boolean defaultReadOnly) {
        this.defaultReadOnly = defaultReadOnly;
    }

    public Boolean isMaskData() {
        return this.maskData;
    }

    public void setMaskData(Boolean maskData) {
        this.maskData = maskData;
    }

    public String getMaskingType() {
        return this.maskingType;
    }

    public void setMaskingType(String maskingType) {
        this.maskingType = maskingType;
    }

    public MaskTemplate getMaskTemplate() {
        return this.maskTemplate;
    }

    public void setMaskTemplate(MaskTemplate maskTemplate) {
        this.maskTemplate = maskTemplate;
    }

    @Override
    public boolean isPreviousColumn() {
        return this.previousColumn;
    }

    public void setPreviousColumn(boolean previousColumn) {
        this.previousColumn = previousColumn;
    }

    public boolean isAutoIncrementColumn() {
        return this.autoIncrementColumn;
    }

    public void setAutoIncrementColumn(boolean autoIncrementColumn) {
        this.autoIncrementColumn = autoIncrementColumn;
    }

    public boolean isIdentityColumn() {
        return this.identityColumn;
    }

    public void setIdentityColumn(boolean identityColumn) {
        this.identityColumn = identityColumn;
        if (identityColumn && !this.autoIncrementColumn) {
            this.autoIncrementColumn = true;
        }
    }

    public boolean isAutoIncrementGenerateAlways() {
        return this.autoIncrementGenerateAlways;
    }

    public void setAutoIncrementGenerateAlways(boolean autoIncrementGenerateAlways) {
        this.autoIncrementGenerateAlways = autoIncrementGenerateAlways;
        if (autoIncrementGenerateAlways && this.isIdentityColumn()) {
            this.setDefaultOnNull(false);
        }
    }

    public String getAutoIncrementStartWith() {
        return this.autoIncrementStartWith;
    }

    public void setAutoIncrementStartWith(String autoIncrementStartWith) {
        this.autoIncrementStartWith = autoIncrementStartWith;
    }

    public Integer getAutoIncrementIncrementBy() {
        return this.autoIncrementIncrementBy;
    }

    public void setAutoIncrementIncrementBy(Integer autoIncrementIncrementBy) {
        this.autoIncrementIncrementBy = autoIncrementIncrementBy;
    }

    public String getAutoIncrementMinValue() {
        return this.autoIncrementMinValue;
    }

    public void setAutoIncrementMinValue(String autoIncrementMinValue) {
        this.autoIncrementMinValue = autoIncrementMinValue;
    }

    public String getAutoIncrementMaxValue() {
        return this.autoIncrementMaxValue;
    }

    public void setAutoIncrementMaxValue(String autoIncrementMaxValue) {
        this.autoIncrementMaxValue = autoIncrementMaxValue;
    }

    public boolean isAutoIncrementCycle() {
        return this.autoIncrementCycle;
    }

    public void setAutoIncrementCycle(boolean autoIncrementCycle) {
        this.autoIncrementCycle = autoIncrementCycle;
    }

    public boolean isAutoIncrementDisableCache() {
        return this.autoIncrementDisableCache;
    }

    public void setAutoIncrementDisableCache(boolean autoIncrementDisableCache) {
        this.autoIncrementDisableCache = autoIncrementDisableCache;
    }

    public Integer getAutoIncrementCache() {
        return this.autoIncrementCache;
    }

    public void setAutoIncrementCache(Integer autoIncrementCache) {
        this.autoIncrementCache = autoIncrementCache;
    }

    public boolean isAutoIncrementOrder() {
        return this.autoIncrementOrder;
    }

    public void setAutoIncrementOrder(boolean autoIncrementOrder) {
        this.autoIncrementOrder = autoIncrementOrder;
    }

    public String getAutoIncrementSequenceName() {
        return this.autoIncrementSequenceName;
    }

    public void setAutoIncrementSequenceName(String autoIncrementSequenceName) {
        this.autoIncrementSequenceName = autoIncrementSequenceName;
    }

    public String getAutoIncrementTriggerName() {
        return this.autoIncrementTriggerName;
    }

    public void setAutoIncrementTriggerName(String autoIncrementTriggerName) {
        this.autoIncrementTriggerName = autoIncrementTriggerName;
    }

    public boolean isAutoIncrementGenerateTrigger() {
        return this.autoIncrementGenerateTrigger;
    }

    public void setAutoIncrementGenerateTrigger(boolean autoIncrementGenerateTrigger) {
        this.autoIncrementGenerateTrigger = autoIncrementGenerateTrigger;
    }

    @Override
    public String getNotNullConstraintName() {
        return this.notNullConstraintName;
    }

    @Override
    public void setNotNullConstraintName(String notNullConstraintName) {
        this.notNullConstraintName = notNullConstraintName;
    }

    public String getGenerateConstraintInDDL() {
        return this.generateConstraintInDDL;
    }

    public void setGenerateConstraintInDDL(String generateConstraintInDDL) {
        this.generateConstraintInDDL = generateConstraintInDDL;
    }

    public boolean isDiscriminatorColumn() {
        return this.isDiscriminatorColumn;
    }

    public void setDiscriminatorColumn(boolean isDiscriminatorColumn) {
        this.isDiscriminatorColumn = isDiscriminatorColumn;
    }

    @Override
    public boolean isSurrogateColumn() {
        return this.isSurrogateColumn;
    }

    public void setSurrogateColumn(boolean isSurrogateColumn) {
        this.isSurrogateColumn = isSurrogateColumn;
    }

    public boolean isRelationshipColumn() {
        return this.isRelationshipColumn;
    }

    public void setRelationshipColumn(boolean isRelationshipColumn) {
        this.isRelationshipColumn = isRelationshipColumn;
    }

    public List getFKAssociationMaps() {
        if (this.associations == null) {
            this.associations = new ArrayList();
        }
        return this.associations;
    }

    public RelationalDesign getRelationalModel() {
        return (RelationalDesign)this.getDesignPart();
    }

    public Table getTable() {
        return (Table)this.getContainer();
    }

    public String getTableSchemaName() {
        if (this.getTable() != null) {
            return this.getTable().getSchema();
        }
        return MT_NOT_DEFINED;
    }

    public List<DependentColumnDescriptor> getDependentColumnDescriptors() {
        if (this.dependentColumns == null) {
            this.dependentColumns = new ArrayList();
        }
        return this.dependentColumns;
    }

    public List<DependentColumnDescriptor> getDependentColumnDescriptors(String discriminatorValue) {
        ArrayList<DependentColumnDescriptor> list = new ArrayList<DependentColumnDescriptor>();
        if (discriminatorValue != null) {
            for (DependentColumnDescriptor desc : this.getDependentColumnDescriptors()) {
                if (!discriminatorValue.equals(desc.getDiscriminatorValue())) continue;
                list.add(desc);
            }
        }
        return list;
    }

    public Map getDependentColumnDescriptorsMap(String discriminatorValue) {
        HashMap<String, DependentColumnDescriptor> map = new HashMap<String, DependentColumnDescriptor>();
        if (discriminatorValue != null) {
            for (DependentColumnDescriptor desc : this.getDependentColumnDescriptors()) {
                if (!discriminatorValue.equals(desc.getDiscriminatorValue())) continue;
                map.put(desc.getColumnID(), desc);
            }
        }
        return map;
    }

    public static DependentColumnDescriptor getDependentColumnDescriptor(List<DependentColumnDescriptor> list, String dependentColumnID) {
        for (DependentColumnDescriptor desc : list) {
            if (!desc.getColumnID().equals(dependentColumnID)) continue;
            return desc;
        }
        return null;
    }

    public DependentColumnDescriptor getDependentColumnDescriptor(String discriminatorValue, String dependentColumnID) {
        if (dependentColumnID != null && discriminatorValue != null) {
            for (DependentColumnDescriptor desc : this.getDependentColumnDescriptors()) {
                if (!dependentColumnID.equals(desc.getColumnID()) || !discriminatorValue.equals(desc.getDiscriminatorValue())) continue;
                return desc;
            }
        }
        return null;
    }

    public void addDependentColumnDescriptor(DependentColumnDescriptor desc) {
        if (desc.getOwner() == this) {
            DependentColumnDescriptor temp = this.getDependentColumnDescriptor(desc.getDiscriminatorValue(), desc.getColumnID());
            if (temp == null) {
                this.getDependentColumnDescriptors().add(desc);
            } else {
                temp.setDependOnValue(desc.isDependOnValue());
                temp.setDependAsMandatory(desc.isDependAsMandatory());
            }
        }
    }

    public void validateDependentColumnsDescriptors() {
        List<DependentColumnDescriptor> list = this.getDependentColumnDescriptors();
        if (list.size() > 0) {
            Table table = this.getTable();
            Set values = this.getValues();
            ArrayList<DependentColumnDescriptor> copy = new ArrayList<DependentColumnDescriptor>(list);
            list.clear();
            for (DependentColumnDescriptor desc : copy) {
                if (!values.contains(desc.getDiscriminatorValue()) || !desc.isDependAsMandatory() && !desc.isDependOnValue()) continue;
                if (table != null) {
                    if (table.getElementByID(desc.getColumnID()) == null) continue;
                    list.add(desc);
                    continue;
                }
                list.add(desc);
            }
        }
    }

    public List<Column> getDependentColumnList() {
        this.validateDependentColumnsDescriptors();
        ArrayList<Column> list = new ArrayList<Column>();
        for (DependentColumnDescriptor desc : this.getDependentColumnDescriptors()) {
            Column col = desc.getColumn();
            if (col == null || list.contains(col)) continue;
            list.add(col);
        }
        return list;
    }

    @Override
    public boolean isInMandatoryFK() {
        for (FKIndexAssociation fk : this.getAllFKs()) {
            if (!fk.isMandatory()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addFKAssociation(FKElement refColumn, FKIndexAssociation fkAssociation) {
        String fkId = fkAssociation.getObjectID();
        String rfColId = refColumn.getObjectID();
        this.addFKAssociation(rfColId, fkId);
    }

    @Override
    public void addFKAssociation(String rfColId, String fkId) {
        if (this.allrefs.size() == 0) {
            this.fkAssociationId = fkId;
            this.referencedColumnId = rfColId;
        }
        boolean added = false;
        for (FKElement.FKColRefNode ref : this.allrefs) {
            if (ref.fkAssocId.equalsIgnoreCase(fkId)) {
                ref.refColumnId = rfColId;
                added = true;
                continue;
            }
            if (ref.fkAssociationRef == null || !fkId.equalsIgnoreCase(ref.fkAssociationRef.getObject().getObjectID())) continue;
            ref.refColumnId = rfColId;
            added = true;
        }
        if (!added) {
            FKElement.FKColRefNode ref;
            ref = new FKElement.FKColRefNode(this);
            ref.fkAssocId = fkId;
            ref.refColumnId = rfColId;
            this.allrefs.add(ref);
        }
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return this.getPreference("column id prefix");
    }

    @Override
    public FKIndexAssociation getDependOnForeignKey() {
        DesignObject obj;
        if (this.dependOnForeignKey == null && !MT_NOT_DEFINED.equals(this.dependOnForeignKeyID) && (obj = this.getDesign().getDesignObject(this.dependOnForeignKeyID)) instanceof FKIndexAssociation) {
            this.dependOnForeignKey = (FKIndexAssociation)obj;
        }
        return this.dependOnForeignKey;
    }

    @Override
    public void setDependOnForeignKey(FKIndexAssociation dependOnForeignKey) {
        if (dependOnForeignKey != null) {
            this.dependOnForeignKeyID = dependOnForeignKey.getObjectID();
        }
        this.dependOnForeignKey = dependOnForeignKey;
    }

    @Override
    public boolean isDependOnFK_AsMandatory() {
        return this.dependOnFK_Mandatory;
    }

    @Override
    public void setDependOnFK_AsMandatory(boolean dependOnFK_Mandatory) {
        this.dependOnFK_Mandatory = dependOnFK_Mandatory;
    }

    public String getDependOnForeignKeyID() {
        if (this.dependOnForeignKey != null && !this.dependOnForeignKey.isRemoved()) {
            this.dependOnForeignKeyID = this.dependOnForeignKey.getObjectID();
        }
        return this.dependOnForeignKeyID;
    }

    @Override
    public void setDependOnForeignKeyID(String dependOnForeignKeyID) {
        this.dependOnForeignKeyID = dependOnForeignKeyID;
    }

    @Override
    public boolean isPartOfFKIndexAssociation(FKIndexAssociation fkAssoc) {
        FKElement.FKColRefNode[] arr = this.allrefs.toArray(new FKElement.FKColRefNode[0]);
        String id = fkAssoc.getObjectID();
        if (id == null) {
            return false;
        }
        for (int i = 0; i < arr.length; ++i) {
            if (id.equalsIgnoreCase(arr[i].fkAssocId)) {
                return true;
            }
            if (arr[i].fkAssociationRef == null) continue;
            return id.equalsIgnoreCase(arr[i].fkAssociationRef.getObject().getObjectID());
        }
        return false;
    }

    @Override
    public Collection getFKAssociationsForDelegate(String delegateId) {
        ArrayList<DesignObject> col = new ArrayList<DesignObject>();
        for (FKElement.FKColRefNode snode : this.allrefs) {
            if (snode.fkAssocId != null) {
                if (!snode.refColumnId.equalsIgnoreCase(delegateId)) continue;
                col.add(this.getFKIndexAssociation(snode.fkAssocId));
                continue;
            }
            if (snode.fkAssociationRef == null || snode.fkAssociationRef.getObject() == null || !snode.refColumnId.equalsIgnoreCase(delegateId)) continue;
            col.add(snode.fkAssociationRef.getObject());
        }
        return col;
    }

    private FKIndexAssociation getFKIndexAssociation(String fkId) {
        if (this.getContainerWithKeyObject() == null) {
            return null;
        }
        KeyObject[] indexes = this.getContainerWithKeyObject().getKeys();
        for (int i = 0; i < indexes.length; ++i) {
            if (!indexes[i].isFK() || !indexes[i].getFKAssociation().getObjectID().equalsIgnoreCase(fkId)) continue;
            return indexes[i].getFKAssociation();
        }
        return null;
    }

    @Override
    public FKElement getDelegate() {
        if (this.delegate != null) {
            return this.delegate;
        }
        return this.getReferencedColumn();
    }

    public FKElement getReferencedColumn() {
        FKIndexAssociation fkass;
        if (this.referencedColumnId != null && this.fkAssociationId != null && (fkass = this.getFKIndexAssociation(this.fkAssociationId)) != null && fkass.getRemoteTable() != null) {
            return (FKElement)fkass.getRemoteTable().getElementByID(this.referencedColumnId);
        }
        return null;
    }

    @Override
    public int getAssociationsCount() {
        return this.allrefs.size();
    }

    @Override
    public void removeFKAssociation(String fkAssocId) {
        boolean simt = true;
        if (this.fkAssociationId != null && this.fkAssociationId.equalsIgnoreCase(fkAssocId)) {
            FKElement refcol = this.getReferencedColumn();
            this.fkAssociationReference = null;
            this.fkAssociationId = null;
            this.referencedColumnId = null;
            if (refcol == null || this.isNested() || this.getContainer().isBST() || simt || !(refcol instanceof ColumnView) || "UNKNOWN".equalsIgnoreCase(refcol.getDataType().getName())) {
                // empty if block
            }
        }
        if (this.allrefs.size() > 0) {
            Iterator it;
            FKElement.FKColRefNode[] arr = this.allrefs.toArray(new FKElement.FKColRefNode[0]);
            for (int i = 0; i < arr.length; ++i) {
                if (!fkAssocId.equalsIgnoreCase(arr[i].fkAssocId) && (arr[i].fkAssociationRef == null || arr[i].fkAssociationRef.getObject() == null || !fkAssocId.equalsIgnoreCase(arr[i].fkAssociationRef.getObject().getObjectID()))) continue;
                this.allrefs.remove(arr[i]);
                break;
            }
            if ((it = this.allrefs.iterator()).hasNext()) {
                FKElement.FKColRefNode rnode = (FKElement.FKColRefNode)it.next();
                this.fkAssociationReference = rnode.fkAssociationRef;
                this.fkAssociationId = rnode.fkAssocId;
                this.referencedColumnId = rnode.refColumnId;
            } else {
                this.fkAssociationReference = null;
                this.fkAssociationId = null;
                this.referencedColumnId = null;
            }
        }
    }

    @Override
    public List getAllFKs() {
        ArrayList<FKIndexAssociation> list = new ArrayList<FKIndexAssociation>();
        for (FKElement.FKColRefNode snode : this.allrefs) {
            FKIndexAssociation fkass = null;
            if (snode.fkAssocId != null) {
                fkass = this.getFKIndexAssociation(snode.fkAssocId);
            } else if (snode.fkAssociationRef != null) {
                snode.fkAssocId = snode.fkAssociationRef.getObject().getObjectID();
                fkass = this.getFKIndexAssociation(snode.fkAssocId);
            }
            if (fkass == null) continue;
            list.add(fkass);
        }
        return list;
    }

    @Override
    public boolean isReferingTo(FKIndexAssociation fk, FKElement delegate) {
        String fkid = fk.getObjectID();
        Iterator it = this.allrefs.iterator();
        String delegateId = delegate.getObjectID();
        while (it.hasNext()) {
            FKElement.FKColRefNode node = (FKElement.FKColRefNode)it.next();
            if (node.refColumnId == null || delegate == null || !node.refColumnId.equalsIgnoreCase(delegateId) || !fkid.equals(node.fkAssocId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isReferingTo(FKElement delegate) {
        Iterator it = this.allrefs.iterator();
        String delegateId = delegate.getObjectID();
        while (it.hasNext()) {
            FKElement.FKColRefNode node = (FKElement.FKColRefNode)it.next();
            if (node.refColumnId == null || delegate == null || !node.refColumnId.equalsIgnoreCase(delegateId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public FKElement getReferencedColumn(FKIndexAssociation fkAssoc) {
        Iterator it = this.allrefs.iterator();
        String id = fkAssoc.getObjectID();
        while (it.hasNext()) {
            FKContainer remoteTable;
            FKIndexAssociation fkass;
            FKElement.FKColRefNode rnode = (FKElement.FKColRefNode)it.next();
            if (!rnode.fkAssocId.equalsIgnoreCase(id) || rnode.refColumnId == null || (fkass = this.getFKIndexAssociation(rnode.fkAssocId)) == null || (remoteTable = fkass.getRemoteTable()) == null) continue;
            return (FKElement)remoteTable.getElementByID(rnode.refColumnId);
        }
        return null;
    }

    @Override
    public boolean isFKColumn() {
        return this.getAssociationsCount() > 0;
    }

    @Override
    public boolean isFKElement() {
        return this.isFKColumn();
    }

    @Override
    public List getAllDelegatesAndFK() {
        ArrayList<FK_And_Delegate_Holder> list = new ArrayList<FK_And_Delegate_Holder>();
        for (FKElement.FKColRefNode snode : this.allrefs) {
            FKElement dcol;
            FKIndexAssociation fkass = null;
            if (snode.fkAssocId != null) {
                fkass = this.getFKIndexAssociation(snode.fkAssocId);
            } else if (snode.fkAssociationRef != null) {
                snode.fkAssocId = snode.fkAssociationRef.getObject().getObjectID();
                fkass = this.getFKIndexAssociation(snode.fkAssocId);
            }
            if (fkass == null || snode.refColumnId == null || (dcol = (FKElement)fkass.getRemoteTable().getElementByID(snode.refColumnId)) == null) continue;
            FK_And_Delegate_Holder fkh = new FK_And_Delegate_Holder();
            fkh.delegateColumn = dcol;
            fkh.fk = fkass;
            list.add(fkh);
        }
        return list;
    }

    @Override
    public String getDataType(int nestedLevel) {
        return this.getDatatypeString();
    }

    public String getDatatypeString() {
        try {
            String dbtype = this.getRelationalModel().getSelectedRDBMSType().getName();
            return this.getDatatypeString(dbtype);
        }
        catch (Exception exception) {
            return MT_NOT_DEFINED;
        }
    }

    @Override
    public Collection getRefColAndAssocIDs() {
        for (FKElement.FKColRefNode snode : this.allrefs) {
            KeyObject remoteKey;
            FKContainer remoteTable;
            FKIndexAssociation fkass;
            snode.remoteTableId = "null";
            snode.remoteKeyId = "null";
            if (snode.fkAssocId != null) {
                fkass = this.getFKIndexAssociation(snode.fkAssocId);
                if (fkass == null) continue;
                remoteTable = fkass.getRemoteTable();
                if (remoteTable != null) {
                    snode.remoteTableId = remoteTable.getObjectID();
                }
                if ((remoteKey = fkass.getKeyObject()) == null) continue;
                snode.remoteKeyId = remoteKey.getObjectID();
                continue;
            }
            if (snode.fkAssociationRef != null) {
                snode.fkAssocId = snode.fkAssociationRef.getObject().getObjectID();
                fkass = this.getFKIndexAssociation(snode.fkAssocId);
                if (fkass == null) continue;
                remoteTable = fkass.getRemoteTable();
                if (remoteTable != null) {
                    snode.remoteTableId = remoteTable.getObjectID();
                }
                if ((remoteKey = fkass.getKeyObject()) == null) continue;
                snode.remoteKeyId = remoteKey.getObjectID();
                continue;
            }
            snode.fkAssocId = "null";
        }
        return this.allrefs;
    }

    @Override
    public List getMappingsToAttributes() {
        return Collections.EMPTY_LIST;
    }

    public FKIndexAssociation getFKIndexAssociation() {
        FKIndexAssociation fk = null;
        if (this.fkAssociationId != null) {
            fk = this.getFKIndexAssociation(this.fkAssociationId);
        }
        if (fk != null) {
            return fk;
        }
        if (this.allrefs.size() > 0) {
            for (FKElement.FKColRefNode rnode : this.allrefs) {
                if (rnode.fkAssocId != null && (fk = this.getFKIndexAssociation(rnode.fkAssocId)) != null) {
                    return fk;
                }
                if (rnode.fkAssociationRef == null) continue;
                if (rnode.fkAssociationRef.getObject() != null) {
                    fk = this.getFKIndexAssociation(rnode.fkAssociationRef.getObject().getObjectID());
                }
                if (fk == null) continue;
                return fk;
            }
        }
        return null;
    }

    public boolean isInFKinArc() {
        for (FKIndexAssociation fk : this.getAllFKs()) {
            if (!fk.isInArc()) continue;
            return true;
        }
        return false;
    }

    public boolean isGenerateConstraintInDDL() {
        return this.generateConstraintInDDL.equalsIgnoreCase("YES");
    }

    public void setGenerateConstraintInDDL(boolean generateConstraintInDDL) {
        this.generateConstraintInDDL = generateConstraintInDDL ? "YES" : MT_NO;
    }

    @Override
    public String getNativeDataType() {
        return this.nativeDataType;
    }

    @Override
    public void setNativeDataType(String nativeDataType) {
        this.nativeDataType = nativeDataType;
    }

    public void copyDepenDendentColumnDescriptors(Column column, boolean copyID, Map copyMap) {
        List<DependentColumnDescriptor> list = column.getDependentColumnDescriptors();
        list.clear();
        for (DependentColumnDescriptor desc : this.getDependentColumnDescriptors()) {
            ModelIDObject obj;
            DependentColumnDescriptor temp = column.createDependentColumnDescriptor();
            desc.copy(temp);
            if (copyMap != null && (obj = (ModelIDObject)copyMap.get(desc.getColumnID())) != null) {
                temp.setColumnID(obj.getObjectID());
            }
            if (copyID) {
                temp.setID(desc.getID());
            }
            list.add(temp);
        }
    }

    public DependentColumnDescriptor createDependentColumnDescriptor() {
        return new DependentColumnDescriptor(this);
    }

    public boolean isNncDeferrable() {
        RelationalObjectProxy pr = (RelationalObjectProxy)this.getProxyObject();
        if (pr != null && pr instanceof ColumnProxyOracle) {
            ColumnProxyOracle cp = (ColumnProxyOracle)pr;
            return "YES".equalsIgnoreCase(cp.getNncDeferrable());
        }
        return this.nncDeferrable;
    }

    public void setNncDeferrable(boolean nncDeferrable) {
        this.nncDeferrable = nncDeferrable;
        RelationalObjectProxy pr = (RelationalObjectProxy)this.getProxyObject();
        if (pr != null && pr instanceof ColumnProxyOracle) {
            ColumnProxyOracle cp = (ColumnProxyOracle)pr;
            cp.setNncDeferrable(nncDeferrable ? "YES" : MT_NO);
        }
    }

    public boolean isNncInitiallyImediate() {
        RelationalObjectProxy pr = (RelationalObjectProxy)this.getProxyObject();
        if (pr != null && pr instanceof ColumnProxyOracle) {
            ColumnProxyOracle cp = (ColumnProxyOracle)pr;
            return "IMMEDIATE".equalsIgnoreCase(cp.getNncInitially());
        }
        return this.nncInitiallyImediate;
    }

    public void setNncInitiallyImediate(boolean nncInitiallyImediate) {
        this.nncInitiallyImediate = nncInitiallyImediate;
        RelationalObjectProxy pr = (RelationalObjectProxy)this.getProxyObject();
        if (pr != null && pr instanceof ColumnProxyOracle) {
            ColumnProxyOracle cp = (ColumnProxyOracle)pr;
            cp.setNncInitially(nncInitiallyImediate ? "IMMEDIATE" : "DEFERRED");
        }
    }

    public boolean isNncEnable() {
        RelationalObjectProxy pr = (RelationalObjectProxy)this.getProxyObject();
        if (pr != null && pr instanceof ColumnProxyOracle) {
            ColumnProxyOracle cp = (ColumnProxyOracle)pr;
            return "YES".equalsIgnoreCase(cp.getNncEnable());
        }
        return this.nncEnable;
    }

    public void setNncEnable(boolean nncEnable) {
        this.nncEnable = nncEnable;
        RelationalObjectProxy pr = (RelationalObjectProxy)this.getProxyObject();
        if (pr != null && pr instanceof ColumnProxyOracle) {
            ColumnProxyOracle cp = (ColumnProxyOracle)pr;
            cp.setNncEnable(nncEnable ? "YES" : MT_NO);
        }
    }

    public boolean isNncValidate() {
        RelationalObjectProxy pr = (RelationalObjectProxy)this.getProxyObject();
        if (pr != null && pr instanceof ColumnProxyOracle) {
            ColumnProxyOracle cp = (ColumnProxyOracle)pr;
            return "YES".equalsIgnoreCase(cp.getNncValidate());
        }
        return this.nncValidate;
    }

    public void setNncValidate(boolean nncValidate) {
        this.nncValidate = nncValidate;
        RelationalObjectProxy pr = (RelationalObjectProxy)this.getProxyObject();
        if (pr != null && pr instanceof ColumnProxyOracle) {
            ColumnProxyOracle cp = (ColumnProxyOracle)pr;
            cp.setNncValidate(nncValidate ? "YES" : MT_NO);
        }
    }

    public boolean isCheckDeferrable() {
        RelationalObjectProxy pr = (RelationalObjectProxy)this.getProxyObject();
        if (pr != null && pr instanceof ColumnProxyOracle) {
            ColumnProxyOracle cp = (ColumnProxyOracle)pr;
            return "YES".equalsIgnoreCase(cp.getDeferrable());
        }
        return this.checkDeferrable;
    }

    public void setCheckDeferrable(boolean checkDeferrable) {
        this.checkDeferrable = checkDeferrable;
        RelationalObjectProxy pr = (RelationalObjectProxy)this.getProxyObject();
        if (pr != null && pr instanceof ColumnProxyOracle) {
            ColumnProxyOracle cp = (ColumnProxyOracle)pr;
            cp.setDeferrable(checkDeferrable ? "YES" : MT_NO);
        }
    }

    public boolean isCheckInitiallyImediate() {
        RelationalObjectProxy pr = (RelationalObjectProxy)this.getProxyObject();
        if (pr != null && pr instanceof ColumnProxyOracle) {
            ColumnProxyOracle cp = (ColumnProxyOracle)pr;
            return "IMMEDIATE".equalsIgnoreCase(cp.getInitially());
        }
        return this.checkInitiallyImediate;
    }

    public void setCheckInitiallyImediate(boolean checkInitiallyImediate) {
        this.checkInitiallyImediate = checkInitiallyImediate;
        RelationalObjectProxy pr = (RelationalObjectProxy)this.getProxyObject();
        if (pr != null && pr instanceof ColumnProxyOracle) {
            ColumnProxyOracle cp = (ColumnProxyOracle)pr;
            cp.setInitially(checkInitiallyImediate ? "IMMEDIATE" : "DEFERRED");
        }
    }

    public boolean isCheckEnable() {
        RelationalObjectProxy pr = (RelationalObjectProxy)this.getProxyObject();
        if (pr != null && pr instanceof ColumnProxyOracle) {
            ColumnProxyOracle cp = (ColumnProxyOracle)pr;
            return "YES".equalsIgnoreCase(cp.getEnable());
        }
        return this.checkEnable;
    }

    public void setCheckEnable(boolean checkEnable) {
        this.checkEnable = checkEnable;
        RelationalObjectProxy pr = (RelationalObjectProxy)this.getProxyObject();
        if (pr != null && pr instanceof ColumnProxyOracle) {
            ColumnProxyOracle cp = (ColumnProxyOracle)pr;
            cp.setEnable(checkEnable ? "YES" : MT_NO);
        }
    }

    public boolean isCheckValidate() {
        RelationalObjectProxy pr = (RelationalObjectProxy)this.getProxyObject();
        if (pr != null && pr instanceof ColumnProxyOracle) {
            ColumnProxyOracle cp = (ColumnProxyOracle)pr;
            return "YES".equalsIgnoreCase(cp.getValidate());
        }
        return this.checkValidate;
    }

    public void setCheckValidate(boolean checkValidate) {
        this.checkValidate = checkValidate;
        RelationalObjectProxy pr = (RelationalObjectProxy)this.getProxyObject();
        if (pr != null && pr instanceof ColumnProxyOracle) {
            ColumnProxyOracle cp = (ColumnProxyOracle)pr;
            cp.setValidate(checkValidate ? "YES" : MT_NO);
        }
    }

    @Override
    public void copy(DesignObject desObject) throws IOException {
        this.copy((Column)desObject, false, null, true);
    }

    public void copy(Column column, boolean remoteObject, Map copyMap, boolean copyNestedColumns) throws IOException {
        super.copy(column);
        if (column.isBackup() && !this.isBackup()) {
            column.setObjectID(this.getObjectID());
        }
        column.setOid(this.isOid());
        column.setStructAttributeID(this.getStructAttributeID());
        column.setNullsAllowed(this.getNullsAllowed());
        column.setReference(this.isReference());
        column.setUse(this.getUse());
        if (this.getUse() == 0) {
            Domain remoteDomain = this.getDomain();
            if (!remoteDomain.isDefault() && remoteObject) {
                Domain newDomain;
                String domainID = remoteDomain.getObjectID();
                if (remoteDomain.isRemoteObject()) {
                    domainID = remoteDomain.getRemoteObjectID();
                }
                if ((newDomain = (Domain)column.getDesign().getDomainSet().getByRemoteObjectId(domainID)) == null) {
                    newDomain = column.getDesign().getDomainSet().createDomain();
                    newDomain.setObjectID(new GUID().toString());
                    remoteDomain.copyTo(newDomain);
                    newDomain.setOwnerDesignName(column.getDesign().getName());
                    newDomain.setFileName(column.getDesign().getName());
                    if (remoteDomain.isRemoteObject()) {
                        newDomain.setRemoteObjectID(remoteDomain.getRemoteObjectID());
                    } else {
                        newDomain.setRemoteObjectID(remoteDomain.getObjectID());
                    }
                    newDomain.setRemoteDesignID(this.getDesign().getObjectID());
                    newDomain.setRemoteObjectRelativeStorageName(remoteDomain.getRelativeStorageName());
                }
                column.setDomain(newDomain);
            } else {
                Domain dom;
                if (remoteDomain != null && remoteObject && (dom = (Domain)column.getDesign().getDomainSet().getObjectByID(remoteDomain.getObjectID())) != null) {
                    remoteDomain = dom;
                }
                column.setDomain(remoteDomain);
            }
        } else if (this.getUse() == 1) {
            column.setLogicalDatatype(this.getLogicalDatatype());
            column.setDataTypeParameter("size", this.getSize());
            column.setDataTypeParameter("precision", this.getPrecision());
            column.setDataTypeParameter("scale", this.getScale());
        } else if (this.getUse() == 3) {
            column.setStructuredType(this.getStructuredType());
            List list = column.getPermittedSubTypes();
            list.clear();
            list.addAll(this.getPermittedSubTypes());
        } else if (this.getUse() == 4) {
            column.setCollectionType(this.getCollectionType());
        } else if (this.getUse() == 2) {
            column.setDistinctType(this.getDistinctType());
        }
        column.setNativeDataType(this.getNativeDataType());
        column.setPreviousColumn(this.isPreviousColumn());
        column.setUsesDefaultValue(this.getUsesDefaultValue());
        column.setUseDomainConstraints(this.getUseDomainConstraints());
        column.setGenerateConstraintInDDL(this.getGenerateConstraintInDDL());
        column.setConstraintName(this.getConstraintName());
        column.setNotNullConstraintName(this.getNotNullConstraintName());
        column.setDefaultValue(this.getDefaultValue());
        column.setDefaultOnNull(this.isDefaultOnNull());
        column.setSourceType(this.getSourceType());
        column.setComputed(this.isComputed());
        column.setFormulaDesc(this.getFormulaDesc());
        column.setScopeId(this.getScopeId());
        column.setAllowSubtypeSubstitution(this.isAllowSubtypeSubstitution());
        column.setRestrictedTypeSubstitution(this.isRestrictedTypeSubstitution());
        column.setAbbreviation(this.getAbbreviation());
        column.setConstraintNotes(this.getConstraintNotes());
        column.setConstraintComment(this.getConstraintComment());
        column.setConstraintCommentInRDBMS(this.getConstraintCommentInRDBMS());
        if (this.getDesignPart() == column.getDesignPart()) {
            column.setDependOnForeignKeyID(this.getDependOnForeignKeyID());
            column.setDependOnForeignKey(this.getDependOnForeignKey());
            column.setDependOnFK_AsMandatory(this.isDependOnFK_AsMandatory());
        }
        column.setSensitiveType(this.getSensitiveType());
        column.setSensitiveTypeDescription(this.getSensitiveTypeDescription());
        column.setDefaultLabel(this.getDefaultLabel());
        column.setDefaultFormatMask(this.getDefaultFormatMask());
        column.setDefaultFormDisplayWidth(this.getDefaultFormDisplayWidth());
        column.setDefaultFormMaximumWidth(this.getDefaultFormMaximumWidth());
        column.setDefaultFormHeight(this.getDefaultFormHeight());
        column.setDefaultHelpText(this.getDefaultHelpText());
        column.setDefaultReadOnly(this.isDefaultReadOnly());
        column.setDefaultDisplayedOnReports(this.isDefaultDisplayedOnReports());
        column.setDefaultDisplayedOnForms(this.isDefaultDisplayedOnForms());
        column.setDefaultDisplayAs(this.getDefaultDisplayAs());
        column.setContainsPII(this.isContainsPII());
        column.setContainsSensitiveInformation(this.isContainsSensitiveInformation());
        column.setMaskingType(this.getMaskingType());
        column.setMaskTemplate(this.getMaskTemplate());
        column.setDiscriminatorColumn(this.isDiscriminatorColumn());
        column.setAutoIncrementColumn(this.isAutoIncrementColumn());
        column.setIdentityColumn(this.isIdentityColumn());
        column.setAutoIncrementGenerateAlways(this.isAutoIncrementGenerateAlways());
        column.setAutoIncrementStartWith(this.getAutoIncrementStartWith());
        column.setAutoIncrementIncrementBy(this.getAutoIncrementIncrementBy());
        column.setAutoIncrementMinValue(this.getAutoIncrementMinValue());
        column.setAutoIncrementMaxValue(this.getAutoIncrementMaxValue());
        column.setAutoIncrementCycle(this.isAutoIncrementCycle());
        column.setAutoIncrementDisableCache(this.isAutoIncrementDisableCache());
        column.setAutoIncrementCache(this.getAutoIncrementCache());
        column.setAutoIncrementOrder(this.isAutoIncrementOrder());
        column.setAutoIncrementSequenceName(this.getAutoIncrementSequenceName());
        column.setAutoIncrementTriggerName(this.getAutoIncrementTriggerName());
        column.setAutoIncrementGenerateTrigger(this.isAutoIncrementGenerateTrigger());
        if (!this.getUseDomainConstraints()) {
            Column.copyCheckConstraint(this, column);
            Column.copyRangeConstraint(this, column);
            Column.copyLOVConstraint(this, column);
        }
        if (copyMap != null) {
            copyMap.put(this.getObjectID(), column);
        }
        if (copyNestedColumns) {
            block0: for (Column sourceNestedCol : this.getNestedObjects()) {
                ModelIDObject mappedStructTypeEl;
                String sourceStructAttID = sourceNestedCol.getStructAttributeID();
                if (sourceStructAttID.equals(MT_NOT_DEFINED)) continue;
                if (copyMap != null && (mappedStructTypeEl = (ModelIDObject)copyMap.get(sourceStructAttID)) != null) {
                    sourceStructAttID = mappedStructTypeEl.getObjectID();
                }
                for (Column targetNestedCol : column.getNestedObjects()) {
                    if (!sourceStructAttID.equals(targetNestedCol.getStructAttributeID())) continue;
                    sourceNestedCol.copy(targetNestedCol, remoteObject, copyMap, copyNestedColumns);
                    continue block0;
                }
            }
        }
        this.copyDepenDendentColumnDescriptors(column, true, copyMap);
        column.setNncDeferrable(this.isNncDeferrable());
        column.setNncEnable(this.isNncEnable());
        column.setNncInitiallyImediate(this.isNncInitiallyImediate());
        column.setNncValidate(this.isNncValidate());
        column.setCheckDeferrable(this.isCheckDeferrable());
        column.setCheckEnable(this.isCheckEnable());
        column.setCheckInitiallyImediate(this.isCheckInitiallyImediate());
        column.setCheckValidate(this.isCheckValidate());
    }

    public static void copyCheckConstraint(ContainedObject left_co, ContainedObject right_co) {
        if (PropertiesComparator.DDL_ONLY) {
            right_co.setUseDomainConstraints(false);
        }
        if (right_co.getUseDomainConstraints()) {
            return;
        }
        CheckConstraint left_c = left_co.getCheck();
        if (left_c == null) {
            right_co.setCheck(null);
            return;
        }
        CheckConstraint right_c = right_co.getCheck();
        if (right_c == null) {
            right_c = new CheckConstraint();
            right_c.setDesign(left_co.getDesign());
        }
        right_co.setCheck(right_c);
        if (right_c != left_c) {
            left_c.copyTo(right_c);
        }
    }

    public static void copyLOVConstraint(ContainedObjectWithDomain left_co, ContainedObjectWithDomain right_co) {
        if (PropertiesComparator.DDL_ONLY) {
            right_co.setUseDomainConstraints(false);
        }
        if (right_co.getUseDomainConstraints()) {
            return;
        }
        ConstraintEnumeration left_c = left_co.getOwnValueList();
        if (left_c == null) {
            right_co.setOwnValueList(null);
            return;
        }
        ConstraintEnumeration right_c = right_co.getOwnValueList();
        if (right_c == null) {
            right_c = new ConstraintEnumeration();
            right_c.setDesign(right_co.getDesign());
        }
        right_co.setValueList(right_c);
        if (right_c != left_c) {
            ((AbstractConstraint)left_c).copyTo(right_c);
        }
    }

    public static void copyRangeConstraint(ContainedObject left_co, ContainedObject right_co) {
        if (PropertiesComparator.DDL_ONLY) {
            right_co.setUseDomainConstraints(false);
        }
        if (right_co.getUseDomainConstraints()) {
            return;
        }
        Iterator it = left_co.getAVTs().iterator();
        right_co.clearAVTs();
        while (it.hasNext()) {
            AVT avt = (AVT)it.next();
            AVT newAVT = new AVT(avt.getBeginValue(), avt.getEndValue(), avt.getDescription());
            right_co.addAVT(newAVT);
        }
    }

    public boolean isDefaultOnNull() {
        return this.defaultOnNull;
    }

    public void setDefaultOnNull(boolean defaultOntNull) {
        this.defaultOnNull = defaultOntNull;
    }

    public String getIdentityGeneration() {
        if (this.isAutoIncrementGenerateAlways()) {
            return IDENTITY_GENERATION_ALWAYS;
        }
        return IDENTITY_GENERATION_BY_DEFAULT;
    }

    public boolean isMandatoryInDDL() {
        if (!this.isMandatory()) {
            return false;
        }
        return !this.isPKElement();
    }

    public boolean isJsonColumn() {
        return this.jsonColumn;
    }

    public void setJsonColumn(boolean jsonColumn) {
        this.jsonColumn = jsonColumn;
    }

    public String getJsonDataGuide() {
        return this.jsonDataGuide;
    }

    public void setJsonDataGuide(String jsonDataGuide) {
        this.jsonDataGuide = jsonDataGuide;
    }

    public static class DependentColumnDescriptor {
        Column owner;
        Column column;
        String columnID;
        String id;
        String discriminatorValue;
        boolean dependAsMandatory = false;
        boolean dependOnValue = false;

        private DependentColumnDescriptor(Column owner) {
            this.owner = owner;
        }

        public Column getColumn() {
            if ((this.column == null || this.column.isRemoved()) && this.columnID != null) {
                Table table = this.owner.getTable();
                this.column = table != null ? (Column)table.getElementByID(this.getColumnID()) : (Column)this.owner.getDesign().getDesignObject(this.columnID);
            }
            return this.column;
        }

        public void setColumn(Column column) {
            this.column = column;
        }

        public String getColumnID() {
            return this.columnID;
        }

        public void setColumnID(String columnID) {
            this.columnID = columnID;
        }

        public String getDiscriminatorValue() {
            return this.discriminatorValue;
        }

        public void setDiscriminatorValue(String discriminatorValue) {
            this.discriminatorValue = discriminatorValue;
        }

        public boolean isDependAsMandatory() {
            return this.dependAsMandatory;
        }

        public void setDependAsMandatory(boolean dependAsMandatory) {
            this.dependAsMandatory = dependAsMandatory;
        }

        public Column getOwner() {
            return this.owner;
        }

        public boolean isDependOnValue() {
            return this.dependOnValue;
        }

        public void setDependOnValue(boolean dependOnValue) {
            this.dependOnValue = dependOnValue;
        }

        public String getID() {
            if (this.id == null) {
                this.id = new GUID().toString();
            }
            return this.id;
        }

        public void setID(String id) {
            this.id = id;
        }

        public void copy(DependentColumnDescriptor desc) {
            desc.setColumnID(this.getColumnID());
            desc.setDiscriminatorValue(this.getDiscriminatorValue());
            desc.setDependOnValue(this.isDependOnValue());
            desc.setDependAsMandatory(this.isDependAsMandatory());
        }

        public void backupTo(DependentColumnDescriptor desc) {
            this.copy(desc);
            desc.setID(this.getID());
        }
    }
}

