/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl.oracle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.ddl.AbstractCSSBOracle;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LocalIndexProperties;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.HashPartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.IndexGlobalPartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.IndexGlobalPartitionsListOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.IndexProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ListPartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ListStorageTemplatePartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PartitionListOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PartitionSetOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.SegmentOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableSpaceOraclev9i;

public class CSSBIndex
extends AbstractCSSBOracle {
    private DesignObject sType;
    private StorageDesignOraclev9i storageDesign;
    private boolean isRenamed = false;
    private StringBuffer columnList = new StringBuffer();
    private String restoredExpression = null;
    private String tableName = "";

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof Index) {
            return true;
        }
        return object instanceof IndexProxyOracle;
    }

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        Design design;
        StringBuffer buffer = new StringBuffer();
        Index index = null;
        IndexProxyOraclev9i indexProxy = null;
        if (object instanceof CompareObjectSelection) {
            index = (Index)((CompareObjectSelection)object).getObject();
            design = index.getDesign();
            RDBMSSite site = index.getSelectedRDBMSSite();
            this.storageDesign = (StorageDesignOraclev9i)design.getStorageDesign(site);
            indexProxy = (IndexProxyOraclev9i)this.storageDesign.getIndexProxySet().getProxy(index.getObjectID());
        } else if (object instanceof Index) {
            index = (Index)object;
            design = index.getDesign();
            RDBMSSite site = index.getSelectedRDBMSSite();
            this.storageDesign = (StorageDesignOraclev9i)design.getStorageDesign(site);
            indexProxy = (IndexProxyOraclev9i)this.storageDesign.getIndexProxySet().getProxy(index.getObjectID());
        } else if (object instanceof IndexProxyOraclev9i) {
            indexProxy = (IndexProxyOraclev9i)object;
            index = (Index)indexProxy.getObject();
        }
        if (index != null && !index.isOidKey() && indexProxy != null && (index.shouldBeMerge() || this.isRenamed())) {
            if (indexProxy.isCommentChanged()) {
                this.appendComment(oldbuffer, indexProxy);
            } else {
                this.appendComment(oldbuffer, index);
            }
            this.storageDesign = (StorageDesignOraclev9i)indexProxy.getStorageDesign();
            CSSBIndex.appendStringWithSpace(buffer, "CREATE");
            if (indexProxy.isUnique()) {
                CSSBIndex.appendStringWithSpace(buffer, "UNIQUE");
            } else if (indexProxy.getBitmapIndex()) {
                CSSBIndex.appendStringWithSpace(buffer, "BITMAP");
            }
            CSSBIndex.appendStringWithSpace(buffer, "INDEX");
            CSSBIndex.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(indexProxy));
            String advancedComment = buffer.toString();
            this.appendTable(buffer, indexProxy);
            if (this.restoredExpression != null || this.isNotEmpty(this.getRestoredColumns().toString())) {
                this.appendElementListRestored(buffer, index, indexProxy, true);
            } else {
                this.appendElementList(buffer, index, indexProxy, true);
            }
            if (!index.isSpatialIndex() && indexProxy.getIndexType().equals("")) {
                this.appendGlobalOrLocal(buffer, indexProxy, prettyPrint);
                this.appendIndexAttributes(buffer, indexProxy, prettyPrint);
            }
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            CSSBIndex.appendNewLine(buffer, prettyPrint, 0);
            CSSBIndex.appendLineFinisher(buffer, prettyPrint);
            CSSBIndex.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            this.getStatus().incrementCreateIndex();
        }
        this.isRenamed = false;
        this.tableName = "";
    }

    private void appendTable(StringBuffer buffer, IndexProxyOraclev9i indexProxy) {
        CSSBIndex.appendStringWithSpace(buffer, "ON");
        if (this.isNotEmpty(this.getFormattedTableName())) {
            CSSBIndex.appendStringWithSpace(buffer, this.getFormattedTableName());
        } else {
            TableProxy tableProxy = indexProxy.getTableProxy();
            CSSBIndex.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(tableProxy));
        }
    }

    private void appendElementList(StringBuffer buffer, Index index, IndexProxyOraclev9i indexProxy, boolean prettyPrint) {
        if (index.hasIndexExpression()) {
            CSSBIndex.appendStringWithSpace(buffer, '(');
            CSSBIndex.appendString(buffer, index.getIndexExpression());
            CSSBIndex.appendStringWithSpace(buffer, ')');
        } else {
            ColumnProxy column = null;
            ColumnProxy[] columns = indexProxy.getColumnProxies();
            CSSBIndex.appendNewLine(buffer, prettyPrint, 1);
            if (columns.length < 1) {
                CSSBIndex.appendStringWithSpace(buffer, "-- No Columns");
                CSSBIndex.appendNewLine(buffer, prettyPrint, 1);
            }
            CSSBIndex.appendStringWithSpace(buffer, '(');
            for (int i = 0; i < columns.length; ++i) {
                if (i != 0) {
                    CSSBIndex.appendStringWithSpace(buffer, ',');
                }
                CSSBIndex.appendNewLine(buffer, prettyPrint, 1);
                column = columns[i];
                CSSBIndex.appendString(buffer, ' ');
                String columnName = this.storageDesign.getFormatedName(column);
                if (index.isSpatialIndex()) {
                    Datatype colType = column.getDataType();
                    if (this.sType == null) {
                        this.sType = column.getDesign().getDataTypesDesign().getStructuredTypeSet().getByName("SDO_GEOMETRY");
                    }
                    if (colType instanceof StructuredType) {
                        StructuredType st = (StructuredType)colType;
                        for (TypeElement te : st.getAllElements()) {
                            if (te.getType() != this.sType) continue;
                            columnName = columnName.concat(".").concat(this.storageDesign.getFormatedName(te));
                            break;
                        }
                    }
                }
                CSSBIndex.appendStringWithSpace(buffer, columnName);
                if (index.isSpatialIndex() || !indexProxy.getIndexType().equals("")) continue;
                CSSBIndex.appendStringWithSpace(buffer, index.getColumnSortOrder(column));
            }
            CSSBIndex.appendNewLine(buffer, prettyPrint, 1);
            CSSBIndex.appendStringWithSpace(buffer, ')');
        }
        if (indexProxy != null) {
            if (index.isSpatialIndex()) {
                this.appendSpatialIndex(buffer, index, indexProxy, prettyPrint);
            } else {
                this.appendDomainIndexProps(buffer, index, indexProxy, prettyPrint);
            }
        }
    }

    private void appendDomainIndexProps(StringBuffer buffer, Index index, IndexProxyOracle indexProxy, boolean prettyPrint) {
        String type;
        if (!index.isSpatialIndex() && !(type = indexProxy.getIndexType()).equals("")) {
            if (!type.equalsIgnoreCase("XMLINDEX") && !type.equalsIgnoreCase("XDB.XMLINDEX")) {
                type = this.storageDesign.getFormatedName(type);
            }
            CSSBIndex.appendNewLine(buffer, prettyPrint, 1);
            CSSBIndex.appendStringWithSpace(buffer, "INDEXTYPE");
            CSSBIndex.appendStringWithSpace(buffer, "IS");
            CSSBIndex.appendStringWithSpace(buffer, type);
            String params = indexProxy.getIndexDomainParameters();
            if (!params.equals("")) {
                CSSBIndex.appendNewLine(buffer, prettyPrint, 1);
                CSSBIndex.appendStringWithSpace(buffer, "PARAMETERS");
                CSSBIndex.appendString(buffer, '(');
                CSSBIndex.appendString(buffer, '\'');
                CSSBIndex.appendString(buffer, params);
                CSSBIndex.appendString(buffer, '\'');
                CSSBIndex.appendStringWithSpace(buffer, ')');
            }
        }
    }

    private void appendSpatialIndex(StringBuffer buffer, Index index, IndexProxyOraclev9i indexProxy, boolean prettyPrint) {
        if (index.isSpatialIndex()) {
            CSSBIndex.appendNewLine(buffer, prettyPrint, 1);
            CSSBIndex.appendStringWithSpace(buffer, "INDEXTYPE");
            CSSBIndex.appendStringWithSpace(buffer, "IS");
            CSSBIndex.appendStringWithSpace(buffer, "MDSYS.SPATIAL_INDEX");
            if (!index.getGeodetic().equals("YES") || indexProxy.getTableSpace() != null || index.getLayerType() != null && !index.getLayerType().equals("") || index.getDimensionsNumber() != 2) {
                CSSBIndex.appendNewLine(buffer, prettyPrint, 1);
                CSSBIndex.appendStringWithSpace(buffer, "PARAMETERS");
                CSSBIndex.appendString(buffer, '(');
                CSSBIndex.appendString(buffer, '\'');
                if (!index.getGeodetic().equals("YES")) {
                    CSSBIndex.appendString(buffer, "geodetic");
                    CSSBIndex.appendString(buffer, '=');
                    this.appendString(buffer, Boolean.FALSE);
                }
                if (index.getLayerType() != null && !index.getLayerType().equals("")) {
                    CSSBIndex.appendSpace(buffer);
                    CSSBIndex.appendString(buffer, "layer_gtype");
                    CSSBIndex.appendString(buffer, '=');
                    CSSBIndex.appendString(buffer, index.getLayerType());
                }
                if (index.getDimensionsNumber() != 2) {
                    CSSBIndex.appendSpace(buffer);
                    CSSBIndex.appendString(buffer, "sdo_indx_dims");
                    CSSBIndex.appendString(buffer, '=');
                    CSSBIndex.appendString(buffer, index.getDimensionsNumber());
                }
                if (indexProxy.getTableSpace() != null) {
                    CSSBIndex.appendSpace(buffer);
                    CSSBIndex.appendString(buffer, "tablespace=");
                    CSSBIndex.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(indexProxy.getTableSpace()));
                }
                CSSBIndex.appendString(buffer, '\'');
                CSSBIndex.appendStringWithSpace(buffer, ')');
            }
            this.appendSpatialIndexPartitions(buffer, indexProxy, prettyPrint);
        }
    }

    private void appendSpatialIndexPartitions(StringBuffer buffer, IndexProxyOraclev9i indexProxy, boolean prettyPrint) {
        if ("LOCAL".equalsIgnoreCase(indexProxy.getIndexPartitioned())) {
            CSSBIndex.appendNewLine(buffer, prettyPrint, 1);
            CSSBIndex.appendStringWithSpace(buffer, "LOCAL");
            TableProxyOraclev9i tableProxy = (TableProxyOraclev9i)indexProxy.getTableProxy();
            PartitionListOraclev9i partitionList = (PartitionListOraclev9i)tableProxy.getPartitionList();
            if (partitionList != null) {
                this.appendSpatialPartitions(buffer, indexProxy, partitionList, prettyPrint);
            }
        }
    }

    private void appendSpatialPartitions(StringBuffer buffer, IndexProxyOraclev9i indexProxy, PartitionListOraclev9i partitionList, boolean prettyPrint) {
        PartitionSetOraclev9i partitionSet = (PartitionSetOraclev9i)((StorageDesignOraclev9i)partitionList.getStorageDesign()).getPartitionSet();
        Object[] partitionsList = partitionSet.toArray();
        Arrays.sort(partitionsList, new PossitionComparator());
        ArrayList<Object> sortedList = new ArrayList<Object>();
        for (int i = 0; i < partitionsList.length; ++i) {
            sortedList.add(partitionsList[i]);
        }
        Iterator setIt = sortedList.iterator();
        boolean first = true;
        while (setIt.hasNext()) {
            String lipPName;
            PartitionOraclev9i partition = (PartitionOraclev9i)setIt.next();
            if (partition.getPartitionList() == null || !partition.getPartitionList().getObjectID().equalsIgnoreCase(partitionList.getObjectID())) continue;
            if (first) {
                CSSBIndex.appendNewLine(buffer, prettyPrint, 1);
                CSSBIndex.appendStringWithSpace(buffer, '(');
                first = false;
            } else {
                buffer.append(',');
            }
            CSSBIndex.appendNewLine(buffer, prettyPrint, 2);
            CSSBIndex.appendStringWithSpace(buffer, "PARTITION");
            String pName = partition.getName();
            String formattedPName = this.storageDesign.getFormatedName(partition);
            LocalIndexProperties lip = this.getPropsForIndex(indexProxy, partition);
            if (lip != null && !"".equals(lipPName = lip.getPartitionName()) && !pName.equals(lipPName)) {
                pName = lipPName;
                formattedPName = this.storageDesign.getFormatedName(lipPName);
            }
            if (!pName.toUpperCase().startsWith("SYS_")) {
                CSSBIndex.appendStringWithSpace(buffer, formattedPName);
            }
            CSSBIndex.appendNewLine(buffer, prettyPrint, 2);
            CSSBIndex.appendStringWithSpace(buffer, "PARAMETERS");
            CSSBIndex.appendString(buffer, '(');
            CSSBIndex.appendString(buffer, '\'');
            if (lip != null) {
                SegmentOraclev9i indexSegment;
                if (lip.getTableSpace() != null) {
                    CSSBIndex.appendString(buffer, "tablespace = ");
                    CSSBIndex.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(lip.getTableSpace()));
                }
                if ((indexSegment = (SegmentOraclev9i)lip.getSegment()) != null) {
                    CSSBIndex.appendSpace(buffer);
                    CSSBIndex.appendString(buffer, "sdo_rdr_pctfree=");
                    CSSBIndex.appendString(buffer, indexSegment.getPCTFree());
                    if (indexSegment.getSCInitialExtent() > 0L) {
                        CSSBIndex.appendSpace(buffer);
                        CSSBIndex.appendString(buffer, "initial=");
                        CSSBIndex.appendString(buffer, indexSegment.getSCInitialExtent());
                    }
                    if (indexSegment.getSCNextExtent() > 0L) {
                        CSSBIndex.appendSpace(buffer);
                        CSSBIndex.appendString(buffer, "next=");
                        CSSBIndex.appendString(buffer, indexSegment.getSCNextExtent());
                    }
                    CSSBIndex.appendSpace(buffer);
                    CSSBIndex.appendString(buffer, "pctincrease=");
                    CSSBIndex.appendStringWithSpace(buffer, indexSegment.getSCPctIncrease());
                    CSSBIndex.appendSpace(buffer);
                    CSSBIndex.appendString(buffer, "minextents=");
                    CSSBIndex.appendStringWithSpace(buffer, indexSegment.getSCMinExtents());
                    CSSBIndex.appendSpace(buffer);
                    CSSBIndex.appendString(buffer, "maxextents=");
                    CSSBIndex.appendString(buffer, indexSegment.getSCMaxExtents());
                }
                if (lip.getLayerType() != null && !lip.getLayerType().equals("")) {
                    CSSBIndex.appendSpace(buffer);
                    CSSBIndex.appendString(buffer, "layer_gtype=");
                    CSSBIndex.appendString(buffer, lip.getLayerType());
                }
            }
            CSSBIndex.appendString(buffer, '\'');
            CSSBIndex.appendString(buffer, ')');
        }
        if (!first) {
            CSSBIndex.appendNewLine(buffer, prettyPrint, 1);
            CSSBIndex.appendString(buffer, ')');
        }
    }

    private void appendElementListRestored(StringBuffer buffer, Index index, IndexProxyOraclev9i indexProxy, boolean prettyPrint) {
        if (this.restoredExpression != null && !this.restoredExpression.trim().equals("")) {
            CSSBIndex.appendStringWithSpace(buffer, '(');
            CSSBIndex.appendString(buffer, this.restoredExpression);
            CSSBIndex.appendStringWithSpace(buffer, ')');
        } else {
            CSSBIndex.appendNewLine(buffer, prettyPrint, 1);
            CSSBIndex.appendStringWithSpace(buffer, '(');
            CSSBIndex.appendNewLine(buffer, prettyPrint, 1);
            CSSBIndex.appendString(buffer, ' ');
            this.appendString(buffer, this.getRestoredColumns());
            CSSBIndex.appendNewLine(buffer, prettyPrint, 1);
            CSSBIndex.appendStringWithSpace(buffer, ')');
            if (indexProxy != null) {
                if (index.isSpatialIndex()) {
                    this.appendSpatialIndex(buffer, index, indexProxy, prettyPrint);
                } else {
                    this.appendDomainIndexProps(buffer, index, indexProxy, prettyPrint);
                }
            }
        }
        this.getRestoredColumns().setLength(0);
        this.restoredExpression = null;
    }

    private void appendGlobalOrLocal(StringBuffer buffer, IndexProxyOraclev9i indexProxy, boolean prettyPrint) {
        if ("GLOBAL".equalsIgnoreCase(indexProxy.getIndexPartitioned())) {
            IndexGlobalPartitionsListOraclev9i globalPartitionList = (IndexGlobalPartitionsListOraclev9i)indexProxy.getIndexGlobalPartitionsList();
            if (globalPartitionList != null) {
                CSSBIndex.appendNewLine(buffer, prettyPrint, 1);
                CSSBIndex.appendStringWithSpace(buffer, "GLOBAL");
                CSSBIndex.appendStringWithSpace(buffer, "PARTITION");
                CSSBIndex.appendStringWithSpace(buffer, "BY");
                CSSBIndex.appendStringWithSpace(buffer, "RANGE");
                CSSBIndex.appendStringWithSpace(buffer, '(');
                CSSBIndex.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(globalPartitionList.getGlobalPartColumns()));
                CSSBIndex.appendStringWithSpace(buffer, ')');
                this.appendGlobalPartitions(buffer, indexProxy, prettyPrint);
            }
        } else if ("LOCAL".equalsIgnoreCase(indexProxy.getIndexPartitioned())) {
            CSSBIndex.appendNewLine(buffer, prettyPrint, 1);
            CSSBIndex.appendStringWithSpace(buffer, "LOCAL");
            this.appendPartitionList(buffer, indexProxy, (TableProxyOraclev9i)indexProxy.getTableProxy(), prettyPrint);
        }
    }

    protected void appendGlobalPartitions(StringBuffer buffer, IndexProxyOracle indexProxy, boolean prettyPrint) {
        Iterator it = indexProxy.getGlobalPartitions().iterator();
        boolean first = true;
        while (it.hasNext()) {
            IndexGlobalPartitionOraclev9i globalPartition = (IndexGlobalPartitionOraclev9i)it.next();
            if (first) {
                CSSBIndex.appendNewLine(buffer, prettyPrint, 1);
                CSSBIndex.appendStringWithSpace(buffer, '(');
                first = false;
            } else {
                buffer.append(',');
            }
            CSSBIndex.appendNewLine(buffer, prettyPrint, 1);
            CSSBIndex.appendStringWithSpace(buffer, "PARTITION");
            if (!globalPartition.getName().toUpperCase().startsWith("SYS_")) {
                CSSBIndex.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(globalPartition));
            }
            CSSBIndex.appendNewLine(buffer, prettyPrint, 1);
            CSSBIndex.appendStringWithSpace(buffer, "VALUES LESS THAN");
            CSSBIndex.appendStringWithSpace(buffer, '(');
            CSSBIndex.appendStringWithSpace(buffer, globalPartition.getValueList());
            CSSBIndex.appendStringWithSpace(buffer, ')');
            if (globalPartition.getTableSpace() != null && this.storageDesign.getDesign().getSettings().isIncludeTablespaceInDDL()) {
                CSSBIndex.appendStringWithSpace(buffer, "TABLESPACE");
                CSSBIndex.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(globalPartition.getTableSpace()));
            }
            this.appendSegment(buffer, (SegmentOraclev9i)globalPartition.getSegment(), prettyPrint);
            if (!this.storageDesign.getDesign().getSettings().isIncludeLoggingInDDL()) continue;
            if ("YES".equalsIgnoreCase(globalPartition.getLogging())) {
                CSSBIndex.appendNewLine(buffer, prettyPrint, 2);
                CSSBIndex.appendStringWithSpace(buffer, "LOGGING");
                continue;
            }
            if (!"NO".equalsIgnoreCase(globalPartition.getLogging())) continue;
            CSSBIndex.appendNewLine(buffer, prettyPrint, 2);
            CSSBIndex.appendStringWithSpace(buffer, "NOLOGGING");
        }
        if (!first) {
            CSSBIndex.appendNewLine(buffer, prettyPrint, 1);
            CSSBIndex.appendStringWithSpace(buffer, ')');
        }
    }

    private void appendSegment(StringBuffer buffer, SegmentOraclev9i segment, boolean prettyPrint) {
        if (segment != null && this.storageDesign.getDesign().getSettings().isIncludeStorageInDDL()) {
            if (this.storageDesign.getDesign().getSettings().isIncludePctFreeInDDL()) {
                CSSBIndex.appendNewLine(buffer, prettyPrint, 2);
                CSSBIndex.appendStringWithSpace(buffer, "PCTFREE");
                CSSBIndex.appendStringWithSpace(buffer, segment.getPCTFree());
            }
            if (this.storageDesign.getDesign().getSettings().isIncludeInitransInDDL()) {
                if (segment.getInitrans() > 2) {
                    CSSBIndex.appendNewLine(buffer, prettyPrint, 2);
                    CSSBIndex.appendStringWithSpace(buffer, "INITRANS");
                    CSSBIndex.appendStringWithSpace(buffer, segment.getInitrans());
                } else if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
                    CSSBIndex.appendNewLine(buffer, prettyPrint, 2);
                    CSSBIndex.appendStringWithSpace(buffer, "INITRANS");
                    CSSBIndex.appendStringWithSpace(buffer, "2");
                }
                if (segment.getMaxTrans() > 2) {
                    CSSBIndex.appendNewLine(buffer, prettyPrint, 2);
                    CSSBIndex.appendStringWithSpace(buffer, "MAXTRANS");
                    CSSBIndex.appendStringWithSpace(buffer, segment.getMaxTrans());
                } else if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
                    CSSBIndex.appendNewLine(buffer, prettyPrint, 2);
                    CSSBIndex.appendStringWithSpace(buffer, "MAXTRANS");
                    CSSBIndex.appendStringWithSpace(buffer, "255");
                }
            }
            CSSBIndex.appendNewLine(buffer, prettyPrint, 2);
            CSSBIndex.appendStringWithSpace(buffer, "STORAGE");
            CSSBIndex.appendStringWithSpace(buffer, '(');
            CSSBIndex.appendNewLine(buffer, prettyPrint, 3);
            boolean props = false;
            if (segment.getSCInitialExtent() > 0L && this.storageDesign.getDesign().getSettings().isIncludeInitialExtentInDDL()) {
                CSSBIndex.appendStringWithSpace(buffer, "INITIAL");
                CSSBIndex.appendStringWithSpace(buffer, segment.getSCInitialExtent());
                CSSBIndex.appendNewLine(buffer, prettyPrint, 3);
                props = true;
            }
            if (segment.getSCNextExtent() > 0L && this.storageDesign.getDesign().getSettings().isIncludeNextExtentInDDL()) {
                CSSBIndex.appendStringWithSpace(buffer, "NEXT");
                CSSBIndex.appendStringWithSpace(buffer, segment.getSCNextExtent());
                CSSBIndex.appendNewLine(buffer, prettyPrint, 3);
                props = true;
            }
            if (this.storageDesign.getDesign().getSettings().isIncludePctIncreaseInDDL()) {
                CSSBIndex.appendStringWithSpace(buffer, "PCTINCREASE");
                CSSBIndex.appendStringWithSpace(buffer, segment.getSCPctIncrease());
                CSSBIndex.appendNewLine(buffer, prettyPrint, 3);
                props = true;
            }
            if (this.storageDesign.getDesign().getSettings().isIncludeMinExtentsInDDL()) {
                CSSBIndex.appendStringWithSpace(buffer, "MINEXTENTS");
                CSSBIndex.appendStringWithSpace(buffer, segment.getSCMinExtents());
                CSSBIndex.appendNewLine(buffer, prettyPrint, 3);
                props = true;
            }
            if (this.storageDesign.getDesign().getSettings().isIncludeMaxExtentsInDDL()) {
                CSSBIndex.appendStringWithSpace(buffer, "MAXEXTENTS");
                CSSBIndex.appendStringWithSpace(buffer, segment.getSCMaxExtents());
                CSSBIndex.appendNewLine(buffer, prettyPrint, 3);
                props = true;
            }
            if (this.storageDesign.getDesign().getSettings().isIncludeFreeListsInDDL()) {
                CSSBIndex.appendStringWithSpace(buffer, "FREELISTS");
                CSSBIndex.appendStringWithSpace(buffer, segment.getSCFreeLists());
                CSSBIndex.appendNewLine(buffer, prettyPrint, 3);
                props = true;
            }
            if (this.storageDesign.getDesign().getSettings().isIncludeFreeListGroupsInDDL()) {
                CSSBIndex.appendStringWithSpace(buffer, "FREELIST");
                CSSBIndex.appendStringWithSpace(buffer, "GROUPS");
                CSSBIndex.appendStringWithSpace(buffer, segment.getSCFreelistGroups());
                CSSBIndex.appendNewLine(buffer, prettyPrint, 3);
                props = true;
            }
            if (this.storageDesign.getDesign().getSettings().isIncludeBufferPoolInDDL()) {
                CSSBIndex.appendStringWithSpace(buffer, "BUFFER_POOL");
                CSSBIndex.appendStringWithSpace(buffer, segment.getSCBufferPool());
                props = true;
            }
            if (props) {
                CSSBIndex.appendStringWithSpace(buffer, ')');
            } else {
                buffer = buffer.replace(buffer.lastIndexOf("STORAGE ("), buffer.length(), "");
            }
        }
    }

    private void appendIndexAttributes(StringBuffer buffer, IndexProxyOraclev9i indexProxy, boolean prettyPrint) {
        TableProxyOracle tableProxy = (TableProxyOracle)indexProxy.getTableProxy();
        boolean temporaryTable = tableProxy.getTemporary().equalsIgnoreCase("YES");
        if (!temporaryTable) {
            if (indexProxy.getTableSpace() != null && this.storageDesign.getDesign().getSettings().isIncludeTablespaceInDDL()) {
                buffer.append(NEWLINE).append("    ");
                CSSBIndex.appendStringWithSpace(buffer, "TABLESPACE");
                CSSBIndex.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(indexProxy.getTableSpace()));
            }
            this.appendSegment(buffer, (SegmentOraclev9i)indexProxy.getSegment(), prettyPrint);
            if (this.storageDesign.getDesign().getSettings().isIncludeLoggingInDDL()) {
                if ("YES".equalsIgnoreCase(indexProxy.getLogging())) {
                    buffer.append(NEWLINE).append("    ");
                    CSSBIndex.appendStringWithSpace(buffer, "LOGGING");
                } else if ("NO".equalsIgnoreCase(indexProxy.getLogging())) {
                    buffer.append(NEWLINE).append("    ");
                    CSSBIndex.appendStringWithSpace(buffer, "NOLOGGING");
                }
            }
        }
        if ("YES".equalsIgnoreCase(indexProxy.getOnline())) {
            buffer.append(NEWLINE).append("    ");
            CSSBIndex.appendStringWithSpace(buffer, "ONLINE");
        }
        if ("YES".equalsIgnoreCase(indexProxy.getComputeStatistics())) {
            buffer.append(NEWLINE).append("    ");
            CSSBIndex.appendStringWithSpace(buffer, "COMPUTE STATISTICS");
        }
        if (indexProxy.getCompress() > 0) {
            buffer.append(NEWLINE).append("    ");
            CSSBIndex.appendStringWithSpace(buffer, "COMPRESS");
            CSSBIndex.appendStringWithSpace(buffer, indexProxy.getCompress());
        } else if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
            buffer.append(NEWLINE).append("    ");
            CSSBIndex.appendStringWithSpace(buffer, "NOCOMPRESS");
        }
        if (!indexProxy.getBitmapIndex()) {
            if ("NO".equalsIgnoreCase(indexProxy.getSortedRows())) {
                buffer.append(NEWLINE).append("    ");
                CSSBIndex.appendStringWithSpace(buffer, "NOSORT");
            } else if ("REVERSE".equalsIgnoreCase(indexProxy.getSortedRows())) {
                buffer.append(NEWLINE).append("    ");
                if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
                    CSSBIndex.appendStringWithSpace(buffer, "SORT");
                }
                CSSBIndex.appendStringWithSpace(buffer, "REVERSE");
            } else if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
                buffer.append(NEWLINE).append("    ");
                CSSBIndex.appendStringWithSpace(buffer, "SORT");
            }
        }
        if (!temporaryTable) {
            if ("YES".equalsIgnoreCase(indexProxy.getParallel())) {
                buffer.append(NEWLINE).append("    ");
                CSSBIndex.appendStringWithSpace(buffer, "PARALLEL");
                if (!"".equalsIgnoreCase(indexProxy.getDegree())) {
                    CSSBIndex.appendStringWithSpace(buffer, indexProxy.getDegree());
                }
            } else if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
                buffer.append(NEWLINE).append("    ");
                CSSBIndex.appendStringWithSpace(buffer, "NOPARALLEL");
            }
        }
    }

    private void appendPartitionList(StringBuffer buffer, IndexProxyOraclev9i indexProxy, TableProxyOraclev9i tableProxy, boolean prettyPrint) {
        PartitionListOraclev9i partitionList = (PartitionListOraclev9i)tableProxy.getPartitionList();
        if (partitionList != null) {
            String partitionType = partitionList.getPartitionType();
            if ("RANGE".equalsIgnoreCase(partitionType)) {
                this.appendPartitions(buffer, indexProxy, partitionList, false, prettyPrint);
            } else if ("COMPOSITE BY HASH".equalsIgnoreCase(partitionType)) {
                String subPartitionTableSpaceIDs = indexProxy.getHashSubPartitionsTableSpaces();
                if (!"".equals(subPartitionTableSpaceIDs)) {
                    CSSBIndex.appendStringWithSpace(buffer, "STORE IN");
                    CSSBIndex.appendStringWithSpace(buffer, '(');
                    CSSBIndex.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(subPartitionTableSpaceIDs));
                    CSSBIndex.appendStringWithSpace(buffer, ')');
                }
                this.appendPartitions(buffer, indexProxy, partitionList, true, prettyPrint);
            } else if ("COMPOSITE BY LIST".equalsIgnoreCase(partitionType)) {
                this.appendPartitions(buffer, indexProxy, partitionList, true, prettyPrint);
            } else if ("HASH BY QUANTITY".equalsIgnoreCase(partitionType) || "HASH BY LIST OF PARTITIONS".equalsIgnoreCase(partitionType)) {
                this.appendHashPartitions(buffer, partitionList, indexProxy, prettyPrint);
            } else if ("LIST".equalsIgnoreCase(partitionType)) {
                this.appendListPartitions(buffer, partitionList, indexProxy, prettyPrint);
            }
        }
    }

    private void appendListPartitions(StringBuffer buffer, PartitionListOraclev9i partitionList, IndexProxyOraclev9i indexProxy, boolean prettyPrint) {
        TableProxyOracle tableProxy = (TableProxyOracle)indexProxy.getTableProxy();
        StorageObjectCollection partitions = tableProxy.getPartitions();
        Iterator it = partitions.iterator();
        boolean first = true;
        while (it.hasNext()) {
            String lipPName;
            ListPartitionOraclev9i partition = (ListPartitionOraclev9i)it.next();
            if (first) {
                CSSBIndex.appendNewLine(buffer, prettyPrint, 1);
                CSSBIndex.appendStringWithSpace(buffer, '(');
                first = false;
            } else {
                CSSBIndex.appendStringWithSpace(buffer, ',');
            }
            CSSBIndex.appendNewLine(buffer, prettyPrint, 1);
            CSSBIndex.appendStringWithSpace(buffer, "PARTITION");
            String pName = partition.getName();
            String formattedPName = this.storageDesign.getFormatedName(partition);
            LocalIndexProperties lip = this.getPropsForIndex(indexProxy, partition);
            if (lip != null && !"".equals(lipPName = lip.getPartitionName()) && !pName.equals(lipPName)) {
                pName = lipPName;
                formattedPName = this.storageDesign.getFormatedName(lipPName);
            }
            if (!pName.toUpperCase().startsWith("SYS_")) {
                CSSBIndex.appendStringWithSpace(buffer, formattedPName);
            }
            if (lip == null) continue;
            TableSpaceOraclev9i ts = (TableSpaceOraclev9i)lip.getTableSpace();
            String logging = lip.getLogging();
            SegmentOraclev9i indexSegment = (SegmentOraclev9i)lip.getSegment();
            if (indexSegment != null) {
                this.appendSegment(buffer, indexSegment, prettyPrint);
            }
            if (this.storageDesign.getDesign().getSettings().isIncludeTablespaceInDDL()) {
                if (ts != null) {
                    CSSBIndex.appendNewLine(buffer, prettyPrint, 1);
                    CSSBIndex.appendStringWithSpace(buffer, "TABLESPACE");
                    CSSBIndex.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(ts));
                } else if (indexSegment != null && indexSegment.getTableSpace() != null) {
                    CSSBIndex.appendNewLine(buffer, prettyPrint, 1);
                    CSSBIndex.appendStringWithSpace(buffer, "TABLESPACE");
                    CSSBIndex.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(indexSegment.getTableSpace()));
                }
            }
            if (!this.storageDesign.getDesign().getSettings().isIncludeLoggingInDDL()) continue;
            if ("YES".equalsIgnoreCase(logging)) {
                CSSBIndex.appendNewLine(buffer, prettyPrint, 1);
                CSSBIndex.appendStringWithSpace(buffer, "LOGGING");
                continue;
            }
            if (!"NO".equalsIgnoreCase(logging)) continue;
            CSSBIndex.appendNewLine(buffer, prettyPrint, 1);
            CSSBIndex.appendStringWithSpace(buffer, "NOLOGGING");
        }
        if (!first) {
            buffer.append(NEWLINE).append("    ");
            CSSBIndex.appendStringWithSpace(buffer, ')');
        }
    }

    private void appendHashPartitions(StringBuffer buffer, PartitionListOraclev9i partitionList, IndexProxyOraclev9i indexProxy, boolean prettyPrint) {
        if (partitionList.getPartitionType().equalsIgnoreCase("HASH BY LIST OF PARTITIONS")) {
            TableProxyOracle tableProxy = (TableProxyOracle)indexProxy.getTableProxy();
            StorageObjectCollection partitions = tableProxy.getPartitions();
            Iterator it = partitions.iterator();
            boolean first = true;
            while (it.hasNext()) {
                TableSpaceOraclev9i ts;
                String lipPName;
                HashPartitionOraclev9i partition = (HashPartitionOraclev9i)it.next();
                if (first) {
                    CSSBIndex.appendNewLine(buffer, prettyPrint, 1);
                    CSSBIndex.appendStringWithSpace(buffer, '(');
                    first = false;
                } else {
                    CSSBIndex.appendStringWithSpace(buffer, ',');
                }
                CSSBIndex.appendNewLine(buffer, prettyPrint, 1);
                CSSBIndex.appendStringWithSpace(buffer, "PARTITION");
                String pName = partition.getName();
                String formattedPName = this.storageDesign.getFormatedName(partition);
                LocalIndexProperties lip = this.getPropsForIndex(indexProxy, partition);
                if (lip != null && !"".equals(lipPName = lip.getPartitionName()) && !pName.equals(lipPName)) {
                    pName = lipPName;
                    formattedPName = this.storageDesign.getFormatedName(lipPName);
                }
                if (!pName.toUpperCase().startsWith("SYS_")) {
                    CSSBIndex.appendStringWithSpace(buffer, formattedPName);
                }
                if (lip == null || (ts = (TableSpaceOraclev9i)lip.getTableSpace()) == null || !this.storageDesign.getDesign().getSettings().isIncludeTablespaceInDDL()) continue;
                CSSBIndex.appendNewLine(buffer, prettyPrint, 1);
                CSSBIndex.appendStringWithSpace(buffer, "TABLESPACE");
                CSSBIndex.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(ts));
            }
            if (!first) {
                buffer.append(NEWLINE).append("    ");
                CSSBIndex.appendStringWithSpace(buffer, ')');
            }
        } else {
            String subPartitionTableSpaceIDs = indexProxy.getHashSubPartitionsTableSpaces();
            if (!"".equals(subPartitionTableSpaceIDs)) {
                CSSBIndex.appendStringWithSpace(buffer, "STORE IN");
                CSSBIndex.appendStringWithSpace(buffer, '(');
                CSSBIndex.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(subPartitionTableSpaceIDs));
                CSSBIndex.appendStringWithSpace(buffer, ')');
            }
        }
    }

    private void appendPartitions(StringBuffer buffer, IndexProxyOraclev9i indexProxy, PartitionListOraclev9i partitionList, boolean composite, boolean prettyPrint) {
        TableProxyOracle tableProxy = (TableProxyOracle)indexProxy.getTableProxy();
        StorageObjectCollection partitions = tableProxy.getPartitions();
        Iterator it = partitions.iterator();
        boolean first = true;
        while (it.hasNext()) {
            String lipPName;
            PartitionOraclev9i partition = (PartitionOraclev9i)it.next();
            if (first) {
                CSSBIndex.appendNewLine(buffer, prettyPrint, 1);
                CSSBIndex.appendStringWithSpace(buffer, '(');
                first = false;
            } else {
                buffer.append(',');
            }
            CSSBIndex.appendNewLine(buffer, prettyPrint, 1);
            CSSBIndex.appendStringWithSpace(buffer, "PARTITION");
            String pName = partition.getName();
            String formattedPName = this.storageDesign.getFormatedName(partition);
            LocalIndexProperties lip = this.getPropsForIndex(indexProxy, partition);
            if (lip != null && !"".equals(lipPName = lip.getPartitionName()) && !pName.equals(lipPName)) {
                pName = lipPName;
                formattedPName = this.storageDesign.getFormatedName(lipPName);
            }
            if (!pName.toUpperCase().startsWith("SYS_")) {
                CSSBIndex.appendStringWithSpace(buffer, formattedPName);
            }
            if (lip != null) {
                TableSpaceOracle ts = lip.getTableSpace();
                String logging = lip.getLogging();
                SegmentOraclev9i indexSegment = (SegmentOraclev9i)lip.getSegment();
                if (indexSegment != null) {
                    this.appendSegment(buffer, indexSegment, prettyPrint);
                }
                if (this.storageDesign.getDesign().getSettings().isIncludeTablespaceInDDL()) {
                    if (ts != null) {
                        CSSBIndex.appendNewLine(buffer, prettyPrint, 1);
                        CSSBIndex.appendStringWithSpace(buffer, "TABLESPACE");
                        CSSBIndex.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(ts));
                    } else if (indexSegment != null && indexSegment.getTableSpace() != null) {
                        CSSBIndex.appendNewLine(buffer, prettyPrint, 1);
                        CSSBIndex.appendStringWithSpace(buffer, "TABLESPACE");
                        CSSBIndex.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(indexSegment.getTableSpace()));
                    }
                }
                if (this.storageDesign.getDesign().getSettings().isIncludeLoggingInDDL()) {
                    if ("YES".equalsIgnoreCase(logging)) {
                        CSSBIndex.appendNewLine(buffer, prettyPrint, 1);
                        CSSBIndex.appendStringWithSpace(buffer, "LOGGING");
                    } else if ("NO".equalsIgnoreCase(logging)) {
                        CSSBIndex.appendNewLine(buffer, prettyPrint, 1);
                        CSSBIndex.appendStringWithSpace(buffer, "NOLOGGING");
                    }
                }
            }
            if (!composite) continue;
            String tablespaceIDs = "";
            if (lip != null) {
                tablespaceIDs = lip.getHashSubPartitionsTableSpaces();
            }
            this.appendIndexSubPartitions(buffer, indexProxy, partitionList.getPartitionType(), partition, tablespaceIDs, prettyPrint);
        }
        if (!first) {
            buffer.append("    ").append(')');
        }
    }

    private LocalIndexProperties getPropsForIndex(IndexProxyOracle indexProxy, StorageObject partition) {
        return this.storageDesign.getLocalIndexPropertiesSet().getLocalIndexPropertiesFor(partition, indexProxy);
    }

    private void appendIndexSubPartitions(StringBuffer buffer, IndexProxyOraclev9i indexProxy, String partType, PartitionOraclev9i partition, String tablespaceIDs, boolean prettyPrint) {
        if (partType.equalsIgnoreCase("COMPOSITE BY HASH")) {
            if (!this.appendHashSubPartitions(buffer, indexProxy, partition, prettyPrint) && !"".equalsIgnoreCase(tablespaceIDs.trim())) {
                CSSBIndex.appendNewLine(buffer, prettyPrint, 1);
                CSSBIndex.appendStringWithSpace(buffer, "STORE IN");
                CSSBIndex.appendStringWithSpace(buffer, '(');
                CSSBIndex.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(tablespaceIDs));
                CSSBIndex.appendStringWithSpace(buffer, ')');
            }
        } else if (partType.equalsIgnoreCase("COMPOSITE BY LIST")) {
            this.appendListSubPartitions(buffer, indexProxy, partition, prettyPrint);
        }
    }

    private void appendListSubPartitions(StringBuffer buffer, IndexProxyOracle indexProxy, PartitionOraclev9i partition, boolean prettyPrint) {
        boolean first = true;
        for (ListStorageTemplatePartitionOraclev9i listPartition : partition.getListPartitions()) {
            TableSpaceOracle ts;
            String lipPName;
            if (first) {
                CSSBIndex.appendNewLine(buffer, prettyPrint, 1);
                CSSBIndex.appendStringWithSpace(buffer, '(');
                first = false;
            } else {
                CSSBIndex.appendStringWithSpace(buffer, ',');
            }
            CSSBIndex.appendNewLine(buffer, prettyPrint, 1);
            CSSBIndex.appendStringWithSpace(buffer, "SUBPARTITION");
            String lpName = listPartition.getName();
            String formattedPName = this.storageDesign.getFormatedName(listPartition);
            LocalIndexProperties lip = this.getPropsForIndex(indexProxy, listPartition);
            if (lip != null && !"".equals(lipPName = lip.getPartitionName()) && !lpName.equals(lipPName)) {
                lpName = lipPName;
                formattedPName = this.storageDesign.getFormatedName(lipPName);
            }
            if (!lpName.toUpperCase().startsWith("SYS_")) {
                CSSBIndex.appendStringWithSpace(buffer, formattedPName);
            }
            if (lip == null || (ts = lip.getTableSpace()) == null || !this.storageDesign.getDesign().getSettings().isIncludeTablespaceInDDL()) continue;
            CSSBIndex.appendStringWithSpace(buffer, "TABLESPACE");
            CSSBIndex.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(ts));
        }
        if (!first) {
            CSSBIndex.appendStringWithSpace(buffer, ')');
        }
    }

    private boolean appendHashSubPartitions(StringBuffer buffer, IndexProxyOraclev9i indexProxy, PartitionOraclev9i partition, boolean prettyPrint) {
        boolean result = false;
        Iterator it = partition.getPartitions().iterator();
        boolean first = true;
        while (it.hasNext()) {
            TableSpaceOraclev9i ts;
            String lipPName;
            HashPartitionOraclev9i hashPartition = (HashPartitionOraclev9i)it.next();
            if (first) {
                CSSBIndex.appendNewLine(buffer, prettyPrint, 1);
                CSSBIndex.appendStringWithSpace(buffer, '(');
                first = false;
                result = true;
            } else {
                CSSBIndex.appendStringWithSpace(buffer, ',');
            }
            CSSBIndex.appendNewLine(buffer, prettyPrint, 1);
            CSSBIndex.appendStringWithSpace(buffer, "SUBPARTITION");
            String hpName = hashPartition.getName();
            String formattedPName = this.storageDesign.getFormatedName(hashPartition);
            LocalIndexProperties lip = this.getPropsForIndex(indexProxy, hashPartition);
            if (lip != null && !"".equals(lipPName = lip.getPartitionName()) && !hpName.equals(lipPName)) {
                hpName = lipPName;
                formattedPName = this.storageDesign.getFormatedName(lipPName);
            }
            if (!hpName.toUpperCase().startsWith("SYS_")) {
                CSSBIndex.appendStringWithSpace(buffer, formattedPName);
            }
            if (lip == null || (ts = (TableSpaceOraclev9i)lip.getTableSpace()) == null || !this.storageDesign.getDesign().getSettings().isIncludeTablespaceInDDL()) continue;
            CSSBIndex.appendNewLine(buffer, prettyPrint, 1);
            CSSBIndex.appendStringWithSpace(buffer, "TABLESPACE");
            CSSBIndex.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(ts));
        }
        if (!first) {
            CSSBIndex.appendNewLine(buffer, prettyPrint, 1);
            buffer.append(')');
        }
        return result;
    }

    public void setRenamed(boolean renamed) {
        this.isRenamed = renamed;
    }

    public boolean isRenamed() {
        return this.isRenamed;
    }

    public void setRestoredExpression(String restoredExpression) {
        this.restoredExpression = restoredExpression;
    }

    public void setRestoredColumns(StringBuffer columnList) {
        this.columnList = columnList;
    }

    public StringBuffer getRestoredColumns() {
        return this.columnList;
    }

    private String getFormattedTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    static class PossitionComparator
    implements Comparator {
        PossitionComparator() {
        }

        public int compare(Object one, Object two) {
            if (one instanceof PartitionOraclev9i && two instanceof PartitionOraclev9i) {
                if (((PartitionOraclev9i)one).getPosition() > ((PartitionOraclev9i)two).getPosition()) {
                    return 1;
                }
                if (((PartitionOraclev9i)one).getPosition() < ((PartitionOraclev9i)two).getPosition()) {
                    return -1;
                }
            } else if (one instanceof ListPartitionOraclev9i && two instanceof ListPartitionOraclev9i) {
                if (((ListPartitionOraclev9i)one).getPosition() > ((ListPartitionOraclev9i)two).getPosition()) {
                    return 1;
                }
                if (((ListPartitionOraclev9i)one).getPosition() < ((ListPartitionOraclev9i)two).getPosition()) {
                    return -1;
                }
            } else {
                return 0;
            }
            return 0;
        }
    }
}

