/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.design.storage.oracle.SequenceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.StorageDesignOraclev12c;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import oracle.dbtools.util.Closeables;

public class MOHSequenceOracle
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "SEQUENCE";
    private static final Logger LOGGER = new Logger(MOHSequenceOracle.class);
    protected boolean dbaUser;

    public MOHSequenceOracle(AbstractDBMExtractionHandler dbmeHandler) {
        super(dbmeHandler);
        this.dbaUser = false;
    }

    public MOHSequenceOracle(AbstractDBMExtractionHandler dbmeHandler, boolean dbaUser) {
        super(dbmeHandler);
        this.dbaUser = dbaUser;
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List extract(Connection sqlConnection, List schemas) throws SQLException {
        TimeLog.log("Extract Sequence begin");
        statement = null;
        list = new ArrayList<DBObject>();
        try {
            for (DBObject dboNext : schemas) {
                if (!dboNext.isSelected()) continue;
                if (statement == null) {
                    filterCondition = this.getFilterConditionOracle("SEQUENCE_NAME");
                    buffer = new StringBuffer();
                    buffer.append("SELECT").append(' ');
                    buffer.append("SEQUENCE_NAME").append(' ');
                    buffer.append("FROM").append(' ');
                    buffer.append(this.dbaUser != false ? "dba_sequences" : "all_sequences").append(' ');
                    buffer.append("WHERE").append(' ');
                    buffer.append("SEQUENCE_OWNER").append('=').append(' ').append('?').append(' ');
                    if (filterCondition != null) {
                        buffer.append("AND").append(' ').append(filterCondition).append(' ');
                    }
                    buffer.append("ORDER BY").append(' ');
                    buffer.append("SEQUENCE_NAME");
                    sql = buffer.toString();
                    if (this.getDbmeHandler().getLimit() > 0) {
                        sql = this.getDbmeHandler().getPaginatedQuery(sql);
                    }
                    statement = sqlConnection.prepareStatement(sql);
                }
                rs = null;
                try {
                    statement.setString(1, dboNext.getName());
                    rs = statement.executeQuery();
                    if (rs != null) {
                        while (rs.next()) {
                            sequenceName = rs.getString(1);
                            dboSequence = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), sequenceName, "SEQUENCE", dboNext.getName());
                            list.add(dboSequence);
                        }
                        rs.close();
                    }
                    ** GOTO lbl54
                }
                catch (Exception e) {
                    try {
                        MOHSequenceOracle.LOGGER.error("MOHSequenceOracle.extract():", e);
                    }
                    catch (Throwable var10_11) {
                        Closeables.close(rs);
                        throw var10_11;
                    }
lbl54:
                    // 1 sources

                    Closeables.close((Object)rs);
                    continue;
                    Closeables.close((Object)rs);
                }
            }
        }
        finally {
            Closeables.close(statement);
        }
        TimeLog.log("Extract Sequence end");
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws SQLException {
        if (this.getStorageDesign() instanceof StorageDesignOracle) {
            StorageDesignOracle storageDesign = (StorageDesignOracle)this.getStorageDesign();
            PreparedStatement statement = null;
            try {
                for (int i = 0; i < selectedObjects.size(); ++i) {
                    DBObject dbo = (DBObject)selectedObjects.get(i);
                    if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
                    ResultSet rs = null;
                    try {
                        if (statement == null) {
                            StringBuffer buffer = new StringBuffer();
                            buffer.append("SELECT").append(' ');
                            buffer.append("MIN_VALUE").append(',');
                            buffer.append("MAX_VALUE").append(',');
                            buffer.append("INCREMENT_BY").append(',');
                            buffer.append("CYCLE_FLAG").append(',');
                            buffer.append("ORDER_FLAG").append(',');
                            buffer.append("CACHE_SIZE").append(',');
                            buffer.append("LAST_NUMBER");
                            if (storageDesign instanceof StorageDesignOraclev12c) {
                                buffer.append(',');
                                buffer.append("SESSION_FLAG");
                            }
                            buffer.append(' ');
                            buffer.append("FROM").append(' ');
                            buffer.append(this.dbaUser ? "dba_sequences" : "all_sequences").append(' ');
                            buffer.append("WHERE").append(' ');
                            buffer.append("SEQUENCE_OWNER").append('=').append('?').append(' ');
                            buffer.append("AND").append(' ');
                            buffer.append("SEQUENCE_NAME").append('=').append('?');
                            statement = sqlConnection.prepareStatement(buffer.toString());
                        }
                        statement.setString(1, dbo.getSchema());
                        statement.setString(2, dbo.getName());
                        rs = statement.executeQuery();
                        if (rs != null) {
                            if (rs.next()) {
                                SequenceOracle sequence = storageDesign.getSequenceSet().createSequence();
                                this.setUser(sequence, storageDesign, dbo.getSchema());
                                String seqName = dbo.getName();
                                sequence.setName(seqName);
                                if (!seqName.equals(seqName.toUpperCase())) {
                                    sequence.setNameHasQuotes(true);
                                }
                                this.setProperties(sequence, rs);
                                this.stampModelObject(sequence, dbo);
                            }
                            rs.close();
                        }
                        Closeables.close((Object)rs);
                    }
                    catch (Exception e) {
                        LOGGER.error("MOHSequenceOracle.generate():", e);
                    }
                    finally {
                        Closeables.close(rs);
                    }
                    importLog.incrementImportedStatements();
                    this.addToHandledObjects(dbo);
                }
            }
            finally {
                Closeables.close(statement);
            }
        }
    }

    private void setUser(SequenceOracle sequence, StorageDesignOracle storageDesign, String userName) {
        UserOracle user = (UserOracle)storageDesign.getUserSet().getByName(userName);
        sequence.setUser(user);
    }

    private void setProperties(SequenceOracle sequence, ResultSet resultSet) throws SQLException {
        try {
            String minValue = resultSet.getString("MIN_VALUE");
            String maxValue = resultSet.getString("MAX_VALUE");
            String incrementBy = resultSet.getString("INCREMENT_BY");
            String cycleFlag = resultSet.getString("CYCLE_FLAG");
            String orderFlag = resultSet.getString("ORDER_FLAG");
            String cacheSize = resultSet.getString("CACHE_SIZE");
            String lastNumber = resultSet.getString("LAST_NUMBER");
            String sessionFlag = "";
            if (this.getStorageDesign() instanceof StorageDesignOraclev12c) {
                sessionFlag = resultSet.getString("SESSION_FLAG");
            }
            sequence.setMinValue(minValue.trim());
            sequence.setMaxValue(maxValue.trim());
            sequence.setIncrementBy(incrementBy.trim());
            if ("Y".equalsIgnoreCase(cycleFlag.trim())) {
                sequence.setCycle("YES");
            } else {
                sequence.setCycle("NO");
            }
            if ("Y".equalsIgnoreCase(orderFlag.trim())) {
                sequence.setOrder("YES");
            } else {
                sequence.setOrder("NO");
            }
            int cacheSizeInt = 0;
            if (StringUtilities.isNotEmpty(cacheSize)) {
                cacheSizeInt = Integer.parseInt(cacheSize);
            }
            if (cacheSizeInt > 0) {
                sequence.setCache(cacheSize);
            } else {
                sequence.setNoCache("YES");
            }
            if ("Y".equalsIgnoreCase(sessionFlag.trim())) {
                sequence.setSession("YES");
            }
            sequence.setLastNumber(lastNumber);
            sequence.setStartWith(lastNumber);
        }
        catch (Exception e) {
            LOGGER.error("MOHSequenceOracle.setProperties()", e);
        }
    }
}

