/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata;

import jakarta.json.JsonObject;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.exports.ddl.DDLFileMaker;
import oracle.dbtools.crest.exports.ddl.SQLAnalyzer;
import oracle.dbtools.crest.exports.ddl.compare.CDDLFileMaker;
import oracle.dbtools.crest.exports.ddl.oracle.v10g.SSBIndexOraclev10g;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.oracle.DBMExtractionHandlerOracle;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.compare.CompareModelToModel;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.metadata.JSONObjToStreamTransformer;
import oracle.dbtools.crest.model.metadata.JSONToObjectTransformer;
import oracle.dbtools.crest.model.metadata.MDTransformationManager;
import oracle.dbtools.crest.model.metadata.MetaFileLoader;
import oracle.dbtools.crest.model.metadata.XMLTransformationManager;
import oracle.dbtools.crest.model.persistence.LogicalDataTypesReader;
import oracle.dbtools.crest.util.GUID;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.Settings;
import oracle.dbtools.crest.util.string.StringUtilities;
import oracle.dbtools.util.Closeables;
import oracle.jdbc.OracleConnection;

public class SDWObjectDDL {
    private static final Logger LOGGER = new Logger(SDWObjectDDL.class);
    static String PHYS_PROPS = "physicalProperties";

    public static boolean isSupportedType(String type) {
        return type != null && ("table".equalsIgnoreCase(type) || "view".equalsIgnoreCase(type) || "index".equalsIgnoreCase(type) || "synonym".equalsIgnoreCase(type) || "sequence".equalsIgnoreCase(type) || "mvlog".equalsIgnoreCase(type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, List<String>> getColumnsForAsterisk(Connection conn, List<SQLAnalyzer.PDescriptor> tables, List<SQLAnalyzer.PDescriptor> columns, String schema) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        HashMap<String, SQLAnalyzer.PDescriptor> mapd = new HashMap<String, SQLAnalyzer.PDescriptor>();
        HashMap mapLongName = new HashMap();
        for (SQLAnalyzer.PDescriptor pd : columns) {
            if (!"*".equals(pd.name)) continue;
            String prefix = pd.getColumnPrefix();
            if ((prefix == null || prefix.isEmpty()) && columns.size() == 1) {
                for (SQLAnalyzer.PDescriptor p : tables) {
                    map.put(p.getTableIdentifier(), new ArrayList());
                    mapd.put(p.getTableIdentifier(), p);
                }
                break;
            }
            SQLAnalyzer.PDescriptor p = SDWObjectDDL.getTableForPrefix(tables, prefix);
            if (p == null || map.containsKey(p.getTableIdentifier())) continue;
            map.put(p.getTableIdentifier(), new ArrayList());
            mapd.put(p.getTableIdentifier(), p);
        }
        if (mapd.size() > 0) {
            String usedSchema = schema;
            if (schema == null || schema.trim().isEmpty()) {
                try {
                    usedSchema = conn instanceof OracleConnection ? ((OracleConnection)conn).getCurrentSchema() : conn.getMetaData().getUserName();
                }
                catch (Exception pd) {
                    // empty catch block
                }
            }
            String rsql = "select column_name from all_tab_columns\r\nwhere owner = ? and table_name = ?\r\norder by column_id";
            String dbasql = "select column_name from dba_tab_columns\r\nwhere owner = ? and table_name = ?\r\norder by column_id";
            Statement statement = null;
            ResultSet rs = null;
            try {
                boolean failed = false;
                for (Map.Entry entry : mapd.entrySet()) {
                    SQLAnalyzer.PDescriptor p = (SQLAnalyzer.PDescriptor)entry.getValue();
                    String lname = p.getTableLongName(usedSchema);
                    List l = (List)mapLongName.get(lname);
                    if (l != null && l.size() > 0) {
                        ArrayList cols = new ArrayList(l);
                        map.put(p.getTableIdentifier(), cols);
                        continue;
                    }
                    String owner = usedSchema;
                    if (p.schema != null) {
                        owner = p.schema.toUpperCase();
                    }
                    String name = p.name.toUpperCase();
                    rs = null;
                    if (statement == null) {
                        statement = conn.prepareStatement(dbasql);
                        try {
                            statement.setString(1, owner);
                            statement.setString(2, name);
                            rs = statement.executeQuery();
                        }
                        catch (Exception e) {
                            failed = true;
                        }
                        if (failed) {
                            if (statement != null) {
                                statement.close();
                            }
                            statement = conn.prepareStatement(rsql);
                            try {
                                statement.setString(1, owner);
                                statement.setString(2, name);
                                rs = statement.executeQuery();
                            }
                            catch (Exception e) {}
                        }
                    } else {
                        try {
                            statement.setString(1, owner);
                            statement.setString(2, name);
                            rs = statement.executeQuery();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    ArrayList<String> list = new ArrayList<String>();
                    if (rs == null) continue;
                    while (rs.next()) {
                        String cname = rs.getString(1);
                        list.add(cname);
                    }
                    map.put(p.getTableIdentifier(), list);
                    mapLongName.put(lname, list);
                    rs.close();
                }
            }
            catch (Exception exception) {
            }
            finally {
                Closeables.close(rs);
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        return map;
    }

    private static List<SQLAnalyzer.PDescriptor> getColumns(List<SQLAnalyzer.PDescriptor> list) {
        ArrayList<SQLAnalyzer.PDescriptor> columns = new ArrayList<SQLAnalyzer.PDescriptor>();
        for (SQLAnalyzer.PDescriptor pd : list) {
            if (!"column".equals(pd.type)) continue;
            columns.add(pd);
        }
        return columns;
    }

    private static List<SQLAnalyzer.PDescriptor> getTables(List<SQLAnalyzer.PDescriptor> list) {
        ArrayList<SQLAnalyzer.PDescriptor> tables = new ArrayList<SQLAnalyzer.PDescriptor>();
        for (SQLAnalyzer.PDescriptor pd : list) {
            if (!"table".equals(pd.type)) continue;
            tables.add(pd);
        }
        return tables;
    }

    private static SQLAnalyzer.PDescriptor getTableForPrefix(List<SQLAnalyzer.PDescriptor> tables, String prefix) {
        if (prefix != null) {
            for (SQLAnalyzer.PDescriptor pd : tables) {
                if (!"table".equals(pd.type) || !prefix.equalsIgnoreCase(pd.getTableIdentifier())) continue;
                return pd;
            }
        }
        return null;
    }

    public static String parseColumns(Connection conn, String sql) {
        return SDWObjectDDL.parseColumns(conn, sql, null);
    }

    public static String parseColumns(Connection conn, String sql, String schema) {
        Object res = "{\"items\":[";
        MetaFileLoader.DMWEB = true;
        try {
            HashMap<String, String> usedNames = new HashMap<String, String>();
            List<SQLAnalyzer.PDescriptor> list = SQLAnalyzer.getFirstColumnNamesAndTables(sql);
            List<SQLAnalyzer.PDescriptor> tables = SDWObjectDDL.getTables(list);
            List<SQLAnalyzer.PDescriptor> columns = SDWObjectDDL.getColumns(list);
            Map<String, List<String>> map = SDWObjectDDL.getColumnsForAsterisk(conn, tables, columns, schema);
            boolean first = true;
            for (SQLAnalyzer.PDescriptor pd : columns) {
                if (!"column".equals(pd.type)) continue;
                if (!first) {
                    res = (String)res + ",";
                } else {
                    first = false;
                }
                if ("*".equals(pd.name)) {
                    String pref = pd.getColumnPrefix();
                    if (pref != null && !pref.isEmpty()) {
                        SQLAnalyzer.PDescriptor pt = SDWObjectDDL.getTableForPrefix(tables, pref);
                        if (pt == null) continue;
                        res = (String)res + SDWObjectDDL.getColumnNames(map, pref, pt, usedNames);
                        continue;
                    }
                    res = (String)res + SDWObjectDDL.getColumnNames(map, pref, tables, usedNames);
                    continue;
                }
                String name = pd.alias;
                if (name == null) {
                    name = pd.name;
                }
                res = (String)res + "\"" + StringUtilities.encodeAttributeValueJSON(name) + "\"";
            }
        }
        catch (Exception e) {
            LOGGER.error(" parseColumns() - parsing of query", e);
        }
        res = (String)res + "]}";
        return res;
    }

    private static String getValidName(Map<String, String> usedNames, String name) {
        if (!usedNames.containsKey(name)) {
            usedNames.put(name, name);
            return name;
        }
        Object temp = name;
        for (int i = 1; i < 1000; ++i) {
            temp = name + "_" + i;
            if (usedNames.containsKey(temp)) continue;
            usedNames.put((String)temp, (String)temp);
            return temp;
        }
        return name;
    }

    private static String getColumnNames(Map<String, List<String>> map, String prefix, SQLAnalyzer.PDescriptor table, Map<String, String> usedNames) {
        Object res = "";
        boolean first = true;
        List<String> list = map.get(table.getTableIdentifier());
        for (String name : list) {
            name = SDWObjectDDL.getValidName(usedNames, name);
            if (first) {
                res = "\"" + StringUtilities.encodeAttributeValueJSON(name) + "\"";
                first = false;
                continue;
            }
            res = (String)res + ",\"" + StringUtilities.encodeAttributeValueJSON(name) + "\"";
        }
        return res;
    }

    private static String getColumnNames(Map<String, List<String>> map, String prefix, List<SQLAnalyzer.PDescriptor> tables, Map<String, String> usedNames) {
        Object res = "";
        boolean first = true;
        for (SQLAnalyzer.PDescriptor t : tables) {
            if (first) {
                res = SDWObjectDDL.getColumnNames(map, prefix, t, usedNames);
                first = false;
                continue;
            }
            res = (String)res + "," + SDWObjectDDL.getColumnNames(map, prefix, t, usedNames);
        }
        return res;
    }

    private static Design getDesign() {
        Design des = new Design();
        LogicalDataTypesReader lr = new LogicalDataTypesReader();
        lr.recreateLogicalTypes(des);
        des.setLoading(true);
        des.setImporting(true);
        des.setPropagatePKChahges(false);
        Settings s = des.getSettings();
        s.setImportPartitions(false);
        s.setImportColumnDetails(true);
        s.setImportTriggers(false);
        s.setScanForUsedStructuredTypes(false);
        s.setImportSpatialProperties(false);
        s.setImportSecondaryTables(false);
        s.setImportCommentsInRDBMS(true);
        s.setGenerateCommentsInRDBMS(true);
        s.setIncludeStorageInDDL(true);
        s.setIncludeTablespaceInDDL(true);
        s.setIncludeSchemaInDDL(true);
        s.setIncludeLoggingInDDL(true);
        s.setUseColumnsOrderPropertyInCompare(false);
        s.setIncludeStoragePropertiesInCompare(false);
        s.setIncludePhysicalPropertiesInCompare(false);
        s.setUseDataTypeKindInCompare(false);
        s.setUseDBSyncSourceConnection(false);
        s.setGenerateFKNoneTransferableTriggers(false);
        s.setCaseSensitiveNamesInCompare(false);
        s.setDefaultOracleIdentityDDL("IDENTITY_CLAUSE");
        return des;
    }

    public static String getNewObjectDDL(Connection conn, String objectType, JsonObject jdoc) {
        String ddl = "object type " + objectType + " is not supported";
        Design des = SDWObjectDDL.getDesign();
        RelationalDesign rm = des.getRelationalDesign();
        DBMExtractionHandlerOracle handler = new DBMExtractionHandlerOracle(des);
        ((AbstractDBMExtractionHandler)handler).init(conn);
        rm.setSelectedRDBMSSite(((AbstractDBMExtractionHandler)handler).getRDBMSSite());
        if ("index".equalsIgnoreCase(objectType)) {
            return SDWObjectDDL.getNewIndexDDL(conn, rm, jdoc).trim();
        }
        ModelIDObject mobj = SDWObjectDDL.createObject(rm, objectType, null);
        if (mobj != null) {
            if (mobj instanceof DesignObject) {
                return SDWObjectDDL.getNewTableDDL(rm, (DesignObject)mobj, jdoc).trim();
            }
            if (mobj instanceof StorageObject) {
                return SDWObjectDDL.getNewSequenceDDL(rm, (StorageObject)mobj, jdoc).trim();
            }
        }
        return ddl;
    }

    private static String getNewIndexDDL(Connection conn, RelationalDesign rm, JsonObject jdoc) {
        SSBIndexOraclev10g ssbIndex = new SSBIndexOraclev10g();
        ssbIndex.setStorageDesign((StorageDesignOraclev10g)rm.getStorageDesign());
        String ddl = ssbIndex.getNewIndexDDL(jdoc);
        return ddl;
    }

    private static String getNewTableDDL(RelationalDesign rm, DesignObject table, JsonObject jdoc) {
        String ddl = "";
        table.setObjectID(new GUID().toString());
        table.setLoadedCompletely(true);
        String id = JSONToObjectTransformer.getSchemaNameID(table, jdoc);
        if (id != null) {
            table.setObjectID(id);
        }
        try {
            StorageDesignOracle sd = (StorageDesignOracle)rm.getStorageDesign();
            sd.openStorageDesign();
            MDTransformationManager trMan = XMLTransformationManager.getInstance().getMDTransformationManager();
            MDTransformationManager.TrObjects trs = trMan.getTransformersFor(table.getClass());
            if (trs != null && trs.getFromJsonToObjectTransformer() != null && trs.getFromJsonToObjectTransformer() instanceof JSONToObjectTransformer) {
                ArrayList<String> list = new ArrayList<String>(JSONObjToStreamTransformer.POPERTIES_TO_SKIP);
                if (!list.contains(PHYS_PROPS)) {
                    list.add(PHYS_PROPS);
                }
                ((JSONToObjectTransformer)trs.getFromJsonToObjectTransformer()).transformToObject((Object)table, jdoc, false, true, list);
            }
            sd.clearMarkGenerateForUsersAndRoles();
            sd.clearMarkGenerateForTablespaces();
            DDLFileMaker ddlFileMaker = new DDLFileMaker(rm.getDesign());
            ddlFileMaker.setStorageDesign(sd);
            ddlFileMaker.generateDDLContent();
            ddl = ddlFileMaker.getContent();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ddl;
    }

    private static String getNewSequenceDDL(RelationalDesign rm, StorageObject sequence, JsonObject jdoc) {
        String ddl = "";
        sequence.setObjectID(new GUID().toString());
        sequence.setLoadedCompletely(true);
        String id = JSONToObjectTransformer.getSchemaNameID(sequence, jdoc);
        if (id != null) {
            sequence.setObjectID(id);
        }
        try {
            StorageDesignOracle sd = (StorageDesignOracle)rm.getStorageDesign();
            sd.openStorageDesign();
            MDTransformationManager trMan = XMLTransformationManager.getInstance().getMDTransformationManager();
            MDTransformationManager.TrObjects trs = trMan.getTransformersFor(sequence.getClass());
            if (trs != null && trs.getFromJsonToObjectTransformer() != null && trs.getFromJsonToObjectTransformer() instanceof JSONToObjectTransformer) {
                ArrayList<String> list = new ArrayList<String>(JSONObjToStreamTransformer.POPERTIES_TO_SKIP);
                if (!list.contains(PHYS_PROPS)) {
                    list.add(PHYS_PROPS);
                }
                ((JSONToObjectTransformer)trs.getFromJsonToObjectTransformer()).transformToObject((Object)sequence, jdoc, false, true, list);
            }
            sd.clearMarkGenerateForUsersAndRoles();
            sd.clearMarkGenerateForTablespaces();
            DDLFileMaker ddlFileMaker = new DDLFileMaker(rm.getDesign());
            ddlFileMaker.setStorageDesign(sd);
            ddlFileMaker.generateDDLContent();
            ddl = ddlFileMaker.getContent();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ddl;
    }

    public static String getCompareObjectDDL(Connection conn, String objectType, JsonObject jdoc, String schemaName, String objectName) throws IOException {
        String ddl = "object type " + objectType + " is not supported";
        if ("index".equalsIgnoreCase(objectType)) {
            return SDWObjectDDL.getCompareIndexDDL(conn, jdoc, schemaName, objectName).trim();
        }
        return SDWObjectDDL.getCompareTabletDDL(conn, objectType, jdoc, schemaName, objectName).trim();
    }

    private static String getCompareIndexDDL(Connection conn, JsonObject jdoc, String schemaName, String objectName) throws IOException {
        String tname = JSONToObjectTransformer.getDecodedString(jdoc, "tableName");
        String tschema = JSONToObjectTransformer.getDecodedString(jdoc, "tableSchema");
        if (tschema != null) {
            if (tschema.startsWith("\"") && tschema.endsWith("\"")) {
                tschema = tschema.substring(1, tschema.length() - 1);
            } else if (tschema.startsWith("\\\"") && tschema.endsWith("\\\"")) {
                tschema = tschema.substring(2, tschema.length() - 2);
            }
        }
        if (tname != null) {
            if (tname.startsWith("\"") && tname.endsWith("\"")) {
                tname = tname.substring(1, tname.length() - 1);
            } else if (tname.startsWith("\\\"") && tname.endsWith("\\\"")) {
                tname = tname.substring(2, tname.length() - 2);
            }
        }
        Design des = SDWObjectDDL.getDesign();
        RelationalDesign rm = des.getRelationalDesign();
        des.setLoading(true);
        Design tdes = SDWObjectDDL.getDesign();
        DBMExtractionHandlerOracle handler = new DBMExtractionHandlerOracle(tdes);
        handler.init(conn);
        rm.setSelectedRDBMSSite(handler.getRDBMSSite());
        StorageDesignOracle sd = (StorageDesignOracle)rm.getStorageDesign();
        sd.setOpen(true);
        RelationalDesign trm = tdes.getRelationalDesign();
        trm.setSelectedRDBMSSite(handler.getRDBMSSite());
        StorageDesign tsd = trm.getStorageDesign();
        tsd.openStorageDesign();
        tsd.setOpen(true);
        ArrayList<DBObject> objects = new ArrayList<DBObject>();
        objects.add(new DBObject(true, tname, "TABLE", tschema));
        ImportLogger importLog = new ImportLogger();
        try {
            handler.generateDesign(conn, objects, importLog);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Table stable = rm.createTable();
        Table ttable = (Table)trm.getTableSet().getByName(tname);
        if (ttable != null) {
            MDTransformationManager trMan;
            MDTransformationManager.TrObjects trs;
            HashMap copyMap = new HashMap();
            ttable.copy(stable, copyMap, false, false);
            ttable.copyForeignKeys(stable, copyMap);
            Index index = stable.getIndexByNameAndSchema(schemaName, objectName);
            if (index != null && (trs = (trMan = XMLTransformationManager.getInstance().getMDTransformationManager()).getTransformersFor(index.getClass())) != null && trs.getFromJsonToObjectTransformer() != null && trs.getFromJsonToObjectTransformer() instanceof JSONToObjectTransformer) {
                ArrayList<String> list = new ArrayList<String>(JSONObjToStreamTransformer.POPERTIES_TO_SKIP);
                if (!list.contains(PHYS_PROPS)) {
                    list.add(PHYS_PROPS);
                }
                ((JSONToObjectTransformer)trs.getFromJsonToObjectTransformer()).transformToObject((Object)index, jdoc, false, true, list);
            }
        }
        CompareModelToModel cm = new CompareModelToModel(rm, trm, false, false, null, false, conn, handler.dbaUser);
        CDDLFileMaker fm = new CDDLFileMaker();
        fm.setMerger(cm);
        fm.setDesign(tdes);
        fm.setStorageDesign(tsd);
        fm.generateDDLContent();
        String ddl = fm.getContent();
        return ddl;
    }

    public static String getCompareTabletDDL(Connection conn, String objectType, JsonObject jdoc, String schemaName, String objectName) {
        Object ddl = "object type " + objectType + " is not supported";
        if (SDWObjectDDL.isSupportedType(objectType)) {
            Design des = SDWObjectDDL.getDesign();
            RelationalDesign rm = des.getRelationalDesign();
            rm.setSDWCompare(true);
            des.setLoading(true);
            Design tdes = SDWObjectDDL.getDesign();
            DBMExtractionHandlerOracle handler = new DBMExtractionHandlerOracle(tdes);
            handler.init(conn);
            rm.setSelectedRDBMSSite(handler.getRDBMSSite());
            StorageDesignOracle sd = (StorageDesignOracle)rm.getStorageDesign();
            sd.setOpen(true);
            ModelIDObject table = SDWObjectDDL.createObject(rm, objectType, null);
            if (table != null) {
                table.setLoadedCompletely(true);
                table.setObjectID(new GUID().toString());
                try {
                    MDTransformationManager trMan = XMLTransformationManager.getInstance().getMDTransformationManager();
                    MDTransformationManager.TrObjects trs = trMan.getTransformersFor(table.getClass());
                    if (trs != null && trs.getFromJsonToObjectTransformer() != null && trs.getFromJsonToObjectTransformer() instanceof JSONToObjectTransformer) {
                        ArrayList<String> list = new ArrayList<String>(JSONObjToStreamTransformer.POPERTIES_TO_SKIP);
                        if (!list.contains(PHYS_PROPS)) {
                            list.add(PHYS_PROPS);
                        }
                        ((JSONToObjectTransformer)trs.getFromJsonToObjectTransformer()).transformToObject((Object)table, jdoc, false, true, list);
                    }
                    rm.resolveFKs();
                    sd.clearMarkGenerateForUsersAndRoles();
                    sd.clearMarkGenerateForTablespaces();
                    RelationalDesign trm = tdes.getRelationalDesign();
                    trm.setSelectedRDBMSSite(handler.getRDBMSSite());
                    StorageDesign tsd = trm.getStorageDesign();
                    tsd.openStorageDesign();
                    ArrayList<DBObject> objects = new ArrayList<DBObject>();
                    String type = objectType.toUpperCase();
                    try {
                        String org = JSONToObjectTransformer.getDecodedString(jdoc, "organization");
                        if (org != null && "EXTERNAL".equalsIgnoreCase(org)) {
                            type = "EXTERNAL TABLE";
                        }
                    }
                    catch (Exception org) {
                        // empty catch block
                    }
                    if ("MVLOG".equalsIgnoreCase(type)) {
                        type = "MATERIALIZED_VIEW_LOG";
                    }
                    objects.add(new DBObject(true, objectName, type, schemaName));
                    ImportLogger importLog = new ImportLogger();
                    try {
                        handler.generateDesign(conn, objects, importLog);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    CompareModelToModel cm = new CompareModelToModel(rm, trm, false, false, null, false, conn, handler.dbaUser);
                    CDDLFileMaker fm = new CDDLFileMaker();
                    fm.setMerger(cm);
                    fm.setDesign(tdes);
                    fm.setStorageDesign(tsd);
                    fm.generateDDLContent();
                    ddl = fm.getContent();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return ddl;
    }

    public static ModelIDObject createObject(RelationalDesign rm, String objectType, String className) {
        if ("table".equalsIgnoreCase(objectType)) {
            return rm.createTable();
        }
        if ("view".equalsIgnoreCase(objectType)) {
            TableView tv = rm.createTableView();
            tv.setCreateOnly(true);
            return tv;
        }
        if ("sequence".equalsIgnoreCase(objectType)) {
            return ((StorageDesignOracle)rm.getStorageDesign()).createSequenceOracle();
        }
        if ("mvlog".equalsIgnoreCase(objectType)) {
            return ((StorageDesignOracle)rm.getStorageDesign()).createMaterializedViewLogOracle();
        }
        if ("synonym".equalsIgnoreCase(objectType)) {
            return ((StorageDesignOracle)rm.getStorageDesign()).createSynonymOracle();
        }
        return null;
    }

    static boolean getBoolean(String value, boolean def) {
        if (value == null || value.isEmpty()) {
            return def;
        }
        boolean bval = def;
        try {
            bval = "true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value) || "y".equalsIgnoreCase(value) || "on".equalsIgnoreCase(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bval;
    }
}

