/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v12c;

import java.util.List;
import java.util.Locale;
import oracle.dbtools.crest.exports.ddl.oracle.SSBAutoIncrementColumnOracle;
import oracle.dbtools.crest.exports.ddl.oracle.v11g.SSBTableOraclev11g;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.ValidTimeDimension;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.TableProxyOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.ColumnProxyOraclev12c;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.TableProxyOraclev12c;
import oracle.dbtools.crest.model.design.storage.oracle.v20c.TableProxyOraclev20c;

public class SSBTableOraclev12c
extends SSBTableOraclev11g {
    private SSBAutoIncrementColumnOracle ssbAutoIncCol = null;
    private boolean hasIdentityOptions;

    @Override
    protected void appendInvisible(StringBuffer buffer, ColumnProxyOracle columnProxy) {
        if (((ColumnProxyOraclev12c)columnProxy).getInvisible().equalsIgnoreCase("YES")) {
            SSBTableOraclev12c.appendStringWithSpace(buffer, "INVISIBLE");
        }
    }

    @Override
    protected void appendCompressClause(StringBuffer buffer, TableProxyOracle tableProxy) {
        String compressionType = ((TableProxyOraclev11g)tableProxy).getCompressionType();
        if (compressionType.length() == 0) {
            SSBTableOraclev12c.appendStringWithSpace(buffer, "COMPRESS");
        } else {
            if (compressionType.equals("BASIC") || compressionType.equals("ADVANCED")) {
                SSBTableOraclev12c.appendStringWithSpace(buffer, "ROW");
                SSBTableOraclev12c.appendStringWithSpace(buffer, "STORE");
                SSBTableOraclev12c.appendStringWithSpace(buffer, "COMPRESS");
            } else {
                SSBTableOraclev12c.appendStringWithSpace(buffer, "COLUMN");
                SSBTableOraclev12c.appendStringWithSpace(buffer, "STORE");
                SSBTableOraclev12c.appendStringWithSpace(buffer, "COMPRESS");
                SSBTableOraclev12c.appendStringWithSpace(buffer, "FOR");
            }
            SSBTableOraclev12c.appendStringWithSpace(buffer, compressionType);
        }
    }

    @Override
    protected void appendInMemoryClause(StringBuffer buffer, TableProxyOracle tableProxy, boolean prettyPrint) {
        TableProxyOraclev12c tableProxy12c = (TableProxyOraclev12c)tableProxy;
        String inMemory = tableProxy12c.getInMemory();
        if (inMemory.equals("YES")) {
            String inMemoryDuplicate;
            String inMemoryDistribute;
            String inMemoryPriority;
            SSBTableOraclev12c.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev12c.appendStringWithSpace(buffer, "INMEMORY");
            String inMemoryCompression = tableProxy12c.getInMemoryCompression();
            if (!inMemoryCompression.isEmpty()) {
                if (!inMemoryCompression.equals("NO MEMCOMPRESS")) {
                    SSBTableOraclev12c.appendStringWithSpace(buffer, "MEMCOMPRESS");
                }
                SSBTableOraclev12c.appendStringWithSpace(buffer, inMemoryCompression);
            }
            if (!(inMemoryPriority = tableProxy12c.getInMemoryPriority()).isEmpty()) {
                SSBTableOraclev12c.appendStringWithSpace(buffer, "PRIORITY");
                SSBTableOraclev12c.appendStringWithSpace(buffer, inMemoryPriority);
            }
            if (!(inMemoryDistribute = tableProxy12c.getInMemoryDistribute()).isEmpty()) {
                SSBTableOraclev12c.appendStringWithSpace(buffer, "DISTRIBUTE");
                SSBTableOraclev12c.appendStringWithSpace(buffer, inMemoryDistribute);
            }
            if (!(inMemoryDuplicate = tableProxy12c.getInMemoryDuplicate()).isEmpty()) {
                SSBTableOraclev12c.appendStringWithSpace(buffer, inMemoryDuplicate);
            }
        } else if (inMemory.equals("NO")) {
            SSBTableOraclev12c.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev12c.appendStringWithSpace(buffer, "NO");
            SSBTableOraclev12c.appendStringWithSpace(buffer, "INMEMORY");
        }
    }

    @Override
    protected void appendAutoIncrementSequences(StringBuffer buffer, Table table, boolean prettyPrint) {
        for (Column column : table.getElementsCollection()) {
            if (!column.isAutoIncrementColumn()) continue;
            if (this.ssbAutoIncCol == null) {
                this.ssbAutoIncCol = new SSBAutoIncrementColumnOracle(this.storageDesign);
            }
            this.ssbAutoIncCol.appendAutoIncrementSequenceAndTrigger(buffer, column, prettyPrint, false);
        }
    }

    @Override
    protected void appendWithDefaultDefinition(StringBuffer buffer, ColumnProxyOracle columnProxy) {
        String dt;
        Column column = columnProxy.getColumn();
        if (column.isIdentityColumn() && !column.getTable().isBST() && columnProxy.getDDLTypeForAutoIncCol().equalsIgnoreCase("IDENTITY_CLAUSE") && (dt = column.getDatatypeString(this.storageDesign.getRDBMSType().getName())).toUpperCase(Locale.ROOT).indexOf("CHAR") == -1) {
            SSBTableOraclev12c.appendStringWithSpace(buffer, "GENERATED");
            if (column.isAutoIncrementGenerateAlways()) {
                SSBTableOraclev12c.appendStringWithSpace(buffer, "ALWAYS");
            } else {
                SSBTableOraclev12c.appendStringWithSpace(buffer, "BY");
                SSBTableOraclev12c.appendStringWithSpace(buffer, "DEFAULT");
                if (((ColumnProxyOraclev12c)columnProxy).getDefaultOnNull().equalsIgnoreCase("YES")) {
                    SSBTableOraclev12c.appendStringWithSpace(buffer, "ON");
                    SSBTableOraclev12c.appendStringWithSpace(buffer, "NULL");
                }
            }
            SSBTableOraclev12c.appendStringWithSpace(buffer, "AS");
            SSBTableOraclev12c.appendStringWithSpace(buffer, "IDENTITY");
            this.appendIdentityOptions(buffer, column);
            return;
        }
        Object defaultValue = columnProxy.getDefaultValue();
        if (column.isAutoIncrementColumn() && columnProxy.getDDLTypeForAutoIncCol().equalsIgnoreCase("DEFAULT_CLAUSE")) {
            if (this.ssbAutoIncCol == null) {
                this.ssbAutoIncCol = new SSBAutoIncrementColumnOracle(this.storageDesign);
            }
            defaultValue = this.ssbAutoIncCol.generateSequenceName(null, column, false) + ".NEXTVAL";
        }
        if (defaultValue != null && !"".equalsIgnoreCase((String)defaultValue)) {
            SSBTableOraclev12c.appendStringWithSpace(buffer, "DEFAULT");
            if (((ColumnProxyOraclev12c)columnProxy).getDefaultOnNull().equalsIgnoreCase("YES")) {
                SSBTableOraclev12c.appendStringWithSpace(buffer, "ON");
                SSBTableOraclev12c.appendStringWithSpace(buffer, "NULL");
            }
            String dt2 = column.getDatatypeString(this.storageDesign.getRDBMSType().getName());
            String df = this.addQuotesToDefault(dt2, (String)defaultValue);
            SSBTableOraclev12c.appendStringWithSpace(buffer, df);
        }
    }

    private void appendIdentityOptions(StringBuffer buffer, Column column) {
        Integer incrementBy;
        this.hasIdentityOptions = false;
        boolean includeDefaultSettings = this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL();
        if (!"".equals(column.getAutoIncrementStartWith())) {
            this.startIdentityOption(buffer);
            SSBTableOraclev12c.appendStringWithSpace(buffer, "START");
            SSBTableOraclev12c.appendStringWithSpace(buffer, "WITH");
            SSBTableOraclev12c.appendStringWithSpace(buffer, column.getAutoIncrementStartWith());
        }
        if ((incrementBy = column.getAutoIncrementIncrementBy()) > 1 || incrementBy < 0) {
            this.startIdentityOption(buffer);
            SSBTableOraclev12c.appendStringWithSpace(buffer, "INCREMENT");
            SSBTableOraclev12c.appendStringWithSpace(buffer, "BY");
            this.appendStringWithSpace(buffer, incrementBy);
        } else if (includeDefaultSettings) {
            this.startIdentityOption(buffer);
            SSBTableOraclev12c.appendStringWithSpace(buffer, "INCREMENT");
            SSBTableOraclev12c.appendStringWithSpace(buffer, "BY");
            SSBTableOraclev12c.appendStringWithSpace(buffer, "1");
        }
        String minValue = column.getAutoIncrementMinValue();
        if (minValue != null && !minValue.equals("")) {
            this.startIdentityOption(buffer);
            SSBTableOraclev12c.appendStringWithSpace(buffer, "MINVALUE");
            SSBTableOraclev12c.appendStringWithSpace(buffer, minValue);
        } else if (includeDefaultSettings) {
            this.startIdentityOption(buffer);
            SSBTableOraclev12c.appendStringWithSpace(buffer, "NOMINVALUE");
        }
        String maxValue = column.getAutoIncrementMaxValue();
        if (maxValue != null && !maxValue.equals("")) {
            this.startIdentityOption(buffer);
            SSBTableOraclev12c.appendStringWithSpace(buffer, "MAXVALUE");
            SSBTableOraclev12c.appendStringWithSpace(buffer, maxValue);
        } else if (includeDefaultSettings) {
            this.startIdentityOption(buffer);
            SSBTableOraclev12c.appendStringWithSpace(buffer, "NOMAXVALUE");
        }
        if (column.isAutoIncrementCycle()) {
            this.startIdentityOption(buffer);
            SSBTableOraclev12c.appendStringWithSpace(buffer, "CYCLE");
        } else if (includeDefaultSettings) {
            this.startIdentityOption(buffer);
            SSBTableOraclev12c.appendStringWithSpace(buffer, "NOCYCLE");
        }
        Integer cacheInteger = column.getAutoIncrementCache();
        if (column.isAutoIncrementDisableCache()) {
            this.startIdentityOption(buffer);
            SSBTableOraclev12c.appendStringWithSpace(buffer, "NOCACHE");
        } else if (cacheInteger != null && cacheInteger > 0) {
            this.startIdentityOption(buffer);
            SSBTableOraclev12c.appendStringWithSpace(buffer, "CACHE");
            this.appendStringWithSpace(buffer, cacheInteger);
        } else if (includeDefaultSettings) {
            this.startIdentityOption(buffer);
            SSBTableOraclev12c.appendStringWithSpace(buffer, "CACHE");
            SSBTableOraclev12c.appendStringWithSpace(buffer, "20");
        }
        if (column.isAutoIncrementOrder()) {
            this.startIdentityOption(buffer);
            SSBTableOraclev12c.appendStringWithSpace(buffer, "ORDER");
        } else if (includeDefaultSettings) {
            this.startIdentityOption(buffer);
            SSBTableOraclev12c.appendStringWithSpace(buffer, "NOORDER");
        }
        if (this.hasIdentityOptions) {
            SSBTableOraclev12c.appendStringWithSpace(buffer, ')');
        }
    }

    private void startIdentityOption(StringBuffer buffer) {
        if (!this.hasIdentityOptions) {
            buffer.append(NEWLINE).append("    ").append("    ");
            SSBTableOraclev12c.appendStringWithSpace(buffer, '(');
            this.hasIdentityOptions = true;
        }
    }

    @Override
    protected boolean appendFirstValidTime(StringBuffer buffer, Table table, TableProxyOracle tableProxy, boolean prettyPrint, boolean first) {
        List<ValidTimeDimension> validTimeDimensions = table.getValidTimeDimensions();
        if (validTimeDimensions.size() > 0) {
            ValidTimeDimension validTimeDimension = validTimeDimensions.get(0);
            if (first) {
                first = false;
                SSBTableOraclev12c.appendStringWithSpace(buffer, '(');
            } else {
                SSBTableOraclev12c.appendStringWithSpace(buffer, ',');
            }
            SSBTableOraclev12c.appendNewLine(buffer, prettyPrint, 1);
            this.appendPeriodDefinition(buffer, validTimeDimension, tableProxy);
        }
        return first;
    }

    @Override
    protected void appendAdditionalValidTimes(StringBuffer oldbuffer, Table table, TableProxyOracle tableProxy, boolean prettyPrint) {
        List<ValidTimeDimension> validTimeDimensions = table.getValidTimeDimensions();
        for (int i = 1; i < validTimeDimensions.size(); ++i) {
            ValidTimeDimension validTimeDimension = validTimeDimensions.get(i);
            SSBTableOraclev12c.appendNewLine(oldbuffer, prettyPrint, 0);
            StringBuffer buffer = new StringBuffer();
            SSBTableOraclev12c.appendStringWithSpace(buffer, "ALTER");
            SSBTableOraclev12c.appendStringWithSpace(buffer, "TABLE");
            SSBTableOraclev12c.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(tableProxy));
            String advancedComments = String.valueOf(buffer) + "ADD period for " + validTimeDimension.getName();
            SSBTableOraclev12c.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev12c.appendStringWithSpace(buffer, "ADD");
            SSBTableOraclev12c.appendStringWithSpace(buffer, '(');
            this.appendPeriodDefinition(buffer, validTimeDimension, tableProxy);
            SSBTableOraclev12c.appendStringWithSpace(buffer, ')');
            this.appendToBuffer(oldbuffer, buffer, advancedComments);
            SSBTableOraclev12c.appendNewLine(buffer, prettyPrint, 0);
            buffer.append(';');
            SSBTableOraclev12c.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, "");
            this.incrementAlterTable();
        }
    }

    private void appendPeriodDefinition(StringBuffer buffer, ValidTimeDimension validTimeDimension, TableProxyOracle tableProxy) {
        SSBTableOraclev12c.appendStringWithSpace(buffer, "PERIOD FOR");
        SSBTableOraclev12c.appendStringWithSpace(buffer, validTimeDimension.getName());
        Column startCol = validTimeDimension.getStartTimeColumn();
        Column endCol = validTimeDimension.getEndTimeColumn();
        if (startCol != null && endCol != null) {
            ColumnProxy startColProxy = tableProxy.getColumnProxy(startCol.getObjectID());
            ColumnProxy endColProxy = tableProxy.getColumnProxy(endCol.getObjectID());
            if (startColProxy != null && endColProxy != null) {
                SSBTableOraclev12c.appendStringWithSpace(buffer, '(');
                SSBTableOraclev12c.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(startColProxy));
                SSBTableOraclev12c.appendStringWithSpace(buffer, ',');
                SSBTableOraclev12c.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(endColProxy));
                SSBTableOraclev12c.appendStringWithSpace(buffer, ')');
            }
        }
    }

    @Override
    protected void appendBlockChainOptions(StringBuffer buffer, TableProxyOracle tableProxy, boolean prettyPrint) {
        if (tableProxy instanceof TableProxyOraclev20c && ((TableProxyOraclev20c)tableProxy).isBlockChainTable()) {
            int days;
            TableProxyOraclev20c tp = (TableProxyOraclev20c)tableProxy;
            SSBTableOraclev12c.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev12c.appendStringWithSpace(buffer, "NO DROP");
            String ndays = tp.getTableDropRetentionDays();
            if (ndays != null && !ndays.isEmpty()) {
                days = 0;
                try {
                    days = Integer.valueOf(ndays);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (days > 15) {
                    SSBTableOraclev12c.appendStringWithSpace(buffer, "UNTIL");
                    SSBTableOraclev12c.appendStringWithSpace(buffer, ndays);
                    SSBTableOraclev12c.appendStringWithSpace(buffer, "DAYS IDLE");
                }
            }
            SSBTableOraclev12c.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev12c.appendStringWithSpace(buffer, "NO DELETE");
            ndays = tp.getRowDeleteRetentionDays();
            if (ndays != null && !ndays.isEmpty()) {
                days = 0;
                try {
                    days = Integer.valueOf(ndays);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (days > 15) {
                    SSBTableOraclev12c.appendStringWithSpace(buffer, "UNTIL");
                    SSBTableOraclev12c.appendStringWithSpace(buffer, ndays);
                    SSBTableOraclev12c.appendStringWithSpace(buffer, "DAYS AFTER INSERT");
                }
            }
            if (tp.isRowDeleteRetentionLock()) {
                SSBTableOraclev12c.appendStringWithSpace(buffer, "LOCKED");
            }
            SSBTableOraclev12c.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev12c.appendStringWithSpace(buffer, "HASHING USING");
            String hash = tp.getBlockChainHashAlgorithm();
            hash = hash == null || hash.isEmpty() ? TableProxyOraclev20c.HashAlgorithm : hash;
            SSBTableOraclev12c.appendStringWithSpace(buffer, hash);
            SSBTableOraclev12c.appendStringWithSpace(buffer, "VERSION");
            hash = tp.getBlockChainDatFormatVersion();
            hash = hash == null || hash.isEmpty() ? TableProxyOraclev20c.BlockChainDatFormatVersion : hash;
            SSBTableOraclev12c.appendStringWithSpace(buffer, hash);
        }
    }
}

