/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl;

import oracle.dbtools.crest.exports.ddl.SQLStatementBuilder;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.IndexProxy;

public class SSBDropFK
extends SQLStatementBuilder {
    @Override
    public boolean canHandle(Object object) {
        if (object instanceof Index && ((Index)object).isFK()) {
            FKIndexAssociation fk = ((Index)object).getFKAssociation();
            return fk.isDropEnabled() && !fk.shouldBeDroppedIndirectly();
        }
        if (object instanceof IndexProxy && ((IndexProxy)object).getIndex().isFK()) {
            FKIndexAssociation fk = ((IndexProxy)object).getIndex().getFKAssociation();
            return fk.isDropEnabled() && !fk.shouldBeDroppedIndirectly();
        }
        return false;
    }

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        if (object == null) {
            return;
        }
        if (object instanceof Index) {
            FKIndexAssociation fkassociation = ((Index)object).getFKAssociation();
            SSBDropFK.appendStringWithSpace(buffer, "ALTER");
            SSBDropFK.appendStringWithSpace(buffer, "TABLE");
            this.appendStringWithSpace(buffer, fkassociation.getTable());
            SSBDropFK.appendNewLine(buffer, prettyPrint, 1);
            this.appendDrop(buffer);
            SSBDropFK.appendStringWithSpace(buffer, "FOREIGN KEY");
            SSBDropFK.appendStringWithSpace(buffer, fkassociation.getName());
            this.appendToBuffer(oldbuffer, buffer, buffer.toString());
            SSBDropFK.appendNewLine(buffer, prettyPrint, 0);
            SSBDropFK.appendLineFinisher(buffer, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, buffer.toString());
        } else if (object instanceof IndexProxy) {
            IndexProxy indp = (IndexProxy)object;
            SSBDropFK.appendStringWithSpace(buffer, "ALTER");
            SSBDropFK.appendStringWithSpace(buffer, "TABLE");
            SSBDropFK.appendStringWithSpace(buffer, indp.getTableProxy().getLongName());
            SSBDropFK.appendNewLine(buffer, prettyPrint, 1);
            this.appendDrop(buffer);
            SSBDropFK.appendStringWithSpace(buffer, "FOREIGN KEY");
            SSBDropFK.appendStringWithSpace(buffer, indp.getName());
            this.appendToBuffer(oldbuffer, buffer, buffer.toString());
            SSBDropFK.appendNewLine(buffer, prettyPrint, 0);
            SSBDropFK.appendLineFinisher(buffer, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, buffer.toString());
        }
    }
}

