/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.IpInventoryCollection;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GetResourceIpInventoryResponse
extends BmcResponse {
    private String etag;
    private String opcNextPage;
    private String opcRequestId;
    private Integer opcTotalItems;
    private IpInventoryCollection ipInventoryCollection;

    public String getEtag() {
        return this.etag;
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Integer getOpcTotalItems() {
        return this.opcTotalItems;
    }

    public IpInventoryCollection getIpInventoryCollection() {
        return this.ipInventoryCollection;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "etag", "opcNextPage", "opcRequestId", "opcTotalItems", "ipInventoryCollection"})
    private GetResourceIpInventoryResponse(int __httpStatusCode__, Map<String, List<String>> headers, String etag, String opcNextPage, String opcRequestId, Integer opcTotalItems, IpInventoryCollection ipInventoryCollection) {
        super(__httpStatusCode__, headers);
        this.etag = etag;
        this.opcNextPage = opcNextPage;
        this.opcRequestId = opcRequestId;
        this.opcTotalItems = opcTotalItems;
        this.ipInventoryCollection = ipInventoryCollection;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",etag=").append(String.valueOf(this.etag));
        sb.append(",opcNextPage=").append(String.valueOf(this.opcNextPage));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcTotalItems=").append(String.valueOf(this.opcTotalItems));
        sb.append(",ipInventoryCollection=").append(String.valueOf((Object)this.ipInventoryCollection));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetResourceIpInventoryResponse)) {
            return false;
        }
        GetResourceIpInventoryResponse other = (GetResourceIpInventoryResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.etag, other.etag) && Objects.equals(this.opcNextPage, other.opcNextPage) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcTotalItems, other.opcTotalItems) && Objects.equals((Object)this.ipInventoryCollection, (Object)other.ipInventoryCollection);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.etag == null ? 43 : this.etag.hashCode());
        result = result * 59 + (this.opcNextPage == null ? 43 : this.opcNextPage.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcTotalItems == null ? 43 : this.opcTotalItems.hashCode());
        result = result * 59 + (this.ipInventoryCollection == null ? 43 : this.ipInventoryCollection.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<GetResourceIpInventoryResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String etag;
        private String opcNextPage;
        private String opcRequestId;
        private Integer opcTotalItems;
        private IpInventoryCollection ipInventoryCollection;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcTotalItems(Integer opcTotalItems) {
            this.opcTotalItems = opcTotalItems;
            return this;
        }

        public Builder ipInventoryCollection(IpInventoryCollection ipInventoryCollection) {
            this.ipInventoryCollection = ipInventoryCollection;
            return this;
        }

        public Builder copy(GetResourceIpInventoryResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.etag(o.getEtag());
            this.opcNextPage(o.getOpcNextPage());
            this.opcRequestId(o.getOpcRequestId());
            this.opcTotalItems(o.getOpcTotalItems());
            this.ipInventoryCollection(o.getIpInventoryCollection());
            return this;
        }

        public GetResourceIpInventoryResponse build() {
            return new GetResourceIpInventoryResponse(this.__httpStatusCode__, this.headers, this.etag, this.opcNextPage, this.opcRequestId, this.opcTotalItems, this.ipInventoryCollection);
        }
    }
}

