/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class TerminateInstanceRequest
extends BmcRequest<Void> {
    private String instanceId;
    private String ifMatch;
    private Boolean preserveBootVolume;
    private Boolean preserveDataVolumesCreatedAtLaunch;

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public Boolean getPreserveBootVolume() {
        return this.preserveBootVolume;
    }

    public Boolean getPreserveDataVolumesCreatedAtLaunch() {
        return this.preserveDataVolumesCreatedAtLaunch;
    }

    public Builder toBuilder() {
        return new Builder().instanceId(this.instanceId).ifMatch(this.ifMatch).preserveBootVolume(this.preserveBootVolume).preserveDataVolumesCreatedAtLaunch(this.preserveDataVolumesCreatedAtLaunch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",instanceId=").append(String.valueOf(this.instanceId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",preserveBootVolume=").append(String.valueOf(this.preserveBootVolume));
        sb.append(",preserveDataVolumesCreatedAtLaunch=").append(String.valueOf(this.preserveDataVolumesCreatedAtLaunch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TerminateInstanceRequest)) {
            return false;
        }
        TerminateInstanceRequest other = (TerminateInstanceRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.instanceId, other.instanceId) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.preserveBootVolume, other.preserveBootVolume) && Objects.equals(this.preserveDataVolumesCreatedAtLaunch, other.preserveDataVolumesCreatedAtLaunch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.instanceId == null ? 43 : this.instanceId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.preserveBootVolume == null ? 43 : this.preserveBootVolume.hashCode());
        result = result * 59 + (this.preserveDataVolumesCreatedAtLaunch == null ? 43 : this.preserveDataVolumesCreatedAtLaunch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<TerminateInstanceRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String instanceId = null;
        private String ifMatch = null;
        private Boolean preserveBootVolume = null;
        private Boolean preserveDataVolumesCreatedAtLaunch = null;

        public Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder preserveBootVolume(Boolean preserveBootVolume) {
            this.preserveBootVolume = preserveBootVolume;
            return this;
        }

        public Builder preserveDataVolumesCreatedAtLaunch(Boolean preserveDataVolumesCreatedAtLaunch) {
            this.preserveDataVolumesCreatedAtLaunch = preserveDataVolumesCreatedAtLaunch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(TerminateInstanceRequest o) {
            this.instanceId(o.getInstanceId());
            this.ifMatch(o.getIfMatch());
            this.preserveBootVolume(o.getPreserveBootVolume());
            this.preserveDataVolumesCreatedAtLaunch(o.getPreserveDataVolumesCreatedAtLaunch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public TerminateInstanceRequest build() {
            TerminateInstanceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public TerminateInstanceRequest buildWithoutInvocationCallback() {
            TerminateInstanceRequest request = new TerminateInstanceRequest();
            request.instanceId = this.instanceId;
            request.ifMatch = this.ifMatch;
            request.preserveBootVolume = this.preserveBootVolume;
            request.preserveDataVolumesCreatedAtLaunch = this.preserveDataVolumesCreatedAtLaunch;
            return request;
        }
    }
}

