/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListDrgRouteRulesRequest
extends BmcRequest<Void> {
    private String drgRouteTableId;
    private Integer limit;
    private String page;
    private RouteType routeType;

    public String getDrgRouteTableId() {
        return this.drgRouteTableId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public RouteType getRouteType() {
        return this.routeType;
    }

    public Builder toBuilder() {
        return new Builder().drgRouteTableId(this.drgRouteTableId).limit(this.limit).page(this.page).routeType(this.routeType);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",drgRouteTableId=").append(String.valueOf(this.drgRouteTableId));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",routeType=").append(String.valueOf((Object)this.routeType));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListDrgRouteRulesRequest)) {
            return false;
        }
        ListDrgRouteRulesRequest other = (ListDrgRouteRulesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.drgRouteTableId, other.drgRouteTableId) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.routeType, (Object)other.routeType);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.drgRouteTableId == null ? 43 : this.drgRouteTableId.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.routeType == null ? 43 : this.routeType.hashCode());
        return result;
    }

    public static enum RouteType implements BmcEnum
    {
        Static("STATIC"),
        Dynamic("DYNAMIC");

        private final String value;
        private static Map<String, RouteType> map;

        private RouteType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static RouteType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid RouteType: " + key);
        }

        static {
            map = new HashMap<String, RouteType>();
            for (RouteType v : RouteType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static class Builder
    implements BmcRequest.Builder<ListDrgRouteRulesRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String drgRouteTableId = null;
        private Integer limit = null;
        private String page = null;
        private RouteType routeType = null;

        public Builder drgRouteTableId(String drgRouteTableId) {
            this.drgRouteTableId = drgRouteTableId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder routeType(RouteType routeType) {
            this.routeType = routeType;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListDrgRouteRulesRequest o) {
            this.drgRouteTableId(o.getDrgRouteTableId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.routeType(o.getRouteType());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListDrgRouteRulesRequest build() {
            ListDrgRouteRulesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListDrgRouteRulesRequest buildWithoutInvocationCallback() {
            ListDrgRouteRulesRequest request = new ListDrgRouteRulesRequest();
            request.drgRouteTableId = this.drgRouteTableId;
            request.limit = this.limit;
            request.page = this.page;
            request.routeType = this.routeType;
            return request;
        }
    }
}

