/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.core.model.IcmpOptions;
import com.oracle.bmc.core.model.TcpOptions;
import com.oracle.bmc.core.model.UdpOptions;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class VtapCaptureFilterRuleDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="trafficDirection")
    private final TrafficDirection trafficDirection;
    @JsonProperty(value="ruleAction")
    private final RuleAction ruleAction;
    @JsonProperty(value="sourceCidr")
    private final String sourceCidr;
    @JsonProperty(value="destinationCidr")
    private final String destinationCidr;
    @JsonProperty(value="protocol")
    private final String protocol;
    @JsonProperty(value="icmpOptions")
    private final IcmpOptions icmpOptions;
    @JsonProperty(value="tcpOptions")
    private final TcpOptions tcpOptions;
    @JsonProperty(value="udpOptions")
    private final UdpOptions udpOptions;

    @Deprecated
    @ConstructorProperties(value={"trafficDirection", "ruleAction", "sourceCidr", "destinationCidr", "protocol", "icmpOptions", "tcpOptions", "udpOptions"})
    public VtapCaptureFilterRuleDetails(TrafficDirection trafficDirection, RuleAction ruleAction, String sourceCidr, String destinationCidr, String protocol, IcmpOptions icmpOptions, TcpOptions tcpOptions, UdpOptions udpOptions) {
        this.trafficDirection = trafficDirection;
        this.ruleAction = ruleAction;
        this.sourceCidr = sourceCidr;
        this.destinationCidr = destinationCidr;
        this.protocol = protocol;
        this.icmpOptions = icmpOptions;
        this.tcpOptions = tcpOptions;
        this.udpOptions = udpOptions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public TrafficDirection getTrafficDirection() {
        return this.trafficDirection;
    }

    public RuleAction getRuleAction() {
        return this.ruleAction;
    }

    public String getSourceCidr() {
        return this.sourceCidr;
    }

    public String getDestinationCidr() {
        return this.destinationCidr;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public IcmpOptions getIcmpOptions() {
        return this.icmpOptions;
    }

    public TcpOptions getTcpOptions() {
        return this.tcpOptions;
    }

    public UdpOptions getUdpOptions() {
        return this.udpOptions;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("VtapCaptureFilterRuleDetails(");
        sb.append("super=").append(super.toString());
        sb.append("trafficDirection=").append(String.valueOf((Object)this.trafficDirection));
        sb.append(", ruleAction=").append(String.valueOf((Object)this.ruleAction));
        sb.append(", sourceCidr=").append(String.valueOf(this.sourceCidr));
        sb.append(", destinationCidr=").append(String.valueOf(this.destinationCidr));
        sb.append(", protocol=").append(String.valueOf(this.protocol));
        sb.append(", icmpOptions=").append(String.valueOf((Object)this.icmpOptions));
        sb.append(", tcpOptions=").append(String.valueOf((Object)this.tcpOptions));
        sb.append(", udpOptions=").append(String.valueOf((Object)this.udpOptions));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VtapCaptureFilterRuleDetails)) {
            return false;
        }
        VtapCaptureFilterRuleDetails other = (VtapCaptureFilterRuleDetails)((Object)o);
        return Objects.equals((Object)this.trafficDirection, (Object)other.trafficDirection) && Objects.equals((Object)this.ruleAction, (Object)other.ruleAction) && Objects.equals(this.sourceCidr, other.sourceCidr) && Objects.equals(this.destinationCidr, other.destinationCidr) && Objects.equals(this.protocol, other.protocol) && Objects.equals((Object)this.icmpOptions, (Object)other.icmpOptions) && Objects.equals((Object)this.tcpOptions, (Object)other.tcpOptions) && Objects.equals((Object)this.udpOptions, (Object)other.udpOptions) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.trafficDirection == null ? 43 : this.trafficDirection.hashCode());
        result = result * 59 + (this.ruleAction == null ? 43 : this.ruleAction.hashCode());
        result = result * 59 + (this.sourceCidr == null ? 43 : this.sourceCidr.hashCode());
        result = result * 59 + (this.destinationCidr == null ? 43 : this.destinationCidr.hashCode());
        result = result * 59 + (this.protocol == null ? 43 : this.protocol.hashCode());
        result = result * 59 + (this.icmpOptions == null ? 43 : this.icmpOptions.hashCode());
        result = result * 59 + (this.tcpOptions == null ? 43 : this.tcpOptions.hashCode());
        result = result * 59 + (this.udpOptions == null ? 43 : this.udpOptions.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum TrafficDirection implements BmcEnum
    {
        Ingress("INGRESS"),
        Egress("EGRESS"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, TrafficDirection> map;

        private TrafficDirection(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static TrafficDirection create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'TrafficDirection', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(TrafficDirection.class);
            map = new HashMap<String, TrafficDirection>();
            for (TrafficDirection v : TrafficDirection.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum RuleAction implements BmcEnum
    {
        Include("INCLUDE"),
        Exclude("EXCLUDE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, RuleAction> map;

        private RuleAction(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static RuleAction create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'RuleAction', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(RuleAction.class);
            map = new HashMap<String, RuleAction>();
            for (RuleAction v : RuleAction.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="trafficDirection")
        private TrafficDirection trafficDirection;
        @JsonProperty(value="ruleAction")
        private RuleAction ruleAction;
        @JsonProperty(value="sourceCidr")
        private String sourceCidr;
        @JsonProperty(value="destinationCidr")
        private String destinationCidr;
        @JsonProperty(value="protocol")
        private String protocol;
        @JsonProperty(value="icmpOptions")
        private IcmpOptions icmpOptions;
        @JsonProperty(value="tcpOptions")
        private TcpOptions tcpOptions;
        @JsonProperty(value="udpOptions")
        private UdpOptions udpOptions;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder trafficDirection(TrafficDirection trafficDirection) {
            this.trafficDirection = trafficDirection;
            this.__explicitlySet__.add("trafficDirection");
            return this;
        }

        public Builder ruleAction(RuleAction ruleAction) {
            this.ruleAction = ruleAction;
            this.__explicitlySet__.add("ruleAction");
            return this;
        }

        public Builder sourceCidr(String sourceCidr) {
            this.sourceCidr = sourceCidr;
            this.__explicitlySet__.add("sourceCidr");
            return this;
        }

        public Builder destinationCidr(String destinationCidr) {
            this.destinationCidr = destinationCidr;
            this.__explicitlySet__.add("destinationCidr");
            return this;
        }

        public Builder protocol(String protocol) {
            this.protocol = protocol;
            this.__explicitlySet__.add("protocol");
            return this;
        }

        public Builder icmpOptions(IcmpOptions icmpOptions) {
            this.icmpOptions = icmpOptions;
            this.__explicitlySet__.add("icmpOptions");
            return this;
        }

        public Builder tcpOptions(TcpOptions tcpOptions) {
            this.tcpOptions = tcpOptions;
            this.__explicitlySet__.add("tcpOptions");
            return this;
        }

        public Builder udpOptions(UdpOptions udpOptions) {
            this.udpOptions = udpOptions;
            this.__explicitlySet__.add("udpOptions");
            return this;
        }

        public VtapCaptureFilterRuleDetails build() {
            VtapCaptureFilterRuleDetails model = new VtapCaptureFilterRuleDetails(this.trafficDirection, this.ruleAction, this.sourceCidr, this.destinationCidr, this.protocol, this.icmpOptions, this.tcpOptions, this.udpOptions);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(VtapCaptureFilterRuleDetails model) {
            if (model.wasPropertyExplicitlySet("trafficDirection")) {
                this.trafficDirection(model.getTrafficDirection());
            }
            if (model.wasPropertyExplicitlySet("ruleAction")) {
                this.ruleAction(model.getRuleAction());
            }
            if (model.wasPropertyExplicitlySet("sourceCidr")) {
                this.sourceCidr(model.getSourceCidr());
            }
            if (model.wasPropertyExplicitlySet("destinationCidr")) {
                this.destinationCidr(model.getDestinationCidr());
            }
            if (model.wasPropertyExplicitlySet("protocol")) {
                this.protocol(model.getProtocol());
            }
            if (model.wasPropertyExplicitlySet("icmpOptions")) {
                this.icmpOptions(model.getIcmpOptions());
            }
            if (model.wasPropertyExplicitlySet("tcpOptions")) {
                this.tcpOptions(model.getTcpOptions());
            }
            if (model.wasPropertyExplicitlySet("udpOptions")) {
                this.udpOptions(model.getUdpOptions());
            }
            return this;
        }
    }
}

