/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class UpdateLaunchOptions
extends ExplicitlySetBmcModel {
    @JsonProperty(value="bootVolumeType")
    private final BootVolumeType bootVolumeType;
    @JsonProperty(value="networkType")
    private final NetworkType networkType;
    @JsonProperty(value="isPvEncryptionInTransitEnabled")
    private final Boolean isPvEncryptionInTransitEnabled;

    @Deprecated
    @ConstructorProperties(value={"bootVolumeType", "networkType", "isPvEncryptionInTransitEnabled"})
    public UpdateLaunchOptions(BootVolumeType bootVolumeType, NetworkType networkType, Boolean isPvEncryptionInTransitEnabled) {
        this.bootVolumeType = bootVolumeType;
        this.networkType = networkType;
        this.isPvEncryptionInTransitEnabled = isPvEncryptionInTransitEnabled;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public BootVolumeType getBootVolumeType() {
        return this.bootVolumeType;
    }

    public NetworkType getNetworkType() {
        return this.networkType;
    }

    public Boolean getIsPvEncryptionInTransitEnabled() {
        return this.isPvEncryptionInTransitEnabled;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateLaunchOptions(");
        sb.append("super=").append(super.toString());
        sb.append("bootVolumeType=").append(String.valueOf((Object)this.bootVolumeType));
        sb.append(", networkType=").append(String.valueOf((Object)this.networkType));
        sb.append(", isPvEncryptionInTransitEnabled=").append(String.valueOf(this.isPvEncryptionInTransitEnabled));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateLaunchOptions)) {
            return false;
        }
        UpdateLaunchOptions other = (UpdateLaunchOptions)((Object)o);
        return Objects.equals((Object)this.bootVolumeType, (Object)other.bootVolumeType) && Objects.equals((Object)this.networkType, (Object)other.networkType) && Objects.equals(this.isPvEncryptionInTransitEnabled, other.isPvEncryptionInTransitEnabled) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.bootVolumeType == null ? 43 : this.bootVolumeType.hashCode());
        result = result * 59 + (this.networkType == null ? 43 : this.networkType.hashCode());
        result = result * 59 + (this.isPvEncryptionInTransitEnabled == null ? 43 : this.isPvEncryptionInTransitEnabled.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum BootVolumeType implements BmcEnum
    {
        Iscsi("ISCSI"),
        Paravirtualized("PARAVIRTUALIZED");

        private final String value;
        private static Map<String, BootVolumeType> map;

        private BootVolumeType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static BootVolumeType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid BootVolumeType: " + key);
        }

        static {
            map = new HashMap<String, BootVolumeType>();
            for (BootVolumeType v : BootVolumeType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum NetworkType implements BmcEnum
    {
        Vfio("VFIO"),
        Paravirtualized("PARAVIRTUALIZED");

        private final String value;
        private static Map<String, NetworkType> map;

        private NetworkType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static NetworkType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid NetworkType: " + key);
        }

        static {
            map = new HashMap<String, NetworkType>();
            for (NetworkType v : NetworkType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="bootVolumeType")
        private BootVolumeType bootVolumeType;
        @JsonProperty(value="networkType")
        private NetworkType networkType;
        @JsonProperty(value="isPvEncryptionInTransitEnabled")
        private Boolean isPvEncryptionInTransitEnabled;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder bootVolumeType(BootVolumeType bootVolumeType) {
            this.bootVolumeType = bootVolumeType;
            this.__explicitlySet__.add("bootVolumeType");
            return this;
        }

        public Builder networkType(NetworkType networkType) {
            this.networkType = networkType;
            this.__explicitlySet__.add("networkType");
            return this;
        }

        public Builder isPvEncryptionInTransitEnabled(Boolean isPvEncryptionInTransitEnabled) {
            this.isPvEncryptionInTransitEnabled = isPvEncryptionInTransitEnabled;
            this.__explicitlySet__.add("isPvEncryptionInTransitEnabled");
            return this;
        }

        public UpdateLaunchOptions build() {
            UpdateLaunchOptions model = new UpdateLaunchOptions(this.bootVolumeType, this.networkType, this.isPvEncryptionInTransitEnabled);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UpdateLaunchOptions model) {
            if (model.wasPropertyExplicitlySet("bootVolumeType")) {
                this.bootVolumeType(model.getBootVolumeType());
            }
            if (model.wasPropertyExplicitlySet("networkType")) {
                this.networkType(model.getNetworkType());
            }
            if (model.wasPropertyExplicitlySet("isPvEncryptionInTransitEnabled")) {
                this.isPvEncryptionInTransitEnabled(model.getIsPvEncryptionInTransitEnabled());
            }
            return this;
        }
    }
}

