/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class IpInventorySubnetResourceSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="ipId")
    private final String ipId;
    @JsonProperty(value="ipAddress")
    private final String ipAddress;
    @JsonProperty(value="ipAddressLifetime")
    private final IpAddressLifetime ipAddressLifetime;
    @JsonProperty(value="parentCidr")
    private final String parentCidr;
    @JsonProperty(value="associatedPublicIp")
    private final String associatedPublicIp;
    @JsonProperty(value="publicIpLifetime")
    private final PublicIpLifetime publicIpLifetime;
    @JsonProperty(value="associatedPublicIpPool")
    private final AssociatedPublicIpPool associatedPublicIpPool;
    @JsonProperty(value="dnsHostName")
    private final String dnsHostName;
    @JsonProperty(value="assignedResourceName")
    private final String assignedResourceName;
    @JsonProperty(value="assignedResourceType")
    private final AssignedResourceType assignedResourceType;
    @JsonProperty(value="addressType")
    private final String addressType;
    @JsonProperty(value="assignedTime")
    private final Date assignedTime;

    @Deprecated
    @ConstructorProperties(value={"ipId", "ipAddress", "ipAddressLifetime", "parentCidr", "associatedPublicIp", "publicIpLifetime", "associatedPublicIpPool", "dnsHostName", "assignedResourceName", "assignedResourceType", "addressType", "assignedTime"})
    public IpInventorySubnetResourceSummary(String ipId, String ipAddress, IpAddressLifetime ipAddressLifetime, String parentCidr, String associatedPublicIp, PublicIpLifetime publicIpLifetime, AssociatedPublicIpPool associatedPublicIpPool, String dnsHostName, String assignedResourceName, AssignedResourceType assignedResourceType, String addressType, Date assignedTime) {
        this.ipId = ipId;
        this.ipAddress = ipAddress;
        this.ipAddressLifetime = ipAddressLifetime;
        this.parentCidr = parentCidr;
        this.associatedPublicIp = associatedPublicIp;
        this.publicIpLifetime = publicIpLifetime;
        this.associatedPublicIpPool = associatedPublicIpPool;
        this.dnsHostName = dnsHostName;
        this.assignedResourceName = assignedResourceName;
        this.assignedResourceType = assignedResourceType;
        this.addressType = addressType;
        this.assignedTime = assignedTime;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getIpId() {
        return this.ipId;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public IpAddressLifetime getIpAddressLifetime() {
        return this.ipAddressLifetime;
    }

    public String getParentCidr() {
        return this.parentCidr;
    }

    public String getAssociatedPublicIp() {
        return this.associatedPublicIp;
    }

    public PublicIpLifetime getPublicIpLifetime() {
        return this.publicIpLifetime;
    }

    public AssociatedPublicIpPool getAssociatedPublicIpPool() {
        return this.associatedPublicIpPool;
    }

    public String getDnsHostName() {
        return this.dnsHostName;
    }

    public String getAssignedResourceName() {
        return this.assignedResourceName;
    }

    public AssignedResourceType getAssignedResourceType() {
        return this.assignedResourceType;
    }

    public String getAddressType() {
        return this.addressType;
    }

    public Date getAssignedTime() {
        return this.assignedTime;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("IpInventorySubnetResourceSummary(");
        sb.append("super=").append(super.toString());
        sb.append("ipId=").append(String.valueOf(this.ipId));
        sb.append(", ipAddress=").append(String.valueOf(this.ipAddress));
        sb.append(", ipAddressLifetime=").append(String.valueOf((Object)this.ipAddressLifetime));
        sb.append(", parentCidr=").append(String.valueOf(this.parentCidr));
        sb.append(", associatedPublicIp=").append(String.valueOf(this.associatedPublicIp));
        sb.append(", publicIpLifetime=").append(String.valueOf((Object)this.publicIpLifetime));
        sb.append(", associatedPublicIpPool=").append(String.valueOf((Object)this.associatedPublicIpPool));
        sb.append(", dnsHostName=").append(String.valueOf(this.dnsHostName));
        sb.append(", assignedResourceName=").append(String.valueOf(this.assignedResourceName));
        sb.append(", assignedResourceType=").append(String.valueOf((Object)this.assignedResourceType));
        sb.append(", addressType=").append(String.valueOf(this.addressType));
        sb.append(", assignedTime=").append(String.valueOf(this.assignedTime));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IpInventorySubnetResourceSummary)) {
            return false;
        }
        IpInventorySubnetResourceSummary other = (IpInventorySubnetResourceSummary)((Object)o);
        return Objects.equals(this.ipId, other.ipId) && Objects.equals(this.ipAddress, other.ipAddress) && Objects.equals((Object)this.ipAddressLifetime, (Object)other.ipAddressLifetime) && Objects.equals(this.parentCidr, other.parentCidr) && Objects.equals(this.associatedPublicIp, other.associatedPublicIp) && Objects.equals((Object)this.publicIpLifetime, (Object)other.publicIpLifetime) && Objects.equals((Object)this.associatedPublicIpPool, (Object)other.associatedPublicIpPool) && Objects.equals(this.dnsHostName, other.dnsHostName) && Objects.equals(this.assignedResourceName, other.assignedResourceName) && Objects.equals((Object)this.assignedResourceType, (Object)other.assignedResourceType) && Objects.equals(this.addressType, other.addressType) && Objects.equals(this.assignedTime, other.assignedTime) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.ipId == null ? 43 : this.ipId.hashCode());
        result = result * 59 + (this.ipAddress == null ? 43 : this.ipAddress.hashCode());
        result = result * 59 + (this.ipAddressLifetime == null ? 43 : this.ipAddressLifetime.hashCode());
        result = result * 59 + (this.parentCidr == null ? 43 : this.parentCidr.hashCode());
        result = result * 59 + (this.associatedPublicIp == null ? 43 : this.associatedPublicIp.hashCode());
        result = result * 59 + (this.publicIpLifetime == null ? 43 : this.publicIpLifetime.hashCode());
        result = result * 59 + (this.associatedPublicIpPool == null ? 43 : this.associatedPublicIpPool.hashCode());
        result = result * 59 + (this.dnsHostName == null ? 43 : this.dnsHostName.hashCode());
        result = result * 59 + (this.assignedResourceName == null ? 43 : this.assignedResourceName.hashCode());
        result = result * 59 + (this.assignedResourceType == null ? 43 : this.assignedResourceType.hashCode());
        result = result * 59 + (this.addressType == null ? 43 : this.addressType.hashCode());
        result = result * 59 + (this.assignedTime == null ? 43 : this.assignedTime.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum IpAddressLifetime implements BmcEnum
    {
        Ephemeral("Ephemeral"),
        Reserved("Reserved"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, IpAddressLifetime> map;

        private IpAddressLifetime(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static IpAddressLifetime create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'IpAddressLifetime', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(IpAddressLifetime.class);
            map = new HashMap<String, IpAddressLifetime>();
            for (IpAddressLifetime v : IpAddressLifetime.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum PublicIpLifetime implements BmcEnum
    {
        Ephemeral("Ephemeral"),
        Reserved("Reserved"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, PublicIpLifetime> map;

        private PublicIpLifetime(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static PublicIpLifetime create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'PublicIpLifetime', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(PublicIpLifetime.class);
            map = new HashMap<String, PublicIpLifetime>();
            for (PublicIpLifetime v : PublicIpLifetime.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum AssociatedPublicIpPool implements BmcEnum
    {
        Oracle("ORACLE"),
        Byoip("BYOIP"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, AssociatedPublicIpPool> map;

        private AssociatedPublicIpPool(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AssociatedPublicIpPool create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'AssociatedPublicIpPool', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(AssociatedPublicIpPool.class);
            map = new HashMap<String, AssociatedPublicIpPool>();
            for (AssociatedPublicIpPool v : AssociatedPublicIpPool.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum AssignedResourceType implements BmcEnum
    {
        Resource("Resource"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, AssignedResourceType> map;

        private AssignedResourceType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AssignedResourceType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'AssignedResourceType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(AssignedResourceType.class);
            map = new HashMap<String, AssignedResourceType>();
            for (AssignedResourceType v : AssignedResourceType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="ipId")
        private String ipId;
        @JsonProperty(value="ipAddress")
        private String ipAddress;
        @JsonProperty(value="ipAddressLifetime")
        private IpAddressLifetime ipAddressLifetime;
        @JsonProperty(value="parentCidr")
        private String parentCidr;
        @JsonProperty(value="associatedPublicIp")
        private String associatedPublicIp;
        @JsonProperty(value="publicIpLifetime")
        private PublicIpLifetime publicIpLifetime;
        @JsonProperty(value="associatedPublicIpPool")
        private AssociatedPublicIpPool associatedPublicIpPool;
        @JsonProperty(value="dnsHostName")
        private String dnsHostName;
        @JsonProperty(value="assignedResourceName")
        private String assignedResourceName;
        @JsonProperty(value="assignedResourceType")
        private AssignedResourceType assignedResourceType;
        @JsonProperty(value="addressType")
        private String addressType;
        @JsonProperty(value="assignedTime")
        private Date assignedTime;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder ipId(String ipId) {
            this.ipId = ipId;
            this.__explicitlySet__.add("ipId");
            return this;
        }

        public Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            this.__explicitlySet__.add("ipAddress");
            return this;
        }

        public Builder ipAddressLifetime(IpAddressLifetime ipAddressLifetime) {
            this.ipAddressLifetime = ipAddressLifetime;
            this.__explicitlySet__.add("ipAddressLifetime");
            return this;
        }

        public Builder parentCidr(String parentCidr) {
            this.parentCidr = parentCidr;
            this.__explicitlySet__.add("parentCidr");
            return this;
        }

        public Builder associatedPublicIp(String associatedPublicIp) {
            this.associatedPublicIp = associatedPublicIp;
            this.__explicitlySet__.add("associatedPublicIp");
            return this;
        }

        public Builder publicIpLifetime(PublicIpLifetime publicIpLifetime) {
            this.publicIpLifetime = publicIpLifetime;
            this.__explicitlySet__.add("publicIpLifetime");
            return this;
        }

        public Builder associatedPublicIpPool(AssociatedPublicIpPool associatedPublicIpPool) {
            this.associatedPublicIpPool = associatedPublicIpPool;
            this.__explicitlySet__.add("associatedPublicIpPool");
            return this;
        }

        public Builder dnsHostName(String dnsHostName) {
            this.dnsHostName = dnsHostName;
            this.__explicitlySet__.add("dnsHostName");
            return this;
        }

        public Builder assignedResourceName(String assignedResourceName) {
            this.assignedResourceName = assignedResourceName;
            this.__explicitlySet__.add("assignedResourceName");
            return this;
        }

        public Builder assignedResourceType(AssignedResourceType assignedResourceType) {
            this.assignedResourceType = assignedResourceType;
            this.__explicitlySet__.add("assignedResourceType");
            return this;
        }

        public Builder addressType(String addressType) {
            this.addressType = addressType;
            this.__explicitlySet__.add("addressType");
            return this;
        }

        public Builder assignedTime(Date assignedTime) {
            this.assignedTime = assignedTime;
            this.__explicitlySet__.add("assignedTime");
            return this;
        }

        public IpInventorySubnetResourceSummary build() {
            IpInventorySubnetResourceSummary model = new IpInventorySubnetResourceSummary(this.ipId, this.ipAddress, this.ipAddressLifetime, this.parentCidr, this.associatedPublicIp, this.publicIpLifetime, this.associatedPublicIpPool, this.dnsHostName, this.assignedResourceName, this.assignedResourceType, this.addressType, this.assignedTime);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(IpInventorySubnetResourceSummary model) {
            if (model.wasPropertyExplicitlySet("ipId")) {
                this.ipId(model.getIpId());
            }
            if (model.wasPropertyExplicitlySet("ipAddress")) {
                this.ipAddress(model.getIpAddress());
            }
            if (model.wasPropertyExplicitlySet("ipAddressLifetime")) {
                this.ipAddressLifetime(model.getIpAddressLifetime());
            }
            if (model.wasPropertyExplicitlySet("parentCidr")) {
                this.parentCidr(model.getParentCidr());
            }
            if (model.wasPropertyExplicitlySet("associatedPublicIp")) {
                this.associatedPublicIp(model.getAssociatedPublicIp());
            }
            if (model.wasPropertyExplicitlySet("publicIpLifetime")) {
                this.publicIpLifetime(model.getPublicIpLifetime());
            }
            if (model.wasPropertyExplicitlySet("associatedPublicIpPool")) {
                this.associatedPublicIpPool(model.getAssociatedPublicIpPool());
            }
            if (model.wasPropertyExplicitlySet("dnsHostName")) {
                this.dnsHostName(model.getDnsHostName());
            }
            if (model.wasPropertyExplicitlySet("assignedResourceName")) {
                this.assignedResourceName(model.getAssignedResourceName());
            }
            if (model.wasPropertyExplicitlySet("assignedResourceType")) {
                this.assignedResourceType(model.getAssignedResourceType());
            }
            if (model.wasPropertyExplicitlySet("addressType")) {
                this.addressType(model.getAddressType());
            }
            if (model.wasPropertyExplicitlySet("assignedTime")) {
                this.assignedTime(model.getAssignedTime());
            }
            return this;
        }
    }
}

