/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.core.model.InventoryIpAddressSummary;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class InventoryResourceSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="resourceName")
    private final String resourceName;
    @JsonProperty(value="resourceType")
    private final ResourceType resourceType;
    @JsonProperty(value="ipAddressCollection")
    private final List<InventoryIpAddressSummary> ipAddressCollection;
    @JsonProperty(value="region")
    private final String region;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;

    @Deprecated
    @ConstructorProperties(value={"resourceName", "resourceType", "ipAddressCollection", "region", "compartmentId"})
    public InventoryResourceSummary(String resourceName, ResourceType resourceType, List<InventoryIpAddressSummary> ipAddressCollection, String region, String compartmentId) {
        this.resourceName = resourceName;
        this.resourceType = resourceType;
        this.ipAddressCollection = ipAddressCollection;
        this.region = region;
        this.compartmentId = compartmentId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public List<InventoryIpAddressSummary> getIpAddressCollection() {
        return this.ipAddressCollection;
    }

    public String getRegion() {
        return this.region;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("InventoryResourceSummary(");
        sb.append("super=").append(super.toString());
        sb.append("resourceName=").append(String.valueOf(this.resourceName));
        sb.append(", resourceType=").append(String.valueOf((Object)this.resourceType));
        sb.append(", ipAddressCollection=").append(String.valueOf(this.ipAddressCollection));
        sb.append(", region=").append(String.valueOf(this.region));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InventoryResourceSummary)) {
            return false;
        }
        InventoryResourceSummary other = (InventoryResourceSummary)((Object)o);
        return Objects.equals(this.resourceName, other.resourceName) && Objects.equals((Object)this.resourceType, (Object)other.resourceType) && Objects.equals(this.ipAddressCollection, other.ipAddressCollection) && Objects.equals(this.region, other.region) && Objects.equals(this.compartmentId, other.compartmentId) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.resourceName == null ? 43 : this.resourceName.hashCode());
        result = result * 59 + (this.resourceType == null ? 43 : this.resourceType.hashCode());
        result = result * 59 + (this.ipAddressCollection == null ? 43 : this.ipAddressCollection.hashCode());
        result = result * 59 + (this.region == null ? 43 : this.region.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ResourceType implements BmcEnum
    {
        Resource("Resource"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ResourceType> map;

        private ResourceType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ResourceType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ResourceType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ResourceType.class);
            map = new HashMap<String, ResourceType>();
            for (ResourceType v : ResourceType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="resourceName")
        private String resourceName;
        @JsonProperty(value="resourceType")
        private ResourceType resourceType;
        @JsonProperty(value="ipAddressCollection")
        private List<InventoryIpAddressSummary> ipAddressCollection;
        @JsonProperty(value="region")
        private String region;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            this.__explicitlySet__.add("resourceName");
            return this;
        }

        public Builder resourceType(ResourceType resourceType) {
            this.resourceType = resourceType;
            this.__explicitlySet__.add("resourceType");
            return this;
        }

        public Builder ipAddressCollection(List<InventoryIpAddressSummary> ipAddressCollection) {
            this.ipAddressCollection = ipAddressCollection;
            this.__explicitlySet__.add("ipAddressCollection");
            return this;
        }

        public Builder region(String region) {
            this.region = region;
            this.__explicitlySet__.add("region");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public InventoryResourceSummary build() {
            InventoryResourceSummary model = new InventoryResourceSummary(this.resourceName, this.resourceType, this.ipAddressCollection, this.region, this.compartmentId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(InventoryResourceSummary model) {
            if (model.wasPropertyExplicitlySet("resourceName")) {
                this.resourceName(model.getResourceName());
            }
            if (model.wasPropertyExplicitlySet("resourceType")) {
                this.resourceType(model.getResourceType());
            }
            if (model.wasPropertyExplicitlySet("ipAddressCollection")) {
                this.ipAddressCollection(model.getIpAddressCollection());
            }
            if (model.wasPropertyExplicitlySet("region")) {
                this.region(model.getRegion());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            return this;
        }
    }
}

