/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.core.model.ClusterConfigDetails;
import com.oracle.bmc.core.model.InstanceReservationShapeConfigDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class InstanceReservationConfigDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="instanceShape")
    private final String instanceShape;
    @JsonProperty(value="instanceShapeConfig")
    private final InstanceReservationShapeConfigDetails instanceShapeConfig;
    @JsonProperty(value="faultDomain")
    private final String faultDomain;
    @JsonProperty(value="clusterConfig")
    private final ClusterConfigDetails clusterConfig;
    @JsonProperty(value="reservedCount")
    private final Long reservedCount;
    @JsonProperty(value="clusterPlacementGroupId")
    private final String clusterPlacementGroupId;

    @Deprecated
    @ConstructorProperties(value={"instanceShape", "instanceShapeConfig", "faultDomain", "clusterConfig", "reservedCount", "clusterPlacementGroupId"})
    public InstanceReservationConfigDetails(String instanceShape, InstanceReservationShapeConfigDetails instanceShapeConfig, String faultDomain, ClusterConfigDetails clusterConfig, Long reservedCount, String clusterPlacementGroupId) {
        this.instanceShape = instanceShape;
        this.instanceShapeConfig = instanceShapeConfig;
        this.faultDomain = faultDomain;
        this.clusterConfig = clusterConfig;
        this.reservedCount = reservedCount;
        this.clusterPlacementGroupId = clusterPlacementGroupId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getInstanceShape() {
        return this.instanceShape;
    }

    public InstanceReservationShapeConfigDetails getInstanceShapeConfig() {
        return this.instanceShapeConfig;
    }

    public String getFaultDomain() {
        return this.faultDomain;
    }

    public ClusterConfigDetails getClusterConfig() {
        return this.clusterConfig;
    }

    public Long getReservedCount() {
        return this.reservedCount;
    }

    public String getClusterPlacementGroupId() {
        return this.clusterPlacementGroupId;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("InstanceReservationConfigDetails(");
        sb.append("super=").append(super.toString());
        sb.append("instanceShape=").append(String.valueOf(this.instanceShape));
        sb.append(", instanceShapeConfig=").append(String.valueOf((Object)this.instanceShapeConfig));
        sb.append(", faultDomain=").append(String.valueOf(this.faultDomain));
        sb.append(", clusterConfig=").append(String.valueOf((Object)this.clusterConfig));
        sb.append(", reservedCount=").append(String.valueOf(this.reservedCount));
        sb.append(", clusterPlacementGroupId=").append(String.valueOf(this.clusterPlacementGroupId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InstanceReservationConfigDetails)) {
            return false;
        }
        InstanceReservationConfigDetails other = (InstanceReservationConfigDetails)((Object)o);
        return Objects.equals(this.instanceShape, other.instanceShape) && Objects.equals((Object)this.instanceShapeConfig, (Object)other.instanceShapeConfig) && Objects.equals(this.faultDomain, other.faultDomain) && Objects.equals((Object)this.clusterConfig, (Object)other.clusterConfig) && Objects.equals(this.reservedCount, other.reservedCount) && Objects.equals(this.clusterPlacementGroupId, other.clusterPlacementGroupId) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.instanceShape == null ? 43 : this.instanceShape.hashCode());
        result = result * 59 + (this.instanceShapeConfig == null ? 43 : this.instanceShapeConfig.hashCode());
        result = result * 59 + (this.faultDomain == null ? 43 : this.faultDomain.hashCode());
        result = result * 59 + (this.clusterConfig == null ? 43 : this.clusterConfig.hashCode());
        result = result * 59 + (this.reservedCount == null ? 43 : this.reservedCount.hashCode());
        result = result * 59 + (this.clusterPlacementGroupId == null ? 43 : this.clusterPlacementGroupId.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="instanceShape")
        private String instanceShape;
        @JsonProperty(value="instanceShapeConfig")
        private InstanceReservationShapeConfigDetails instanceShapeConfig;
        @JsonProperty(value="faultDomain")
        private String faultDomain;
        @JsonProperty(value="clusterConfig")
        private ClusterConfigDetails clusterConfig;
        @JsonProperty(value="reservedCount")
        private Long reservedCount;
        @JsonProperty(value="clusterPlacementGroupId")
        private String clusterPlacementGroupId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder instanceShape(String instanceShape) {
            this.instanceShape = instanceShape;
            this.__explicitlySet__.add("instanceShape");
            return this;
        }

        public Builder instanceShapeConfig(InstanceReservationShapeConfigDetails instanceShapeConfig) {
            this.instanceShapeConfig = instanceShapeConfig;
            this.__explicitlySet__.add("instanceShapeConfig");
            return this;
        }

        public Builder faultDomain(String faultDomain) {
            this.faultDomain = faultDomain;
            this.__explicitlySet__.add("faultDomain");
            return this;
        }

        public Builder clusterConfig(ClusterConfigDetails clusterConfig) {
            this.clusterConfig = clusterConfig;
            this.__explicitlySet__.add("clusterConfig");
            return this;
        }

        public Builder reservedCount(Long reservedCount) {
            this.reservedCount = reservedCount;
            this.__explicitlySet__.add("reservedCount");
            return this;
        }

        public Builder clusterPlacementGroupId(String clusterPlacementGroupId) {
            this.clusterPlacementGroupId = clusterPlacementGroupId;
            this.__explicitlySet__.add("clusterPlacementGroupId");
            return this;
        }

        public InstanceReservationConfigDetails build() {
            InstanceReservationConfigDetails model = new InstanceReservationConfigDetails(this.instanceShape, this.instanceShapeConfig, this.faultDomain, this.clusterConfig, this.reservedCount, this.clusterPlacementGroupId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(InstanceReservationConfigDetails model) {
            if (model.wasPropertyExplicitlySet("instanceShape")) {
                this.instanceShape(model.getInstanceShape());
            }
            if (model.wasPropertyExplicitlySet("instanceShapeConfig")) {
                this.instanceShapeConfig(model.getInstanceShapeConfig());
            }
            if (model.wasPropertyExplicitlySet("faultDomain")) {
                this.faultDomain(model.getFaultDomain());
            }
            if (model.wasPropertyExplicitlySet("clusterConfig")) {
                this.clusterConfig(model.getClusterConfig());
            }
            if (model.wasPropertyExplicitlySet("reservedCount")) {
                this.reservedCount(model.getReservedCount());
            }
            if (model.wasPropertyExplicitlySet("clusterPlacementGroupId")) {
                this.clusterPlacementGroupId(model.getClusterPlacementGroupId());
            }
            return this;
        }
    }
}

