/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ComputeHost
extends ExplicitlySetBmcModel {
    @JsonProperty(value="availabilityDomain")
    private final String availabilityDomain;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="faultDomain")
    private final String faultDomain;
    @JsonProperty(value="hpcIslandId")
    private final String hpcIslandId;
    @JsonProperty(value="networkBlockId")
    private final String networkBlockId;
    @JsonProperty(value="localBlockId")
    private final String localBlockId;
    @JsonProperty(value="gpuMemoryFabricId")
    private final String gpuMemoryFabricId;
    @JsonProperty(value="instanceId")
    private final String instanceId;
    @JsonProperty(value="shape")
    private final String shape;
    @JsonProperty(value="health")
    private final Health health;
    @JsonProperty(value="additionalData")
    private final Map<String, Object> additionalData;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="lifecycleDetails")
    private final Map<String, Object> lifecycleDetails;
    @JsonProperty(value="capacityReservationId")
    private final String capacityReservationId;
    @JsonProperty(value="impactedComponentDetails")
    private final Map<String, Object> impactedComponentDetails;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;

    @Deprecated
    @ConstructorProperties(value={"availabilityDomain", "compartmentId", "id", "faultDomain", "hpcIslandId", "networkBlockId", "localBlockId", "gpuMemoryFabricId", "instanceId", "shape", "health", "additionalData", "lifecycleState", "lifecycleDetails", "capacityReservationId", "impactedComponentDetails", "timeCreated", "timeUpdated", "definedTags", "displayName", "freeformTags"})
    public ComputeHost(String availabilityDomain, String compartmentId, String id, String faultDomain, String hpcIslandId, String networkBlockId, String localBlockId, String gpuMemoryFabricId, String instanceId, String shape, Health health, Map<String, Object> additionalData, LifecycleState lifecycleState, Map<String, Object> lifecycleDetails, String capacityReservationId, Map<String, Object> impactedComponentDetails, Date timeCreated, Date timeUpdated, Map<String, Map<String, Object>> definedTags, String displayName, Map<String, String> freeformTags) {
        this.availabilityDomain = availabilityDomain;
        this.compartmentId = compartmentId;
        this.id = id;
        this.faultDomain = faultDomain;
        this.hpcIslandId = hpcIslandId;
        this.networkBlockId = networkBlockId;
        this.localBlockId = localBlockId;
        this.gpuMemoryFabricId = gpuMemoryFabricId;
        this.instanceId = instanceId;
        this.shape = shape;
        this.health = health;
        this.additionalData = additionalData;
        this.lifecycleState = lifecycleState;
        this.lifecycleDetails = lifecycleDetails;
        this.capacityReservationId = capacityReservationId;
        this.impactedComponentDetails = impactedComponentDetails;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.definedTags = definedTags;
        this.displayName = displayName;
        this.freeformTags = freeformTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getAvailabilityDomain() {
        return this.availabilityDomain;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getId() {
        return this.id;
    }

    public String getFaultDomain() {
        return this.faultDomain;
    }

    public String getHpcIslandId() {
        return this.hpcIslandId;
    }

    public String getNetworkBlockId() {
        return this.networkBlockId;
    }

    public String getLocalBlockId() {
        return this.localBlockId;
    }

    public String getGpuMemoryFabricId() {
        return this.gpuMemoryFabricId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getShape() {
        return this.shape;
    }

    public Health getHealth() {
        return this.health;
    }

    public Map<String, Object> getAdditionalData() {
        return this.additionalData;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Map<String, Object> getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public String getCapacityReservationId() {
        return this.capacityReservationId;
    }

    public Map<String, Object> getImpactedComponentDetails() {
        return this.impactedComponentDetails;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ComputeHost(");
        sb.append("super=").append(super.toString());
        sb.append("availabilityDomain=").append(String.valueOf(this.availabilityDomain));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", id=").append(String.valueOf(this.id));
        sb.append(", faultDomain=").append(String.valueOf(this.faultDomain));
        sb.append(", hpcIslandId=").append(String.valueOf(this.hpcIslandId));
        sb.append(", networkBlockId=").append(String.valueOf(this.networkBlockId));
        sb.append(", localBlockId=").append(String.valueOf(this.localBlockId));
        sb.append(", gpuMemoryFabricId=").append(String.valueOf(this.gpuMemoryFabricId));
        sb.append(", instanceId=").append(String.valueOf(this.instanceId));
        sb.append(", shape=").append(String.valueOf(this.shape));
        sb.append(", health=").append(String.valueOf((Object)this.health));
        sb.append(", additionalData=").append(String.valueOf(this.additionalData));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", capacityReservationId=").append(String.valueOf(this.capacityReservationId));
        sb.append(", impactedComponentDetails=").append(String.valueOf(this.impactedComponentDetails));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ComputeHost)) {
            return false;
        }
        ComputeHost other = (ComputeHost)((Object)o);
        return Objects.equals(this.availabilityDomain, other.availabilityDomain) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.id, other.id) && Objects.equals(this.faultDomain, other.faultDomain) && Objects.equals(this.hpcIslandId, other.hpcIslandId) && Objects.equals(this.networkBlockId, other.networkBlockId) && Objects.equals(this.localBlockId, other.localBlockId) && Objects.equals(this.gpuMemoryFabricId, other.gpuMemoryFabricId) && Objects.equals(this.instanceId, other.instanceId) && Objects.equals(this.shape, other.shape) && Objects.equals((Object)this.health, (Object)other.health) && Objects.equals(this.additionalData, other.additionalData) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && Objects.equals(this.capacityReservationId, other.capacityReservationId) && Objects.equals(this.impactedComponentDetails, other.impactedComponentDetails) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.freeformTags, other.freeformTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.availabilityDomain == null ? 43 : this.availabilityDomain.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.faultDomain == null ? 43 : this.faultDomain.hashCode());
        result = result * 59 + (this.hpcIslandId == null ? 43 : this.hpcIslandId.hashCode());
        result = result * 59 + (this.networkBlockId == null ? 43 : this.networkBlockId.hashCode());
        result = result * 59 + (this.localBlockId == null ? 43 : this.localBlockId.hashCode());
        result = result * 59 + (this.gpuMemoryFabricId == null ? 43 : this.gpuMemoryFabricId.hashCode());
        result = result * 59 + (this.instanceId == null ? 43 : this.instanceId.hashCode());
        result = result * 59 + (this.shape == null ? 43 : this.shape.hashCode());
        result = result * 59 + (this.health == null ? 43 : this.health.hashCode());
        result = result * 59 + (this.additionalData == null ? 43 : this.additionalData.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.capacityReservationId == null ? 43 : this.capacityReservationId.hashCode());
        result = result * 59 + (this.impactedComponentDetails == null ? 43 : this.impactedComponentDetails.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Health implements BmcEnum
    {
        Healthy("HEALTHY"),
        Unhealthy("UNHEALTHY"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Health> map;

        private Health(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Health create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Health', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Health.class);
            map = new HashMap<String, Health>();
            for (Health v : Health.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum LifecycleState implements BmcEnum
    {
        Available("AVAILABLE"),
        Occupied("OCCUPIED"),
        Provisioning("PROVISIONING"),
        Repair("REPAIR"),
        Unavailable("UNAVAILABLE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="availabilityDomain")
        private String availabilityDomain;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="faultDomain")
        private String faultDomain;
        @JsonProperty(value="hpcIslandId")
        private String hpcIslandId;
        @JsonProperty(value="networkBlockId")
        private String networkBlockId;
        @JsonProperty(value="localBlockId")
        private String localBlockId;
        @JsonProperty(value="gpuMemoryFabricId")
        private String gpuMemoryFabricId;
        @JsonProperty(value="instanceId")
        private String instanceId;
        @JsonProperty(value="shape")
        private String shape;
        @JsonProperty(value="health")
        private Health health;
        @JsonProperty(value="additionalData")
        private Map<String, Object> additionalData;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="lifecycleDetails")
        private Map<String, Object> lifecycleDetails;
        @JsonProperty(value="capacityReservationId")
        private String capacityReservationId;
        @JsonProperty(value="impactedComponentDetails")
        private Map<String, Object> impactedComponentDetails;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder availabilityDomain(String availabilityDomain) {
            this.availabilityDomain = availabilityDomain;
            this.__explicitlySet__.add("availabilityDomain");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder faultDomain(String faultDomain) {
            this.faultDomain = faultDomain;
            this.__explicitlySet__.add("faultDomain");
            return this;
        }

        public Builder hpcIslandId(String hpcIslandId) {
            this.hpcIslandId = hpcIslandId;
            this.__explicitlySet__.add("hpcIslandId");
            return this;
        }

        public Builder networkBlockId(String networkBlockId) {
            this.networkBlockId = networkBlockId;
            this.__explicitlySet__.add("networkBlockId");
            return this;
        }

        public Builder localBlockId(String localBlockId) {
            this.localBlockId = localBlockId;
            this.__explicitlySet__.add("localBlockId");
            return this;
        }

        public Builder gpuMemoryFabricId(String gpuMemoryFabricId) {
            this.gpuMemoryFabricId = gpuMemoryFabricId;
            this.__explicitlySet__.add("gpuMemoryFabricId");
            return this;
        }

        public Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            this.__explicitlySet__.add("instanceId");
            return this;
        }

        public Builder shape(String shape) {
            this.shape = shape;
            this.__explicitlySet__.add("shape");
            return this;
        }

        public Builder health(Health health) {
            this.health = health;
            this.__explicitlySet__.add("health");
            return this;
        }

        public Builder additionalData(Map<String, Object> additionalData) {
            this.additionalData = additionalData;
            this.__explicitlySet__.add("additionalData");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleDetails(Map<String, Object> lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder capacityReservationId(String capacityReservationId) {
            this.capacityReservationId = capacityReservationId;
            this.__explicitlySet__.add("capacityReservationId");
            return this;
        }

        public Builder impactedComponentDetails(Map<String, Object> impactedComponentDetails) {
            this.impactedComponentDetails = impactedComponentDetails;
            this.__explicitlySet__.add("impactedComponentDetails");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public ComputeHost build() {
            ComputeHost model = new ComputeHost(this.availabilityDomain, this.compartmentId, this.id, this.faultDomain, this.hpcIslandId, this.networkBlockId, this.localBlockId, this.gpuMemoryFabricId, this.instanceId, this.shape, this.health, this.additionalData, this.lifecycleState, this.lifecycleDetails, this.capacityReservationId, this.impactedComponentDetails, this.timeCreated, this.timeUpdated, this.definedTags, this.displayName, this.freeformTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ComputeHost model) {
            if (model.wasPropertyExplicitlySet("availabilityDomain")) {
                this.availabilityDomain(model.getAvailabilityDomain());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("faultDomain")) {
                this.faultDomain(model.getFaultDomain());
            }
            if (model.wasPropertyExplicitlySet("hpcIslandId")) {
                this.hpcIslandId(model.getHpcIslandId());
            }
            if (model.wasPropertyExplicitlySet("networkBlockId")) {
                this.networkBlockId(model.getNetworkBlockId());
            }
            if (model.wasPropertyExplicitlySet("localBlockId")) {
                this.localBlockId(model.getLocalBlockId());
            }
            if (model.wasPropertyExplicitlySet("gpuMemoryFabricId")) {
                this.gpuMemoryFabricId(model.getGpuMemoryFabricId());
            }
            if (model.wasPropertyExplicitlySet("instanceId")) {
                this.instanceId(model.getInstanceId());
            }
            if (model.wasPropertyExplicitlySet("shape")) {
                this.shape(model.getShape());
            }
            if (model.wasPropertyExplicitlySet("health")) {
                this.health(model.getHealth());
            }
            if (model.wasPropertyExplicitlySet("additionalData")) {
                this.additionalData(model.getAdditionalData());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("capacityReservationId")) {
                this.capacityReservationId(model.getCapacityReservationId());
            }
            if (model.wasPropertyExplicitlySet("impactedComponentDetails")) {
                this.impactedComponentDetails(model.getImpactedComponentDetails());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            return this;
        }
    }
}

