/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.core.model.InstanceReservationShapeConfigDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CapacityReservationInstanceSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="availabilityDomain")
    private final String availabilityDomain;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="faultDomain")
    private final String faultDomain;
    @JsonProperty(value="clusterPlacementGroupId")
    private final String clusterPlacementGroupId;
    @JsonProperty(value="shapeConfig")
    private final InstanceReservationShapeConfigDetails shapeConfig;
    @JsonProperty(value="shape")
    private final String shape;

    @Deprecated
    @ConstructorProperties(value={"id", "availabilityDomain", "compartmentId", "faultDomain", "clusterPlacementGroupId", "shapeConfig", "shape"})
    public CapacityReservationInstanceSummary(String id, String availabilityDomain, String compartmentId, String faultDomain, String clusterPlacementGroupId, InstanceReservationShapeConfigDetails shapeConfig, String shape) {
        this.id = id;
        this.availabilityDomain = availabilityDomain;
        this.compartmentId = compartmentId;
        this.faultDomain = faultDomain;
        this.clusterPlacementGroupId = clusterPlacementGroupId;
        this.shapeConfig = shapeConfig;
        this.shape = shape;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getAvailabilityDomain() {
        return this.availabilityDomain;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getFaultDomain() {
        return this.faultDomain;
    }

    public String getClusterPlacementGroupId() {
        return this.clusterPlacementGroupId;
    }

    public InstanceReservationShapeConfigDetails getShapeConfig() {
        return this.shapeConfig;
    }

    public String getShape() {
        return this.shape;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CapacityReservationInstanceSummary(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", availabilityDomain=").append(String.valueOf(this.availabilityDomain));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", faultDomain=").append(String.valueOf(this.faultDomain));
        sb.append(", clusterPlacementGroupId=").append(String.valueOf(this.clusterPlacementGroupId));
        sb.append(", shapeConfig=").append(String.valueOf((Object)this.shapeConfig));
        sb.append(", shape=").append(String.valueOf(this.shape));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CapacityReservationInstanceSummary)) {
            return false;
        }
        CapacityReservationInstanceSummary other = (CapacityReservationInstanceSummary)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.availabilityDomain, other.availabilityDomain) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.faultDomain, other.faultDomain) && Objects.equals(this.clusterPlacementGroupId, other.clusterPlacementGroupId) && Objects.equals((Object)this.shapeConfig, (Object)other.shapeConfig) && Objects.equals(this.shape, other.shape) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.availabilityDomain == null ? 43 : this.availabilityDomain.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.faultDomain == null ? 43 : this.faultDomain.hashCode());
        result = result * 59 + (this.clusterPlacementGroupId == null ? 43 : this.clusterPlacementGroupId.hashCode());
        result = result * 59 + (this.shapeConfig == null ? 43 : this.shapeConfig.hashCode());
        result = result * 59 + (this.shape == null ? 43 : this.shape.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="availabilityDomain")
        private String availabilityDomain;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="faultDomain")
        private String faultDomain;
        @JsonProperty(value="clusterPlacementGroupId")
        private String clusterPlacementGroupId;
        @JsonProperty(value="shapeConfig")
        private InstanceReservationShapeConfigDetails shapeConfig;
        @JsonProperty(value="shape")
        private String shape;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder availabilityDomain(String availabilityDomain) {
            this.availabilityDomain = availabilityDomain;
            this.__explicitlySet__.add("availabilityDomain");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder faultDomain(String faultDomain) {
            this.faultDomain = faultDomain;
            this.__explicitlySet__.add("faultDomain");
            return this;
        }

        public Builder clusterPlacementGroupId(String clusterPlacementGroupId) {
            this.clusterPlacementGroupId = clusterPlacementGroupId;
            this.__explicitlySet__.add("clusterPlacementGroupId");
            return this;
        }

        public Builder shapeConfig(InstanceReservationShapeConfigDetails shapeConfig) {
            this.shapeConfig = shapeConfig;
            this.__explicitlySet__.add("shapeConfig");
            return this;
        }

        public Builder shape(String shape) {
            this.shape = shape;
            this.__explicitlySet__.add("shape");
            return this;
        }

        public CapacityReservationInstanceSummary build() {
            CapacityReservationInstanceSummary model = new CapacityReservationInstanceSummary(this.id, this.availabilityDomain, this.compartmentId, this.faultDomain, this.clusterPlacementGroupId, this.shapeConfig, this.shape);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CapacityReservationInstanceSummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("availabilityDomain")) {
                this.availabilityDomain(model.getAvailabilityDomain());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("faultDomain")) {
                this.faultDomain(model.getFaultDomain());
            }
            if (model.wasPropertyExplicitlySet("clusterPlacementGroupId")) {
                this.clusterPlacementGroupId(model.getClusterPlacementGroupId());
            }
            if (model.wasPropertyExplicitlySet("shapeConfig")) {
                this.shapeConfig(model.getShapeConfig());
            }
            if (model.wasPropertyExplicitlySet("shape")) {
                this.shape(model.getShape());
            }
            return this;
        }
    }
}

