/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.core.VirtualNetwork;
import com.oracle.bmc.core.VirtualNetworkPaginators;
import com.oracle.bmc.core.VirtualNetworkWaiters;
import com.oracle.bmc.core.model.AddedNetworkSecurityGroupSecurityRules;
import com.oracle.bmc.core.model.AllowedIkeIPSecParameters;
import com.oracle.bmc.core.model.Byoasn;
import com.oracle.bmc.core.model.ByoasnCollection;
import com.oracle.bmc.core.model.ByoipAllocatedRangeCollection;
import com.oracle.bmc.core.model.ByoipRange;
import com.oracle.bmc.core.model.ByoipRangeCollection;
import com.oracle.bmc.core.model.CaptureFilter;
import com.oracle.bmc.core.model.Cpe;
import com.oracle.bmc.core.model.CpeDeviceShapeDetail;
import com.oracle.bmc.core.model.CpeDeviceShapeSummary;
import com.oracle.bmc.core.model.CrossConnect;
import com.oracle.bmc.core.model.CrossConnectGroup;
import com.oracle.bmc.core.model.CrossConnectLocation;
import com.oracle.bmc.core.model.CrossConnectMappingDetailsCollection;
import com.oracle.bmc.core.model.CrossConnectPortSpeedShape;
import com.oracle.bmc.core.model.CrossConnectStatus;
import com.oracle.bmc.core.model.DhcpOptions;
import com.oracle.bmc.core.model.Drg;
import com.oracle.bmc.core.model.DrgAttachment;
import com.oracle.bmc.core.model.DrgAttachmentInfo;
import com.oracle.bmc.core.model.DrgRedundancyStatus;
import com.oracle.bmc.core.model.DrgRouteDistribution;
import com.oracle.bmc.core.model.DrgRouteDistributionStatement;
import com.oracle.bmc.core.model.DrgRouteRule;
import com.oracle.bmc.core.model.DrgRouteTable;
import com.oracle.bmc.core.model.FastConnectProviderService;
import com.oracle.bmc.core.model.FastConnectProviderServiceKey;
import com.oracle.bmc.core.model.IPSecConnection;
import com.oracle.bmc.core.model.IPSecConnectionDeviceConfig;
import com.oracle.bmc.core.model.IPSecConnectionDeviceStatus;
import com.oracle.bmc.core.model.IPSecConnectionTunnel;
import com.oracle.bmc.core.model.IPSecConnectionTunnelErrorDetails;
import com.oracle.bmc.core.model.IPSecConnectionTunnelSharedSecret;
import com.oracle.bmc.core.model.InternetGateway;
import com.oracle.bmc.core.model.IpInventoryCidrUtilizationCollection;
import com.oracle.bmc.core.model.IpInventoryCollection;
import com.oracle.bmc.core.model.IpInventorySubnetResourceCollection;
import com.oracle.bmc.core.model.IpInventoryVcnOverlapCollection;
import com.oracle.bmc.core.model.Ipv6;
import com.oracle.bmc.core.model.LetterOfAuthority;
import com.oracle.bmc.core.model.LocalPeeringGateway;
import com.oracle.bmc.core.model.NatGateway;
import com.oracle.bmc.core.model.NetworkSecurityGroup;
import com.oracle.bmc.core.model.NetworkSecurityGroupVnic;
import com.oracle.bmc.core.model.NetworkingTopology;
import com.oracle.bmc.core.model.PeerRegionForRemotePeering;
import com.oracle.bmc.core.model.PrivateIp;
import com.oracle.bmc.core.model.PublicIp;
import com.oracle.bmc.core.model.PublicIpPool;
import com.oracle.bmc.core.model.PublicIpPoolCollection;
import com.oracle.bmc.core.model.RemotePeeringConnection;
import com.oracle.bmc.core.model.RouteTable;
import com.oracle.bmc.core.model.SecurityList;
import com.oracle.bmc.core.model.SecurityRule;
import com.oracle.bmc.core.model.ServiceGateway;
import com.oracle.bmc.core.model.Subnet;
import com.oracle.bmc.core.model.SubnetTopology;
import com.oracle.bmc.core.model.TunnelCpeDeviceConfig;
import com.oracle.bmc.core.model.TunnelRouteSummary;
import com.oracle.bmc.core.model.TunnelSecurityAssociationSummary;
import com.oracle.bmc.core.model.UpdatedNetworkSecurityGroupSecurityRules;
import com.oracle.bmc.core.model.UpgradeStatus;
import com.oracle.bmc.core.model.Vcn;
import com.oracle.bmc.core.model.VcnDnsResolverAssociation;
import com.oracle.bmc.core.model.VcnTopology;
import com.oracle.bmc.core.model.VirtualCircuit;
import com.oracle.bmc.core.model.VirtualCircuitAssociatedTunnelDetails;
import com.oracle.bmc.core.model.VirtualCircuitBandwidthShape;
import com.oracle.bmc.core.model.VirtualCircuitPublicPrefix;
import com.oracle.bmc.core.model.Vlan;
import com.oracle.bmc.core.model.Vnic;
import com.oracle.bmc.core.model.Vtap;
import com.oracle.bmc.core.requests.AddDrgRouteDistributionStatementsRequest;
import com.oracle.bmc.core.requests.AddDrgRouteRulesRequest;
import com.oracle.bmc.core.requests.AddIpv6SubnetCidrRequest;
import com.oracle.bmc.core.requests.AddIpv6VcnCidrRequest;
import com.oracle.bmc.core.requests.AddNetworkSecurityGroupSecurityRulesRequest;
import com.oracle.bmc.core.requests.AddPublicIpPoolCapacityRequest;
import com.oracle.bmc.core.requests.AddVcnCidrRequest;
import com.oracle.bmc.core.requests.AdvertiseByoipRangeRequest;
import com.oracle.bmc.core.requests.AttachServiceIdRequest;
import com.oracle.bmc.core.requests.BulkAddVirtualCircuitPublicPrefixesRequest;
import com.oracle.bmc.core.requests.BulkDeleteVirtualCircuitPublicPrefixesRequest;
import com.oracle.bmc.core.requests.ChangeByoasnCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeByoipRangeCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeCaptureFilterCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeCpeCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeCrossConnectCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeCrossConnectGroupCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeDhcpOptionsCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeDrgCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeIPSecConnectionCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeInternetGatewayCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeLocalPeeringGatewayCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeNatGatewayCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeNetworkSecurityGroupCompartmentRequest;
import com.oracle.bmc.core.requests.ChangePublicIpCompartmentRequest;
import com.oracle.bmc.core.requests.ChangePublicIpPoolCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeRemotePeeringConnectionCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeRouteTableCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeSecurityListCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeServiceGatewayCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeSubnetCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeVcnCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeVirtualCircuitCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeVlanCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeVtapCompartmentRequest;
import com.oracle.bmc.core.requests.ConnectLocalPeeringGatewaysRequest;
import com.oracle.bmc.core.requests.ConnectRemotePeeringConnectionsRequest;
import com.oracle.bmc.core.requests.CreateByoasnRequest;
import com.oracle.bmc.core.requests.CreateByoipRangeRequest;
import com.oracle.bmc.core.requests.CreateCaptureFilterRequest;
import com.oracle.bmc.core.requests.CreateCpeRequest;
import com.oracle.bmc.core.requests.CreateCrossConnectGroupRequest;
import com.oracle.bmc.core.requests.CreateCrossConnectRequest;
import com.oracle.bmc.core.requests.CreateDhcpOptionsRequest;
import com.oracle.bmc.core.requests.CreateDrgAttachmentRequest;
import com.oracle.bmc.core.requests.CreateDrgRequest;
import com.oracle.bmc.core.requests.CreateDrgRouteDistributionRequest;
import com.oracle.bmc.core.requests.CreateDrgRouteTableRequest;
import com.oracle.bmc.core.requests.CreateIPSecConnectionRequest;
import com.oracle.bmc.core.requests.CreateInternetGatewayRequest;
import com.oracle.bmc.core.requests.CreateIpv6Request;
import com.oracle.bmc.core.requests.CreateLocalPeeringGatewayRequest;
import com.oracle.bmc.core.requests.CreateNatGatewayRequest;
import com.oracle.bmc.core.requests.CreateNetworkSecurityGroupRequest;
import com.oracle.bmc.core.requests.CreatePrivateIpRequest;
import com.oracle.bmc.core.requests.CreatePublicIpPoolRequest;
import com.oracle.bmc.core.requests.CreatePublicIpRequest;
import com.oracle.bmc.core.requests.CreateRemotePeeringConnectionRequest;
import com.oracle.bmc.core.requests.CreateRouteTableRequest;
import com.oracle.bmc.core.requests.CreateSecurityListRequest;
import com.oracle.bmc.core.requests.CreateServiceGatewayRequest;
import com.oracle.bmc.core.requests.CreateSubnetRequest;
import com.oracle.bmc.core.requests.CreateVcnRequest;
import com.oracle.bmc.core.requests.CreateVirtualCircuitRequest;
import com.oracle.bmc.core.requests.CreateVlanRequest;
import com.oracle.bmc.core.requests.CreateVtapRequest;
import com.oracle.bmc.core.requests.DeleteByoasnRequest;
import com.oracle.bmc.core.requests.DeleteByoipRangeRequest;
import com.oracle.bmc.core.requests.DeleteCaptureFilterRequest;
import com.oracle.bmc.core.requests.DeleteCpeRequest;
import com.oracle.bmc.core.requests.DeleteCrossConnectGroupRequest;
import com.oracle.bmc.core.requests.DeleteCrossConnectRequest;
import com.oracle.bmc.core.requests.DeleteDhcpOptionsRequest;
import com.oracle.bmc.core.requests.DeleteDrgAttachmentRequest;
import com.oracle.bmc.core.requests.DeleteDrgRequest;
import com.oracle.bmc.core.requests.DeleteDrgRouteDistributionRequest;
import com.oracle.bmc.core.requests.DeleteDrgRouteTableRequest;
import com.oracle.bmc.core.requests.DeleteIPSecConnectionRequest;
import com.oracle.bmc.core.requests.DeleteInternetGatewayRequest;
import com.oracle.bmc.core.requests.DeleteIpv6Request;
import com.oracle.bmc.core.requests.DeleteLocalPeeringGatewayRequest;
import com.oracle.bmc.core.requests.DeleteNatGatewayRequest;
import com.oracle.bmc.core.requests.DeleteNetworkSecurityGroupRequest;
import com.oracle.bmc.core.requests.DeletePrivateIpRequest;
import com.oracle.bmc.core.requests.DeletePublicIpPoolRequest;
import com.oracle.bmc.core.requests.DeletePublicIpRequest;
import com.oracle.bmc.core.requests.DeleteRemotePeeringConnectionRequest;
import com.oracle.bmc.core.requests.DeleteRouteTableRequest;
import com.oracle.bmc.core.requests.DeleteSecurityListRequest;
import com.oracle.bmc.core.requests.DeleteServiceGatewayRequest;
import com.oracle.bmc.core.requests.DeleteSubnetRequest;
import com.oracle.bmc.core.requests.DeleteVcnRequest;
import com.oracle.bmc.core.requests.DeleteVirtualCircuitRequest;
import com.oracle.bmc.core.requests.DeleteVlanRequest;
import com.oracle.bmc.core.requests.DeleteVtapRequest;
import com.oracle.bmc.core.requests.DetachServiceIdRequest;
import com.oracle.bmc.core.requests.GetAllDrgAttachmentsRequest;
import com.oracle.bmc.core.requests.GetAllowedIkeIPSecParametersRequest;
import com.oracle.bmc.core.requests.GetByoasnRequest;
import com.oracle.bmc.core.requests.GetByoipRangeRequest;
import com.oracle.bmc.core.requests.GetCaptureFilterRequest;
import com.oracle.bmc.core.requests.GetCpeDeviceConfigContentRequest;
import com.oracle.bmc.core.requests.GetCpeDeviceShapeRequest;
import com.oracle.bmc.core.requests.GetCpeRequest;
import com.oracle.bmc.core.requests.GetCrossConnectGroupRequest;
import com.oracle.bmc.core.requests.GetCrossConnectLetterOfAuthorityRequest;
import com.oracle.bmc.core.requests.GetCrossConnectRequest;
import com.oracle.bmc.core.requests.GetCrossConnectStatusRequest;
import com.oracle.bmc.core.requests.GetDhcpOptionsRequest;
import com.oracle.bmc.core.requests.GetDrgAttachmentRequest;
import com.oracle.bmc.core.requests.GetDrgRedundancyStatusRequest;
import com.oracle.bmc.core.requests.GetDrgRequest;
import com.oracle.bmc.core.requests.GetDrgRouteDistributionRequest;
import com.oracle.bmc.core.requests.GetDrgRouteTableRequest;
import com.oracle.bmc.core.requests.GetFastConnectProviderServiceKeyRequest;
import com.oracle.bmc.core.requests.GetFastConnectProviderServiceRequest;
import com.oracle.bmc.core.requests.GetIPSecConnectionDeviceConfigRequest;
import com.oracle.bmc.core.requests.GetIPSecConnectionDeviceStatusRequest;
import com.oracle.bmc.core.requests.GetIPSecConnectionRequest;
import com.oracle.bmc.core.requests.GetIPSecConnectionTunnelErrorRequest;
import com.oracle.bmc.core.requests.GetIPSecConnectionTunnelRequest;
import com.oracle.bmc.core.requests.GetIPSecConnectionTunnelSharedSecretRequest;
import com.oracle.bmc.core.requests.GetInternetGatewayRequest;
import com.oracle.bmc.core.requests.GetIpsecCpeDeviceConfigContentRequest;
import com.oracle.bmc.core.requests.GetIpv6Request;
import com.oracle.bmc.core.requests.GetLocalPeeringGatewayRequest;
import com.oracle.bmc.core.requests.GetNatGatewayRequest;
import com.oracle.bmc.core.requests.GetNetworkSecurityGroupRequest;
import com.oracle.bmc.core.requests.GetNetworkingTopologyRequest;
import com.oracle.bmc.core.requests.GetPrivateIpRequest;
import com.oracle.bmc.core.requests.GetPublicIpByIpAddressRequest;
import com.oracle.bmc.core.requests.GetPublicIpByPrivateIpIdRequest;
import com.oracle.bmc.core.requests.GetPublicIpPoolRequest;
import com.oracle.bmc.core.requests.GetPublicIpRequest;
import com.oracle.bmc.core.requests.GetRemotePeeringConnectionRequest;
import com.oracle.bmc.core.requests.GetResourceIpInventoryRequest;
import com.oracle.bmc.core.requests.GetRouteTableRequest;
import com.oracle.bmc.core.requests.GetSecurityListRequest;
import com.oracle.bmc.core.requests.GetServiceGatewayRequest;
import com.oracle.bmc.core.requests.GetServiceRequest;
import com.oracle.bmc.core.requests.GetSubnetCidrUtilizationRequest;
import com.oracle.bmc.core.requests.GetSubnetIpInventoryRequest;
import com.oracle.bmc.core.requests.GetSubnetRequest;
import com.oracle.bmc.core.requests.GetSubnetTopologyRequest;
import com.oracle.bmc.core.requests.GetTunnelCpeDeviceConfigContentRequest;
import com.oracle.bmc.core.requests.GetTunnelCpeDeviceConfigRequest;
import com.oracle.bmc.core.requests.GetUpgradeStatusRequest;
import com.oracle.bmc.core.requests.GetVcnDnsResolverAssociationRequest;
import com.oracle.bmc.core.requests.GetVcnOverlapRequest;
import com.oracle.bmc.core.requests.GetVcnRequest;
import com.oracle.bmc.core.requests.GetVcnTopologyRequest;
import com.oracle.bmc.core.requests.GetVirtualCircuitRequest;
import com.oracle.bmc.core.requests.GetVlanRequest;
import com.oracle.bmc.core.requests.GetVnicRequest;
import com.oracle.bmc.core.requests.GetVtapRequest;
import com.oracle.bmc.core.requests.Ipv6VnicDetachRequest;
import com.oracle.bmc.core.requests.ListAllowedPeerRegionsForRemotePeeringRequest;
import com.oracle.bmc.core.requests.ListByoasnsRequest;
import com.oracle.bmc.core.requests.ListByoipAllocatedRangesRequest;
import com.oracle.bmc.core.requests.ListByoipRangesRequest;
import com.oracle.bmc.core.requests.ListCaptureFiltersRequest;
import com.oracle.bmc.core.requests.ListCpeDeviceShapesRequest;
import com.oracle.bmc.core.requests.ListCpesRequest;
import com.oracle.bmc.core.requests.ListCrossConnectGroupsRequest;
import com.oracle.bmc.core.requests.ListCrossConnectLocationsRequest;
import com.oracle.bmc.core.requests.ListCrossConnectMappingsRequest;
import com.oracle.bmc.core.requests.ListCrossConnectsRequest;
import com.oracle.bmc.core.requests.ListCrossconnectPortSpeedShapesRequest;
import com.oracle.bmc.core.requests.ListDhcpOptionsRequest;
import com.oracle.bmc.core.requests.ListDrgAttachmentsRequest;
import com.oracle.bmc.core.requests.ListDrgRouteDistributionStatementsRequest;
import com.oracle.bmc.core.requests.ListDrgRouteDistributionsRequest;
import com.oracle.bmc.core.requests.ListDrgRouteRulesRequest;
import com.oracle.bmc.core.requests.ListDrgRouteTablesRequest;
import com.oracle.bmc.core.requests.ListDrgsRequest;
import com.oracle.bmc.core.requests.ListFastConnectProviderServicesRequest;
import com.oracle.bmc.core.requests.ListFastConnectProviderVirtualCircuitBandwidthShapesRequest;
import com.oracle.bmc.core.requests.ListIPSecConnectionTunnelRoutesRequest;
import com.oracle.bmc.core.requests.ListIPSecConnectionTunnelSecurityAssociationsRequest;
import com.oracle.bmc.core.requests.ListIPSecConnectionTunnelsRequest;
import com.oracle.bmc.core.requests.ListIPSecConnectionsRequest;
import com.oracle.bmc.core.requests.ListInternetGatewaysRequest;
import com.oracle.bmc.core.requests.ListIpInventoryRequest;
import com.oracle.bmc.core.requests.ListIpv6sRequest;
import com.oracle.bmc.core.requests.ListLocalPeeringGatewaysRequest;
import com.oracle.bmc.core.requests.ListNatGatewaysRequest;
import com.oracle.bmc.core.requests.ListNetworkSecurityGroupSecurityRulesRequest;
import com.oracle.bmc.core.requests.ListNetworkSecurityGroupVnicsRequest;
import com.oracle.bmc.core.requests.ListNetworkSecurityGroupsRequest;
import com.oracle.bmc.core.requests.ListPrivateIpsRequest;
import com.oracle.bmc.core.requests.ListPublicIpPoolsRequest;
import com.oracle.bmc.core.requests.ListPublicIpsRequest;
import com.oracle.bmc.core.requests.ListRemotePeeringConnectionsRequest;
import com.oracle.bmc.core.requests.ListRouteTablesRequest;
import com.oracle.bmc.core.requests.ListSecurityListsRequest;
import com.oracle.bmc.core.requests.ListServiceGatewaysRequest;
import com.oracle.bmc.core.requests.ListServicesRequest;
import com.oracle.bmc.core.requests.ListSubnetsRequest;
import com.oracle.bmc.core.requests.ListVcnsRequest;
import com.oracle.bmc.core.requests.ListVirtualCircuitAssociatedTunnelsRequest;
import com.oracle.bmc.core.requests.ListVirtualCircuitBandwidthShapesRequest;
import com.oracle.bmc.core.requests.ListVirtualCircuitPublicPrefixesRequest;
import com.oracle.bmc.core.requests.ListVirtualCircuitsRequest;
import com.oracle.bmc.core.requests.ListVlansRequest;
import com.oracle.bmc.core.requests.ListVtapsRequest;
import com.oracle.bmc.core.requests.ModifyVcnCidrRequest;
import com.oracle.bmc.core.requests.PrivateIpVnicDetachRequest;
import com.oracle.bmc.core.requests.RemoveDrgRouteDistributionStatementsRequest;
import com.oracle.bmc.core.requests.RemoveDrgRouteRulesRequest;
import com.oracle.bmc.core.requests.RemoveExportDrgRouteDistributionRequest;
import com.oracle.bmc.core.requests.RemoveImportDrgRouteDistributionRequest;
import com.oracle.bmc.core.requests.RemoveIpv6SubnetCidrRequest;
import com.oracle.bmc.core.requests.RemoveIpv6VcnCidrRequest;
import com.oracle.bmc.core.requests.RemoveNetworkSecurityGroupSecurityRulesRequest;
import com.oracle.bmc.core.requests.RemovePublicIpPoolCapacityRequest;
import com.oracle.bmc.core.requests.RemoveVcnCidrRequest;
import com.oracle.bmc.core.requests.SetOriginAsnRequest;
import com.oracle.bmc.core.requests.SetOriginAsnToOracleRequest;
import com.oracle.bmc.core.requests.UpdateByoasnRequest;
import com.oracle.bmc.core.requests.UpdateByoipRangeRequest;
import com.oracle.bmc.core.requests.UpdateCaptureFilterRequest;
import com.oracle.bmc.core.requests.UpdateCpeRequest;
import com.oracle.bmc.core.requests.UpdateCrossConnectGroupRequest;
import com.oracle.bmc.core.requests.UpdateCrossConnectRequest;
import com.oracle.bmc.core.requests.UpdateDhcpOptionsRequest;
import com.oracle.bmc.core.requests.UpdateDrgAttachmentRequest;
import com.oracle.bmc.core.requests.UpdateDrgRequest;
import com.oracle.bmc.core.requests.UpdateDrgRouteDistributionRequest;
import com.oracle.bmc.core.requests.UpdateDrgRouteDistributionStatementsRequest;
import com.oracle.bmc.core.requests.UpdateDrgRouteRulesRequest;
import com.oracle.bmc.core.requests.UpdateDrgRouteTableRequest;
import com.oracle.bmc.core.requests.UpdateIPSecConnectionRequest;
import com.oracle.bmc.core.requests.UpdateIPSecConnectionTunnelRequest;
import com.oracle.bmc.core.requests.UpdateIPSecConnectionTunnelSharedSecretRequest;
import com.oracle.bmc.core.requests.UpdateInternetGatewayRequest;
import com.oracle.bmc.core.requests.UpdateIpv6Request;
import com.oracle.bmc.core.requests.UpdateLocalPeeringGatewayRequest;
import com.oracle.bmc.core.requests.UpdateNatGatewayRequest;
import com.oracle.bmc.core.requests.UpdateNetworkSecurityGroupRequest;
import com.oracle.bmc.core.requests.UpdateNetworkSecurityGroupSecurityRulesRequest;
import com.oracle.bmc.core.requests.UpdatePrivateIpRequest;
import com.oracle.bmc.core.requests.UpdatePublicIpPoolRequest;
import com.oracle.bmc.core.requests.UpdatePublicIpRequest;
import com.oracle.bmc.core.requests.UpdateRemotePeeringConnectionRequest;
import com.oracle.bmc.core.requests.UpdateRouteTableRequest;
import com.oracle.bmc.core.requests.UpdateSecurityListRequest;
import com.oracle.bmc.core.requests.UpdateServiceGatewayRequest;
import com.oracle.bmc.core.requests.UpdateSubnetRequest;
import com.oracle.bmc.core.requests.UpdateTunnelCpeDeviceConfigRequest;
import com.oracle.bmc.core.requests.UpdateVcnRequest;
import com.oracle.bmc.core.requests.UpdateVirtualCircuitRequest;
import com.oracle.bmc.core.requests.UpdateVlanRequest;
import com.oracle.bmc.core.requests.UpdateVnicRequest;
import com.oracle.bmc.core.requests.UpdateVtapRequest;
import com.oracle.bmc.core.requests.UpgradeDrgRequest;
import com.oracle.bmc.core.requests.ValidateByoasnRequest;
import com.oracle.bmc.core.requests.ValidateByoipRangeRequest;
import com.oracle.bmc.core.requests.WithdrawByoipRangeRequest;
import com.oracle.bmc.core.responses.AddDrgRouteDistributionStatementsResponse;
import com.oracle.bmc.core.responses.AddDrgRouteRulesResponse;
import com.oracle.bmc.core.responses.AddIpv6SubnetCidrResponse;
import com.oracle.bmc.core.responses.AddIpv6VcnCidrResponse;
import com.oracle.bmc.core.responses.AddNetworkSecurityGroupSecurityRulesResponse;
import com.oracle.bmc.core.responses.AddPublicIpPoolCapacityResponse;
import com.oracle.bmc.core.responses.AddVcnCidrResponse;
import com.oracle.bmc.core.responses.AdvertiseByoipRangeResponse;
import com.oracle.bmc.core.responses.AttachServiceIdResponse;
import com.oracle.bmc.core.responses.BulkAddVirtualCircuitPublicPrefixesResponse;
import com.oracle.bmc.core.responses.BulkDeleteVirtualCircuitPublicPrefixesResponse;
import com.oracle.bmc.core.responses.ChangeByoasnCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeByoipRangeCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeCaptureFilterCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeCpeCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeCrossConnectCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeCrossConnectGroupCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeDhcpOptionsCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeDrgCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeIPSecConnectionCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeInternetGatewayCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeLocalPeeringGatewayCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeNatGatewayCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeNetworkSecurityGroupCompartmentResponse;
import com.oracle.bmc.core.responses.ChangePublicIpCompartmentResponse;
import com.oracle.bmc.core.responses.ChangePublicIpPoolCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeRemotePeeringConnectionCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeRouteTableCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeSecurityListCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeServiceGatewayCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeSubnetCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeVcnCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeVirtualCircuitCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeVlanCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeVtapCompartmentResponse;
import com.oracle.bmc.core.responses.ConnectLocalPeeringGatewaysResponse;
import com.oracle.bmc.core.responses.ConnectRemotePeeringConnectionsResponse;
import com.oracle.bmc.core.responses.CreateByoasnResponse;
import com.oracle.bmc.core.responses.CreateByoipRangeResponse;
import com.oracle.bmc.core.responses.CreateCaptureFilterResponse;
import com.oracle.bmc.core.responses.CreateCpeResponse;
import com.oracle.bmc.core.responses.CreateCrossConnectGroupResponse;
import com.oracle.bmc.core.responses.CreateCrossConnectResponse;
import com.oracle.bmc.core.responses.CreateDhcpOptionsResponse;
import com.oracle.bmc.core.responses.CreateDrgAttachmentResponse;
import com.oracle.bmc.core.responses.CreateDrgResponse;
import com.oracle.bmc.core.responses.CreateDrgRouteDistributionResponse;
import com.oracle.bmc.core.responses.CreateDrgRouteTableResponse;
import com.oracle.bmc.core.responses.CreateIPSecConnectionResponse;
import com.oracle.bmc.core.responses.CreateInternetGatewayResponse;
import com.oracle.bmc.core.responses.CreateIpv6Response;
import com.oracle.bmc.core.responses.CreateLocalPeeringGatewayResponse;
import com.oracle.bmc.core.responses.CreateNatGatewayResponse;
import com.oracle.bmc.core.responses.CreateNetworkSecurityGroupResponse;
import com.oracle.bmc.core.responses.CreatePrivateIpResponse;
import com.oracle.bmc.core.responses.CreatePublicIpPoolResponse;
import com.oracle.bmc.core.responses.CreatePublicIpResponse;
import com.oracle.bmc.core.responses.CreateRemotePeeringConnectionResponse;
import com.oracle.bmc.core.responses.CreateRouteTableResponse;
import com.oracle.bmc.core.responses.CreateSecurityListResponse;
import com.oracle.bmc.core.responses.CreateServiceGatewayResponse;
import com.oracle.bmc.core.responses.CreateSubnetResponse;
import com.oracle.bmc.core.responses.CreateVcnResponse;
import com.oracle.bmc.core.responses.CreateVirtualCircuitResponse;
import com.oracle.bmc.core.responses.CreateVlanResponse;
import com.oracle.bmc.core.responses.CreateVtapResponse;
import com.oracle.bmc.core.responses.DeleteByoasnResponse;
import com.oracle.bmc.core.responses.DeleteByoipRangeResponse;
import com.oracle.bmc.core.responses.DeleteCaptureFilterResponse;
import com.oracle.bmc.core.responses.DeleteCpeResponse;
import com.oracle.bmc.core.responses.DeleteCrossConnectGroupResponse;
import com.oracle.bmc.core.responses.DeleteCrossConnectResponse;
import com.oracle.bmc.core.responses.DeleteDhcpOptionsResponse;
import com.oracle.bmc.core.responses.DeleteDrgAttachmentResponse;
import com.oracle.bmc.core.responses.DeleteDrgResponse;
import com.oracle.bmc.core.responses.DeleteDrgRouteDistributionResponse;
import com.oracle.bmc.core.responses.DeleteDrgRouteTableResponse;
import com.oracle.bmc.core.responses.DeleteIPSecConnectionResponse;
import com.oracle.bmc.core.responses.DeleteInternetGatewayResponse;
import com.oracle.bmc.core.responses.DeleteIpv6Response;
import com.oracle.bmc.core.responses.DeleteLocalPeeringGatewayResponse;
import com.oracle.bmc.core.responses.DeleteNatGatewayResponse;
import com.oracle.bmc.core.responses.DeleteNetworkSecurityGroupResponse;
import com.oracle.bmc.core.responses.DeletePrivateIpResponse;
import com.oracle.bmc.core.responses.DeletePublicIpPoolResponse;
import com.oracle.bmc.core.responses.DeletePublicIpResponse;
import com.oracle.bmc.core.responses.DeleteRemotePeeringConnectionResponse;
import com.oracle.bmc.core.responses.DeleteRouteTableResponse;
import com.oracle.bmc.core.responses.DeleteSecurityListResponse;
import com.oracle.bmc.core.responses.DeleteServiceGatewayResponse;
import com.oracle.bmc.core.responses.DeleteSubnetResponse;
import com.oracle.bmc.core.responses.DeleteVcnResponse;
import com.oracle.bmc.core.responses.DeleteVirtualCircuitResponse;
import com.oracle.bmc.core.responses.DeleteVlanResponse;
import com.oracle.bmc.core.responses.DeleteVtapResponse;
import com.oracle.bmc.core.responses.DetachServiceIdResponse;
import com.oracle.bmc.core.responses.GetAllDrgAttachmentsResponse;
import com.oracle.bmc.core.responses.GetAllowedIkeIPSecParametersResponse;
import com.oracle.bmc.core.responses.GetByoasnResponse;
import com.oracle.bmc.core.responses.GetByoipRangeResponse;
import com.oracle.bmc.core.responses.GetCaptureFilterResponse;
import com.oracle.bmc.core.responses.GetCpeDeviceConfigContentResponse;
import com.oracle.bmc.core.responses.GetCpeDeviceShapeResponse;
import com.oracle.bmc.core.responses.GetCpeResponse;
import com.oracle.bmc.core.responses.GetCrossConnectGroupResponse;
import com.oracle.bmc.core.responses.GetCrossConnectLetterOfAuthorityResponse;
import com.oracle.bmc.core.responses.GetCrossConnectResponse;
import com.oracle.bmc.core.responses.GetCrossConnectStatusResponse;
import com.oracle.bmc.core.responses.GetDhcpOptionsResponse;
import com.oracle.bmc.core.responses.GetDrgAttachmentResponse;
import com.oracle.bmc.core.responses.GetDrgRedundancyStatusResponse;
import com.oracle.bmc.core.responses.GetDrgResponse;
import com.oracle.bmc.core.responses.GetDrgRouteDistributionResponse;
import com.oracle.bmc.core.responses.GetDrgRouteTableResponse;
import com.oracle.bmc.core.responses.GetFastConnectProviderServiceKeyResponse;
import com.oracle.bmc.core.responses.GetFastConnectProviderServiceResponse;
import com.oracle.bmc.core.responses.GetIPSecConnectionDeviceConfigResponse;
import com.oracle.bmc.core.responses.GetIPSecConnectionDeviceStatusResponse;
import com.oracle.bmc.core.responses.GetIPSecConnectionResponse;
import com.oracle.bmc.core.responses.GetIPSecConnectionTunnelErrorResponse;
import com.oracle.bmc.core.responses.GetIPSecConnectionTunnelResponse;
import com.oracle.bmc.core.responses.GetIPSecConnectionTunnelSharedSecretResponse;
import com.oracle.bmc.core.responses.GetInternetGatewayResponse;
import com.oracle.bmc.core.responses.GetIpsecCpeDeviceConfigContentResponse;
import com.oracle.bmc.core.responses.GetIpv6Response;
import com.oracle.bmc.core.responses.GetLocalPeeringGatewayResponse;
import com.oracle.bmc.core.responses.GetNatGatewayResponse;
import com.oracle.bmc.core.responses.GetNetworkSecurityGroupResponse;
import com.oracle.bmc.core.responses.GetNetworkingTopologyResponse;
import com.oracle.bmc.core.responses.GetPrivateIpResponse;
import com.oracle.bmc.core.responses.GetPublicIpByIpAddressResponse;
import com.oracle.bmc.core.responses.GetPublicIpByPrivateIpIdResponse;
import com.oracle.bmc.core.responses.GetPublicIpPoolResponse;
import com.oracle.bmc.core.responses.GetPublicIpResponse;
import com.oracle.bmc.core.responses.GetRemotePeeringConnectionResponse;
import com.oracle.bmc.core.responses.GetResourceIpInventoryResponse;
import com.oracle.bmc.core.responses.GetRouteTableResponse;
import com.oracle.bmc.core.responses.GetSecurityListResponse;
import com.oracle.bmc.core.responses.GetServiceGatewayResponse;
import com.oracle.bmc.core.responses.GetServiceResponse;
import com.oracle.bmc.core.responses.GetSubnetCidrUtilizationResponse;
import com.oracle.bmc.core.responses.GetSubnetIpInventoryResponse;
import com.oracle.bmc.core.responses.GetSubnetResponse;
import com.oracle.bmc.core.responses.GetSubnetTopologyResponse;
import com.oracle.bmc.core.responses.GetTunnelCpeDeviceConfigContentResponse;
import com.oracle.bmc.core.responses.GetTunnelCpeDeviceConfigResponse;
import com.oracle.bmc.core.responses.GetUpgradeStatusResponse;
import com.oracle.bmc.core.responses.GetVcnDnsResolverAssociationResponse;
import com.oracle.bmc.core.responses.GetVcnOverlapResponse;
import com.oracle.bmc.core.responses.GetVcnResponse;
import com.oracle.bmc.core.responses.GetVcnTopologyResponse;
import com.oracle.bmc.core.responses.GetVirtualCircuitResponse;
import com.oracle.bmc.core.responses.GetVlanResponse;
import com.oracle.bmc.core.responses.GetVnicResponse;
import com.oracle.bmc.core.responses.GetVtapResponse;
import com.oracle.bmc.core.responses.Ipv6VnicDetachResponse;
import com.oracle.bmc.core.responses.ListAllowedPeerRegionsForRemotePeeringResponse;
import com.oracle.bmc.core.responses.ListByoasnsResponse;
import com.oracle.bmc.core.responses.ListByoipAllocatedRangesResponse;
import com.oracle.bmc.core.responses.ListByoipRangesResponse;
import com.oracle.bmc.core.responses.ListCaptureFiltersResponse;
import com.oracle.bmc.core.responses.ListCpeDeviceShapesResponse;
import com.oracle.bmc.core.responses.ListCpesResponse;
import com.oracle.bmc.core.responses.ListCrossConnectGroupsResponse;
import com.oracle.bmc.core.responses.ListCrossConnectLocationsResponse;
import com.oracle.bmc.core.responses.ListCrossConnectMappingsResponse;
import com.oracle.bmc.core.responses.ListCrossConnectsResponse;
import com.oracle.bmc.core.responses.ListCrossconnectPortSpeedShapesResponse;
import com.oracle.bmc.core.responses.ListDhcpOptionsResponse;
import com.oracle.bmc.core.responses.ListDrgAttachmentsResponse;
import com.oracle.bmc.core.responses.ListDrgRouteDistributionStatementsResponse;
import com.oracle.bmc.core.responses.ListDrgRouteDistributionsResponse;
import com.oracle.bmc.core.responses.ListDrgRouteRulesResponse;
import com.oracle.bmc.core.responses.ListDrgRouteTablesResponse;
import com.oracle.bmc.core.responses.ListDrgsResponse;
import com.oracle.bmc.core.responses.ListFastConnectProviderServicesResponse;
import com.oracle.bmc.core.responses.ListFastConnectProviderVirtualCircuitBandwidthShapesResponse;
import com.oracle.bmc.core.responses.ListIPSecConnectionTunnelRoutesResponse;
import com.oracle.bmc.core.responses.ListIPSecConnectionTunnelSecurityAssociationsResponse;
import com.oracle.bmc.core.responses.ListIPSecConnectionTunnelsResponse;
import com.oracle.bmc.core.responses.ListIPSecConnectionsResponse;
import com.oracle.bmc.core.responses.ListInternetGatewaysResponse;
import com.oracle.bmc.core.responses.ListIpInventoryResponse;
import com.oracle.bmc.core.responses.ListIpv6sResponse;
import com.oracle.bmc.core.responses.ListLocalPeeringGatewaysResponse;
import com.oracle.bmc.core.responses.ListNatGatewaysResponse;
import com.oracle.bmc.core.responses.ListNetworkSecurityGroupSecurityRulesResponse;
import com.oracle.bmc.core.responses.ListNetworkSecurityGroupVnicsResponse;
import com.oracle.bmc.core.responses.ListNetworkSecurityGroupsResponse;
import com.oracle.bmc.core.responses.ListPrivateIpsResponse;
import com.oracle.bmc.core.responses.ListPublicIpPoolsResponse;
import com.oracle.bmc.core.responses.ListPublicIpsResponse;
import com.oracle.bmc.core.responses.ListRemotePeeringConnectionsResponse;
import com.oracle.bmc.core.responses.ListRouteTablesResponse;
import com.oracle.bmc.core.responses.ListSecurityListsResponse;
import com.oracle.bmc.core.responses.ListServiceGatewaysResponse;
import com.oracle.bmc.core.responses.ListServicesResponse;
import com.oracle.bmc.core.responses.ListSubnetsResponse;
import com.oracle.bmc.core.responses.ListVcnsResponse;
import com.oracle.bmc.core.responses.ListVirtualCircuitAssociatedTunnelsResponse;
import com.oracle.bmc.core.responses.ListVirtualCircuitBandwidthShapesResponse;
import com.oracle.bmc.core.responses.ListVirtualCircuitPublicPrefixesResponse;
import com.oracle.bmc.core.responses.ListVirtualCircuitsResponse;
import com.oracle.bmc.core.responses.ListVlansResponse;
import com.oracle.bmc.core.responses.ListVtapsResponse;
import com.oracle.bmc.core.responses.ModifyVcnCidrResponse;
import com.oracle.bmc.core.responses.PrivateIpVnicDetachResponse;
import com.oracle.bmc.core.responses.RemoveDrgRouteDistributionStatementsResponse;
import com.oracle.bmc.core.responses.RemoveDrgRouteRulesResponse;
import com.oracle.bmc.core.responses.RemoveExportDrgRouteDistributionResponse;
import com.oracle.bmc.core.responses.RemoveImportDrgRouteDistributionResponse;
import com.oracle.bmc.core.responses.RemoveIpv6SubnetCidrResponse;
import com.oracle.bmc.core.responses.RemoveIpv6VcnCidrResponse;
import com.oracle.bmc.core.responses.RemoveNetworkSecurityGroupSecurityRulesResponse;
import com.oracle.bmc.core.responses.RemovePublicIpPoolCapacityResponse;
import com.oracle.bmc.core.responses.RemoveVcnCidrResponse;
import com.oracle.bmc.core.responses.SetOriginAsnResponse;
import com.oracle.bmc.core.responses.SetOriginAsnToOracleResponse;
import com.oracle.bmc.core.responses.UpdateByoasnResponse;
import com.oracle.bmc.core.responses.UpdateByoipRangeResponse;
import com.oracle.bmc.core.responses.UpdateCaptureFilterResponse;
import com.oracle.bmc.core.responses.UpdateCpeResponse;
import com.oracle.bmc.core.responses.UpdateCrossConnectGroupResponse;
import com.oracle.bmc.core.responses.UpdateCrossConnectResponse;
import com.oracle.bmc.core.responses.UpdateDhcpOptionsResponse;
import com.oracle.bmc.core.responses.UpdateDrgAttachmentResponse;
import com.oracle.bmc.core.responses.UpdateDrgResponse;
import com.oracle.bmc.core.responses.UpdateDrgRouteDistributionResponse;
import com.oracle.bmc.core.responses.UpdateDrgRouteDistributionStatementsResponse;
import com.oracle.bmc.core.responses.UpdateDrgRouteRulesResponse;
import com.oracle.bmc.core.responses.UpdateDrgRouteTableResponse;
import com.oracle.bmc.core.responses.UpdateIPSecConnectionResponse;
import com.oracle.bmc.core.responses.UpdateIPSecConnectionTunnelResponse;
import com.oracle.bmc.core.responses.UpdateIPSecConnectionTunnelSharedSecretResponse;
import com.oracle.bmc.core.responses.UpdateInternetGatewayResponse;
import com.oracle.bmc.core.responses.UpdateIpv6Response;
import com.oracle.bmc.core.responses.UpdateLocalPeeringGatewayResponse;
import com.oracle.bmc.core.responses.UpdateNatGatewayResponse;
import com.oracle.bmc.core.responses.UpdateNetworkSecurityGroupResponse;
import com.oracle.bmc.core.responses.UpdateNetworkSecurityGroupSecurityRulesResponse;
import com.oracle.bmc.core.responses.UpdatePrivateIpResponse;
import com.oracle.bmc.core.responses.UpdatePublicIpPoolResponse;
import com.oracle.bmc.core.responses.UpdatePublicIpResponse;
import com.oracle.bmc.core.responses.UpdateRemotePeeringConnectionResponse;
import com.oracle.bmc.core.responses.UpdateRouteTableResponse;
import com.oracle.bmc.core.responses.UpdateSecurityListResponse;
import com.oracle.bmc.core.responses.UpdateServiceGatewayResponse;
import com.oracle.bmc.core.responses.UpdateSubnetResponse;
import com.oracle.bmc.core.responses.UpdateTunnelCpeDeviceConfigResponse;
import com.oracle.bmc.core.responses.UpdateVcnResponse;
import com.oracle.bmc.core.responses.UpdateVirtualCircuitResponse;
import com.oracle.bmc.core.responses.UpdateVlanResponse;
import com.oracle.bmc.core.responses.UpdateVnicResponse;
import com.oracle.bmc.core.responses.UpdateVtapResponse;
import com.oracle.bmc.core.responses.UpgradeDrgResponse;
import com.oracle.bmc.core.responses.ValidateByoasnResponse;
import com.oracle.bmc.core.responses.ValidateByoipRangeResponse;
import com.oracle.bmc.core.responses.WithdrawByoipRangeResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.StreamUtils;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.workrequests.WorkRequest;
import jakarta.annotation.Nonnull;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualNetworkClient
extends BaseSyncClient
implements VirtualNetwork {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("VIRTUALNETWORK").serviceEndpointPrefix("iaas").serviceEndpointTemplate("https://iaas.{region}.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(VirtualNetworkClient.class);
    protected final ExecutorService executorService;
    private final VirtualNetworkWaiters waiters;
    private final VirtualNetworkPaginators paginators;

    VirtualNetworkClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        this(builder, authenticationDetailsProvider, executorService, true);
    }

    VirtualNetworkClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService, boolean isStreamWarningEnabled) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("VirtualNetwork-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.executorService = executorService;
        this.waiters = new VirtualNetworkWaiters(executorService, this);
        this.paginators = new VirtualNetworkPaginators(this);
        if (isStreamWarningEnabled && StreamUtils.isExtraStreamLogsEnabled()) {
            LOG.warn(StreamUtils.getStreamWarningMessage((String)"VirtualNetworkClient", (String)"getCpeDeviceConfigContent,getIpsecCpeDeviceConfigContent,getTunnelCpeDeviceConfigContent"));
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public AddDrgRouteDistributionStatementsResponse addDrgRouteDistributionStatements(AddDrgRouteDistributionStatementsRequest request) {
        Validate.notBlank((String)request.getDrgRouteDistributionId(), (String)"drgRouteDistributionId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getAddDrgRouteDistributionStatementsDetails(), "addDrgRouteDistributionStatementsDetails is required");
        return (AddDrgRouteDistributionStatementsResponse)this.clientCall(request, AddDrgRouteDistributionStatementsResponse::builder).logger(LOG, "addDrgRouteDistributionStatements").serviceDetails("VirtualNetwork", "AddDrgRouteDistributionStatements", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/DrgRouteDistributionStatement/AddDrgRouteDistributionStatements").method(Method.POST).requestBuilder(AddDrgRouteDistributionStatementsRequest::builder).basePath("/20160918").appendPathParam("drgRouteDistributions").appendPathParam(request.getDrgRouteDistributionId()).appendPathParam("actions").appendPathParam("addDrgRouteDistributionStatements").accept(new String[]{"application/json"}).hasBody().handleBodyList(DrgRouteDistributionStatement.class, AddDrgRouteDistributionStatementsResponse.Builder::items).handleResponseHeaderString("opc-request-id", AddDrgRouteDistributionStatementsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public AddDrgRouteRulesResponse addDrgRouteRules(AddDrgRouteRulesRequest request) {
        Validate.notBlank((String)request.getDrgRouteTableId(), (String)"drgRouteTableId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getAddDrgRouteRulesDetails(), "addDrgRouteRulesDetails is required");
        return (AddDrgRouteRulesResponse)this.clientCall(request, AddDrgRouteRulesResponse::builder).logger(LOG, "addDrgRouteRules").serviceDetails("VirtualNetwork", "AddDrgRouteRules", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/DrgRouteRule/AddDrgRouteRules").method(Method.POST).requestBuilder(AddDrgRouteRulesRequest::builder).basePath("/20160918").appendPathParam("drgRouteTables").appendPathParam(request.getDrgRouteTableId()).appendPathParam("actions").appendPathParam("addDrgRouteRules").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBodyList(DrgRouteRule.class, AddDrgRouteRulesResponse.Builder::items).handleResponseHeaderString("opc-request-id", AddDrgRouteRulesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public AddIpv6SubnetCidrResponse addIpv6SubnetCidr(AddIpv6SubnetCidrRequest request) {
        Validate.notBlank((String)request.getSubnetId(), (String)"subnetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getAddSubnetIpv6CidrDetails(), "addSubnetIpv6CidrDetails is required");
        return (AddIpv6SubnetCidrResponse)this.clientCall(request, AddIpv6SubnetCidrResponse::builder).logger(LOG, "addIpv6SubnetCidr").serviceDetails("VirtualNetwork", "AddIpv6SubnetCidr", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Subnet/AddIpv6SubnetCidr").method(Method.POST).requestBuilder(AddIpv6SubnetCidrRequest::builder).basePath("/20160918").appendPathParam("subnets").appendPathParam(request.getSubnetId()).appendPathParam("actions").appendPathParam("addIpv6Cidr").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("etag", AddIpv6SubnetCidrResponse.Builder::etag).handleResponseHeaderString("opc-request-id", AddIpv6SubnetCidrResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", AddIpv6SubnetCidrResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public AddIpv6VcnCidrResponse addIpv6VcnCidr(AddIpv6VcnCidrRequest request) {
        Validate.notBlank((String)request.getVcnId(), (String)"vcnId must not be blank", (Object[])new Object[0]);
        return (AddIpv6VcnCidrResponse)this.clientCall(request, AddIpv6VcnCidrResponse::builder).logger(LOG, "addIpv6VcnCidr").serviceDetails("VirtualNetwork", "AddIpv6VcnCidr", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Vcn/AddIpv6VcnCidr").method(Method.POST).requestBuilder(AddIpv6VcnCidrRequest::builder).basePath("/20160918").appendPathParam("vcns").appendPathParam(request.getVcnId()).appendPathParam("actions").appendPathParam("addIpv6Cidr").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", AddIpv6VcnCidrResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", AddIpv6VcnCidrResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public AddNetworkSecurityGroupSecurityRulesResponse addNetworkSecurityGroupSecurityRules(AddNetworkSecurityGroupSecurityRulesRequest request) {
        Validate.notBlank((String)request.getNetworkSecurityGroupId(), (String)"networkSecurityGroupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getAddNetworkSecurityGroupSecurityRulesDetails(), "addNetworkSecurityGroupSecurityRulesDetails is required");
        return (AddNetworkSecurityGroupSecurityRulesResponse)this.clientCall(request, AddNetworkSecurityGroupSecurityRulesResponse::builder).logger(LOG, "addNetworkSecurityGroupSecurityRules").serviceDetails("VirtualNetwork", "AddNetworkSecurityGroupSecurityRules", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/SecurityRule/AddNetworkSecurityGroupSecurityRules").method(Method.POST).requestBuilder(AddNetworkSecurityGroupSecurityRulesRequest::builder).basePath("/20160918").appendPathParam("networkSecurityGroups").appendPathParam(request.getNetworkSecurityGroupId()).appendPathParam("actions").appendPathParam("addSecurityRules").accept(new String[]{"application/json"}).hasBody().handleBody(AddedNetworkSecurityGroupSecurityRules.class, AddNetworkSecurityGroupSecurityRulesResponse.Builder::addedNetworkSecurityGroupSecurityRules).handleResponseHeaderString("opc-request-id", AddNetworkSecurityGroupSecurityRulesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public AddPublicIpPoolCapacityResponse addPublicIpPoolCapacity(AddPublicIpPoolCapacityRequest request) {
        Validate.notBlank((String)request.getPublicIpPoolId(), (String)"publicIpPoolId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getAddPublicIpPoolCapacityDetails(), "addPublicIpPoolCapacityDetails is required");
        return (AddPublicIpPoolCapacityResponse)this.clientCall(request, AddPublicIpPoolCapacityResponse::builder).logger(LOG, "addPublicIpPoolCapacity").serviceDetails("VirtualNetwork", "AddPublicIpPoolCapacity", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/PublicIpPool/AddPublicIpPoolCapacity").method(Method.POST).requestBuilder(AddPublicIpPoolCapacityRequest::builder).basePath("/20160918").appendPathParam("publicIpPools").appendPathParam(request.getPublicIpPoolId()).appendPathParam("actions").appendPathParam("addCapacity").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(PublicIpPool.class, AddPublicIpPoolCapacityResponse.Builder::publicIpPool).handleResponseHeaderString("etag", AddPublicIpPoolCapacityResponse.Builder::etag).handleResponseHeaderString("opc-request-id", AddPublicIpPoolCapacityResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public AddVcnCidrResponse addVcnCidr(AddVcnCidrRequest request) {
        Validate.notBlank((String)request.getVcnId(), (String)"vcnId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getAddVcnCidrDetails(), "addVcnCidrDetails is required");
        return (AddVcnCidrResponse)this.clientCall(request, AddVcnCidrResponse::builder).logger(LOG, "addVcnCidr").serviceDetails("VirtualNetwork", "AddVcnCidr", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Vcn/AddVcnCidr").method(Method.POST).requestBuilder(AddVcnCidrRequest::builder).basePath("/20160918").appendPathParam("vcns").appendPathParam(request.getVcnId()).appendPathParam("actions").appendPathParam("addCidr").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", AddVcnCidrResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", AddVcnCidrResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public AdvertiseByoipRangeResponse advertiseByoipRange(AdvertiseByoipRangeRequest request) {
        Validate.notBlank((String)request.getByoipRangeId(), (String)"byoipRangeId must not be blank", (Object[])new Object[0]);
        return (AdvertiseByoipRangeResponse)this.clientCall(request, AdvertiseByoipRangeResponse::builder).logger(LOG, "advertiseByoipRange").serviceDetails("VirtualNetwork", "AdvertiseByoipRange", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ByoipRange/AdvertiseByoipRange").method(Method.POST).requestBuilder(AdvertiseByoipRangeRequest::builder).basePath("/20160918").appendPathParam("byoipRanges").appendPathParam(request.getByoipRangeId()).appendPathParam("actions").appendPathParam("advertise").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", AdvertiseByoipRangeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public AttachServiceIdResponse attachServiceId(AttachServiceIdRequest request) {
        Validate.notBlank((String)request.getServiceGatewayId(), (String)"serviceGatewayId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getAttachServiceDetails(), "attachServiceDetails is required");
        return (AttachServiceIdResponse)this.clientCall(request, AttachServiceIdResponse::builder).logger(LOG, "attachServiceId").serviceDetails("VirtualNetwork", "AttachServiceId", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ServiceGateway/AttachServiceId").method(Method.POST).requestBuilder(AttachServiceIdRequest::builder).basePath("/20160918").appendPathParam("serviceGateways").appendPathParam(request.getServiceGatewayId()).appendPathParam("actions").appendPathParam("attachService").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(ServiceGateway.class, AttachServiceIdResponse.Builder::serviceGateway).handleResponseHeaderString("opc-request-id", AttachServiceIdResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public BulkAddVirtualCircuitPublicPrefixesResponse bulkAddVirtualCircuitPublicPrefixes(BulkAddVirtualCircuitPublicPrefixesRequest request) {
        Validate.notBlank((String)request.getVirtualCircuitId(), (String)"virtualCircuitId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getBulkAddVirtualCircuitPublicPrefixesDetails(), "bulkAddVirtualCircuitPublicPrefixesDetails is required");
        return (BulkAddVirtualCircuitPublicPrefixesResponse)this.clientCall(request, BulkAddVirtualCircuitPublicPrefixesResponse::builder).logger(LOG, "bulkAddVirtualCircuitPublicPrefixes").serviceDetails("VirtualNetwork", "BulkAddVirtualCircuitPublicPrefixes", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/VirtualCircuitPublicPrefix/BulkAddVirtualCircuitPublicPrefixes").method(Method.POST).requestBuilder(BulkAddVirtualCircuitPublicPrefixesRequest::builder).basePath("/20160918").appendPathParam("virtualCircuits").appendPathParam(request.getVirtualCircuitId()).appendPathParam("actions").appendPathParam("bulkAddPublicPrefixes").accept(new String[]{"application/json"}).operationUsesDefaultRetries().hasBody().callSync();
    }

    @Override
    public BulkDeleteVirtualCircuitPublicPrefixesResponse bulkDeleteVirtualCircuitPublicPrefixes(BulkDeleteVirtualCircuitPublicPrefixesRequest request) {
        Validate.notBlank((String)request.getVirtualCircuitId(), (String)"virtualCircuitId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getBulkDeleteVirtualCircuitPublicPrefixesDetails(), "bulkDeleteVirtualCircuitPublicPrefixesDetails is required");
        return (BulkDeleteVirtualCircuitPublicPrefixesResponse)this.clientCall(request, BulkDeleteVirtualCircuitPublicPrefixesResponse::builder).logger(LOG, "bulkDeleteVirtualCircuitPublicPrefixes").serviceDetails("VirtualNetwork", "BulkDeleteVirtualCircuitPublicPrefixes", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/VirtualCircuitPublicPrefix/BulkDeleteVirtualCircuitPublicPrefixes").method(Method.POST).requestBuilder(BulkDeleteVirtualCircuitPublicPrefixesRequest::builder).basePath("/20160918").appendPathParam("virtualCircuits").appendPathParam(request.getVirtualCircuitId()).appendPathParam("actions").appendPathParam("bulkDeletePublicPrefixes").accept(new String[]{"application/json"}).operationUsesDefaultRetries().hasBody().callSync();
    }

    @Override
    public ChangeByoasnCompartmentResponse changeByoasnCompartment(ChangeByoasnCompartmentRequest request) {
        Validate.notBlank((String)request.getByoasnId(), (String)"byoasnId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeByoasnCompartmentDetails(), "changeByoasnCompartmentDetails is required");
        return (ChangeByoasnCompartmentResponse)this.clientCall(request, ChangeByoasnCompartmentResponse::builder).logger(LOG, "changeByoasnCompartment").serviceDetails("VirtualNetwork", "ChangeByoasnCompartment", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Byoasn/ChangeByoasnCompartment").method(Method.POST).requestBuilder(ChangeByoasnCompartmentRequest::builder).basePath("/20160918").appendPathParam("byoasns").appendPathParam(request.getByoasnId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-request-id", ChangeByoasnCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeByoipRangeCompartmentResponse changeByoipRangeCompartment(ChangeByoipRangeCompartmentRequest request) {
        Validate.notBlank((String)request.getByoipRangeId(), (String)"byoipRangeId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeByoipRangeCompartmentDetails(), "changeByoipRangeCompartmentDetails is required");
        return (ChangeByoipRangeCompartmentResponse)this.clientCall(request, ChangeByoipRangeCompartmentResponse::builder).logger(LOG, "changeByoipRangeCompartment").serviceDetails("VirtualNetwork", "ChangeByoipRangeCompartment", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ByoipRange/ChangeByoipRangeCompartment").method(Method.POST).requestBuilder(ChangeByoipRangeCompartmentRequest::builder).basePath("/20160918").appendPathParam("byoipRanges").appendPathParam(request.getByoipRangeId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeByoipRangeCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeCaptureFilterCompartmentResponse changeCaptureFilterCompartment(ChangeCaptureFilterCompartmentRequest request) {
        Validate.notBlank((String)request.getCaptureFilterId(), (String)"captureFilterId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeCaptureFilterCompartmentDetails(), "changeCaptureFilterCompartmentDetails is required");
        return (ChangeCaptureFilterCompartmentResponse)this.clientCall(request, ChangeCaptureFilterCompartmentResponse::builder).logger(LOG, "changeCaptureFilterCompartment").serviceDetails("VirtualNetwork", "ChangeCaptureFilterCompartment", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/CaptureFilter/ChangeCaptureFilterCompartment").method(Method.POST).requestBuilder(ChangeCaptureFilterCompartmentRequest::builder).basePath("/20160918").appendPathParam("captureFilters").appendPathParam(request.getCaptureFilterId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("etag", ChangeCaptureFilterCompartmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ChangeCaptureFilterCompartmentResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ChangeCaptureFilterCompartmentResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public ChangeCpeCompartmentResponse changeCpeCompartment(ChangeCpeCompartmentRequest request) {
        Validate.notBlank((String)request.getCpeId(), (String)"cpeId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeCpeCompartmentDetails(), "changeCpeCompartmentDetails is required");
        return (ChangeCpeCompartmentResponse)this.clientCall(request, ChangeCpeCompartmentResponse::builder).logger(LOG, "changeCpeCompartment").serviceDetails("VirtualNetwork", "ChangeCpeCompartment", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Cpe/ChangeCpeCompartment").method(Method.POST).requestBuilder(ChangeCpeCompartmentRequest::builder).basePath("/20160918").appendPathParam("cpes").appendPathParam(request.getCpeId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("etag", ChangeCpeCompartmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ChangeCpeCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeCrossConnectCompartmentResponse changeCrossConnectCompartment(ChangeCrossConnectCompartmentRequest request) {
        Validate.notBlank((String)request.getCrossConnectId(), (String)"crossConnectId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeCrossConnectCompartmentDetails(), "changeCrossConnectCompartmentDetails is required");
        return (ChangeCrossConnectCompartmentResponse)this.clientCall(request, ChangeCrossConnectCompartmentResponse::builder).logger(LOG, "changeCrossConnectCompartment").serviceDetails("VirtualNetwork", "ChangeCrossConnectCompartment", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/CrossConnect/ChangeCrossConnectCompartment").method(Method.POST).requestBuilder(ChangeCrossConnectCompartmentRequest::builder).basePath("/20160918").appendPathParam("crossConnects").appendPathParam(request.getCrossConnectId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("etag", ChangeCrossConnectCompartmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ChangeCrossConnectCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeCrossConnectGroupCompartmentResponse changeCrossConnectGroupCompartment(ChangeCrossConnectGroupCompartmentRequest request) {
        Validate.notBlank((String)request.getCrossConnectGroupId(), (String)"crossConnectGroupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeCrossConnectGroupCompartmentDetails(), "changeCrossConnectGroupCompartmentDetails is required");
        return (ChangeCrossConnectGroupCompartmentResponse)this.clientCall(request, ChangeCrossConnectGroupCompartmentResponse::builder).logger(LOG, "changeCrossConnectGroupCompartment").serviceDetails("VirtualNetwork", "ChangeCrossConnectGroupCompartment", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/CrossConnectGroup/ChangeCrossConnectGroupCompartment").method(Method.POST).requestBuilder(ChangeCrossConnectGroupCompartmentRequest::builder).basePath("/20160918").appendPathParam("crossConnectGroups").appendPathParam(request.getCrossConnectGroupId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("etag", ChangeCrossConnectGroupCompartmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ChangeCrossConnectGroupCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeDhcpOptionsCompartmentResponse changeDhcpOptionsCompartment(ChangeDhcpOptionsCompartmentRequest request) {
        Validate.notBlank((String)request.getDhcpId(), (String)"dhcpId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeDhcpOptionsCompartmentDetails(), "changeDhcpOptionsCompartmentDetails is required");
        return (ChangeDhcpOptionsCompartmentResponse)this.clientCall(request, ChangeDhcpOptionsCompartmentResponse::builder).logger(LOG, "changeDhcpOptionsCompartment").serviceDetails("VirtualNetwork", "ChangeDhcpOptionsCompartment", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/DhcpOptions/ChangeDhcpOptionsCompartment").method(Method.POST).requestBuilder(ChangeDhcpOptionsCompartmentRequest::builder).basePath("/20160918").appendPathParam("dhcps").appendPathParam(request.getDhcpId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("etag", ChangeDhcpOptionsCompartmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ChangeDhcpOptionsCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeDrgCompartmentResponse changeDrgCompartment(ChangeDrgCompartmentRequest request) {
        Validate.notBlank((String)request.getDrgId(), (String)"drgId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeDrgCompartmentDetails(), "changeDrgCompartmentDetails is required");
        return (ChangeDrgCompartmentResponse)this.clientCall(request, ChangeDrgCompartmentResponse::builder).logger(LOG, "changeDrgCompartment").serviceDetails("VirtualNetwork", "ChangeDrgCompartment", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Drg/ChangeDrgCompartment").method(Method.POST).requestBuilder(ChangeDrgCompartmentRequest::builder).basePath("/20160918").appendPathParam("drgs").appendPathParam(request.getDrgId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("etag", ChangeDrgCompartmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ChangeDrgCompartmentResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ChangeDrgCompartmentResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public ChangeIPSecConnectionCompartmentResponse changeIPSecConnectionCompartment(ChangeIPSecConnectionCompartmentRequest request) {
        Validate.notBlank((String)request.getIpscId(), (String)"ipscId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeIPSecConnectionCompartmentDetails(), "changeIPSecConnectionCompartmentDetails is required");
        return (ChangeIPSecConnectionCompartmentResponse)this.clientCall(request, ChangeIPSecConnectionCompartmentResponse::builder).logger(LOG, "changeIPSecConnectionCompartment").serviceDetails("VirtualNetwork", "ChangeIPSecConnectionCompartment", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/IPSecConnection/ChangeIPSecConnectionCompartment").method(Method.POST).requestBuilder(ChangeIPSecConnectionCompartmentRequest::builder).basePath("/20160918").appendPathParam("ipsecConnections").appendPathParam(request.getIpscId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("etag", ChangeIPSecConnectionCompartmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ChangeIPSecConnectionCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeInternetGatewayCompartmentResponse changeInternetGatewayCompartment(ChangeInternetGatewayCompartmentRequest request) {
        Validate.notBlank((String)request.getIgId(), (String)"igId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeInternetGatewayCompartmentDetails(), "changeInternetGatewayCompartmentDetails is required");
        return (ChangeInternetGatewayCompartmentResponse)this.clientCall(request, ChangeInternetGatewayCompartmentResponse::builder).logger(LOG, "changeInternetGatewayCompartment").serviceDetails("VirtualNetwork", "ChangeInternetGatewayCompartment", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/InternetGateway/ChangeInternetGatewayCompartment").method(Method.POST).requestBuilder(ChangeInternetGatewayCompartmentRequest::builder).basePath("/20160918").appendPathParam("internetGateways").appendPathParam(request.getIgId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("etag", ChangeInternetGatewayCompartmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ChangeInternetGatewayCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeLocalPeeringGatewayCompartmentResponse changeLocalPeeringGatewayCompartment(ChangeLocalPeeringGatewayCompartmentRequest request) {
        Validate.notBlank((String)request.getLocalPeeringGatewayId(), (String)"localPeeringGatewayId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeLocalPeeringGatewayCompartmentDetails(), "changeLocalPeeringGatewayCompartmentDetails is required");
        return (ChangeLocalPeeringGatewayCompartmentResponse)this.clientCall(request, ChangeLocalPeeringGatewayCompartmentResponse::builder).logger(LOG, "changeLocalPeeringGatewayCompartment").serviceDetails("VirtualNetwork", "ChangeLocalPeeringGatewayCompartment", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/LocalPeeringGateway/ChangeLocalPeeringGatewayCompartment").method(Method.POST).requestBuilder(ChangeLocalPeeringGatewayCompartmentRequest::builder).basePath("/20160918").appendPathParam("localPeeringGateways").appendPathParam(request.getLocalPeeringGatewayId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("etag", ChangeLocalPeeringGatewayCompartmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ChangeLocalPeeringGatewayCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeNatGatewayCompartmentResponse changeNatGatewayCompartment(ChangeNatGatewayCompartmentRequest request) {
        Validate.notBlank((String)request.getNatGatewayId(), (String)"natGatewayId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeNatGatewayCompartmentDetails(), "changeNatGatewayCompartmentDetails is required");
        return (ChangeNatGatewayCompartmentResponse)this.clientCall(request, ChangeNatGatewayCompartmentResponse::builder).logger(LOG, "changeNatGatewayCompartment").serviceDetails("VirtualNetwork", "ChangeNatGatewayCompartment", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/NatGateway/ChangeNatGatewayCompartment").method(Method.POST).requestBuilder(ChangeNatGatewayCompartmentRequest::builder).basePath("/20160918").appendPathParam("natGateways").appendPathParam(request.getNatGatewayId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("etag", ChangeNatGatewayCompartmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ChangeNatGatewayCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeNetworkSecurityGroupCompartmentResponse changeNetworkSecurityGroupCompartment(ChangeNetworkSecurityGroupCompartmentRequest request) {
        Validate.notBlank((String)request.getNetworkSecurityGroupId(), (String)"networkSecurityGroupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeNetworkSecurityGroupCompartmentDetails(), "changeNetworkSecurityGroupCompartmentDetails is required");
        return (ChangeNetworkSecurityGroupCompartmentResponse)this.clientCall(request, ChangeNetworkSecurityGroupCompartmentResponse::builder).logger(LOG, "changeNetworkSecurityGroupCompartment").serviceDetails("VirtualNetwork", "ChangeNetworkSecurityGroupCompartment", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/NetworkSecurityGroup/ChangeNetworkSecurityGroupCompartment").method(Method.POST).requestBuilder(ChangeNetworkSecurityGroupCompartmentRequest::builder).basePath("/20160918").appendPathParam("networkSecurityGroups").appendPathParam(request.getNetworkSecurityGroupId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("etag", ChangeNetworkSecurityGroupCompartmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ChangeNetworkSecurityGroupCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangePublicIpCompartmentResponse changePublicIpCompartment(ChangePublicIpCompartmentRequest request) {
        Validate.notBlank((String)request.getPublicIpId(), (String)"publicIpId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangePublicIpCompartmentDetails(), "changePublicIpCompartmentDetails is required");
        return (ChangePublicIpCompartmentResponse)this.clientCall(request, ChangePublicIpCompartmentResponse::builder).logger(LOG, "changePublicIpCompartment").serviceDetails("VirtualNetwork", "ChangePublicIpCompartment", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/PublicIp/ChangePublicIpCompartment").method(Method.POST).requestBuilder(ChangePublicIpCompartmentRequest::builder).basePath("/20160918").appendPathParam("publicIps").appendPathParam(request.getPublicIpId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("etag", ChangePublicIpCompartmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ChangePublicIpCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangePublicIpPoolCompartmentResponse changePublicIpPoolCompartment(ChangePublicIpPoolCompartmentRequest request) {
        Validate.notBlank((String)request.getPublicIpPoolId(), (String)"publicIpPoolId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangePublicIpPoolCompartmentDetails(), "changePublicIpPoolCompartmentDetails is required");
        return (ChangePublicIpPoolCompartmentResponse)this.clientCall(request, ChangePublicIpPoolCompartmentResponse::builder).logger(LOG, "changePublicIpPoolCompartment").serviceDetails("VirtualNetwork", "ChangePublicIpPoolCompartment", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/PublicIpPool/ChangePublicIpPoolCompartment").method(Method.POST).requestBuilder(ChangePublicIpPoolCompartmentRequest::builder).basePath("/20160918").appendPathParam("publicIpPools").appendPathParam(request.getPublicIpPoolId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangePublicIpPoolCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeRemotePeeringConnectionCompartmentResponse changeRemotePeeringConnectionCompartment(ChangeRemotePeeringConnectionCompartmentRequest request) {
        Validate.notBlank((String)request.getRemotePeeringConnectionId(), (String)"remotePeeringConnectionId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeRemotePeeringConnectionCompartmentDetails(), "changeRemotePeeringConnectionCompartmentDetails is required");
        return (ChangeRemotePeeringConnectionCompartmentResponse)this.clientCall(request, ChangeRemotePeeringConnectionCompartmentResponse::builder).logger(LOG, "changeRemotePeeringConnectionCompartment").serviceDetails("VirtualNetwork", "ChangeRemotePeeringConnectionCompartment", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/RemotePeeringConnection/ChangeRemotePeeringConnectionCompartment").method(Method.POST).requestBuilder(ChangeRemotePeeringConnectionCompartmentRequest::builder).basePath("/20160918").appendPathParam("remotePeeringConnections").appendPathParam(request.getRemotePeeringConnectionId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("etag", ChangeRemotePeeringConnectionCompartmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ChangeRemotePeeringConnectionCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeRouteTableCompartmentResponse changeRouteTableCompartment(ChangeRouteTableCompartmentRequest request) {
        Validate.notBlank((String)request.getRtId(), (String)"rtId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeRouteTableCompartmentDetails(), "changeRouteTableCompartmentDetails is required");
        return (ChangeRouteTableCompartmentResponse)this.clientCall(request, ChangeRouteTableCompartmentResponse::builder).logger(LOG, "changeRouteTableCompartment").serviceDetails("VirtualNetwork", "ChangeRouteTableCompartment", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/RouteTable/ChangeRouteTableCompartment").method(Method.POST).requestBuilder(ChangeRouteTableCompartmentRequest::builder).basePath("/20160918").appendPathParam("routeTables").appendPathParam(request.getRtId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("etag", ChangeRouteTableCompartmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ChangeRouteTableCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeSecurityListCompartmentResponse changeSecurityListCompartment(ChangeSecurityListCompartmentRequest request) {
        Validate.notBlank((String)request.getSecurityListId(), (String)"securityListId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeSecurityListCompartmentDetails(), "changeSecurityListCompartmentDetails is required");
        return (ChangeSecurityListCompartmentResponse)this.clientCall(request, ChangeSecurityListCompartmentResponse::builder).logger(LOG, "changeSecurityListCompartment").serviceDetails("VirtualNetwork", "ChangeSecurityListCompartment", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/SecurityList/ChangeSecurityListCompartment").method(Method.POST).requestBuilder(ChangeSecurityListCompartmentRequest::builder).basePath("/20160918").appendPathParam("securityLists").appendPathParam(request.getSecurityListId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("etag", ChangeSecurityListCompartmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ChangeSecurityListCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeServiceGatewayCompartmentResponse changeServiceGatewayCompartment(ChangeServiceGatewayCompartmentRequest request) {
        Validate.notBlank((String)request.getServiceGatewayId(), (String)"serviceGatewayId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeServiceGatewayCompartmentDetails(), "changeServiceGatewayCompartmentDetails is required");
        return (ChangeServiceGatewayCompartmentResponse)this.clientCall(request, ChangeServiceGatewayCompartmentResponse::builder).logger(LOG, "changeServiceGatewayCompartment").serviceDetails("VirtualNetwork", "ChangeServiceGatewayCompartment", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ServiceGateway/ChangeServiceGatewayCompartment").method(Method.POST).requestBuilder(ChangeServiceGatewayCompartmentRequest::builder).basePath("/20160918").appendPathParam("serviceGateways").appendPathParam(request.getServiceGatewayId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("etag", ChangeServiceGatewayCompartmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ChangeServiceGatewayCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeSubnetCompartmentResponse changeSubnetCompartment(ChangeSubnetCompartmentRequest request) {
        Validate.notBlank((String)request.getSubnetId(), (String)"subnetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeSubnetCompartmentDetails(), "changeSubnetCompartmentDetails is required");
        return (ChangeSubnetCompartmentResponse)this.clientCall(request, ChangeSubnetCompartmentResponse::builder).logger(LOG, "changeSubnetCompartment").serviceDetails("VirtualNetwork", "ChangeSubnetCompartment", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Subnet/ChangeSubnetCompartment").method(Method.POST).requestBuilder(ChangeSubnetCompartmentRequest::builder).basePath("/20160918").appendPathParam("subnets").appendPathParam(request.getSubnetId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("etag", ChangeSubnetCompartmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ChangeSubnetCompartmentResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ChangeSubnetCompartmentResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public ChangeVcnCompartmentResponse changeVcnCompartment(ChangeVcnCompartmentRequest request) {
        Validate.notBlank((String)request.getVcnId(), (String)"vcnId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeVcnCompartmentDetails(), "changeVcnCompartmentDetails is required");
        return (ChangeVcnCompartmentResponse)this.clientCall(request, ChangeVcnCompartmentResponse::builder).logger(LOG, "changeVcnCompartment").serviceDetails("VirtualNetwork", "ChangeVcnCompartment", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Vcn/ChangeVcnCompartment").method(Method.POST).requestBuilder(ChangeVcnCompartmentRequest::builder).basePath("/20160918").appendPathParam("vcns").appendPathParam(request.getVcnId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("etag", ChangeVcnCompartmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ChangeVcnCompartmentResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ChangeVcnCompartmentResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public ChangeVirtualCircuitCompartmentResponse changeVirtualCircuitCompartment(ChangeVirtualCircuitCompartmentRequest request) {
        Validate.notBlank((String)request.getVirtualCircuitId(), (String)"virtualCircuitId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeVirtualCircuitCompartmentDetails(), "changeVirtualCircuitCompartmentDetails is required");
        return (ChangeVirtualCircuitCompartmentResponse)this.clientCall(request, ChangeVirtualCircuitCompartmentResponse::builder).logger(LOG, "changeVirtualCircuitCompartment").serviceDetails("VirtualNetwork", "ChangeVirtualCircuitCompartment", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/VirtualCircuit/ChangeVirtualCircuitCompartment").method(Method.POST).requestBuilder(ChangeVirtualCircuitCompartmentRequest::builder).basePath("/20160918").appendPathParam("virtualCircuits").appendPathParam(request.getVirtualCircuitId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("etag", ChangeVirtualCircuitCompartmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ChangeVirtualCircuitCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeVlanCompartmentResponse changeVlanCompartment(ChangeVlanCompartmentRequest request) {
        Validate.notBlank((String)request.getVlanId(), (String)"vlanId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeVlanCompartmentDetails(), "changeVlanCompartmentDetails is required");
        return (ChangeVlanCompartmentResponse)this.clientCall(request, ChangeVlanCompartmentResponse::builder).logger(LOG, "changeVlanCompartment").serviceDetails("VirtualNetwork", "ChangeVlanCompartment", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Vlan/ChangeVlanCompartment").method(Method.POST).requestBuilder(ChangeVlanCompartmentRequest::builder).basePath("/20160918").appendPathParam("vlans").appendPathParam(request.getVlanId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeVlanCompartmentResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ChangeVlanCompartmentResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public ChangeVtapCompartmentResponse changeVtapCompartment(ChangeVtapCompartmentRequest request) {
        Validate.notBlank((String)request.getVtapId(), (String)"vtapId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeVtapCompartmentDetails(), "changeVtapCompartmentDetails is required");
        return (ChangeVtapCompartmentResponse)this.clientCall(request, ChangeVtapCompartmentResponse::builder).logger(LOG, "changeVtapCompartment").serviceDetails("VirtualNetwork", "ChangeVtapCompartment", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Vtap/ChangeVtapCompartment").method(Method.POST).requestBuilder(ChangeVtapCompartmentRequest::builder).basePath("/20160918").appendPathParam("vtaps").appendPathParam(request.getVtapId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("etag", ChangeVtapCompartmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ChangeVtapCompartmentResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ChangeVtapCompartmentResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public ConnectLocalPeeringGatewaysResponse connectLocalPeeringGateways(ConnectLocalPeeringGatewaysRequest request) {
        Validate.notBlank((String)request.getLocalPeeringGatewayId(), (String)"localPeeringGatewayId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getConnectLocalPeeringGatewaysDetails(), "connectLocalPeeringGatewaysDetails is required");
        return (ConnectLocalPeeringGatewaysResponse)this.clientCall(request, ConnectLocalPeeringGatewaysResponse::builder).logger(LOG, "connectLocalPeeringGateways").serviceDetails("VirtualNetwork", "ConnectLocalPeeringGateways", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/LocalPeeringGateway/ConnectLocalPeeringGateways").method(Method.POST).requestBuilder(ConnectLocalPeeringGatewaysRequest::builder).basePath("/20160918").appendPathParam("localPeeringGateways").appendPathParam(request.getLocalPeeringGatewayId()).appendPathParam("actions").appendPathParam("connect").accept(new String[]{"application/json"}).hasBody().handleResponseHeaderString("opc-request-id", ConnectLocalPeeringGatewaysResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ConnectRemotePeeringConnectionsResponse connectRemotePeeringConnections(ConnectRemotePeeringConnectionsRequest request) {
        Validate.notBlank((String)request.getRemotePeeringConnectionId(), (String)"remotePeeringConnectionId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getConnectRemotePeeringConnectionsDetails(), "connectRemotePeeringConnectionsDetails is required");
        return (ConnectRemotePeeringConnectionsResponse)this.clientCall(request, ConnectRemotePeeringConnectionsResponse::builder).logger(LOG, "connectRemotePeeringConnections").serviceDetails("VirtualNetwork", "ConnectRemotePeeringConnections", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/RemotePeeringConnection/ConnectRemotePeeringConnections").method(Method.POST).requestBuilder(ConnectRemotePeeringConnectionsRequest::builder).basePath("/20160918").appendPathParam("remotePeeringConnections").appendPathParam(request.getRemotePeeringConnectionId()).appendPathParam("actions").appendPathParam("connect").accept(new String[]{"application/json"}).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-request-id", ConnectRemotePeeringConnectionsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateByoasnResponse createByoasn(CreateByoasnRequest request) {
        Objects.requireNonNull(request.getCreateByoasnDetails(), "createByoasnDetails is required");
        return (CreateByoasnResponse)this.clientCall(request, CreateByoasnResponse::builder).logger(LOG, "createByoasn").serviceDetails("VirtualNetwork", "CreateByoasn", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Byoasn/CreateByoasn").method(Method.POST).requestBuilder(CreateByoasnRequest::builder).basePath("/20160918").appendPathParam("byoasns").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleBody(Byoasn.class, CreateByoasnResponse.Builder::byoasn).handleResponseHeaderString("etag", CreateByoasnResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateByoasnResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateByoipRangeResponse createByoipRange(CreateByoipRangeRequest request) {
        Objects.requireNonNull(request.getCreateByoipRangeDetails(), "createByoipRangeDetails is required");
        return (CreateByoipRangeResponse)this.clientCall(request, CreateByoipRangeResponse::builder).logger(LOG, "createByoipRange").serviceDetails("VirtualNetwork", "CreateByoipRange", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ByoipRange/CreateByoipRange").method(Method.POST).requestBuilder(CreateByoipRangeRequest::builder).basePath("/20160918").appendPathParam("byoipRanges").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(ByoipRange.class, CreateByoipRangeResponse.Builder::byoipRange).handleResponseHeaderString("etag", CreateByoipRangeResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateByoipRangeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateCaptureFilterResponse createCaptureFilter(CreateCaptureFilterRequest request) {
        Objects.requireNonNull(request.getCreateCaptureFilterDetails(), "createCaptureFilterDetails is required");
        return (CreateCaptureFilterResponse)this.clientCall(request, CreateCaptureFilterResponse::builder).logger(LOG, "createCaptureFilter").serviceDetails("VirtualNetwork", "CreateCaptureFilter", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/CaptureFilter/CreateCaptureFilter").method(Method.POST).requestBuilder(CreateCaptureFilterRequest::builder).basePath("/20160918").appendPathParam("captureFilters").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(CaptureFilter.class, CreateCaptureFilterResponse.Builder::captureFilter).handleResponseHeaderString("etag", CreateCaptureFilterResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateCaptureFilterResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateCpeResponse createCpe(CreateCpeRequest request) {
        Objects.requireNonNull(request.getCreateCpeDetails(), "createCpeDetails is required");
        return (CreateCpeResponse)this.clientCall(request, CreateCpeResponse::builder).logger(LOG, "createCpe").serviceDetails("VirtualNetwork", "CreateCpe", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Cpe/CreateCpe").method(Method.POST).requestBuilder(CreateCpeRequest::builder).basePath("/20160918").appendPathParam("cpes").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleBody(Cpe.class, CreateCpeResponse.Builder::cpe).handleResponseHeaderString("etag", CreateCpeResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateCpeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateCrossConnectResponse createCrossConnect(CreateCrossConnectRequest request) {
        Objects.requireNonNull(request.getCreateCrossConnectDetails(), "createCrossConnectDetails is required");
        return (CreateCrossConnectResponse)this.clientCall(request, CreateCrossConnectResponse::builder).logger(LOG, "createCrossConnect").serviceDetails("VirtualNetwork", "CreateCrossConnect", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/CrossConnect/CreateCrossConnect").method(Method.POST).requestBuilder(CreateCrossConnectRequest::builder).basePath("/20160918").appendPathParam("crossConnects").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleBody(CrossConnect.class, CreateCrossConnectResponse.Builder::crossConnect).handleResponseHeaderString("etag", CreateCrossConnectResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateCrossConnectResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateCrossConnectGroupResponse createCrossConnectGroup(CreateCrossConnectGroupRequest request) {
        Objects.requireNonNull(request.getCreateCrossConnectGroupDetails(), "createCrossConnectGroupDetails is required");
        return (CreateCrossConnectGroupResponse)this.clientCall(request, CreateCrossConnectGroupResponse::builder).logger(LOG, "createCrossConnectGroup").serviceDetails("VirtualNetwork", "CreateCrossConnectGroup", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/CrossConnectGroup/CreateCrossConnectGroup").method(Method.POST).requestBuilder(CreateCrossConnectGroupRequest::builder).basePath("/20160918").appendPathParam("crossConnectGroups").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleBody(CrossConnectGroup.class, CreateCrossConnectGroupResponse.Builder::crossConnectGroup).handleResponseHeaderString("etag", CreateCrossConnectGroupResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateCrossConnectGroupResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateDhcpOptionsResponse createDhcpOptions(CreateDhcpOptionsRequest request) {
        Objects.requireNonNull(request.getCreateDhcpDetails(), "createDhcpDetails is required");
        return (CreateDhcpOptionsResponse)this.clientCall(request, CreateDhcpOptionsResponse::builder).logger(LOG, "createDhcpOptions").serviceDetails("VirtualNetwork", "CreateDhcpOptions", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/DhcpOptions/CreateDhcpOptions").method(Method.POST).requestBuilder(CreateDhcpOptionsRequest::builder).basePath("/20160918").appendPathParam("dhcps").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(DhcpOptions.class, CreateDhcpOptionsResponse.Builder::dhcpOptions).handleResponseHeaderString("etag", CreateDhcpOptionsResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateDhcpOptionsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateDrgResponse createDrg(CreateDrgRequest request) {
        Objects.requireNonNull(request.getCreateDrgDetails(), "createDrgDetails is required");
        return (CreateDrgResponse)this.clientCall(request, CreateDrgResponse::builder).logger(LOG, "createDrg").serviceDetails("VirtualNetwork", "CreateDrg", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Drg/CreateDrg").method(Method.POST).requestBuilder(CreateDrgRequest::builder).basePath("/20160918").appendPathParam("drgs").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Drg.class, CreateDrgResponse.Builder::drg).handleResponseHeaderString("etag", CreateDrgResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateDrgResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateDrgAttachmentResponse createDrgAttachment(CreateDrgAttachmentRequest request) {
        Objects.requireNonNull(request.getCreateDrgAttachmentDetails(), "createDrgAttachmentDetails is required");
        return (CreateDrgAttachmentResponse)this.clientCall(request, CreateDrgAttachmentResponse::builder).logger(LOG, "createDrgAttachment").serviceDetails("VirtualNetwork", "CreateDrgAttachment", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/DrgAttachment/CreateDrgAttachment").method(Method.POST).requestBuilder(CreateDrgAttachmentRequest::builder).basePath("/20160918").appendPathParam("drgAttachments").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(DrgAttachment.class, CreateDrgAttachmentResponse.Builder::drgAttachment).handleResponseHeaderString("etag", CreateDrgAttachmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateDrgAttachmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateDrgRouteDistributionResponse createDrgRouteDistribution(CreateDrgRouteDistributionRequest request) {
        Objects.requireNonNull(request.getCreateDrgRouteDistributionDetails(), "createDrgRouteDistributionDetails is required");
        return (CreateDrgRouteDistributionResponse)this.clientCall(request, CreateDrgRouteDistributionResponse::builder).logger(LOG, "createDrgRouteDistribution").serviceDetails("VirtualNetwork", "CreateDrgRouteDistribution", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/DrgRouteDistribution/CreateDrgRouteDistribution").method(Method.POST).requestBuilder(CreateDrgRouteDistributionRequest::builder).basePath("/20160918").appendPathParam("drgRouteDistributions").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(DrgRouteDistribution.class, CreateDrgRouteDistributionResponse.Builder::drgRouteDistribution).handleResponseHeaderString("etag", CreateDrgRouteDistributionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateDrgRouteDistributionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateDrgRouteTableResponse createDrgRouteTable(CreateDrgRouteTableRequest request) {
        Objects.requireNonNull(request.getCreateDrgRouteTableDetails(), "createDrgRouteTableDetails is required");
        return (CreateDrgRouteTableResponse)this.clientCall(request, CreateDrgRouteTableResponse::builder).logger(LOG, "createDrgRouteTable").serviceDetails("VirtualNetwork", "CreateDrgRouteTable", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/DrgRouteTable/CreateDrgRouteTable").method(Method.POST).requestBuilder(CreateDrgRouteTableRequest::builder).basePath("/20160918").appendPathParam("drgRouteTables").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(DrgRouteTable.class, CreateDrgRouteTableResponse.Builder::drgRouteTable).handleResponseHeaderString("etag", CreateDrgRouteTableResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateDrgRouteTableResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateIPSecConnectionResponse createIPSecConnection(CreateIPSecConnectionRequest request) {
        Objects.requireNonNull(request.getCreateIPSecConnectionDetails(), "createIPSecConnectionDetails is required");
        return (CreateIPSecConnectionResponse)this.clientCall(request, CreateIPSecConnectionResponse::builder).logger(LOG, "createIPSecConnection").serviceDetails("VirtualNetwork", "CreateIPSecConnection", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/IPSecConnection/CreateIPSecConnection").method(Method.POST).requestBuilder(CreateIPSecConnectionRequest::builder).basePath("/20160918").appendPathParam("ipsecConnections").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleBody(IPSecConnection.class, CreateIPSecConnectionResponse.Builder::iPSecConnection).handleResponseHeaderString("etag", CreateIPSecConnectionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateIPSecConnectionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateInternetGatewayResponse createInternetGateway(CreateInternetGatewayRequest request) {
        Objects.requireNonNull(request.getCreateInternetGatewayDetails(), "createInternetGatewayDetails is required");
        return (CreateInternetGatewayResponse)this.clientCall(request, CreateInternetGatewayResponse::builder).logger(LOG, "createInternetGateway").serviceDetails("VirtualNetwork", "CreateInternetGateway", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/InternetGateway/CreateInternetGateway").method(Method.POST).requestBuilder(CreateInternetGatewayRequest::builder).basePath("/20160918").appendPathParam("internetGateways").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(InternetGateway.class, CreateInternetGatewayResponse.Builder::internetGateway).handleResponseHeaderString("etag", CreateInternetGatewayResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateInternetGatewayResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateIpv6Response createIpv6(CreateIpv6Request request) {
        Objects.requireNonNull(request.getCreateIpv6Details(), "createIpv6Details is required");
        return (CreateIpv6Response)this.clientCall(request, CreateIpv6Response::builder).logger(LOG, "createIpv6").serviceDetails("VirtualNetwork", "CreateIpv6", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Ipv6/CreateIpv6").method(Method.POST).requestBuilder(CreateIpv6Request::builder).basePath("/20160918").appendPathParam("ipv6").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Ipv6.class, CreateIpv6Response.Builder::ipv6).handleResponseHeaderString("etag", CreateIpv6Response.Builder::etag).handleResponseHeaderString("opc-request-id", CreateIpv6Response.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateLocalPeeringGatewayResponse createLocalPeeringGateway(CreateLocalPeeringGatewayRequest request) {
        Objects.requireNonNull(request.getCreateLocalPeeringGatewayDetails(), "createLocalPeeringGatewayDetails is required");
        return (CreateLocalPeeringGatewayResponse)this.clientCall(request, CreateLocalPeeringGatewayResponse::builder).logger(LOG, "createLocalPeeringGateway").serviceDetails("VirtualNetwork", "CreateLocalPeeringGateway", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/LocalPeeringGateway/CreateLocalPeeringGateway").method(Method.POST).requestBuilder(CreateLocalPeeringGatewayRequest::builder).basePath("/20160918").appendPathParam("localPeeringGateways").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(LocalPeeringGateway.class, CreateLocalPeeringGatewayResponse.Builder::localPeeringGateway).handleResponseHeaderString("etag", CreateLocalPeeringGatewayResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateLocalPeeringGatewayResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateNatGatewayResponse createNatGateway(CreateNatGatewayRequest request) {
        Objects.requireNonNull(request.getCreateNatGatewayDetails(), "createNatGatewayDetails is required");
        return (CreateNatGatewayResponse)this.clientCall(request, CreateNatGatewayResponse::builder).logger(LOG, "createNatGateway").serviceDetails("VirtualNetwork", "CreateNatGateway", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/NatGateway/CreateNatGateway").method(Method.POST).requestBuilder(CreateNatGatewayRequest::builder).basePath("/20160918").appendPathParam("natGateways").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(NatGateway.class, CreateNatGatewayResponse.Builder::natGateway).handleResponseHeaderString("etag", CreateNatGatewayResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateNatGatewayResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateNetworkSecurityGroupResponse createNetworkSecurityGroup(CreateNetworkSecurityGroupRequest request) {
        Objects.requireNonNull(request.getCreateNetworkSecurityGroupDetails(), "createNetworkSecurityGroupDetails is required");
        return (CreateNetworkSecurityGroupResponse)this.clientCall(request, CreateNetworkSecurityGroupResponse::builder).logger(LOG, "createNetworkSecurityGroup").serviceDetails("VirtualNetwork", "CreateNetworkSecurityGroup", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/NetworkSecurityGroup/CreateNetworkSecurityGroup").method(Method.POST).requestBuilder(CreateNetworkSecurityGroupRequest::builder).basePath("/20160918").appendPathParam("networkSecurityGroups").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(NetworkSecurityGroup.class, CreateNetworkSecurityGroupResponse.Builder::networkSecurityGroup).handleResponseHeaderString("etag", CreateNetworkSecurityGroupResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateNetworkSecurityGroupResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreatePrivateIpResponse createPrivateIp(CreatePrivateIpRequest request) {
        Objects.requireNonNull(request.getCreatePrivateIpDetails(), "createPrivateIpDetails is required");
        return (CreatePrivateIpResponse)this.clientCall(request, CreatePrivateIpResponse::builder).logger(LOG, "createPrivateIp").serviceDetails("VirtualNetwork", "CreatePrivateIp", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/PrivateIp/CreatePrivateIp").method(Method.POST).requestBuilder(CreatePrivateIpRequest::builder).basePath("/20160918").appendPathParam("privateIps").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(PrivateIp.class, CreatePrivateIpResponse.Builder::privateIp).handleResponseHeaderString("etag", CreatePrivateIpResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreatePrivateIpResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreatePublicIpResponse createPublicIp(CreatePublicIpRequest request) {
        Objects.requireNonNull(request.getCreatePublicIpDetails(), "createPublicIpDetails is required");
        return (CreatePublicIpResponse)this.clientCall(request, CreatePublicIpResponse::builder).logger(LOG, "createPublicIp").serviceDetails("VirtualNetwork", "CreatePublicIp", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/PublicIp/CreatePublicIp").method(Method.POST).requestBuilder(CreatePublicIpRequest::builder).basePath("/20160918").appendPathParam("publicIps").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(PublicIp.class, CreatePublicIpResponse.Builder::publicIp).handleResponseHeaderString("etag", CreatePublicIpResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreatePublicIpResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreatePublicIpPoolResponse createPublicIpPool(CreatePublicIpPoolRequest request) {
        Objects.requireNonNull(request.getCreatePublicIpPoolDetails(), "createPublicIpPoolDetails is required");
        return (CreatePublicIpPoolResponse)this.clientCall(request, CreatePublicIpPoolResponse::builder).logger(LOG, "createPublicIpPool").serviceDetails("VirtualNetwork", "CreatePublicIpPool", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/PublicIpPool/CreatePublicIpPool").method(Method.POST).requestBuilder(CreatePublicIpPoolRequest::builder).basePath("/20160918").appendPathParam("publicIpPools").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(PublicIpPool.class, CreatePublicIpPoolResponse.Builder::publicIpPool).handleResponseHeaderString("etag", CreatePublicIpPoolResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreatePublicIpPoolResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateRemotePeeringConnectionResponse createRemotePeeringConnection(CreateRemotePeeringConnectionRequest request) {
        Objects.requireNonNull(request.getCreateRemotePeeringConnectionDetails(), "createRemotePeeringConnectionDetails is required");
        return (CreateRemotePeeringConnectionResponse)this.clientCall(request, CreateRemotePeeringConnectionResponse::builder).logger(LOG, "createRemotePeeringConnection").serviceDetails("VirtualNetwork", "CreateRemotePeeringConnection", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/RemotePeeringConnection/CreateRemotePeeringConnection").method(Method.POST).requestBuilder(CreateRemotePeeringConnectionRequest::builder).basePath("/20160918").appendPathParam("remotePeeringConnections").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleBody(RemotePeeringConnection.class, CreateRemotePeeringConnectionResponse.Builder::remotePeeringConnection).handleResponseHeaderString("etag", CreateRemotePeeringConnectionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateRemotePeeringConnectionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateRouteTableResponse createRouteTable(CreateRouteTableRequest request) {
        Objects.requireNonNull(request.getCreateRouteTableDetails(), "createRouteTableDetails is required");
        return (CreateRouteTableResponse)this.clientCall(request, CreateRouteTableResponse::builder).logger(LOG, "createRouteTable").serviceDetails("VirtualNetwork", "CreateRouteTable", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/RouteTable/CreateRouteTable").method(Method.POST).requestBuilder(CreateRouteTableRequest::builder).basePath("/20160918").appendPathParam("routeTables").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(RouteTable.class, CreateRouteTableResponse.Builder::routeTable).handleResponseHeaderString("etag", CreateRouteTableResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateRouteTableResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateSecurityListResponse createSecurityList(CreateSecurityListRequest request) {
        Objects.requireNonNull(request.getCreateSecurityListDetails(), "createSecurityListDetails is required");
        return (CreateSecurityListResponse)this.clientCall(request, CreateSecurityListResponse::builder).logger(LOG, "createSecurityList").serviceDetails("VirtualNetwork", "CreateSecurityList", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/SecurityList/CreateSecurityList").method(Method.POST).requestBuilder(CreateSecurityListRequest::builder).basePath("/20160918").appendPathParam("securityLists").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(SecurityList.class, CreateSecurityListResponse.Builder::securityList).handleResponseHeaderString("etag", CreateSecurityListResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateSecurityListResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateServiceGatewayResponse createServiceGateway(CreateServiceGatewayRequest request) {
        Objects.requireNonNull(request.getCreateServiceGatewayDetails(), "createServiceGatewayDetails is required");
        return (CreateServiceGatewayResponse)this.clientCall(request, CreateServiceGatewayResponse::builder).logger(LOG, "createServiceGateway").serviceDetails("VirtualNetwork", "CreateServiceGateway", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ServiceGateway/CreateServiceGateway").method(Method.POST).requestBuilder(CreateServiceGatewayRequest::builder).basePath("/20160918").appendPathParam("serviceGateways").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(ServiceGateway.class, CreateServiceGatewayResponse.Builder::serviceGateway).handleResponseHeaderString("opc-request-id", CreateServiceGatewayResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateSubnetResponse createSubnet(CreateSubnetRequest request) {
        Objects.requireNonNull(request.getCreateSubnetDetails(), "createSubnetDetails is required");
        return (CreateSubnetResponse)this.clientCall(request, CreateSubnetResponse::builder).logger(LOG, "createSubnet").serviceDetails("VirtualNetwork", "CreateSubnet", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Subnet/CreateSubnet").method(Method.POST).requestBuilder(CreateSubnetRequest::builder).basePath("/20160918").appendPathParam("subnets").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Subnet.class, CreateSubnetResponse.Builder::subnet).handleResponseHeaderString("etag", CreateSubnetResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateSubnetResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateVcnResponse createVcn(CreateVcnRequest request) {
        Objects.requireNonNull(request.getCreateVcnDetails(), "createVcnDetails is required");
        return (CreateVcnResponse)this.clientCall(request, CreateVcnResponse::builder).logger(LOG, "createVcn").serviceDetails("VirtualNetwork", "CreateVcn", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Vcn/CreateVcn").method(Method.POST).requestBuilder(CreateVcnRequest::builder).basePath("/20160918").appendPathParam("vcns").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Vcn.class, CreateVcnResponse.Builder::vcn).handleResponseHeaderString("etag", CreateVcnResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateVcnResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateVirtualCircuitResponse createVirtualCircuit(CreateVirtualCircuitRequest request) {
        Objects.requireNonNull(request.getCreateVirtualCircuitDetails(), "createVirtualCircuitDetails is required");
        return (CreateVirtualCircuitResponse)this.clientCall(request, CreateVirtualCircuitResponse::builder).logger(LOG, "createVirtualCircuit").serviceDetails("VirtualNetwork", "CreateVirtualCircuit", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/VirtualCircuit/CreateVirtualCircuit").method(Method.POST).requestBuilder(CreateVirtualCircuitRequest::builder).basePath("/20160918").appendPathParam("virtualCircuits").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleBody(VirtualCircuit.class, CreateVirtualCircuitResponse.Builder::virtualCircuit).handleResponseHeaderString("etag", CreateVirtualCircuitResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateVirtualCircuitResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateVlanResponse createVlan(CreateVlanRequest request) {
        Objects.requireNonNull(request.getCreateVlanDetails(), "createVlanDetails is required");
        return (CreateVlanResponse)this.clientCall(request, CreateVlanResponse::builder).logger(LOG, "createVlan").serviceDetails("VirtualNetwork", "CreateVlan", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Vlan/CreateVlan").method(Method.POST).requestBuilder(CreateVlanRequest::builder).basePath("/20160918").appendPathParam("vlans").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Vlan.class, CreateVlanResponse.Builder::vlan).handleResponseHeaderString("etag", CreateVlanResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateVlanResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateVtapResponse createVtap(CreateVtapRequest request) {
        Objects.requireNonNull(request.getCreateVtapDetails(), "createVtapDetails is required");
        return (CreateVtapResponse)this.clientCall(request, CreateVtapResponse::builder).logger(LOG, "createVtap").serviceDetails("VirtualNetwork", "CreateVtap", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Vtap/CreateVtap").method(Method.POST).requestBuilder(CreateVtapRequest::builder).basePath("/20160918").appendPathParam("vtaps").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Vtap.class, CreateVtapResponse.Builder::vtap).handleResponseHeaderString("etag", CreateVtapResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateVtapResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteByoasnResponse deleteByoasn(DeleteByoasnRequest request) {
        Validate.notBlank((String)request.getByoasnId(), (String)"byoasnId must not be blank", (Object[])new Object[0]);
        return (DeleteByoasnResponse)this.clientCall(request, DeleteByoasnResponse::builder).logger(LOG, "deleteByoasn").serviceDetails("VirtualNetwork", "DeleteByoasn", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Byoasn/DeleteByoasn").method(Method.DELETE).requestBuilder(DeleteByoasnRequest::builder).basePath("/20160918").appendPathParam("byoasns").appendPathParam(request.getByoasnId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteByoasnResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteByoipRangeResponse deleteByoipRange(DeleteByoipRangeRequest request) {
        Validate.notBlank((String)request.getByoipRangeId(), (String)"byoipRangeId must not be blank", (Object[])new Object[0]);
        return (DeleteByoipRangeResponse)this.clientCall(request, DeleteByoipRangeResponse::builder).logger(LOG, "deleteByoipRange").serviceDetails("VirtualNetwork", "DeleteByoipRange", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ByoipRange/DeleteByoipRange").method(Method.DELETE).requestBuilder(DeleteByoipRangeRequest::builder).basePath("/20160918").appendPathParam("byoipRanges").appendPathParam(request.getByoipRangeId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteByoipRangeResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteByoipRangeResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public DeleteCaptureFilterResponse deleteCaptureFilter(DeleteCaptureFilterRequest request) {
        Validate.notBlank((String)request.getCaptureFilterId(), (String)"captureFilterId must not be blank", (Object[])new Object[0]);
        return (DeleteCaptureFilterResponse)this.clientCall(request, DeleteCaptureFilterResponse::builder).logger(LOG, "deleteCaptureFilter").serviceDetails("VirtualNetwork", "DeleteCaptureFilter", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/CaptureFilter/DeleteCaptureFilter").method(Method.DELETE).requestBuilder(DeleteCaptureFilterRequest::builder).basePath("/20160918").appendPathParam("captureFilters").appendPathParam(request.getCaptureFilterId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteCaptureFilterResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteCpeResponse deleteCpe(DeleteCpeRequest request) {
        Validate.notBlank((String)request.getCpeId(), (String)"cpeId must not be blank", (Object[])new Object[0]);
        return (DeleteCpeResponse)this.clientCall(request, DeleteCpeResponse::builder).logger(LOG, "deleteCpe").serviceDetails("VirtualNetwork", "DeleteCpe", "").method(Method.DELETE).requestBuilder(DeleteCpeRequest::builder).basePath("/20160918").appendPathParam("cpes").appendPathParam(request.getCpeId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", DeleteCpeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteCrossConnectResponse deleteCrossConnect(DeleteCrossConnectRequest request) {
        Validate.notBlank((String)request.getCrossConnectId(), (String)"crossConnectId must not be blank", (Object[])new Object[0]);
        return (DeleteCrossConnectResponse)this.clientCall(request, DeleteCrossConnectResponse::builder).logger(LOG, "deleteCrossConnect").serviceDetails("VirtualNetwork", "DeleteCrossConnect", "").method(Method.DELETE).requestBuilder(DeleteCrossConnectRequest::builder).basePath("/20160918").appendPathParam("crossConnects").appendPathParam(request.getCrossConnectId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", DeleteCrossConnectResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteCrossConnectGroupResponse deleteCrossConnectGroup(DeleteCrossConnectGroupRequest request) {
        Validate.notBlank((String)request.getCrossConnectGroupId(), (String)"crossConnectGroupId must not be blank", (Object[])new Object[0]);
        return (DeleteCrossConnectGroupResponse)this.clientCall(request, DeleteCrossConnectGroupResponse::builder).logger(LOG, "deleteCrossConnectGroup").serviceDetails("VirtualNetwork", "DeleteCrossConnectGroup", "").method(Method.DELETE).requestBuilder(DeleteCrossConnectGroupRequest::builder).basePath("/20160918").appendPathParam("crossConnectGroups").appendPathParam(request.getCrossConnectGroupId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", DeleteCrossConnectGroupResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteDhcpOptionsResponse deleteDhcpOptions(DeleteDhcpOptionsRequest request) {
        Validate.notBlank((String)request.getDhcpId(), (String)"dhcpId must not be blank", (Object[])new Object[0]);
        return (DeleteDhcpOptionsResponse)this.clientCall(request, DeleteDhcpOptionsResponse::builder).logger(LOG, "deleteDhcpOptions").serviceDetails("VirtualNetwork", "DeleteDhcpOptions", "").method(Method.DELETE).requestBuilder(DeleteDhcpOptionsRequest::builder).basePath("/20160918").appendPathParam("dhcps").appendPathParam(request.getDhcpId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteDhcpOptionsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteDrgResponse deleteDrg(DeleteDrgRequest request) {
        Validate.notBlank((String)request.getDrgId(), (String)"drgId must not be blank", (Object[])new Object[0]);
        return (DeleteDrgResponse)this.clientCall(request, DeleteDrgResponse::builder).logger(LOG, "deleteDrg").serviceDetails("VirtualNetwork", "DeleteDrg", "").method(Method.DELETE).requestBuilder(DeleteDrgRequest::builder).basePath("/20160918").appendPathParam("drgs").appendPathParam(request.getDrgId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteDrgResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteDrgAttachmentResponse deleteDrgAttachment(DeleteDrgAttachmentRequest request) {
        Validate.notBlank((String)request.getDrgAttachmentId(), (String)"drgAttachmentId must not be blank", (Object[])new Object[0]);
        return (DeleteDrgAttachmentResponse)this.clientCall(request, DeleteDrgAttachmentResponse::builder).logger(LOG, "deleteDrgAttachment").serviceDetails("VirtualNetwork", "DeleteDrgAttachment", "").method(Method.DELETE).requestBuilder(DeleteDrgAttachmentRequest::builder).basePath("/20160918").appendPathParam("drgAttachments").appendPathParam(request.getDrgAttachmentId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteDrgAttachmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteDrgRouteDistributionResponse deleteDrgRouteDistribution(DeleteDrgRouteDistributionRequest request) {
        Validate.notBlank((String)request.getDrgRouteDistributionId(), (String)"drgRouteDistributionId must not be blank", (Object[])new Object[0]);
        return (DeleteDrgRouteDistributionResponse)this.clientCall(request, DeleteDrgRouteDistributionResponse::builder).logger(LOG, "deleteDrgRouteDistribution").serviceDetails("VirtualNetwork", "DeleteDrgRouteDistribution", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/DrgRouteDistributionStatement/DeleteDrgRouteDistribution").method(Method.DELETE).requestBuilder(DeleteDrgRouteDistributionRequest::builder).basePath("/20160918").appendPathParam("drgRouteDistributions").appendPathParam(request.getDrgRouteDistributionId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteDrgRouteDistributionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteDrgRouteTableResponse deleteDrgRouteTable(DeleteDrgRouteTableRequest request) {
        Validate.notBlank((String)request.getDrgRouteTableId(), (String)"drgRouteTableId must not be blank", (Object[])new Object[0]);
        return (DeleteDrgRouteTableResponse)this.clientCall(request, DeleteDrgRouteTableResponse::builder).logger(LOG, "deleteDrgRouteTable").serviceDetails("VirtualNetwork", "DeleteDrgRouteTable", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/InternalPublicIp/DeleteDrgRouteTable").method(Method.DELETE).requestBuilder(DeleteDrgRouteTableRequest::builder).basePath("/20160918").appendPathParam("drgRouteTables").appendPathParam(request.getDrgRouteTableId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteDrgRouteTableResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteIPSecConnectionResponse deleteIPSecConnection(DeleteIPSecConnectionRequest request) {
        Validate.notBlank((String)request.getIpscId(), (String)"ipscId must not be blank", (Object[])new Object[0]);
        return (DeleteIPSecConnectionResponse)this.clientCall(request, DeleteIPSecConnectionResponse::builder).logger(LOG, "deleteIPSecConnection").serviceDetails("VirtualNetwork", "DeleteIPSecConnection", "").method(Method.DELETE).requestBuilder(DeleteIPSecConnectionRequest::builder).basePath("/20160918").appendPathParam("ipsecConnections").appendPathParam(request.getIpscId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", DeleteIPSecConnectionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteInternetGatewayResponse deleteInternetGateway(DeleteInternetGatewayRequest request) {
        Validate.notBlank((String)request.getIgId(), (String)"igId must not be blank", (Object[])new Object[0]);
        return (DeleteInternetGatewayResponse)this.clientCall(request, DeleteInternetGatewayResponse::builder).logger(LOG, "deleteInternetGateway").serviceDetails("VirtualNetwork", "DeleteInternetGateway", "").method(Method.DELETE).requestBuilder(DeleteInternetGatewayRequest::builder).basePath("/20160918").appendPathParam("internetGateways").appendPathParam(request.getIgId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteInternetGatewayResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteIpv6Response deleteIpv6(DeleteIpv6Request request) {
        Validate.notBlank((String)request.getIpv6Id(), (String)"ipv6Id must not be blank", (Object[])new Object[0]);
        return (DeleteIpv6Response)this.clientCall(request, DeleteIpv6Response::builder).logger(LOG, "deleteIpv6").serviceDetails("VirtualNetwork", "DeleteIpv6", "").method(Method.DELETE).requestBuilder(DeleteIpv6Request::builder).basePath("/20160918").appendPathParam("ipv6").appendPathParam(request.getIpv6Id()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteIpv6Response.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteLocalPeeringGatewayResponse deleteLocalPeeringGateway(DeleteLocalPeeringGatewayRequest request) {
        Validate.notBlank((String)request.getLocalPeeringGatewayId(), (String)"localPeeringGatewayId must not be blank", (Object[])new Object[0]);
        return (DeleteLocalPeeringGatewayResponse)this.clientCall(request, DeleteLocalPeeringGatewayResponse::builder).logger(LOG, "deleteLocalPeeringGateway").serviceDetails("VirtualNetwork", "DeleteLocalPeeringGateway", "").method(Method.DELETE).requestBuilder(DeleteLocalPeeringGatewayRequest::builder).basePath("/20160918").appendPathParam("localPeeringGateways").appendPathParam(request.getLocalPeeringGatewayId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteLocalPeeringGatewayResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteNatGatewayResponse deleteNatGateway(DeleteNatGatewayRequest request) {
        Validate.notBlank((String)request.getNatGatewayId(), (String)"natGatewayId must not be blank", (Object[])new Object[0]);
        return (DeleteNatGatewayResponse)this.clientCall(request, DeleteNatGatewayResponse::builder).logger(LOG, "deleteNatGateway").serviceDetails("VirtualNetwork", "DeleteNatGateway", "").method(Method.DELETE).requestBuilder(DeleteNatGatewayRequest::builder).basePath("/20160918").appendPathParam("natGateways").appendPathParam(request.getNatGatewayId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteNatGatewayResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteNetworkSecurityGroupResponse deleteNetworkSecurityGroup(DeleteNetworkSecurityGroupRequest request) {
        Validate.notBlank((String)request.getNetworkSecurityGroupId(), (String)"networkSecurityGroupId must not be blank", (Object[])new Object[0]);
        return (DeleteNetworkSecurityGroupResponse)this.clientCall(request, DeleteNetworkSecurityGroupResponse::builder).logger(LOG, "deleteNetworkSecurityGroup").serviceDetails("VirtualNetwork", "DeleteNetworkSecurityGroup", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/NetworkSecurityGroup/DeleteNetworkSecurityGroup").method(Method.DELETE).requestBuilder(DeleteNetworkSecurityGroupRequest::builder).basePath("/20160918").appendPathParam("networkSecurityGroups").appendPathParam(request.getNetworkSecurityGroupId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteNetworkSecurityGroupResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeletePrivateIpResponse deletePrivateIp(DeletePrivateIpRequest request) {
        Validate.notBlank((String)request.getPrivateIpId(), (String)"privateIpId must not be blank", (Object[])new Object[0]);
        return (DeletePrivateIpResponse)this.clientCall(request, DeletePrivateIpResponse::builder).logger(LOG, "deletePrivateIp").serviceDetails("VirtualNetwork", "DeletePrivateIp", "").method(Method.DELETE).requestBuilder(DeletePrivateIpRequest::builder).basePath("/20160918").appendPathParam("privateIps").appendPathParam(request.getPrivateIpId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeletePrivateIpResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeletePublicIpResponse deletePublicIp(DeletePublicIpRequest request) {
        Validate.notBlank((String)request.getPublicIpId(), (String)"publicIpId must not be blank", (Object[])new Object[0]);
        return (DeletePublicIpResponse)this.clientCall(request, DeletePublicIpResponse::builder).logger(LOG, "deletePublicIp").serviceDetails("VirtualNetwork", "DeletePublicIp", "").method(Method.DELETE).requestBuilder(DeletePublicIpRequest::builder).basePath("/20160918").appendPathParam("publicIps").appendPathParam(request.getPublicIpId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeletePublicIpResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeletePublicIpPoolResponse deletePublicIpPool(DeletePublicIpPoolRequest request) {
        Validate.notBlank((String)request.getPublicIpPoolId(), (String)"publicIpPoolId must not be blank", (Object[])new Object[0]);
        return (DeletePublicIpPoolResponse)this.clientCall(request, DeletePublicIpPoolResponse::builder).logger(LOG, "deletePublicIpPool").serviceDetails("VirtualNetwork", "DeletePublicIpPool", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/PublicIpPool/DeletePublicIpPool").method(Method.DELETE).requestBuilder(DeletePublicIpPoolRequest::builder).basePath("/20160918").appendPathParam("publicIpPools").appendPathParam(request.getPublicIpPoolId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeletePublicIpPoolResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteRemotePeeringConnectionResponse deleteRemotePeeringConnection(DeleteRemotePeeringConnectionRequest request) {
        Validate.notBlank((String)request.getRemotePeeringConnectionId(), (String)"remotePeeringConnectionId must not be blank", (Object[])new Object[0]);
        return (DeleteRemotePeeringConnectionResponse)this.clientCall(request, DeleteRemotePeeringConnectionResponse::builder).logger(LOG, "deleteRemotePeeringConnection").serviceDetails("VirtualNetwork", "DeleteRemotePeeringConnection", "").method(Method.DELETE).requestBuilder(DeleteRemotePeeringConnectionRequest::builder).basePath("/20160918").appendPathParam("remotePeeringConnections").appendPathParam(request.getRemotePeeringConnectionId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", DeleteRemotePeeringConnectionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteRouteTableResponse deleteRouteTable(DeleteRouteTableRequest request) {
        Validate.notBlank((String)request.getRtId(), (String)"rtId must not be blank", (Object[])new Object[0]);
        return (DeleteRouteTableResponse)this.clientCall(request, DeleteRouteTableResponse::builder).logger(LOG, "deleteRouteTable").serviceDetails("VirtualNetwork", "DeleteRouteTable", "").method(Method.DELETE).requestBuilder(DeleteRouteTableRequest::builder).basePath("/20160918").appendPathParam("routeTables").appendPathParam(request.getRtId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteRouteTableResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteSecurityListResponse deleteSecurityList(DeleteSecurityListRequest request) {
        Validate.notBlank((String)request.getSecurityListId(), (String)"securityListId must not be blank", (Object[])new Object[0]);
        return (DeleteSecurityListResponse)this.clientCall(request, DeleteSecurityListResponse::builder).logger(LOG, "deleteSecurityList").serviceDetails("VirtualNetwork", "DeleteSecurityList", "").method(Method.DELETE).requestBuilder(DeleteSecurityListRequest::builder).basePath("/20160918").appendPathParam("securityLists").appendPathParam(request.getSecurityListId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteSecurityListResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteServiceGatewayResponse deleteServiceGateway(DeleteServiceGatewayRequest request) {
        Validate.notBlank((String)request.getServiceGatewayId(), (String)"serviceGatewayId must not be blank", (Object[])new Object[0]);
        return (DeleteServiceGatewayResponse)this.clientCall(request, DeleteServiceGatewayResponse::builder).logger(LOG, "deleteServiceGateway").serviceDetails("VirtualNetwork", "DeleteServiceGateway", "").method(Method.DELETE).requestBuilder(DeleteServiceGatewayRequest::builder).basePath("/20160918").appendPathParam("serviceGateways").appendPathParam(request.getServiceGatewayId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteServiceGatewayResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteSubnetResponse deleteSubnet(DeleteSubnetRequest request) {
        Validate.notBlank((String)request.getSubnetId(), (String)"subnetId must not be blank", (Object[])new Object[0]);
        return (DeleteSubnetResponse)this.clientCall(request, DeleteSubnetResponse::builder).logger(LOG, "deleteSubnet").serviceDetails("VirtualNetwork", "DeleteSubnet", "").method(Method.DELETE).requestBuilder(DeleteSubnetRequest::builder).basePath("/20160918").appendPathParam("subnets").appendPathParam(request.getSubnetId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteSubnetResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteVcnResponse deleteVcn(DeleteVcnRequest request) {
        Validate.notBlank((String)request.getVcnId(), (String)"vcnId must not be blank", (Object[])new Object[0]);
        return (DeleteVcnResponse)this.clientCall(request, DeleteVcnResponse::builder).logger(LOG, "deleteVcn").serviceDetails("VirtualNetwork", "DeleteVcn", "").method(Method.DELETE).requestBuilder(DeleteVcnRequest::builder).basePath("/20160918").appendPathParam("vcns").appendPathParam(request.getVcnId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteVcnResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteVirtualCircuitResponse deleteVirtualCircuit(DeleteVirtualCircuitRequest request) {
        Validate.notBlank((String)request.getVirtualCircuitId(), (String)"virtualCircuitId must not be blank", (Object[])new Object[0]);
        return (DeleteVirtualCircuitResponse)this.clientCall(request, DeleteVirtualCircuitResponse::builder).logger(LOG, "deleteVirtualCircuit").serviceDetails("VirtualNetwork", "DeleteVirtualCircuit", "").method(Method.DELETE).requestBuilder(DeleteVirtualCircuitRequest::builder).basePath("/20160918").appendPathParam("virtualCircuits").appendPathParam(request.getVirtualCircuitId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", DeleteVirtualCircuitResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteVlanResponse deleteVlan(DeleteVlanRequest request) {
        Validate.notBlank((String)request.getVlanId(), (String)"vlanId must not be blank", (Object[])new Object[0]);
        return (DeleteVlanResponse)this.clientCall(request, DeleteVlanResponse::builder).logger(LOG, "deleteVlan").serviceDetails("VirtualNetwork", "DeleteVlan", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Vlan/DeleteVlan").method(Method.DELETE).requestBuilder(DeleteVlanRequest::builder).basePath("/20160918").appendPathParam("vlans").appendPathParam(request.getVlanId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteVlanResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteVtapResponse deleteVtap(DeleteVtapRequest request) {
        Validate.notBlank((String)request.getVtapId(), (String)"vtapId must not be blank", (Object[])new Object[0]);
        return (DeleteVtapResponse)this.clientCall(request, DeleteVtapResponse::builder).logger(LOG, "deleteVtap").serviceDetails("VirtualNetwork", "DeleteVtap", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Vtap/DeleteVtap").method(Method.DELETE).requestBuilder(DeleteVtapRequest::builder).basePath("/20160918").appendPathParam("vtaps").appendPathParam(request.getVtapId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteVtapResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteVtapResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public DetachServiceIdResponse detachServiceId(DetachServiceIdRequest request) {
        Validate.notBlank((String)request.getServiceGatewayId(), (String)"serviceGatewayId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getDetachServiceDetails(), "detachServiceDetails is required");
        return (DetachServiceIdResponse)this.clientCall(request, DetachServiceIdResponse::builder).logger(LOG, "detachServiceId").serviceDetails("VirtualNetwork", "DetachServiceId", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ServiceGateway/DetachServiceId").method(Method.POST).requestBuilder(DetachServiceIdRequest::builder).basePath("/20160918").appendPathParam("serviceGateways").appendPathParam(request.getServiceGatewayId()).appendPathParam("actions").appendPathParam("detachService").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(ServiceGateway.class, DetachServiceIdResponse.Builder::serviceGateway).handleResponseHeaderString("opc-request-id", DetachServiceIdResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetAllDrgAttachmentsResponse getAllDrgAttachments(GetAllDrgAttachmentsRequest request) {
        Validate.notBlank((String)request.getDrgId(), (String)"drgId must not be blank", (Object[])new Object[0]);
        return (GetAllDrgAttachmentsResponse)this.clientCall(request, GetAllDrgAttachmentsResponse::builder).logger(LOG, "getAllDrgAttachments").serviceDetails("VirtualNetwork", "GetAllDrgAttachments", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Drg/GetAllDrgAttachments").method(Method.POST).requestBuilder(GetAllDrgAttachmentsRequest::builder).basePath("/20160918").appendPathParam("drgs").appendPathParam(request.getDrgId()).appendPathParam("actions").appendPathParam("getAllDrgAttachments").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("attachmentType", (BmcEnum)request.getAttachmentType()).appendQueryParam("isCrossTenancy", (Object)request.getIsCrossTenancy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(DrgAttachmentInfo.class, GetAllDrgAttachmentsResponse.Builder::items).handleResponseHeaderString("opc-next-page", GetAllDrgAttachmentsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", GetAllDrgAttachmentsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetAllowedIkeIPSecParametersResponse getAllowedIkeIPSecParameters(GetAllowedIkeIPSecParametersRequest request) {
        return (GetAllowedIkeIPSecParametersResponse)this.clientCall(request, GetAllowedIkeIPSecParametersResponse::builder).logger(LOG, "getAllowedIkeIPSecParameters").serviceDetails("VirtualNetwork", "GetAllowedIkeIPSecParameters", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/AllowedIkeIPSecParameters/GetAllowedIkeIPSecParameters").method(Method.GET).requestBuilder(GetAllowedIkeIPSecParametersRequest::builder).basePath("/20160918").appendPathParam("ipsecAlgorithms").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(AllowedIkeIPSecParameters.class, GetAllowedIkeIPSecParametersResponse.Builder::allowedIkeIPSecParameters).handleResponseHeaderString("opc-request-id", GetAllowedIkeIPSecParametersResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetByoasnResponse getByoasn(GetByoasnRequest request) {
        Validate.notBlank((String)request.getByoasnId(), (String)"byoasnId must not be blank", (Object[])new Object[0]);
        return (GetByoasnResponse)this.clientCall(request, GetByoasnResponse::builder).logger(LOG, "getByoasn").serviceDetails("VirtualNetwork", "GetByoasn", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Byoasn/GetByoasn").method(Method.GET).requestBuilder(GetByoasnRequest::builder).basePath("/20160918").appendPathParam("byoasns").appendPathParam(request.getByoasnId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(Byoasn.class, GetByoasnResponse.Builder::byoasn).handleResponseHeaderString("etag", GetByoasnResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetByoasnResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetByoipRangeResponse getByoipRange(GetByoipRangeRequest request) {
        Validate.notBlank((String)request.getByoipRangeId(), (String)"byoipRangeId must not be blank", (Object[])new Object[0]);
        return (GetByoipRangeResponse)this.clientCall(request, GetByoipRangeResponse::builder).logger(LOG, "getByoipRange").serviceDetails("VirtualNetwork", "GetByoipRange", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ByoipRange/GetByoipRange").method(Method.GET).requestBuilder(GetByoipRangeRequest::builder).basePath("/20160918").appendPathParam("byoipRanges").appendPathParam(request.getByoipRangeId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ByoipRange.class, GetByoipRangeResponse.Builder::byoipRange).handleResponseHeaderString("etag", GetByoipRangeResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetByoipRangeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetCaptureFilterResponse getCaptureFilter(GetCaptureFilterRequest request) {
        Validate.notBlank((String)request.getCaptureFilterId(), (String)"captureFilterId must not be blank", (Object[])new Object[0]);
        return (GetCaptureFilterResponse)this.clientCall(request, GetCaptureFilterResponse::builder).logger(LOG, "getCaptureFilter").serviceDetails("VirtualNetwork", "GetCaptureFilter", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/CaptureFilter/GetCaptureFilter").method(Method.GET).requestBuilder(GetCaptureFilterRequest::builder).basePath("/20160918").appendPathParam("captureFilters").appendPathParam(request.getCaptureFilterId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(CaptureFilter.class, GetCaptureFilterResponse.Builder::captureFilter).handleResponseHeaderString("etag", GetCaptureFilterResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetCaptureFilterResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetCpeResponse getCpe(GetCpeRequest request) {
        Validate.notBlank((String)request.getCpeId(), (String)"cpeId must not be blank", (Object[])new Object[0]);
        return (GetCpeResponse)this.clientCall(request, GetCpeResponse::builder).logger(LOG, "getCpe").serviceDetails("VirtualNetwork", "GetCpe", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Cpe/GetCpe").method(Method.GET).requestBuilder(GetCpeRequest::builder).basePath("/20160918").appendPathParam("cpes").appendPathParam(request.getCpeId()).accept(new String[]{"application/json"}).operationUsesDefaultRetries().handleBody(Cpe.class, GetCpeResponse.Builder::cpe).handleResponseHeaderString("etag", GetCpeResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetCpeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetCpeDeviceConfigContentResponse getCpeDeviceConfigContent(GetCpeDeviceConfigContentRequest request) {
        Validate.notBlank((String)request.getCpeId(), (String)"cpeId must not be blank", (Object[])new Object[0]);
        return (GetCpeDeviceConfigContentResponse)this.clientCall(request, GetCpeDeviceConfigContentResponse::builder).logger(LOG, "getCpeDeviceConfigContent").serviceDetails("VirtualNetwork", "GetCpeDeviceConfigContent", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Cpe/GetCpeDeviceConfigContent").method(Method.GET).requestBuilder(GetCpeDeviceConfigContentRequest::builder).basePath("/20160918").appendPathParam("cpes").appendPathParam(request.getCpeId()).appendPathParam("cpeConfigContent").accept(new String[]{"text/plain; charset=utf-8"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(InputStream.class, GetCpeDeviceConfigContentResponse.Builder::inputStream).handleResponseHeaderString("opc-request-id", GetCpeDeviceConfigContentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetCpeDeviceShapeResponse getCpeDeviceShape(GetCpeDeviceShapeRequest request) {
        Validate.notBlank((String)request.getCpeDeviceShapeId(), (String)"cpeDeviceShapeId must not be blank", (Object[])new Object[0]);
        return (GetCpeDeviceShapeResponse)this.clientCall(request, GetCpeDeviceShapeResponse::builder).logger(LOG, "getCpeDeviceShape").serviceDetails("VirtualNetwork", "GetCpeDeviceShape", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/CpeDeviceShapeDetail/GetCpeDeviceShape").method(Method.GET).requestBuilder(GetCpeDeviceShapeRequest::builder).basePath("/20160918").appendPathParam("cpeDeviceShapes").appendPathParam(request.getCpeDeviceShapeId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(CpeDeviceShapeDetail.class, GetCpeDeviceShapeResponse.Builder::cpeDeviceShapeDetail).handleResponseHeaderString("opc-request-id", GetCpeDeviceShapeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetCrossConnectResponse getCrossConnect(GetCrossConnectRequest request) {
        Validate.notBlank((String)request.getCrossConnectId(), (String)"crossConnectId must not be blank", (Object[])new Object[0]);
        return (GetCrossConnectResponse)this.clientCall(request, GetCrossConnectResponse::builder).logger(LOG, "getCrossConnect").serviceDetails("VirtualNetwork", "GetCrossConnect", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/CrossConnect/GetCrossConnect").method(Method.GET).requestBuilder(GetCrossConnectRequest::builder).basePath("/20160918").appendPathParam("crossConnects").appendPathParam(request.getCrossConnectId()).accept(new String[]{"application/json"}).operationUsesDefaultRetries().handleBody(CrossConnect.class, GetCrossConnectResponse.Builder::crossConnect).handleResponseHeaderString("etag", GetCrossConnectResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetCrossConnectResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetCrossConnectGroupResponse getCrossConnectGroup(GetCrossConnectGroupRequest request) {
        Validate.notBlank((String)request.getCrossConnectGroupId(), (String)"crossConnectGroupId must not be blank", (Object[])new Object[0]);
        return (GetCrossConnectGroupResponse)this.clientCall(request, GetCrossConnectGroupResponse::builder).logger(LOG, "getCrossConnectGroup").serviceDetails("VirtualNetwork", "GetCrossConnectGroup", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/CrossConnectGroup/GetCrossConnectGroup").method(Method.GET).requestBuilder(GetCrossConnectGroupRequest::builder).basePath("/20160918").appendPathParam("crossConnectGroups").appendPathParam(request.getCrossConnectGroupId()).accept(new String[]{"application/json"}).operationUsesDefaultRetries().handleBody(CrossConnectGroup.class, GetCrossConnectGroupResponse.Builder::crossConnectGroup).handleResponseHeaderString("etag", GetCrossConnectGroupResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetCrossConnectGroupResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetCrossConnectLetterOfAuthorityResponse getCrossConnectLetterOfAuthority(GetCrossConnectLetterOfAuthorityRequest request) {
        Validate.notBlank((String)request.getCrossConnectId(), (String)"crossConnectId must not be blank", (Object[])new Object[0]);
        return (GetCrossConnectLetterOfAuthorityResponse)this.clientCall(request, GetCrossConnectLetterOfAuthorityResponse::builder).logger(LOG, "getCrossConnectLetterOfAuthority").serviceDetails("VirtualNetwork", "GetCrossConnectLetterOfAuthority", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/LetterOfAuthority/GetCrossConnectLetterOfAuthority").method(Method.GET).requestBuilder(GetCrossConnectLetterOfAuthorityRequest::builder).basePath("/20160918").appendPathParam("crossConnects").appendPathParam(request.getCrossConnectId()).appendPathParam("letterOfAuthority").accept(new String[]{"application/json, text/html"}).operationUsesDefaultRetries().handleBody(LetterOfAuthority.class, GetCrossConnectLetterOfAuthorityResponse.Builder::letterOfAuthority).handleResponseHeaderString("opc-request-id", GetCrossConnectLetterOfAuthorityResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetCrossConnectStatusResponse getCrossConnectStatus(GetCrossConnectStatusRequest request) {
        Validate.notBlank((String)request.getCrossConnectId(), (String)"crossConnectId must not be blank", (Object[])new Object[0]);
        return (GetCrossConnectStatusResponse)this.clientCall(request, GetCrossConnectStatusResponse::builder).logger(LOG, "getCrossConnectStatus").serviceDetails("VirtualNetwork", "GetCrossConnectStatus", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/CrossConnectStatus/GetCrossConnectStatus").method(Method.GET).requestBuilder(GetCrossConnectStatusRequest::builder).basePath("/20160918").appendPathParam("crossConnects").appendPathParam(request.getCrossConnectId()).appendPathParam("status").accept(new String[]{"application/json"}).operationUsesDefaultRetries().handleBody(CrossConnectStatus.class, GetCrossConnectStatusResponse.Builder::crossConnectStatus).handleResponseHeaderString("opc-request-id", GetCrossConnectStatusResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetDhcpOptionsResponse getDhcpOptions(GetDhcpOptionsRequest request) {
        Validate.notBlank((String)request.getDhcpId(), (String)"dhcpId must not be blank", (Object[])new Object[0]);
        return (GetDhcpOptionsResponse)this.clientCall(request, GetDhcpOptionsResponse::builder).logger(LOG, "getDhcpOptions").serviceDetails("VirtualNetwork", "GetDhcpOptions", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/DhcpOptions/GetDhcpOptions").method(Method.GET).requestBuilder(GetDhcpOptionsRequest::builder).basePath("/20160918").appendPathParam("dhcps").appendPathParam(request.getDhcpId()).accept(new String[]{"application/json"}).handleBody(DhcpOptions.class, GetDhcpOptionsResponse.Builder::dhcpOptions).handleResponseHeaderString("etag", GetDhcpOptionsResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDhcpOptionsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetDrgResponse getDrg(GetDrgRequest request) {
        Validate.notBlank((String)request.getDrgId(), (String)"drgId must not be blank", (Object[])new Object[0]);
        return (GetDrgResponse)this.clientCall(request, GetDrgResponse::builder).logger(LOG, "getDrg").serviceDetails("VirtualNetwork", "GetDrg", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Drg/GetDrg").method(Method.GET).requestBuilder(GetDrgRequest::builder).basePath("/20160918").appendPathParam("drgs").appendPathParam(request.getDrgId()).accept(new String[]{"application/json"}).handleBody(Drg.class, GetDrgResponse.Builder::drg).handleResponseHeaderString("etag", GetDrgResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDrgResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetDrgAttachmentResponse getDrgAttachment(GetDrgAttachmentRequest request) {
        Validate.notBlank((String)request.getDrgAttachmentId(), (String)"drgAttachmentId must not be blank", (Object[])new Object[0]);
        return (GetDrgAttachmentResponse)this.clientCall(request, GetDrgAttachmentResponse::builder).logger(LOG, "getDrgAttachment").serviceDetails("VirtualNetwork", "GetDrgAttachment", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/DrgAttachment/GetDrgAttachment").method(Method.GET).requestBuilder(GetDrgAttachmentRequest::builder).basePath("/20160918").appendPathParam("drgAttachments").appendPathParam(request.getDrgAttachmentId()).accept(new String[]{"application/json"}).handleBody(DrgAttachment.class, GetDrgAttachmentResponse.Builder::drgAttachment).handleResponseHeaderString("etag", GetDrgAttachmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDrgAttachmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetDrgRedundancyStatusResponse getDrgRedundancyStatus(GetDrgRedundancyStatusRequest request) {
        Validate.notBlank((String)request.getDrgId(), (String)"drgId must not be blank", (Object[])new Object[0]);
        return (GetDrgRedundancyStatusResponse)this.clientCall(request, GetDrgRedundancyStatusResponse::builder).logger(LOG, "getDrgRedundancyStatus").serviceDetails("VirtualNetwork", "GetDrgRedundancyStatus", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/DrgRedundancyStatus/GetDrgRedundancyStatus").method(Method.GET).requestBuilder(GetDrgRedundancyStatusRequest::builder).basePath("/20160918").appendPathParam("drgs").appendPathParam(request.getDrgId()).appendPathParam("redundancyStatus").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(DrgRedundancyStatus.class, GetDrgRedundancyStatusResponse.Builder::drgRedundancyStatus).handleResponseHeaderString("opc-request-id", GetDrgRedundancyStatusResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetDrgRouteDistributionResponse getDrgRouteDistribution(GetDrgRouteDistributionRequest request) {
        Validate.notBlank((String)request.getDrgRouteDistributionId(), (String)"drgRouteDistributionId must not be blank", (Object[])new Object[0]);
        return (GetDrgRouteDistributionResponse)this.clientCall(request, GetDrgRouteDistributionResponse::builder).logger(LOG, "getDrgRouteDistribution").serviceDetails("VirtualNetwork", "GetDrgRouteDistribution", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/DrgRouteDistribution/GetDrgRouteDistribution").method(Method.GET).requestBuilder(GetDrgRouteDistributionRequest::builder).basePath("/20160918").appendPathParam("drgRouteDistributions").appendPathParam(request.getDrgRouteDistributionId()).accept(new String[]{"application/json"}).handleBody(DrgRouteDistribution.class, GetDrgRouteDistributionResponse.Builder::drgRouteDistribution).handleResponseHeaderString("etag", GetDrgRouteDistributionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDrgRouteDistributionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetDrgRouteTableResponse getDrgRouteTable(GetDrgRouteTableRequest request) {
        Validate.notBlank((String)request.getDrgRouteTableId(), (String)"drgRouteTableId must not be blank", (Object[])new Object[0]);
        return (GetDrgRouteTableResponse)this.clientCall(request, GetDrgRouteTableResponse::builder).logger(LOG, "getDrgRouteTable").serviceDetails("VirtualNetwork", "GetDrgRouteTable", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/DrgRouteTable/GetDrgRouteTable").method(Method.GET).requestBuilder(GetDrgRouteTableRequest::builder).basePath("/20160918").appendPathParam("drgRouteTables").appendPathParam(request.getDrgRouteTableId()).accept(new String[]{"application/json"}).handleBody(DrgRouteTable.class, GetDrgRouteTableResponse.Builder::drgRouteTable).handleResponseHeaderString("etag", GetDrgRouteTableResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDrgRouteTableResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetFastConnectProviderServiceResponse getFastConnectProviderService(GetFastConnectProviderServiceRequest request) {
        Validate.notBlank((String)request.getProviderServiceId(), (String)"providerServiceId must not be blank", (Object[])new Object[0]);
        return (GetFastConnectProviderServiceResponse)this.clientCall(request, GetFastConnectProviderServiceResponse::builder).logger(LOG, "getFastConnectProviderService").serviceDetails("VirtualNetwork", "GetFastConnectProviderService", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/FastConnectProviderService/GetFastConnectProviderService").method(Method.GET).requestBuilder(GetFastConnectProviderServiceRequest::builder).basePath("/20160918").appendPathParam("fastConnectProviderServices").appendPathParam(request.getProviderServiceId()).accept(new String[]{"application/json"}).operationUsesDefaultRetries().handleBody(FastConnectProviderService.class, GetFastConnectProviderServiceResponse.Builder::fastConnectProviderService).handleResponseHeaderString("opc-request-id", GetFastConnectProviderServiceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetFastConnectProviderServiceKeyResponse getFastConnectProviderServiceKey(GetFastConnectProviderServiceKeyRequest request) {
        Validate.notBlank((String)request.getProviderServiceId(), (String)"providerServiceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getProviderServiceKeyName(), (String)"providerServiceKeyName must not be blank", (Object[])new Object[0]);
        return (GetFastConnectProviderServiceKeyResponse)this.clientCall(request, GetFastConnectProviderServiceKeyResponse::builder).logger(LOG, "getFastConnectProviderServiceKey").serviceDetails("VirtualNetwork", "GetFastConnectProviderServiceKey", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/FastConnectProviderServiceKey/GetFastConnectProviderServiceKey").method(Method.GET).requestBuilder(GetFastConnectProviderServiceKeyRequest::builder).basePath("/20160918").appendPathParam("fastConnectProviderServices").appendPathParam(request.getProviderServiceId()).appendPathParam("providerServiceKeys").appendPathParam(request.getProviderServiceKeyName()).accept(new String[]{"application/json"}).operationUsesDefaultRetries().handleBody(FastConnectProviderServiceKey.class, GetFastConnectProviderServiceKeyResponse.Builder::fastConnectProviderServiceKey).handleResponseHeaderString("opc-request-id", GetFastConnectProviderServiceKeyResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetIPSecConnectionResponse getIPSecConnection(GetIPSecConnectionRequest request) {
        Validate.notBlank((String)request.getIpscId(), (String)"ipscId must not be blank", (Object[])new Object[0]);
        return (GetIPSecConnectionResponse)this.clientCall(request, GetIPSecConnectionResponse::builder).logger(LOG, "getIPSecConnection").serviceDetails("VirtualNetwork", "GetIPSecConnection", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/IPSecConnection/GetIPSecConnection").method(Method.GET).requestBuilder(GetIPSecConnectionRequest::builder).basePath("/20160918").appendPathParam("ipsecConnections").appendPathParam(request.getIpscId()).accept(new String[]{"application/json"}).operationUsesDefaultRetries().handleBody(IPSecConnection.class, GetIPSecConnectionResponse.Builder::iPSecConnection).handleResponseHeaderString("etag", GetIPSecConnectionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetIPSecConnectionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetIPSecConnectionDeviceConfigResponse getIPSecConnectionDeviceConfig(GetIPSecConnectionDeviceConfigRequest request) {
        Validate.notBlank((String)request.getIpscId(), (String)"ipscId must not be blank", (Object[])new Object[0]);
        return (GetIPSecConnectionDeviceConfigResponse)this.clientCall(request, GetIPSecConnectionDeviceConfigResponse::builder).logger(LOG, "getIPSecConnectionDeviceConfig").serviceDetails("VirtualNetwork", "GetIPSecConnectionDeviceConfig", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/IPSecConnectionDeviceConfig/GetIPSecConnectionDeviceConfig").method(Method.GET).requestBuilder(GetIPSecConnectionDeviceConfigRequest::builder).basePath("/20160918").appendPathParam("ipsecConnections").appendPathParam(request.getIpscId()).appendPathParam("deviceConfig").accept(new String[]{"application/json"}).operationUsesDefaultRetries().handleBody(IPSecConnectionDeviceConfig.class, GetIPSecConnectionDeviceConfigResponse.Builder::iPSecConnectionDeviceConfig).handleResponseHeaderString("etag", GetIPSecConnectionDeviceConfigResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetIPSecConnectionDeviceConfigResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetIPSecConnectionDeviceStatusResponse getIPSecConnectionDeviceStatus(GetIPSecConnectionDeviceStatusRequest request) {
        Validate.notBlank((String)request.getIpscId(), (String)"ipscId must not be blank", (Object[])new Object[0]);
        return (GetIPSecConnectionDeviceStatusResponse)this.clientCall(request, GetIPSecConnectionDeviceStatusResponse::builder).logger(LOG, "getIPSecConnectionDeviceStatus").serviceDetails("VirtualNetwork", "GetIPSecConnectionDeviceStatus", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/IPSecConnectionDeviceStatus/GetIPSecConnectionDeviceStatus").method(Method.GET).requestBuilder(GetIPSecConnectionDeviceStatusRequest::builder).basePath("/20160918").appendPathParam("ipsecConnections").appendPathParam(request.getIpscId()).appendPathParam("deviceStatus").accept(new String[]{"application/json"}).operationUsesDefaultRetries().handleBody(IPSecConnectionDeviceStatus.class, GetIPSecConnectionDeviceStatusResponse.Builder::iPSecConnectionDeviceStatus).handleResponseHeaderString("etag", GetIPSecConnectionDeviceStatusResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetIPSecConnectionDeviceStatusResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetIPSecConnectionTunnelResponse getIPSecConnectionTunnel(GetIPSecConnectionTunnelRequest request) {
        Validate.notBlank((String)request.getIpscId(), (String)"ipscId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTunnelId(), (String)"tunnelId must not be blank", (Object[])new Object[0]);
        return (GetIPSecConnectionTunnelResponse)this.clientCall(request, GetIPSecConnectionTunnelResponse::builder).logger(LOG, "getIPSecConnectionTunnel").serviceDetails("VirtualNetwork", "GetIPSecConnectionTunnel", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/IPSecConnectionTunnel/GetIPSecConnectionTunnel").method(Method.GET).requestBuilder(GetIPSecConnectionTunnelRequest::builder).basePath("/20160918").appendPathParam("ipsecConnections").appendPathParam(request.getIpscId()).appendPathParam("tunnels").appendPathParam(request.getTunnelId()).accept(new String[]{"application/json"}).operationUsesDefaultRetries().handleBody(IPSecConnectionTunnel.class, GetIPSecConnectionTunnelResponse.Builder::iPSecConnectionTunnel).handleResponseHeaderString("etag", GetIPSecConnectionTunnelResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetIPSecConnectionTunnelResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetIPSecConnectionTunnelErrorResponse getIPSecConnectionTunnelError(GetIPSecConnectionTunnelErrorRequest request) {
        Validate.notBlank((String)request.getIpscId(), (String)"ipscId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTunnelId(), (String)"tunnelId must not be blank", (Object[])new Object[0]);
        return (GetIPSecConnectionTunnelErrorResponse)this.clientCall(request, GetIPSecConnectionTunnelErrorResponse::builder).logger(LOG, "getIPSecConnectionTunnelError").serviceDetails("VirtualNetwork", "GetIPSecConnectionTunnelError", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/IPSecConnectionTunnelErrorDetails/GetIPSecConnectionTunnelError").method(Method.GET).requestBuilder(GetIPSecConnectionTunnelErrorRequest::builder).basePath("/20160918").appendPathParam("ipsecConnections").appendPathParam(request.getIpscId()).appendPathParam("tunnels").appendPathParam(request.getTunnelId()).appendPathParam("error").accept(new String[]{"application/json"}).operationUsesDefaultRetries().handleBody(IPSecConnectionTunnelErrorDetails.class, GetIPSecConnectionTunnelErrorResponse.Builder::iPSecConnectionTunnelErrorDetails).handleResponseHeaderString("opc-request-id", GetIPSecConnectionTunnelErrorResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetIPSecConnectionTunnelSharedSecretResponse getIPSecConnectionTunnelSharedSecret(GetIPSecConnectionTunnelSharedSecretRequest request) {
        Validate.notBlank((String)request.getIpscId(), (String)"ipscId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTunnelId(), (String)"tunnelId must not be blank", (Object[])new Object[0]);
        return (GetIPSecConnectionTunnelSharedSecretResponse)this.clientCall(request, GetIPSecConnectionTunnelSharedSecretResponse::builder).logger(LOG, "getIPSecConnectionTunnelSharedSecret").serviceDetails("VirtualNetwork", "GetIPSecConnectionTunnelSharedSecret", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/IPSecConnectionTunnelSharedSecret/GetIPSecConnectionTunnelSharedSecret").method(Method.GET).requestBuilder(GetIPSecConnectionTunnelSharedSecretRequest::builder).basePath("/20160918").appendPathParam("ipsecConnections").appendPathParam(request.getIpscId()).appendPathParam("tunnels").appendPathParam(request.getTunnelId()).appendPathParam("sharedSecret").accept(new String[]{"application/json"}).operationUsesDefaultRetries().handleBody(IPSecConnectionTunnelSharedSecret.class, GetIPSecConnectionTunnelSharedSecretResponse.Builder::iPSecConnectionTunnelSharedSecret).handleResponseHeaderString("etag", GetIPSecConnectionTunnelSharedSecretResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetIPSecConnectionTunnelSharedSecretResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetInternetGatewayResponse getInternetGateway(GetInternetGatewayRequest request) {
        Validate.notBlank((String)request.getIgId(), (String)"igId must not be blank", (Object[])new Object[0]);
        return (GetInternetGatewayResponse)this.clientCall(request, GetInternetGatewayResponse::builder).logger(LOG, "getInternetGateway").serviceDetails("VirtualNetwork", "GetInternetGateway", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/InternetGateway/GetInternetGateway").method(Method.GET).requestBuilder(GetInternetGatewayRequest::builder).basePath("/20160918").appendPathParam("internetGateways").appendPathParam(request.getIgId()).accept(new String[]{"application/json"}).handleBody(InternetGateway.class, GetInternetGatewayResponse.Builder::internetGateway).handleResponseHeaderString("etag", GetInternetGatewayResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetInternetGatewayResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetIpsecCpeDeviceConfigContentResponse getIpsecCpeDeviceConfigContent(GetIpsecCpeDeviceConfigContentRequest request) {
        Validate.notBlank((String)request.getIpscId(), (String)"ipscId must not be blank", (Object[])new Object[0]);
        return (GetIpsecCpeDeviceConfigContentResponse)this.clientCall(request, GetIpsecCpeDeviceConfigContentResponse::builder).logger(LOG, "getIpsecCpeDeviceConfigContent").serviceDetails("VirtualNetwork", "GetIpsecCpeDeviceConfigContent", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/IPSecConnection/GetIpsecCpeDeviceConfigContent").method(Method.GET).requestBuilder(GetIpsecCpeDeviceConfigContentRequest::builder).basePath("/20160918").appendPathParam("ipsecConnections").appendPathParam(request.getIpscId()).appendPathParam("cpeConfigContent").accept(new String[]{"text/plain; charset=utf-8"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(InputStream.class, GetIpsecCpeDeviceConfigContentResponse.Builder::inputStream).handleResponseHeaderString("opc-request-id", GetIpsecCpeDeviceConfigContentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetIpv6Response getIpv6(GetIpv6Request request) {
        Validate.notBlank((String)request.getIpv6Id(), (String)"ipv6Id must not be blank", (Object[])new Object[0]);
        return (GetIpv6Response)this.clientCall(request, GetIpv6Response::builder).logger(LOG, "getIpv6").serviceDetails("VirtualNetwork", "GetIpv6", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Ipv6/GetIpv6").method(Method.GET).requestBuilder(GetIpv6Request::builder).basePath("/20160918").appendPathParam("ipv6").appendPathParam(request.getIpv6Id()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Ipv6.class, GetIpv6Response.Builder::ipv6).handleResponseHeaderString("etag", GetIpv6Response.Builder::etag).handleResponseHeaderString("opc-request-id", GetIpv6Response.Builder::opcRequestId).callSync();
    }

    @Override
    public GetLocalPeeringGatewayResponse getLocalPeeringGateway(GetLocalPeeringGatewayRequest request) {
        Validate.notBlank((String)request.getLocalPeeringGatewayId(), (String)"localPeeringGatewayId must not be blank", (Object[])new Object[0]);
        return (GetLocalPeeringGatewayResponse)this.clientCall(request, GetLocalPeeringGatewayResponse::builder).logger(LOG, "getLocalPeeringGateway").serviceDetails("VirtualNetwork", "GetLocalPeeringGateway", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/LocalPeeringGateway/GetLocalPeeringGateway").method(Method.GET).requestBuilder(GetLocalPeeringGatewayRequest::builder).basePath("/20160918").appendPathParam("localPeeringGateways").appendPathParam(request.getLocalPeeringGatewayId()).accept(new String[]{"application/json"}).handleBody(LocalPeeringGateway.class, GetLocalPeeringGatewayResponse.Builder::localPeeringGateway).handleResponseHeaderString("etag", GetLocalPeeringGatewayResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetLocalPeeringGatewayResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetNatGatewayResponse getNatGateway(GetNatGatewayRequest request) {
        Validate.notBlank((String)request.getNatGatewayId(), (String)"natGatewayId must not be blank", (Object[])new Object[0]);
        return (GetNatGatewayResponse)this.clientCall(request, GetNatGatewayResponse::builder).logger(LOG, "getNatGateway").serviceDetails("VirtualNetwork", "GetNatGateway", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/NatGateway/GetNatGateway").method(Method.GET).requestBuilder(GetNatGatewayRequest::builder).basePath("/20160918").appendPathParam("natGateways").appendPathParam(request.getNatGatewayId()).accept(new String[]{"application/json"}).handleBody(NatGateway.class, GetNatGatewayResponse.Builder::natGateway).handleResponseHeaderString("etag", GetNatGatewayResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetNatGatewayResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetNetworkSecurityGroupResponse getNetworkSecurityGroup(GetNetworkSecurityGroupRequest request) {
        Validate.notBlank((String)request.getNetworkSecurityGroupId(), (String)"networkSecurityGroupId must not be blank", (Object[])new Object[0]);
        return (GetNetworkSecurityGroupResponse)this.clientCall(request, GetNetworkSecurityGroupResponse::builder).logger(LOG, "getNetworkSecurityGroup").serviceDetails("VirtualNetwork", "GetNetworkSecurityGroup", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/NetworkSecurityGroup/GetNetworkSecurityGroup").method(Method.GET).requestBuilder(GetNetworkSecurityGroupRequest::builder).basePath("/20160918").appendPathParam("networkSecurityGroups").appendPathParam(request.getNetworkSecurityGroupId()).accept(new String[]{"application/json"}).handleBody(NetworkSecurityGroup.class, GetNetworkSecurityGroupResponse.Builder::networkSecurityGroup).handleResponseHeaderString("etag", GetNetworkSecurityGroupResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetNetworkSecurityGroupResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetNetworkingTopologyResponse getNetworkingTopology(GetNetworkingTopologyRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (GetNetworkingTopologyResponse)this.clientCall(request, GetNetworkingTopologyResponse::builder).logger(LOG, "getNetworkingTopology").serviceDetails("VirtualNetwork", "GetNetworkingTopology", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/NetworkingTopology/GetNetworkingTopology").method(Method.GET).requestBuilder(GetNetworkingTopologyRequest::builder).basePath("/20160918").appendPathParam("networkingTopology").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("accessLevel", (BmcEnum)request.getAccessLevel()).appendQueryParam("queryCompartmentSubtree", (Object)request.getQueryCompartmentSubtree()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-none-match", request.getIfNoneMatch()).appendHeader("cache-control", request.getCacheControl()).handleBody(NetworkingTopology.class, GetNetworkingTopologyResponse.Builder::networkingTopology).handleResponseHeaderString("etag", GetNetworkingTopologyResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetNetworkingTopologyResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetPrivateIpResponse getPrivateIp(GetPrivateIpRequest request) {
        Validate.notBlank((String)request.getPrivateIpId(), (String)"privateIpId must not be blank", (Object[])new Object[0]);
        return (GetPrivateIpResponse)this.clientCall(request, GetPrivateIpResponse::builder).logger(LOG, "getPrivateIp").serviceDetails("VirtualNetwork", "GetPrivateIp", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/PrivateIp/GetPrivateIp").method(Method.GET).requestBuilder(GetPrivateIpRequest::builder).basePath("/20160918").appendPathParam("privateIps").appendPathParam(request.getPrivateIpId()).accept(new String[]{"application/json"}).handleBody(PrivateIp.class, GetPrivateIpResponse.Builder::privateIp).handleResponseHeaderString("etag", GetPrivateIpResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetPrivateIpResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetPublicIpResponse getPublicIp(GetPublicIpRequest request) {
        Validate.notBlank((String)request.getPublicIpId(), (String)"publicIpId must not be blank", (Object[])new Object[0]);
        return (GetPublicIpResponse)this.clientCall(request, GetPublicIpResponse::builder).logger(LOG, "getPublicIp").serviceDetails("VirtualNetwork", "GetPublicIp", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/PublicIp/GetPublicIp").method(Method.GET).requestBuilder(GetPublicIpRequest::builder).basePath("/20160918").appendPathParam("publicIps").appendPathParam(request.getPublicIpId()).accept(new String[]{"application/json"}).handleBody(PublicIp.class, GetPublicIpResponse.Builder::publicIp).handleResponseHeaderString("etag", GetPublicIpResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetPublicIpResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetPublicIpByIpAddressResponse getPublicIpByIpAddress(GetPublicIpByIpAddressRequest request) {
        Objects.requireNonNull(request.getGetPublicIpByIpAddressDetails(), "getPublicIpByIpAddressDetails is required");
        return (GetPublicIpByIpAddressResponse)this.clientCall(request, GetPublicIpByIpAddressResponse::builder).logger(LOG, "getPublicIpByIpAddress").serviceDetails("VirtualNetwork", "GetPublicIpByIpAddress", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/PublicIp/GetPublicIpByIpAddress").method(Method.POST).requestBuilder(GetPublicIpByIpAddressRequest::builder).basePath("/20160918").appendPathParam("publicIps").appendPathParam("actions").appendPathParam("getByIpAddress").accept(new String[]{"application/json"}).hasBody().handleBody(PublicIp.class, GetPublicIpByIpAddressResponse.Builder::publicIp).handleResponseHeaderString("etag", GetPublicIpByIpAddressResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetPublicIpByIpAddressResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetPublicIpByPrivateIpIdResponse getPublicIpByPrivateIpId(GetPublicIpByPrivateIpIdRequest request) {
        Objects.requireNonNull(request.getGetPublicIpByPrivateIpIdDetails(), "getPublicIpByPrivateIpIdDetails is required");
        return (GetPublicIpByPrivateIpIdResponse)this.clientCall(request, GetPublicIpByPrivateIpIdResponse::builder).logger(LOG, "getPublicIpByPrivateIpId").serviceDetails("VirtualNetwork", "GetPublicIpByPrivateIpId", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/PublicIp/GetPublicIpByPrivateIpId").method(Method.POST).requestBuilder(GetPublicIpByPrivateIpIdRequest::builder).basePath("/20160918").appendPathParam("publicIps").appendPathParam("actions").appendPathParam("getByPrivateIpId").accept(new String[]{"application/json"}).hasBody().handleBody(PublicIp.class, GetPublicIpByPrivateIpIdResponse.Builder::publicIp).handleResponseHeaderString("etag", GetPublicIpByPrivateIpIdResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetPublicIpByPrivateIpIdResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetPublicIpPoolResponse getPublicIpPool(GetPublicIpPoolRequest request) {
        Validate.notBlank((String)request.getPublicIpPoolId(), (String)"publicIpPoolId must not be blank", (Object[])new Object[0]);
        return (GetPublicIpPoolResponse)this.clientCall(request, GetPublicIpPoolResponse::builder).logger(LOG, "getPublicIpPool").serviceDetails("VirtualNetwork", "GetPublicIpPool", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/PublicIpPool/GetPublicIpPool").method(Method.GET).requestBuilder(GetPublicIpPoolRequest::builder).basePath("/20160918").appendPathParam("publicIpPools").appendPathParam(request.getPublicIpPoolId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(PublicIpPool.class, GetPublicIpPoolResponse.Builder::publicIpPool).handleResponseHeaderString("etag", GetPublicIpPoolResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetPublicIpPoolResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetRemotePeeringConnectionResponse getRemotePeeringConnection(GetRemotePeeringConnectionRequest request) {
        Validate.notBlank((String)request.getRemotePeeringConnectionId(), (String)"remotePeeringConnectionId must not be blank", (Object[])new Object[0]);
        return (GetRemotePeeringConnectionResponse)this.clientCall(request, GetRemotePeeringConnectionResponse::builder).logger(LOG, "getRemotePeeringConnection").serviceDetails("VirtualNetwork", "GetRemotePeeringConnection", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/RemotePeeringConnection/GetRemotePeeringConnection").method(Method.GET).requestBuilder(GetRemotePeeringConnectionRequest::builder).basePath("/20160918").appendPathParam("remotePeeringConnections").appendPathParam(request.getRemotePeeringConnectionId()).accept(new String[]{"application/json"}).operationUsesDefaultRetries().handleBody(RemotePeeringConnection.class, GetRemotePeeringConnectionResponse.Builder::remotePeeringConnection).handleResponseHeaderString("etag", GetRemotePeeringConnectionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetRemotePeeringConnectionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetResourceIpInventoryResponse getResourceIpInventory(GetResourceIpInventoryRequest request) {
        Validate.notBlank((String)request.getDataRequestId(), (String)"dataRequestId must not be blank", (Object[])new Object[0]);
        return (GetResourceIpInventoryResponse)this.clientCall(request, GetResourceIpInventoryResponse::builder).logger(LOG, "getResourceIpInventory").serviceDetails("VirtualNetwork", "GetResourceIpInventory", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/IpInventoryCollection/GetResourceIpInventory").method(Method.GET).requestBuilder(GetResourceIpInventoryRequest::builder).basePath("/20160918").appendPathParam("ipinventory").appendPathParam("DataRequestId").appendPathParam(request.getDataRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(IpInventoryCollection.class, GetResourceIpInventoryResponse.Builder::ipInventoryCollection).handleResponseHeaderString("etag", GetResourceIpInventoryResponse.Builder::etag).handleResponseHeaderString("opc-next-page", GetResourceIpInventoryResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", GetResourceIpInventoryResponse.Builder::opcRequestId).handleResponseHeaderInteger("opc-total-items", GetResourceIpInventoryResponse.Builder::opcTotalItems).callSync();
    }

    @Override
    public GetRouteTableResponse getRouteTable(GetRouteTableRequest request) {
        Validate.notBlank((String)request.getRtId(), (String)"rtId must not be blank", (Object[])new Object[0]);
        return (GetRouteTableResponse)this.clientCall(request, GetRouteTableResponse::builder).logger(LOG, "getRouteTable").serviceDetails("VirtualNetwork", "GetRouteTable", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/RouteTable/GetRouteTable").method(Method.GET).requestBuilder(GetRouteTableRequest::builder).basePath("/20160918").appendPathParam("routeTables").appendPathParam(request.getRtId()).accept(new String[]{"application/json"}).handleBody(RouteTable.class, GetRouteTableResponse.Builder::routeTable).handleResponseHeaderString("etag", GetRouteTableResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetRouteTableResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetSecurityListResponse getSecurityList(GetSecurityListRequest request) {
        Validate.notBlank((String)request.getSecurityListId(), (String)"securityListId must not be blank", (Object[])new Object[0]);
        return (GetSecurityListResponse)this.clientCall(request, GetSecurityListResponse::builder).logger(LOG, "getSecurityList").serviceDetails("VirtualNetwork", "GetSecurityList", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/SecurityList/GetSecurityList").method(Method.GET).requestBuilder(GetSecurityListRequest::builder).basePath("/20160918").appendPathParam("securityLists").appendPathParam(request.getSecurityListId()).accept(new String[]{"application/json"}).handleBody(SecurityList.class, GetSecurityListResponse.Builder::securityList).handleResponseHeaderString("etag", GetSecurityListResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetSecurityListResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetServiceResponse getService(GetServiceRequest request) {
        Validate.notBlank((String)request.getServiceId(), (String)"serviceId must not be blank", (Object[])new Object[0]);
        return (GetServiceResponse)this.clientCall(request, GetServiceResponse::builder).logger(LOG, "getService").serviceDetails("VirtualNetwork", "GetService", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Service/GetService").method(Method.GET).requestBuilder(GetServiceRequest::builder).basePath("/20160918").appendPathParam("services").appendPathParam(request.getServiceId()).accept(new String[]{"application/json"}).handleBody(com.oracle.bmc.core.model.Service.class, GetServiceResponse.Builder::service).handleResponseHeaderString("etag", GetServiceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetServiceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetServiceGatewayResponse getServiceGateway(GetServiceGatewayRequest request) {
        Validate.notBlank((String)request.getServiceGatewayId(), (String)"serviceGatewayId must not be blank", (Object[])new Object[0]);
        return (GetServiceGatewayResponse)this.clientCall(request, GetServiceGatewayResponse::builder).logger(LOG, "getServiceGateway").serviceDetails("VirtualNetwork", "GetServiceGateway", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ServiceGateway/GetServiceGateway").method(Method.GET).requestBuilder(GetServiceGatewayRequest::builder).basePath("/20160918").appendPathParam("serviceGateways").appendPathParam(request.getServiceGatewayId()).accept(new String[]{"application/json"}).handleBody(ServiceGateway.class, GetServiceGatewayResponse.Builder::serviceGateway).handleResponseHeaderString("etag", GetServiceGatewayResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetServiceGatewayResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetSubnetResponse getSubnet(GetSubnetRequest request) {
        Validate.notBlank((String)request.getSubnetId(), (String)"subnetId must not be blank", (Object[])new Object[0]);
        return (GetSubnetResponse)this.clientCall(request, GetSubnetResponse::builder).logger(LOG, "getSubnet").serviceDetails("VirtualNetwork", "GetSubnet", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Subnet/GetSubnet").method(Method.GET).requestBuilder(GetSubnetRequest::builder).basePath("/20160918").appendPathParam("subnets").appendPathParam(request.getSubnetId()).accept(new String[]{"application/json"}).handleBody(Subnet.class, GetSubnetResponse.Builder::subnet).handleResponseHeaderString("etag", GetSubnetResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetSubnetResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetSubnetCidrUtilizationResponse getSubnetCidrUtilization(GetSubnetCidrUtilizationRequest request) {
        Validate.notBlank((String)request.getSubnetId(), (String)"subnetId must not be blank", (Object[])new Object[0]);
        return (GetSubnetCidrUtilizationResponse)this.clientCall(request, GetSubnetCidrUtilizationResponse::builder).logger(LOG, "getSubnetCidrUtilization").serviceDetails("VirtualNetwork", "GetSubnetCidrUtilization", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/IpInventoryCidrUtilizationCollection/GetSubnetCidrUtilization").method(Method.GET).requestBuilder(GetSubnetCidrUtilizationRequest::builder).basePath("/20160918").appendPathParam("ipInventory").appendPathParam("subnets").appendPathParam(request.getSubnetId()).appendPathParam("cidrs").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(IpInventoryCidrUtilizationCollection.class, GetSubnetCidrUtilizationResponse.Builder::ipInventoryCidrUtilizationCollection).handleResponseHeaderString("etag", GetSubnetCidrUtilizationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetSubnetCidrUtilizationResponse.Builder::opcRequestId).handleResponseHeaderInteger("opc-total-items", GetSubnetCidrUtilizationResponse.Builder::opcTotalItems).callSync();
    }

    @Override
    public GetSubnetIpInventoryResponse getSubnetIpInventory(GetSubnetIpInventoryRequest request) {
        Validate.notBlank((String)request.getSubnetId(), (String)"subnetId must not be blank", (Object[])new Object[0]);
        return (GetSubnetIpInventoryResponse)this.clientCall(request, GetSubnetIpInventoryResponse::builder).logger(LOG, "getSubnetIpInventory").serviceDetails("VirtualNetwork", "GetSubnetIpInventory", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/IpInventorySubnetResourceCollection/GetSubnetIpInventory").method(Method.GET).requestBuilder(GetSubnetIpInventoryRequest::builder).basePath("/20160918").appendPathParam("ipInventory").appendPathParam("subnets").appendPathParam(request.getSubnetId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(IpInventorySubnetResourceCollection.class, GetSubnetIpInventoryResponse.Builder::ipInventorySubnetResourceCollection).handleResponseHeaderString("etag", GetSubnetIpInventoryResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetSubnetIpInventoryResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetSubnetTopologyResponse getSubnetTopology(GetSubnetTopologyRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getSubnetId(), "subnetId is required");
        return (GetSubnetTopologyResponse)this.clientCall(request, GetSubnetTopologyResponse::builder).logger(LOG, "getSubnetTopology").serviceDetails("VirtualNetwork", "GetSubnetTopology", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/SubnetTopology/GetSubnetTopology").method(Method.GET).requestBuilder(GetSubnetTopologyRequest::builder).basePath("/20160918").appendPathParam("subnetTopology").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("accessLevel", (BmcEnum)request.getAccessLevel()).appendQueryParam("queryCompartmentSubtree", (Object)request.getQueryCompartmentSubtree()).appendQueryParam("subnetId", (Object)request.getSubnetId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-none-match", request.getIfNoneMatch()).appendHeader("cache-control", request.getCacheControl()).handleBody(SubnetTopology.class, GetSubnetTopologyResponse.Builder::subnetTopology).handleResponseHeaderString("etag", GetSubnetTopologyResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetSubnetTopologyResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetTunnelCpeDeviceConfigResponse getTunnelCpeDeviceConfig(GetTunnelCpeDeviceConfigRequest request) {
        Validate.notBlank((String)request.getIpscId(), (String)"ipscId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTunnelId(), (String)"tunnelId must not be blank", (Object[])new Object[0]);
        return (GetTunnelCpeDeviceConfigResponse)this.clientCall(request, GetTunnelCpeDeviceConfigResponse::builder).logger(LOG, "getTunnelCpeDeviceConfig").serviceDetails("VirtualNetwork", "GetTunnelCpeDeviceConfig", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/TunnelCpeDeviceConfig/GetTunnelCpeDeviceConfig").method(Method.GET).requestBuilder(GetTunnelCpeDeviceConfigRequest::builder).basePath("/20160918").appendPathParam("ipsecConnections").appendPathParam(request.getIpscId()).appendPathParam("tunnels").appendPathParam(request.getTunnelId()).appendPathParam("tunnelDeviceConfig").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(TunnelCpeDeviceConfig.class, GetTunnelCpeDeviceConfigResponse.Builder::tunnelCpeDeviceConfig).handleResponseHeaderString("etag", GetTunnelCpeDeviceConfigResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetTunnelCpeDeviceConfigResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetTunnelCpeDeviceConfigContentResponse getTunnelCpeDeviceConfigContent(GetTunnelCpeDeviceConfigContentRequest request) {
        Validate.notBlank((String)request.getIpscId(), (String)"ipscId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTunnelId(), (String)"tunnelId must not be blank", (Object[])new Object[0]);
        return (GetTunnelCpeDeviceConfigContentResponse)this.clientCall(request, GetTunnelCpeDeviceConfigContentResponse::builder).logger(LOG, "getTunnelCpeDeviceConfigContent").serviceDetails("VirtualNetwork", "GetTunnelCpeDeviceConfigContent", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/TunnelCpeDeviceConfig/GetTunnelCpeDeviceConfigContent").method(Method.GET).requestBuilder(GetTunnelCpeDeviceConfigContentRequest::builder).basePath("/20160918").appendPathParam("ipsecConnections").appendPathParam(request.getIpscId()).appendPathParam("tunnels").appendPathParam(request.getTunnelId()).appendPathParam("tunnelDeviceConfig").appendPathParam("content").accept(new String[]{"text/plain; charset=utf-8"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(InputStream.class, GetTunnelCpeDeviceConfigContentResponse.Builder::inputStream).handleResponseHeaderString("opc-request-id", GetTunnelCpeDeviceConfigContentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetUpgradeStatusResponse getUpgradeStatus(GetUpgradeStatusRequest request) {
        Validate.notBlank((String)request.getDrgId(), (String)"drgId must not be blank", (Object[])new Object[0]);
        return (GetUpgradeStatusResponse)this.clientCall(request, GetUpgradeStatusResponse::builder).logger(LOG, "getUpgradeStatus").serviceDetails("VirtualNetwork", "GetUpgradeStatus", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Drg/GetUpgradeStatus").method(Method.GET).requestBuilder(GetUpgradeStatusRequest::builder).basePath("/20160918").appendPathParam("drgs").appendPathParam(request.getDrgId()).appendPathParam("actions").appendPathParam("upgradeStatus").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(UpgradeStatus.class, GetUpgradeStatusResponse.Builder::upgradeStatus).handleResponseHeaderString("opc-request-id", GetUpgradeStatusResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetVcnResponse getVcn(GetVcnRequest request) {
        Validate.notBlank((String)request.getVcnId(), (String)"vcnId must not be blank", (Object[])new Object[0]);
        return (GetVcnResponse)this.clientCall(request, GetVcnResponse::builder).logger(LOG, "getVcn").serviceDetails("VirtualNetwork", "GetVcn", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Vcn/GetVcn").method(Method.GET).requestBuilder(GetVcnRequest::builder).basePath("/20160918").appendPathParam("vcns").appendPathParam(request.getVcnId()).accept(new String[]{"application/json"}).handleBody(Vcn.class, GetVcnResponse.Builder::vcn).handleResponseHeaderString("etag", GetVcnResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetVcnResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetVcnDnsResolverAssociationResponse getVcnDnsResolverAssociation(GetVcnDnsResolverAssociationRequest request) {
        Validate.notBlank((String)request.getVcnId(), (String)"vcnId must not be blank", (Object[])new Object[0]);
        return (GetVcnDnsResolverAssociationResponse)this.clientCall(request, GetVcnDnsResolverAssociationResponse::builder).logger(LOG, "getVcnDnsResolverAssociation").serviceDetails("VirtualNetwork", "GetVcnDnsResolverAssociation", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/VcnDnsResolverAssociation/GetVcnDnsResolverAssociation").method(Method.GET).requestBuilder(GetVcnDnsResolverAssociationRequest::builder).basePath("/20160918").appendPathParam("vcns").appendPathParam(request.getVcnId()).appendPathParam("dnsResolverAssociation").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(VcnDnsResolverAssociation.class, GetVcnDnsResolverAssociationResponse.Builder::vcnDnsResolverAssociation).handleResponseHeaderString("etag", GetVcnDnsResolverAssociationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetVcnDnsResolverAssociationResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetVcnOverlapResponse getVcnOverlap(GetVcnOverlapRequest request) {
        Validate.notBlank((String)request.getVcnId(), (String)"vcnId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getGetVcnOverlapDetails(), "getVcnOverlapDetails is required");
        return (GetVcnOverlapResponse)this.clientCall(request, GetVcnOverlapResponse::builder).logger(LOG, "getVcnOverlap").serviceDetails("VirtualNetwork", "GetVcnOverlap", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/IpInventoryVcnOverlapCollection/GetVcnOverlap").method(Method.POST).requestBuilder(GetVcnOverlapRequest::builder).basePath("/20160918").appendPathParam("ipInventory").appendPathParam("vcns").appendPathParam(request.getVcnId()).appendPathParam("overlaps").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(IpInventoryVcnOverlapCollection.class, GetVcnOverlapResponse.Builder::ipInventoryVcnOverlapCollection).handleResponseHeaderString("etag", GetVcnOverlapResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetVcnOverlapResponse.Builder::opcRequestId).handleResponseHeaderInteger("opc-total-items", GetVcnOverlapResponse.Builder::opcTotalItems).handleResponseHeaderString("opc-work-request-id", GetVcnOverlapResponse.Builder::opcWorkRequestId).handleResponseHeaderEnum("lifecycle-state", GetVcnOverlapResponse.LifecycleState::create, GetVcnOverlapResponse.Builder::lifecycleState).handleResponseHeaderString("data-request-id", GetVcnOverlapResponse.Builder::dataRequestId).callSync();
    }

    @Override
    public GetVcnTopologyResponse getVcnTopology(GetVcnTopologyRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getVcnId(), "vcnId is required");
        return (GetVcnTopologyResponse)this.clientCall(request, GetVcnTopologyResponse::builder).logger(LOG, "getVcnTopology").serviceDetails("VirtualNetwork", "GetVcnTopology", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/VcnTopology/GetVcnTopology").method(Method.GET).requestBuilder(GetVcnTopologyRequest::builder).basePath("/20160918").appendPathParam("vcnTopology").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("accessLevel", (BmcEnum)request.getAccessLevel()).appendQueryParam("queryCompartmentSubtree", (Object)request.getQueryCompartmentSubtree()).appendQueryParam("vcnId", (Object)request.getVcnId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-none-match", request.getIfNoneMatch()).appendHeader("cache-control", request.getCacheControl()).handleBody(VcnTopology.class, GetVcnTopologyResponse.Builder::vcnTopology).handleResponseHeaderString("etag", GetVcnTopologyResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetVcnTopologyResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetVirtualCircuitResponse getVirtualCircuit(GetVirtualCircuitRequest request) {
        Validate.notBlank((String)request.getVirtualCircuitId(), (String)"virtualCircuitId must not be blank", (Object[])new Object[0]);
        return (GetVirtualCircuitResponse)this.clientCall(request, GetVirtualCircuitResponse::builder).logger(LOG, "getVirtualCircuit").serviceDetails("VirtualNetwork", "GetVirtualCircuit", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/VirtualCircuit/GetVirtualCircuit").method(Method.GET).requestBuilder(GetVirtualCircuitRequest::builder).basePath("/20160918").appendPathParam("virtualCircuits").appendPathParam(request.getVirtualCircuitId()).accept(new String[]{"application/json"}).operationUsesDefaultRetries().handleBody(VirtualCircuit.class, GetVirtualCircuitResponse.Builder::virtualCircuit).handleResponseHeaderString("etag", GetVirtualCircuitResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetVirtualCircuitResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetVlanResponse getVlan(GetVlanRequest request) {
        Validate.notBlank((String)request.getVlanId(), (String)"vlanId must not be blank", (Object[])new Object[0]);
        return (GetVlanResponse)this.clientCall(request, GetVlanResponse::builder).logger(LOG, "getVlan").serviceDetails("VirtualNetwork", "GetVlan", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Vlan/GetVlan").method(Method.GET).requestBuilder(GetVlanRequest::builder).basePath("/20160918").appendPathParam("vlans").appendPathParam(request.getVlanId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Vlan.class, GetVlanResponse.Builder::vlan).handleResponseHeaderString("etag", GetVlanResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetVlanResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetVnicResponse getVnic(GetVnicRequest request) {
        Validate.notBlank((String)request.getVnicId(), (String)"vnicId must not be blank", (Object[])new Object[0]);
        return (GetVnicResponse)this.clientCall(request, GetVnicResponse::builder).logger(LOG, "getVnic").serviceDetails("VirtualNetwork", "GetVnic", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Vnic/GetVnic").method(Method.GET).requestBuilder(GetVnicRequest::builder).basePath("/20160918").appendPathParam("vnics").appendPathParam(request.getVnicId()).accept(new String[]{"application/json"}).handleBody(Vnic.class, GetVnicResponse.Builder::vnic).handleResponseHeaderString("etag", GetVnicResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetVnicResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetVtapResponse getVtap(GetVtapRequest request) {
        Validate.notBlank((String)request.getVtapId(), (String)"vtapId must not be blank", (Object[])new Object[0]);
        return (GetVtapResponse)this.clientCall(request, GetVtapResponse::builder).logger(LOG, "getVtap").serviceDetails("VirtualNetwork", "GetVtap", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Vtap/GetVtap").method(Method.GET).requestBuilder(GetVtapRequest::builder).basePath("/20160918").appendPathParam("vtaps").appendPathParam(request.getVtapId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Vtap.class, GetVtapResponse.Builder::vtap).handleResponseHeaderString("etag", GetVtapResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetVtapResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public Ipv6VnicDetachResponse ipv6VnicDetach(Ipv6VnicDetachRequest request) {
        Validate.notBlank((String)request.getIpv6Id(), (String)"ipv6Id must not be blank", (Object[])new Object[0]);
        return (Ipv6VnicDetachResponse)this.clientCall(request, Ipv6VnicDetachResponse::builder).logger(LOG, "ipv6VnicDetach").serviceDetails("VirtualNetwork", "Ipv6VnicDetach", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Ipv6/Ipv6VnicDetach").method(Method.POST).requestBuilder(Ipv6VnicDetachRequest::builder).basePath("/20160918").appendPathParam("ipv6").appendPathParam(request.getIpv6Id()).appendPathParam("actions").appendPathParam("detach").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleBody(Ipv6.class, Ipv6VnicDetachResponse.Builder::ipv6).handleResponseHeaderString("etag", Ipv6VnicDetachResponse.Builder::etag).handleResponseHeaderString("opc-request-id", Ipv6VnicDetachResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListAllowedPeerRegionsForRemotePeeringResponse listAllowedPeerRegionsForRemotePeering(ListAllowedPeerRegionsForRemotePeeringRequest request) {
        return (ListAllowedPeerRegionsForRemotePeeringResponse)this.clientCall(request, ListAllowedPeerRegionsForRemotePeeringResponse::builder).logger(LOG, "listAllowedPeerRegionsForRemotePeering").serviceDetails("VirtualNetwork", "ListAllowedPeerRegionsForRemotePeering", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/PeerRegionForRemotePeering/ListAllowedPeerRegionsForRemotePeering").method(Method.GET).requestBuilder(ListAllowedPeerRegionsForRemotePeeringRequest::builder).basePath("/20160918").appendPathParam("allowedPeerRegionsForRemotePeering").accept(new String[]{"application/json"}).operationUsesDefaultRetries().handleBodyList(PeerRegionForRemotePeering.class, ListAllowedPeerRegionsForRemotePeeringResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListAllowedPeerRegionsForRemotePeeringResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListByoasnsResponse listByoasns(ListByoasnsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListByoasnsResponse)this.clientCall(request, ListByoasnsResponse::builder).logger(LOG, "listByoasns").serviceDetails("VirtualNetwork", "ListByoasns", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Byoasn/ListByoasns").method(Method.GET).requestBuilder(ListByoasnsRequest::builder).basePath("/20160918").appendPathParam("byoasns").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("lifecycleState", (Object)request.getLifecycleState()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ByoasnCollection.class, ListByoasnsResponse.Builder::byoasnCollection).handleResponseHeaderString("opc-next-page", ListByoasnsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListByoasnsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListByoipAllocatedRangesResponse listByoipAllocatedRanges(ListByoipAllocatedRangesRequest request) {
        Validate.notBlank((String)request.getByoipRangeId(), (String)"byoipRangeId must not be blank", (Object[])new Object[0]);
        return (ListByoipAllocatedRangesResponse)this.clientCall(request, ListByoipAllocatedRangesResponse::builder).logger(LOG, "listByoipAllocatedRanges").serviceDetails("VirtualNetwork", "ListByoipAllocatedRanges", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ByoipAllocatedRangeSummary/ListByoipAllocatedRanges").method(Method.GET).requestBuilder(ListByoipAllocatedRangesRequest::builder).basePath("/20160918").appendPathParam("byoipRanges").appendPathParam(request.getByoipRangeId()).appendPathParam("byoipAllocatedRanges").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ByoipAllocatedRangeCollection.class, ListByoipAllocatedRangesResponse.Builder::byoipAllocatedRangeCollection).handleResponseHeaderString("opc-next-page", ListByoipAllocatedRangesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListByoipAllocatedRangesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListByoipRangesResponse listByoipRanges(ListByoipRangesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListByoipRangesResponse)this.clientCall(request, ListByoipRangesResponse::builder).logger(LOG, "listByoipRanges").serviceDetails("VirtualNetwork", "ListByoipRanges", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ByoipRange/ListByoipRanges").method(Method.GET).requestBuilder(ListByoipRangesRequest::builder).basePath("/20160918").appendPathParam("byoipRanges").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("lifecycleState", (Object)request.getLifecycleState()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ByoipRangeCollection.class, ListByoipRangesResponse.Builder::byoipRangeCollection).handleResponseHeaderString("opc-next-page", ListByoipRangesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListByoipRangesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListCaptureFiltersResponse listCaptureFilters(ListCaptureFiltersRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListCaptureFiltersResponse)this.clientCall(request, ListCaptureFiltersResponse::builder).logger(LOG, "listCaptureFilters").serviceDetails("VirtualNetwork", "ListCaptureFilters", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/CaptureFilter/ListCaptureFilters").method(Method.GET).requestBuilder(ListCaptureFiltersRequest::builder).basePath("/20160918").appendPathParam("captureFilters").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("filterType", (BmcEnum)request.getFilterType()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(CaptureFilter.class, ListCaptureFiltersResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListCaptureFiltersResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListCaptureFiltersResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListCpeDeviceShapesResponse listCpeDeviceShapes(ListCpeDeviceShapesRequest request) {
        return (ListCpeDeviceShapesResponse)this.clientCall(request, ListCpeDeviceShapesResponse::builder).logger(LOG, "listCpeDeviceShapes").serviceDetails("VirtualNetwork", "ListCpeDeviceShapes", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/CpeDeviceShapeSummary/ListCpeDeviceShapes").method(Method.GET).requestBuilder(ListCpeDeviceShapesRequest::builder).basePath("/20160918").appendPathParam("cpeDeviceShapes").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBodyList(CpeDeviceShapeSummary.class, ListCpeDeviceShapesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListCpeDeviceShapesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListCpeDeviceShapesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListCpesResponse listCpes(ListCpesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListCpesResponse)this.clientCall(request, ListCpesResponse::builder).logger(LOG, "listCpes").serviceDetails("VirtualNetwork", "ListCpes", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Cpe/ListCpes").method(Method.GET).requestBuilder(ListCpesRequest::builder).basePath("/20160918").appendPathParam("cpes").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).operationUsesDefaultRetries().handleBodyList(Cpe.class, ListCpesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListCpesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListCpesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListCrossConnectGroupsResponse listCrossConnectGroups(ListCrossConnectGroupsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListCrossConnectGroupsResponse)this.clientCall(request, ListCrossConnectGroupsResponse::builder).logger(LOG, "listCrossConnectGroups").serviceDetails("VirtualNetwork", "ListCrossConnectGroups", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/CrossConnectGroup/ListCrossConnectGroups").method(Method.GET).requestBuilder(ListCrossConnectGroupsRequest::builder).basePath("/20160918").appendPathParam("crossConnectGroups").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).operationUsesDefaultRetries().handleBodyList(CrossConnectGroup.class, ListCrossConnectGroupsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListCrossConnectGroupsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListCrossConnectGroupsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListCrossConnectLocationsResponse listCrossConnectLocations(ListCrossConnectLocationsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListCrossConnectLocationsResponse)this.clientCall(request, ListCrossConnectLocationsResponse::builder).logger(LOG, "listCrossConnectLocations").serviceDetails("VirtualNetwork", "ListCrossConnectLocations", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/CrossConnectLocation/ListCrossConnectLocations").method(Method.GET).requestBuilder(ListCrossConnectLocationsRequest::builder).basePath("/20160918").appendPathParam("crossConnectLocations").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).operationUsesDefaultRetries().handleBodyList(CrossConnectLocation.class, ListCrossConnectLocationsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListCrossConnectLocationsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListCrossConnectLocationsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListCrossConnectMappingsResponse listCrossConnectMappings(ListCrossConnectMappingsRequest request) {
        Validate.notBlank((String)request.getVirtualCircuitId(), (String)"virtualCircuitId must not be blank", (Object[])new Object[0]);
        return (ListCrossConnectMappingsResponse)this.clientCall(request, ListCrossConnectMappingsResponse::builder).logger(LOG, "listCrossConnectMappings").serviceDetails("VirtualNetwork", "ListCrossConnectMappings", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/CrossConnectMappingDetailsCollection/ListCrossConnectMappings").method(Method.GET).requestBuilder(ListCrossConnectMappingsRequest::builder).basePath("/20160918").appendPathParam("virtualCircuits").appendPathParam(request.getVirtualCircuitId()).appendPathParam("crossConnectMappings").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(CrossConnectMappingDetailsCollection.class, ListCrossConnectMappingsResponse.Builder::crossConnectMappingDetailsCollection).handleResponseHeaderString("opc-request-id", ListCrossConnectMappingsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListCrossConnectsResponse listCrossConnects(ListCrossConnectsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListCrossConnectsResponse)this.clientCall(request, ListCrossConnectsResponse::builder).logger(LOG, "listCrossConnects").serviceDetails("VirtualNetwork", "ListCrossConnects", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/CrossConnect/ListCrossConnects").method(Method.GET).requestBuilder(ListCrossConnectsRequest::builder).basePath("/20160918").appendPathParam("crossConnects").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("crossConnectGroupId", (Object)request.getCrossConnectGroupId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).operationUsesDefaultRetries().handleBodyList(CrossConnect.class, ListCrossConnectsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListCrossConnectsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListCrossConnectsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListCrossconnectPortSpeedShapesResponse listCrossconnectPortSpeedShapes(ListCrossconnectPortSpeedShapesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListCrossconnectPortSpeedShapesResponse)this.clientCall(request, ListCrossconnectPortSpeedShapesResponse::builder).logger(LOG, "listCrossconnectPortSpeedShapes").serviceDetails("VirtualNetwork", "ListCrossconnectPortSpeedShapes", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/CrossConnectPortSpeedShape/ListCrossconnectPortSpeedShapes").method(Method.GET).requestBuilder(ListCrossconnectPortSpeedShapesRequest::builder).basePath("/20160918").appendPathParam("crossConnectPortSpeedShapes").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).operationUsesDefaultRetries().handleBodyList(CrossConnectPortSpeedShape.class, ListCrossconnectPortSpeedShapesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListCrossconnectPortSpeedShapesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListCrossconnectPortSpeedShapesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListDhcpOptionsResponse listDhcpOptions(ListDhcpOptionsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListDhcpOptionsResponse)this.clientCall(request, ListDhcpOptionsResponse::builder).logger(LOG, "listDhcpOptions").serviceDetails("VirtualNetwork", "ListDhcpOptions", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/DhcpOptions/ListDhcpOptions").method(Method.GET).requestBuilder(ListDhcpOptionsRequest::builder).basePath("/20160918").appendPathParam("dhcps").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("vcnId", (Object)request.getVcnId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).handleBodyList(DhcpOptions.class, ListDhcpOptionsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListDhcpOptionsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListDhcpOptionsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListDrgAttachmentsResponse listDrgAttachments(ListDrgAttachmentsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListDrgAttachmentsResponse)this.clientCall(request, ListDrgAttachmentsResponse::builder).logger(LOG, "listDrgAttachments").serviceDetails("VirtualNetwork", "ListDrgAttachments", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/DrgAttachment/ListDrgAttachments").method(Method.GET).requestBuilder(ListDrgAttachmentsRequest::builder).basePath("/20160918").appendPathParam("drgAttachments").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("vcnId", (Object)request.getVcnId()).appendQueryParam("drgId", (Object)request.getDrgId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("networkId", (Object)request.getNetworkId()).appendEnumQueryParam("attachmentType", (BmcEnum)request.getAttachmentType()).appendQueryParam("drgRouteTableId", (Object)request.getDrgRouteTableId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).handleBodyList(DrgAttachment.class, ListDrgAttachmentsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListDrgAttachmentsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListDrgAttachmentsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListDrgRouteDistributionStatementsResponse listDrgRouteDistributionStatements(ListDrgRouteDistributionStatementsRequest request) {
        Validate.notBlank((String)request.getDrgRouteDistributionId(), (String)"drgRouteDistributionId must not be blank", (Object[])new Object[0]);
        return (ListDrgRouteDistributionStatementsResponse)this.clientCall(request, ListDrgRouteDistributionStatementsResponse::builder).logger(LOG, "listDrgRouteDistributionStatements").serviceDetails("VirtualNetwork", "ListDrgRouteDistributionStatements", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/DrgRouteDistributionStatement/ListDrgRouteDistributionStatements").method(Method.GET).requestBuilder(ListDrgRouteDistributionStatementsRequest::builder).basePath("/20160918").appendPathParam("drgRouteDistributions").appendPathParam(request.getDrgRouteDistributionId()).appendPathParam("drgRouteDistributionStatements").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).handleBodyList(DrgRouteDistributionStatement.class, ListDrgRouteDistributionStatementsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListDrgRouteDistributionStatementsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListDrgRouteDistributionStatementsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListDrgRouteDistributionsResponse listDrgRouteDistributions(ListDrgRouteDistributionsRequest request) {
        Objects.requireNonNull(request.getDrgId(), "drgId is required");
        return (ListDrgRouteDistributionsResponse)this.clientCall(request, ListDrgRouteDistributionsResponse::builder).logger(LOG, "listDrgRouteDistributions").serviceDetails("VirtualNetwork", "ListDrgRouteDistributions", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/DrgRouteDistribution/ListDrgRouteDistributions").method(Method.GET).requestBuilder(ListDrgRouteDistributionsRequest::builder).basePath("/20160918").appendPathParam("drgRouteDistributions").appendQueryParam("drgId", (Object)request.getDrgId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).handleBodyList(DrgRouteDistribution.class, ListDrgRouteDistributionsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListDrgRouteDistributionsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListDrgRouteDistributionsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListDrgRouteRulesResponse listDrgRouteRules(ListDrgRouteRulesRequest request) {
        Validate.notBlank((String)request.getDrgRouteTableId(), (String)"drgRouteTableId must not be blank", (Object[])new Object[0]);
        return (ListDrgRouteRulesResponse)this.clientCall(request, ListDrgRouteRulesResponse::builder).logger(LOG, "listDrgRouteRules").serviceDetails("VirtualNetwork", "ListDrgRouteRules", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/DrgRouteRule/ListDrgRouteRules").method(Method.GET).requestBuilder(ListDrgRouteRulesRequest::builder).basePath("/20160918").appendPathParam("drgRouteTables").appendPathParam(request.getDrgRouteTableId()).appendPathParam("drgRouteRules").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("routeType", (BmcEnum)request.getRouteType()).accept(new String[]{"application/json"}).handleBodyList(DrgRouteRule.class, ListDrgRouteRulesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListDrgRouteRulesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListDrgRouteRulesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListDrgRouteTablesResponse listDrgRouteTables(ListDrgRouteTablesRequest request) {
        Objects.requireNonNull(request.getDrgId(), "drgId is required");
        return (ListDrgRouteTablesResponse)this.clientCall(request, ListDrgRouteTablesResponse::builder).logger(LOG, "listDrgRouteTables").serviceDetails("VirtualNetwork", "ListDrgRouteTables", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/DrgRouteTable/ListDrgRouteTables").method(Method.GET).requestBuilder(ListDrgRouteTablesRequest::builder).basePath("/20160918").appendPathParam("drgRouteTables").appendQueryParam("drgId", (Object)request.getDrgId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("importDrgRouteDistributionId", (Object)request.getImportDrgRouteDistributionId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).handleBodyList(DrgRouteTable.class, ListDrgRouteTablesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListDrgRouteTablesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListDrgRouteTablesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListDrgsResponse listDrgs(ListDrgsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListDrgsResponse)this.clientCall(request, ListDrgsResponse::builder).logger(LOG, "listDrgs").serviceDetails("VirtualNetwork", "ListDrgs", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Drg/ListDrgs").method(Method.GET).requestBuilder(ListDrgsRequest::builder).basePath("/20160918").appendPathParam("drgs").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).handleBodyList(Drg.class, ListDrgsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListDrgsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListDrgsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListFastConnectProviderServicesResponse listFastConnectProviderServices(ListFastConnectProviderServicesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListFastConnectProviderServicesResponse)this.clientCall(request, ListFastConnectProviderServicesResponse::builder).logger(LOG, "listFastConnectProviderServices").serviceDetails("VirtualNetwork", "ListFastConnectProviderServices", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/FastConnectProviderService/ListFastConnectProviderServices").method(Method.GET).requestBuilder(ListFastConnectProviderServicesRequest::builder).basePath("/20160918").appendPathParam("fastConnectProviderServices").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).operationUsesDefaultRetries().handleBodyList(FastConnectProviderService.class, ListFastConnectProviderServicesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListFastConnectProviderServicesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListFastConnectProviderServicesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListFastConnectProviderVirtualCircuitBandwidthShapesResponse listFastConnectProviderVirtualCircuitBandwidthShapes(ListFastConnectProviderVirtualCircuitBandwidthShapesRequest request) {
        Validate.notBlank((String)request.getProviderServiceId(), (String)"providerServiceId must not be blank", (Object[])new Object[0]);
        return (ListFastConnectProviderVirtualCircuitBandwidthShapesResponse)this.clientCall(request, ListFastConnectProviderVirtualCircuitBandwidthShapesResponse::builder).logger(LOG, "listFastConnectProviderVirtualCircuitBandwidthShapes").serviceDetails("VirtualNetwork", "ListFastConnectProviderVirtualCircuitBandwidthShapes", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/FastConnectProviderService/ListFastConnectProviderVirtualCircuitBandwidthShapes").method(Method.GET).requestBuilder(ListFastConnectProviderVirtualCircuitBandwidthShapesRequest::builder).basePath("/20160918").appendPathParam("fastConnectProviderServices").appendPathParam(request.getProviderServiceId()).appendPathParam("virtualCircuitBandwidthShapes").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).operationUsesDefaultRetries().handleBodyList(VirtualCircuitBandwidthShape.class, ListFastConnectProviderVirtualCircuitBandwidthShapesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListFastConnectProviderVirtualCircuitBandwidthShapesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListFastConnectProviderVirtualCircuitBandwidthShapesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListIPSecConnectionTunnelRoutesResponse listIPSecConnectionTunnelRoutes(ListIPSecConnectionTunnelRoutesRequest request) {
        Validate.notBlank((String)request.getIpscId(), (String)"ipscId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTunnelId(), (String)"tunnelId must not be blank", (Object[])new Object[0]);
        return (ListIPSecConnectionTunnelRoutesResponse)this.clientCall(request, ListIPSecConnectionTunnelRoutesResponse::builder).logger(LOG, "listIPSecConnectionTunnelRoutes").serviceDetails("VirtualNetwork", "ListIPSecConnectionTunnelRoutes", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/TunnelRouteSummary/ListIPSecConnectionTunnelRoutes").method(Method.GET).requestBuilder(ListIPSecConnectionTunnelRoutesRequest::builder).basePath("/20160918").appendPathParam("ipsecConnections").appendPathParam(request.getIpscId()).appendPathParam("tunnels").appendPathParam(request.getTunnelId()).appendPathParam("routes").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("advertiser", (BmcEnum)request.getAdvertiser()).accept(new String[]{"application/json"}).operationUsesDefaultRetries().handleBodyList(TunnelRouteSummary.class, ListIPSecConnectionTunnelRoutesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListIPSecConnectionTunnelRoutesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListIPSecConnectionTunnelRoutesResponse.Builder::opcRequestId).handleResponseHeaderInteger("opc-total-items", ListIPSecConnectionTunnelRoutesResponse.Builder::opcTotalItems).callSync();
    }

    @Override
    public ListIPSecConnectionTunnelSecurityAssociationsResponse listIPSecConnectionTunnelSecurityAssociations(ListIPSecConnectionTunnelSecurityAssociationsRequest request) {
        Validate.notBlank((String)request.getIpscId(), (String)"ipscId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTunnelId(), (String)"tunnelId must not be blank", (Object[])new Object[0]);
        return (ListIPSecConnectionTunnelSecurityAssociationsResponse)this.clientCall(request, ListIPSecConnectionTunnelSecurityAssociationsResponse::builder).logger(LOG, "listIPSecConnectionTunnelSecurityAssociations").serviceDetails("VirtualNetwork", "ListIPSecConnectionTunnelSecurityAssociations", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/TunnelSecurityAssociationSummary/ListIPSecConnectionTunnelSecurityAssociations").method(Method.GET).requestBuilder(ListIPSecConnectionTunnelSecurityAssociationsRequest::builder).basePath("/20160918").appendPathParam("ipsecConnections").appendPathParam(request.getIpscId()).appendPathParam("tunnels").appendPathParam(request.getTunnelId()).appendPathParam("tunnelSecurityAssociations").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).operationUsesDefaultRetries().handleBodyList(TunnelSecurityAssociationSummary.class, ListIPSecConnectionTunnelSecurityAssociationsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListIPSecConnectionTunnelSecurityAssociationsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListIPSecConnectionTunnelSecurityAssociationsResponse.Builder::opcRequestId).handleResponseHeaderInteger("opc-total-items", ListIPSecConnectionTunnelSecurityAssociationsResponse.Builder::opcTotalItems).callSync();
    }

    @Override
    public ListIPSecConnectionTunnelsResponse listIPSecConnectionTunnels(ListIPSecConnectionTunnelsRequest request) {
        Validate.notBlank((String)request.getIpscId(), (String)"ipscId must not be blank", (Object[])new Object[0]);
        return (ListIPSecConnectionTunnelsResponse)this.clientCall(request, ListIPSecConnectionTunnelsResponse::builder).logger(LOG, "listIPSecConnectionTunnels").serviceDetails("VirtualNetwork", "ListIPSecConnectionTunnels", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/IPSecConnectionTunnel/ListIPSecConnectionTunnels").method(Method.GET).requestBuilder(ListIPSecConnectionTunnelsRequest::builder).basePath("/20160918").appendPathParam("ipsecConnections").appendPathParam(request.getIpscId()).appendPathParam("tunnels").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).operationUsesDefaultRetries().handleBodyList(IPSecConnectionTunnel.class, ListIPSecConnectionTunnelsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListIPSecConnectionTunnelsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListIPSecConnectionTunnelsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListIPSecConnectionsResponse listIPSecConnections(ListIPSecConnectionsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListIPSecConnectionsResponse)this.clientCall(request, ListIPSecConnectionsResponse::builder).logger(LOG, "listIPSecConnections").serviceDetails("VirtualNetwork", "ListIPSecConnections", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/IPSecConnection/ListIPSecConnections").method(Method.GET).requestBuilder(ListIPSecConnectionsRequest::builder).basePath("/20160918").appendPathParam("ipsecConnections").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("drgId", (Object)request.getDrgId()).appendQueryParam("cpeId", (Object)request.getCpeId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).operationUsesDefaultRetries().handleBodyList(IPSecConnection.class, ListIPSecConnectionsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListIPSecConnectionsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListIPSecConnectionsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListInternetGatewaysResponse listInternetGateways(ListInternetGatewaysRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListInternetGatewaysResponse)this.clientCall(request, ListInternetGatewaysResponse::builder).logger(LOG, "listInternetGateways").serviceDetails("VirtualNetwork", "ListInternetGateways", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/InternetGateway/ListInternetGateways").method(Method.GET).requestBuilder(ListInternetGatewaysRequest::builder).basePath("/20160918").appendPathParam("internetGateways").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("vcnId", (Object)request.getVcnId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).handleBodyList(InternetGateway.class, ListInternetGatewaysResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListInternetGatewaysResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListInternetGatewaysResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListIpInventoryResponse listIpInventory(ListIpInventoryRequest request) {
        Objects.requireNonNull(request.getListIpInventoryDetails(), "listIpInventoryDetails is required");
        return (ListIpInventoryResponse)this.clientCall(request, ListIpInventoryResponse::builder).logger(LOG, "listIpInventory").serviceDetails("VirtualNetwork", "ListIpInventory", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/IpInventoryCollection/ListIpInventory").method(Method.POST).requestBuilder(ListIpInventoryRequest::builder).basePath("/20160918").appendPathParam("ipInventory").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(IpInventoryCollection.class, ListIpInventoryResponse.Builder::ipInventoryCollection).handleResponseHeaderString("etag", ListIpInventoryResponse.Builder::etag).handleResponseHeaderString("opc-next-page", ListIpInventoryResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListIpInventoryResponse.Builder::opcRequestId).handleResponseHeaderInteger("opc-total-items", ListIpInventoryResponse.Builder::opcTotalItems).handleResponseHeaderString("opc-work-request-id", ListIpInventoryResponse.Builder::opcWorkRequestId).handleResponseHeaderEnum("lifecycle-state", ListIpInventoryResponse.LifecycleState::create, ListIpInventoryResponse.Builder::lifecycleState).handleResponseHeaderString("data-request-id", ListIpInventoryResponse.Builder::dataRequestId).callSync();
    }

    @Override
    public ListIpv6sResponse listIpv6s(ListIpv6sRequest request) {
        return (ListIpv6sResponse)this.clientCall(request, ListIpv6sResponse::builder).logger(LOG, "listIpv6s").serviceDetails("VirtualNetwork", "ListIpv6s", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Ipv6/ListIpv6s").method(Method.GET).requestBuilder(ListIpv6sRequest::builder).basePath("/20160918").appendPathParam("ipv6").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("ipAddress", (Object)request.getIpAddress()).appendQueryParam("subnetId", (Object)request.getSubnetId()).appendQueryParam("vnicId", (Object)request.getVnicId()).appendQueryParam("ipState", (Object)request.getIpState()).appendQueryParam("lifetime", (Object)request.getLifetime()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(Ipv6.class, ListIpv6sResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListIpv6sResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListIpv6sResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListLocalPeeringGatewaysResponse listLocalPeeringGateways(ListLocalPeeringGatewaysRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListLocalPeeringGatewaysResponse)this.clientCall(request, ListLocalPeeringGatewaysResponse::builder).logger(LOG, "listLocalPeeringGateways").serviceDetails("VirtualNetwork", "ListLocalPeeringGateways", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/LocalPeeringGateway/ListLocalPeeringGateways").method(Method.GET).requestBuilder(ListLocalPeeringGatewaysRequest::builder).basePath("/20160918").appendPathParam("localPeeringGateways").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("vcnId", (Object)request.getVcnId()).accept(new String[]{"application/json"}).handleBodyList(LocalPeeringGateway.class, ListLocalPeeringGatewaysResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListLocalPeeringGatewaysResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListLocalPeeringGatewaysResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListNatGatewaysResponse listNatGateways(ListNatGatewaysRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListNatGatewaysResponse)this.clientCall(request, ListNatGatewaysResponse::builder).logger(LOG, "listNatGateways").serviceDetails("VirtualNetwork", "ListNatGateways", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/NatGateway/ListNatGateways").method(Method.GET).requestBuilder(ListNatGatewaysRequest::builder).basePath("/20160918").appendPathParam("natGateways").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("vcnId", (Object)request.getVcnId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).handleBodyList(NatGateway.class, ListNatGatewaysResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListNatGatewaysResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListNatGatewaysResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListNetworkSecurityGroupSecurityRulesResponse listNetworkSecurityGroupSecurityRules(ListNetworkSecurityGroupSecurityRulesRequest request) {
        Validate.notBlank((String)request.getNetworkSecurityGroupId(), (String)"networkSecurityGroupId must not be blank", (Object[])new Object[0]);
        return (ListNetworkSecurityGroupSecurityRulesResponse)this.clientCall(request, ListNetworkSecurityGroupSecurityRulesResponse::builder).logger(LOG, "listNetworkSecurityGroupSecurityRules").serviceDetails("VirtualNetwork", "ListNetworkSecurityGroupSecurityRules", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/SecurityRule/ListNetworkSecurityGroupSecurityRules").method(Method.GET).requestBuilder(ListNetworkSecurityGroupSecurityRulesRequest::builder).basePath("/20160918").appendPathParam("networkSecurityGroups").appendPathParam(request.getNetworkSecurityGroupId()).appendPathParam("securityRules").appendEnumQueryParam("direction", (BmcEnum)request.getDirection()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).handleBodyList(SecurityRule.class, ListNetworkSecurityGroupSecurityRulesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListNetworkSecurityGroupSecurityRulesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListNetworkSecurityGroupSecurityRulesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListNetworkSecurityGroupVnicsResponse listNetworkSecurityGroupVnics(ListNetworkSecurityGroupVnicsRequest request) {
        Validate.notBlank((String)request.getNetworkSecurityGroupId(), (String)"networkSecurityGroupId must not be blank", (Object[])new Object[0]);
        return (ListNetworkSecurityGroupVnicsResponse)this.clientCall(request, ListNetworkSecurityGroupVnicsResponse::builder).logger(LOG, "listNetworkSecurityGroupVnics").serviceDetails("VirtualNetwork", "ListNetworkSecurityGroupVnics", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/NetworkSecurityGroupVnic/ListNetworkSecurityGroupVnics").method(Method.GET).requestBuilder(ListNetworkSecurityGroupVnicsRequest::builder).basePath("/20160918").appendPathParam("networkSecurityGroups").appendPathParam(request.getNetworkSecurityGroupId()).appendPathParam("vnics").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).handleBodyList(NetworkSecurityGroupVnic.class, ListNetworkSecurityGroupVnicsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListNetworkSecurityGroupVnicsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListNetworkSecurityGroupVnicsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListNetworkSecurityGroupsResponse listNetworkSecurityGroups(ListNetworkSecurityGroupsRequest request) {
        return (ListNetworkSecurityGroupsResponse)this.clientCall(request, ListNetworkSecurityGroupsResponse::builder).logger(LOG, "listNetworkSecurityGroups").serviceDetails("VirtualNetwork", "ListNetworkSecurityGroups", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/NetworkSecurityGroup/ListNetworkSecurityGroups").method(Method.GET).requestBuilder(ListNetworkSecurityGroupsRequest::builder).basePath("/20160918").appendPathParam("networkSecurityGroups").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("vlanId", (Object)request.getVlanId()).appendQueryParam("vcnId", (Object)request.getVcnId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).handleBodyList(NetworkSecurityGroup.class, ListNetworkSecurityGroupsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListNetworkSecurityGroupsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListNetworkSecurityGroupsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListPrivateIpsResponse listPrivateIps(ListPrivateIpsRequest request) {
        return (ListPrivateIpsResponse)this.clientCall(request, ListPrivateIpsResponse::builder).logger(LOG, "listPrivateIps").serviceDetails("VirtualNetwork", "ListPrivateIps", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/PrivateIp/ListPrivateIps").method(Method.GET).requestBuilder(ListPrivateIpsRequest::builder).basePath("/20160918").appendPathParam("privateIps").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("ipAddress", (Object)request.getIpAddress()).appendQueryParam("subnetId", (Object)request.getSubnetId()).appendQueryParam("vnicId", (Object)request.getVnicId()).appendQueryParam("ipState", (Object)request.getIpState()).appendQueryParam("lifetime", (Object)request.getLifetime()).appendQueryParam("vlanId", (Object)request.getVlanId()).accept(new String[]{"application/json"}).handleBodyList(PrivateIp.class, ListPrivateIpsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListPrivateIpsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListPrivateIpsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListPublicIpPoolsResponse listPublicIpPools(ListPublicIpPoolsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListPublicIpPoolsResponse)this.clientCall(request, ListPublicIpPoolsResponse::builder).logger(LOG, "listPublicIpPools").serviceDetails("VirtualNetwork", "ListPublicIpPools", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/PublicIpPool/ListPublicIpPools").method(Method.GET).requestBuilder(ListPublicIpPoolsRequest::builder).basePath("/20160918").appendPathParam("publicIpPools").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("byoipRangeId", (Object)request.getByoipRangeId()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(PublicIpPoolCollection.class, ListPublicIpPoolsResponse.Builder::publicIpPoolCollection).handleResponseHeaderString("opc-next-page", ListPublicIpPoolsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListPublicIpPoolsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListPublicIpsResponse listPublicIps(ListPublicIpsRequest request) {
        Objects.requireNonNull(request.getScope(), "scope is required");
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListPublicIpsResponse)this.clientCall(request, ListPublicIpsResponse::builder).logger(LOG, "listPublicIps").serviceDetails("VirtualNetwork", "ListPublicIps", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/PublicIp/ListPublicIps").method(Method.GET).requestBuilder(ListPublicIpsRequest::builder).basePath("/20160918").appendPathParam("publicIps").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("scope", (BmcEnum)request.getScope()).appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).appendEnumQueryParam("lifetime", (BmcEnum)request.getLifetime()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("publicIpPoolId", (Object)request.getPublicIpPoolId()).accept(new String[]{"application/json"}).handleBodyList(PublicIp.class, ListPublicIpsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListPublicIpsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListPublicIpsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListRemotePeeringConnectionsResponse listRemotePeeringConnections(ListRemotePeeringConnectionsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListRemotePeeringConnectionsResponse)this.clientCall(request, ListRemotePeeringConnectionsResponse::builder).logger(LOG, "listRemotePeeringConnections").serviceDetails("VirtualNetwork", "ListRemotePeeringConnections", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/RemotePeeringConnection/ListRemotePeeringConnections").method(Method.GET).requestBuilder(ListRemotePeeringConnectionsRequest::builder).basePath("/20160918").appendPathParam("remotePeeringConnections").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("drgId", (Object)request.getDrgId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).operationUsesDefaultRetries().handleBodyList(RemotePeeringConnection.class, ListRemotePeeringConnectionsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListRemotePeeringConnectionsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListRemotePeeringConnectionsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListRouteTablesResponse listRouteTables(ListRouteTablesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListRouteTablesResponse)this.clientCall(request, ListRouteTablesResponse::builder).logger(LOG, "listRouteTables").serviceDetails("VirtualNetwork", "ListRouteTables", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/RouteTable/ListRouteTables").method(Method.GET).requestBuilder(ListRouteTablesRequest::builder).basePath("/20160918").appendPathParam("routeTables").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("vcnId", (Object)request.getVcnId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).handleBodyList(RouteTable.class, ListRouteTablesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListRouteTablesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListRouteTablesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListSecurityListsResponse listSecurityLists(ListSecurityListsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListSecurityListsResponse)this.clientCall(request, ListSecurityListsResponse::builder).logger(LOG, "listSecurityLists").serviceDetails("VirtualNetwork", "ListSecurityLists", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/SecurityList/ListSecurityLists").method(Method.GET).requestBuilder(ListSecurityListsRequest::builder).basePath("/20160918").appendPathParam("securityLists").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("vcnId", (Object)request.getVcnId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).handleBodyList(SecurityList.class, ListSecurityListsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListSecurityListsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListSecurityListsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListServiceGatewaysResponse listServiceGateways(ListServiceGatewaysRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListServiceGatewaysResponse)this.clientCall(request, ListServiceGatewaysResponse::builder).logger(LOG, "listServiceGateways").serviceDetails("VirtualNetwork", "ListServiceGateways", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ServiceGateway/ListServiceGateways").method(Method.GET).requestBuilder(ListServiceGatewaysRequest::builder).basePath("/20160918").appendPathParam("serviceGateways").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("vcnId", (Object)request.getVcnId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).handleBodyList(ServiceGateway.class, ListServiceGatewaysResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListServiceGatewaysResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListServiceGatewaysResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListServicesResponse listServices(ListServicesRequest request) {
        return (ListServicesResponse)this.clientCall(request, ListServicesResponse::builder).logger(LOG, "listServices").serviceDetails("VirtualNetwork", "ListServices", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Service/ListServices").method(Method.GET).requestBuilder(ListServicesRequest::builder).basePath("/20160918").appendPathParam("services").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).handleBodyList(com.oracle.bmc.core.model.Service.class, ListServicesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListServicesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListServicesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListSubnetsResponse listSubnets(ListSubnetsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListSubnetsResponse)this.clientCall(request, ListSubnetsResponse::builder).logger(LOG, "listSubnets").serviceDetails("VirtualNetwork", "ListSubnets", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Subnet/ListSubnets").method(Method.GET).requestBuilder(ListSubnetsRequest::builder).basePath("/20160918").appendPathParam("subnets").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("vcnId", (Object)request.getVcnId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).handleBodyList(Subnet.class, ListSubnetsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListSubnetsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListSubnetsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListVcnsResponse listVcns(ListVcnsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListVcnsResponse)this.clientCall(request, ListVcnsResponse::builder).logger(LOG, "listVcns").serviceDetails("VirtualNetwork", "ListVcns", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Vcn/ListVcns").method(Method.GET).requestBuilder(ListVcnsRequest::builder).basePath("/20160918").appendPathParam("vcns").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).handleBodyList(Vcn.class, ListVcnsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListVcnsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListVcnsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListVirtualCircuitAssociatedTunnelsResponse listVirtualCircuitAssociatedTunnels(ListVirtualCircuitAssociatedTunnelsRequest request) {
        Validate.notBlank((String)request.getVirtualCircuitId(), (String)"virtualCircuitId must not be blank", (Object[])new Object[0]);
        return (ListVirtualCircuitAssociatedTunnelsResponse)this.clientCall(request, ListVirtualCircuitAssociatedTunnelsResponse::builder).logger(LOG, "listVirtualCircuitAssociatedTunnels").serviceDetails("VirtualNetwork", "ListVirtualCircuitAssociatedTunnels", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/VirtualCircuitAssociatedTunnelDetails/ListVirtualCircuitAssociatedTunnels").method(Method.GET).requestBuilder(ListVirtualCircuitAssociatedTunnelsRequest::builder).basePath("/20160918").appendPathParam("virtualCircuits").appendPathParam(request.getVirtualCircuitId()).appendPathParam("associatedTunnels").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).operationUsesDefaultRetries().handleBodyList(VirtualCircuitAssociatedTunnelDetails.class, ListVirtualCircuitAssociatedTunnelsResponse.Builder::items).handleResponseHeaderString("etag", ListVirtualCircuitAssociatedTunnelsResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ListVirtualCircuitAssociatedTunnelsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListVirtualCircuitAssociatedTunnelsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListVirtualCircuitBandwidthShapesResponse listVirtualCircuitBandwidthShapes(ListVirtualCircuitBandwidthShapesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListVirtualCircuitBandwidthShapesResponse)this.clientCall(request, ListVirtualCircuitBandwidthShapesResponse::builder).logger(LOG, "listVirtualCircuitBandwidthShapes").serviceDetails("VirtualNetwork", "ListVirtualCircuitBandwidthShapes", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/VirtualCircuitBandwidthShape/ListVirtualCircuitBandwidthShapes").method(Method.GET).requestBuilder(ListVirtualCircuitBandwidthShapesRequest::builder).basePath("/20160918").appendPathParam("virtualCircuitBandwidthShapes").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).operationUsesDefaultRetries().handleBodyList(VirtualCircuitBandwidthShape.class, ListVirtualCircuitBandwidthShapesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListVirtualCircuitBandwidthShapesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListVirtualCircuitBandwidthShapesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListVirtualCircuitPublicPrefixesResponse listVirtualCircuitPublicPrefixes(ListVirtualCircuitPublicPrefixesRequest request) {
        Validate.notBlank((String)request.getVirtualCircuitId(), (String)"virtualCircuitId must not be blank", (Object[])new Object[0]);
        return (ListVirtualCircuitPublicPrefixesResponse)this.clientCall(request, ListVirtualCircuitPublicPrefixesResponse::builder).logger(LOG, "listVirtualCircuitPublicPrefixes").serviceDetails("VirtualNetwork", "ListVirtualCircuitPublicPrefixes", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/VirtualCircuitPublicPrefix/ListVirtualCircuitPublicPrefixes").method(Method.GET).requestBuilder(ListVirtualCircuitPublicPrefixesRequest::builder).basePath("/20160918").appendPathParam("virtualCircuits").appendPathParam(request.getVirtualCircuitId()).appendPathParam("publicPrefixes").appendEnumQueryParam("verificationState", (BmcEnum)request.getVerificationState()).accept(new String[]{"application/json"}).operationUsesDefaultRetries().handleBodyList(VirtualCircuitPublicPrefix.class, ListVirtualCircuitPublicPrefixesResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListVirtualCircuitPublicPrefixesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListVirtualCircuitsResponse listVirtualCircuits(ListVirtualCircuitsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListVirtualCircuitsResponse)this.clientCall(request, ListVirtualCircuitsResponse::builder).logger(LOG, "listVirtualCircuits").serviceDetails("VirtualNetwork", "ListVirtualCircuits", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/VirtualCircuit/ListVirtualCircuits").method(Method.GET).requestBuilder(ListVirtualCircuitsRequest::builder).basePath("/20160918").appendPathParam("virtualCircuits").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).operationUsesDefaultRetries().handleBodyList(VirtualCircuit.class, ListVirtualCircuitsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListVirtualCircuitsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListVirtualCircuitsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListVlansResponse listVlans(ListVlansRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListVlansResponse)this.clientCall(request, ListVlansResponse::builder).logger(LOG, "listVlans").serviceDetails("VirtualNetwork", "ListVlans", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Vlan/ListVlans").method(Method.GET).requestBuilder(ListVlansRequest::builder).basePath("/20160918").appendPathParam("vlans").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("vcnId", (Object)request.getVcnId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(Vlan.class, ListVlansResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListVlansResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListVlansResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListVtapsResponse listVtaps(ListVtapsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListVtapsResponse)this.clientCall(request, ListVtapsResponse::builder).logger(LOG, "listVtaps").serviceDetails("VirtualNetwork", "ListVtaps", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Vtap/ListVtaps").method(Method.GET).requestBuilder(ListVtapsRequest::builder).basePath("/20160918").appendPathParam("vtaps").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("vcnId", (Object)request.getVcnId()).appendQueryParam("source", (Object)request.getSource()).appendQueryParam("targetId", (Object)request.getTargetId()).appendQueryParam("targetIp", (Object)request.getTargetIp()).appendQueryParam("isVtapEnabled", (Object)request.getIsVtapEnabled()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(Vtap.class, ListVtapsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListVtapsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListVtapsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ModifyVcnCidrResponse modifyVcnCidr(ModifyVcnCidrRequest request) {
        Validate.notBlank((String)request.getVcnId(), (String)"vcnId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getModifyVcnCidrDetails(), "modifyVcnCidrDetails is required");
        return (ModifyVcnCidrResponse)this.clientCall(request, ModifyVcnCidrResponse::builder).logger(LOG, "modifyVcnCidr").serviceDetails("VirtualNetwork", "ModifyVcnCidr", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Vcn/ModifyVcnCidr").method(Method.POST).requestBuilder(ModifyVcnCidrRequest::builder).basePath("/20160918").appendPathParam("vcns").appendPathParam(request.getVcnId()).appendPathParam("actions").appendPathParam("modifyCidr").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", ModifyVcnCidrResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ModifyVcnCidrResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public PrivateIpVnicDetachResponse privateIpVnicDetach(PrivateIpVnicDetachRequest request) {
        Validate.notBlank((String)request.getPrivateIpId(), (String)"privateIpId must not be blank", (Object[])new Object[0]);
        return (PrivateIpVnicDetachResponse)this.clientCall(request, PrivateIpVnicDetachResponse::builder).logger(LOG, "privateIpVnicDetach").serviceDetails("VirtualNetwork", "PrivateIpVnicDetach", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/PrivateIp/PrivateIpVnicDetach").method(Method.POST).requestBuilder(PrivateIpVnicDetachRequest::builder).basePath("/20160918").appendPathParam("privateIps").appendPathParam(request.getPrivateIpId()).appendPathParam("actions").appendPathParam("detach").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleBody(PrivateIp.class, PrivateIpVnicDetachResponse.Builder::privateIp).handleResponseHeaderString("etag", PrivateIpVnicDetachResponse.Builder::etag).handleResponseHeaderString("opc-request-id", PrivateIpVnicDetachResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public RemoveDrgRouteDistributionStatementsResponse removeDrgRouteDistributionStatements(RemoveDrgRouteDistributionStatementsRequest request) {
        Validate.notBlank((String)request.getDrgRouteDistributionId(), (String)"drgRouteDistributionId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRemoveDrgRouteDistributionStatementsDetails(), "removeDrgRouteDistributionStatementsDetails is required");
        return (RemoveDrgRouteDistributionStatementsResponse)this.clientCall(request, RemoveDrgRouteDistributionStatementsResponse::builder).logger(LOG, "removeDrgRouteDistributionStatements").serviceDetails("VirtualNetwork", "RemoveDrgRouteDistributionStatements", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/DrgRouteDistributionStatement/RemoveDrgRouteDistributionStatements").method(Method.POST).requestBuilder(RemoveDrgRouteDistributionStatementsRequest::builder).basePath("/20160918").appendPathParam("drgRouteDistributions").appendPathParam(request.getDrgRouteDistributionId()).appendPathParam("actions").appendPathParam("removeDrgRouteDistributionStatements").accept(new String[]{"application/json"}).hasBody().handleResponseHeaderString("opc-request-id", RemoveDrgRouteDistributionStatementsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public RemoveDrgRouteRulesResponse removeDrgRouteRules(RemoveDrgRouteRulesRequest request) {
        Validate.notBlank((String)request.getDrgRouteTableId(), (String)"drgRouteTableId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRemoveDrgRouteRulesDetails(), "removeDrgRouteRulesDetails is required");
        return (RemoveDrgRouteRulesResponse)this.clientCall(request, RemoveDrgRouteRulesResponse::builder).logger(LOG, "removeDrgRouteRules").serviceDetails("VirtualNetwork", "RemoveDrgRouteRules", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/DrgRouteRule/RemoveDrgRouteRules").method(Method.POST).requestBuilder(RemoveDrgRouteRulesRequest::builder).basePath("/20160918").appendPathParam("drgRouteTables").appendPathParam(request.getDrgRouteTableId()).appendPathParam("actions").appendPathParam("removeDrgRouteRules").accept(new String[]{"application/json"}).hasBody().handleResponseHeaderString("opc-request-id", RemoveDrgRouteRulesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public RemoveExportDrgRouteDistributionResponse removeExportDrgRouteDistribution(RemoveExportDrgRouteDistributionRequest request) {
        Validate.notBlank((String)request.getDrgAttachmentId(), (String)"drgAttachmentId must not be blank", (Object[])new Object[0]);
        return (RemoveExportDrgRouteDistributionResponse)this.clientCall(request, RemoveExportDrgRouteDistributionResponse::builder).logger(LOG, "removeExportDrgRouteDistribution").serviceDetails("VirtualNetwork", "RemoveExportDrgRouteDistribution", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/DrgAttachment/RemoveExportDrgRouteDistribution").method(Method.POST).requestBuilder(RemoveExportDrgRouteDistributionRequest::builder).basePath("/20160918").appendPathParam("drgAttachments").appendPathParam(request.getDrgAttachmentId()).appendPathParam("actions").appendPathParam("removeExportDrgRouteDistribution").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleBody(DrgAttachment.class, RemoveExportDrgRouteDistributionResponse.Builder::drgAttachment).handleResponseHeaderString("etag", RemoveExportDrgRouteDistributionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", RemoveExportDrgRouteDistributionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public RemoveImportDrgRouteDistributionResponse removeImportDrgRouteDistribution(RemoveImportDrgRouteDistributionRequest request) {
        Validate.notBlank((String)request.getDrgRouteTableId(), (String)"drgRouteTableId must not be blank", (Object[])new Object[0]);
        return (RemoveImportDrgRouteDistributionResponse)this.clientCall(request, RemoveImportDrgRouteDistributionResponse::builder).logger(LOG, "removeImportDrgRouteDistribution").serviceDetails("VirtualNetwork", "RemoveImportDrgRouteDistribution", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/DrgRouteTable/RemoveImportDrgRouteDistribution").method(Method.POST).requestBuilder(RemoveImportDrgRouteDistributionRequest::builder).basePath("/20160918").appendPathParam("drgRouteTables").appendPathParam(request.getDrgRouteTableId()).appendPathParam("actions").appendPathParam("removeImportDrgRouteDistribution").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleBody(DrgRouteTable.class, RemoveImportDrgRouteDistributionResponse.Builder::drgRouteTable).handleResponseHeaderString("etag", RemoveImportDrgRouteDistributionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", RemoveImportDrgRouteDistributionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public RemoveIpv6SubnetCidrResponse removeIpv6SubnetCidr(RemoveIpv6SubnetCidrRequest request) {
        Validate.notBlank((String)request.getSubnetId(), (String)"subnetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRemoveSubnetIpv6CidrDetails(), "removeSubnetIpv6CidrDetails is required");
        return (RemoveIpv6SubnetCidrResponse)this.clientCall(request, RemoveIpv6SubnetCidrResponse::builder).logger(LOG, "removeIpv6SubnetCidr").serviceDetails("VirtualNetwork", "RemoveIpv6SubnetCidr", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Subnet/RemoveIpv6SubnetCidr").method(Method.POST).requestBuilder(RemoveIpv6SubnetCidrRequest::builder).basePath("/20160918").appendPathParam("subnets").appendPathParam(request.getSubnetId()).appendPathParam("actions").appendPathParam("removeIpv6Cidr").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("etag", RemoveIpv6SubnetCidrResponse.Builder::etag).handleResponseHeaderString("opc-request-id", RemoveIpv6SubnetCidrResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", RemoveIpv6SubnetCidrResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public RemoveIpv6VcnCidrResponse removeIpv6VcnCidr(RemoveIpv6VcnCidrRequest request) {
        Validate.notBlank((String)request.getVcnId(), (String)"vcnId must not be blank", (Object[])new Object[0]);
        return (RemoveIpv6VcnCidrResponse)this.clientCall(request, RemoveIpv6VcnCidrResponse::builder).logger(LOG, "removeIpv6VcnCidr").serviceDetails("VirtualNetwork", "RemoveIpv6VcnCidr", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Vcn/RemoveIpv6VcnCidr").method(Method.POST).requestBuilder(RemoveIpv6VcnCidrRequest::builder).basePath("/20160918").appendPathParam("vcns").appendPathParam(request.getVcnId()).appendPathParam("actions").appendPathParam("removeIpv6Cidr").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("etag", RemoveIpv6VcnCidrResponse.Builder::etag).handleResponseHeaderString("opc-request-id", RemoveIpv6VcnCidrResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", RemoveIpv6VcnCidrResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public RemoveNetworkSecurityGroupSecurityRulesResponse removeNetworkSecurityGroupSecurityRules(RemoveNetworkSecurityGroupSecurityRulesRequest request) {
        Validate.notBlank((String)request.getNetworkSecurityGroupId(), (String)"networkSecurityGroupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRemoveNetworkSecurityGroupSecurityRulesDetails(), "removeNetworkSecurityGroupSecurityRulesDetails is required");
        return (RemoveNetworkSecurityGroupSecurityRulesResponse)this.clientCall(request, RemoveNetworkSecurityGroupSecurityRulesResponse::builder).logger(LOG, "removeNetworkSecurityGroupSecurityRules").serviceDetails("VirtualNetwork", "RemoveNetworkSecurityGroupSecurityRules", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/SecurityRule/RemoveNetworkSecurityGroupSecurityRules").method(Method.POST).requestBuilder(RemoveNetworkSecurityGroupSecurityRulesRequest::builder).basePath("/20160918").appendPathParam("networkSecurityGroups").appendPathParam(request.getNetworkSecurityGroupId()).appendPathParam("actions").appendPathParam("removeSecurityRules").accept(new String[]{"application/json"}).hasBody().handleResponseHeaderString("opc-request-id", RemoveNetworkSecurityGroupSecurityRulesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public RemovePublicIpPoolCapacityResponse removePublicIpPoolCapacity(RemovePublicIpPoolCapacityRequest request) {
        Validate.notBlank((String)request.getPublicIpPoolId(), (String)"publicIpPoolId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRemovePublicIpPoolCapacityDetails(), "removePublicIpPoolCapacityDetails is required");
        return (RemovePublicIpPoolCapacityResponse)this.clientCall(request, RemovePublicIpPoolCapacityResponse::builder).logger(LOG, "removePublicIpPoolCapacity").serviceDetails("VirtualNetwork", "RemovePublicIpPoolCapacity", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/PublicIpPool/RemovePublicIpPoolCapacity").method(Method.POST).requestBuilder(RemovePublicIpPoolCapacityRequest::builder).basePath("/20160918").appendPathParam("publicIpPools").appendPathParam(request.getPublicIpPoolId()).appendPathParam("actions").appendPathParam("removeCapacity").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(PublicIpPool.class, RemovePublicIpPoolCapacityResponse.Builder::publicIpPool).handleResponseHeaderString("etag", RemovePublicIpPoolCapacityResponse.Builder::etag).handleResponseHeaderString("opc-request-id", RemovePublicIpPoolCapacityResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public RemoveVcnCidrResponse removeVcnCidr(RemoveVcnCidrRequest request) {
        Validate.notBlank((String)request.getVcnId(), (String)"vcnId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRemoveVcnCidrDetails(), "removeVcnCidrDetails is required");
        return (RemoveVcnCidrResponse)this.clientCall(request, RemoveVcnCidrResponse::builder).logger(LOG, "removeVcnCidr").serviceDetails("VirtualNetwork", "RemoveVcnCidr", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Vcn/RemoveVcnCidr").method(Method.POST).requestBuilder(RemoveVcnCidrRequest::builder).basePath("/20160918").appendPathParam("vcns").appendPathParam(request.getVcnId()).appendPathParam("actions").appendPathParam("removeCidr").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", RemoveVcnCidrResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", RemoveVcnCidrResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public SetOriginAsnResponse setOriginAsn(SetOriginAsnRequest request) {
        Validate.notBlank((String)request.getByoipRangeId(), (String)"byoipRangeId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getSetOriginAsnDetails(), "setOriginAsnDetails is required");
        return (SetOriginAsnResponse)this.clientCall(request, SetOriginAsnResponse::builder).logger(LOG, "setOriginAsn").serviceDetails("VirtualNetwork", "SetOriginAsn", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ByoipRange/SetOriginAsn").method(Method.POST).requestBuilder(SetOriginAsnRequest::builder).basePath("/20160918").appendPathParam("byoipRanges").appendPathParam(request.getByoipRangeId()).appendPathParam("actions").appendPathParam("setOrigin").appendPathParam("byoasn").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", SetOriginAsnResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", SetOriginAsnResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public SetOriginAsnToOracleResponse setOriginAsnToOracle(SetOriginAsnToOracleRequest request) {
        Validate.notBlank((String)request.getByoipRangeId(), (String)"byoipRangeId must not be blank", (Object[])new Object[0]);
        return (SetOriginAsnToOracleResponse)this.clientCall(request, SetOriginAsnToOracleResponse::builder).logger(LOG, "setOriginAsnToOracle").serviceDetails("VirtualNetwork", "SetOriginAsnToOracle", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ByoipRange/SetOriginAsnToOracle").method(Method.POST).requestBuilder(SetOriginAsnToOracleRequest::builder).basePath("/20160918").appendPathParam("byoipRanges").appendPathParam(request.getByoipRangeId()).appendPathParam("actions").appendPathParam("setOrigin").appendPathParam("oracleAsn").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", SetOriginAsnToOracleResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateByoasnResponse updateByoasn(UpdateByoasnRequest request) {
        Validate.notBlank((String)request.getByoasnId(), (String)"byoasnId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateByoasnDetails(), "updateByoasnDetails is required");
        return (UpdateByoasnResponse)this.clientCall(request, UpdateByoasnResponse::builder).logger(LOG, "updateByoasn").serviceDetails("VirtualNetwork", "UpdateByoasn", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Byoasn/UpdateByoasn").method(Method.PUT).requestBuilder(UpdateByoasnRequest::builder).basePath("/20160918").appendPathParam("byoasns").appendPathParam(request.getByoasnId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(Byoasn.class, UpdateByoasnResponse.Builder::byoasn).handleResponseHeaderString("etag", UpdateByoasnResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateByoasnResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateByoipRangeResponse updateByoipRange(UpdateByoipRangeRequest request) {
        Validate.notBlank((String)request.getByoipRangeId(), (String)"byoipRangeId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateByoipRangeDetails(), "updateByoipRangeDetails is required");
        return (UpdateByoipRangeResponse)this.clientCall(request, UpdateByoipRangeResponse::builder).logger(LOG, "updateByoipRange").serviceDetails("VirtualNetwork", "UpdateByoipRange", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ByoipRange/UpdateByoipRange").method(Method.PUT).requestBuilder(UpdateByoipRangeRequest::builder).basePath("/20160918").appendPathParam("byoipRanges").appendPathParam(request.getByoipRangeId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(ByoipRange.class, UpdateByoipRangeResponse.Builder::byoipRange).handleResponseHeaderString("etag", UpdateByoipRangeResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateByoipRangeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateCaptureFilterResponse updateCaptureFilter(UpdateCaptureFilterRequest request) {
        Validate.notBlank((String)request.getCaptureFilterId(), (String)"captureFilterId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateCaptureFilterDetails(), "updateCaptureFilterDetails is required");
        return (UpdateCaptureFilterResponse)this.clientCall(request, UpdateCaptureFilterResponse::builder).logger(LOG, "updateCaptureFilter").serviceDetails("VirtualNetwork", "UpdateCaptureFilter", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/CaptureFilter/UpdateCaptureFilter").method(Method.PUT).requestBuilder(UpdateCaptureFilterRequest::builder).basePath("/20160918").appendPathParam("captureFilters").appendPathParam(request.getCaptureFilterId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(CaptureFilter.class, UpdateCaptureFilterResponse.Builder::captureFilter).handleResponseHeaderString("etag", UpdateCaptureFilterResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateCaptureFilterResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateCpeResponse updateCpe(UpdateCpeRequest request) {
        Validate.notBlank((String)request.getCpeId(), (String)"cpeId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateCpeDetails(), "updateCpeDetails is required");
        return (UpdateCpeResponse)this.clientCall(request, UpdateCpeResponse::builder).logger(LOG, "updateCpe").serviceDetails("VirtualNetwork", "UpdateCpe", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Cpe/UpdateCpe").method(Method.PUT).requestBuilder(UpdateCpeRequest::builder).basePath("/20160918").appendPathParam("cpes").appendPathParam(request.getCpeId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).operationUsesDefaultRetries().hasBody().handleBody(Cpe.class, UpdateCpeResponse.Builder::cpe).handleResponseHeaderString("etag", UpdateCpeResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateCpeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateCrossConnectResponse updateCrossConnect(UpdateCrossConnectRequest request) {
        Validate.notBlank((String)request.getCrossConnectId(), (String)"crossConnectId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateCrossConnectDetails(), "updateCrossConnectDetails is required");
        return (UpdateCrossConnectResponse)this.clientCall(request, UpdateCrossConnectResponse::builder).logger(LOG, "updateCrossConnect").serviceDetails("VirtualNetwork", "UpdateCrossConnect", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/CrossConnect/UpdateCrossConnect").method(Method.PUT).requestBuilder(UpdateCrossConnectRequest::builder).basePath("/20160918").appendPathParam("crossConnects").appendPathParam(request.getCrossConnectId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).operationUsesDefaultRetries().hasBody().handleBody(CrossConnect.class, UpdateCrossConnectResponse.Builder::crossConnect).handleResponseHeaderString("etag", UpdateCrossConnectResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateCrossConnectResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateCrossConnectGroupResponse updateCrossConnectGroup(UpdateCrossConnectGroupRequest request) {
        Validate.notBlank((String)request.getCrossConnectGroupId(), (String)"crossConnectGroupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateCrossConnectGroupDetails(), "updateCrossConnectGroupDetails is required");
        return (UpdateCrossConnectGroupResponse)this.clientCall(request, UpdateCrossConnectGroupResponse::builder).logger(LOG, "updateCrossConnectGroup").serviceDetails("VirtualNetwork", "UpdateCrossConnectGroup", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/CrossConnectGroup/UpdateCrossConnectGroup").method(Method.PUT).requestBuilder(UpdateCrossConnectGroupRequest::builder).basePath("/20160918").appendPathParam("crossConnectGroups").appendPathParam(request.getCrossConnectGroupId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).operationUsesDefaultRetries().hasBody().handleBody(CrossConnectGroup.class, UpdateCrossConnectGroupResponse.Builder::crossConnectGroup).handleResponseHeaderString("etag", UpdateCrossConnectGroupResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateCrossConnectGroupResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateDhcpOptionsResponse updateDhcpOptions(UpdateDhcpOptionsRequest request) {
        Validate.notBlank((String)request.getDhcpId(), (String)"dhcpId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateDhcpDetails(), "updateDhcpDetails is required");
        return (UpdateDhcpOptionsResponse)this.clientCall(request, UpdateDhcpOptionsResponse::builder).logger(LOG, "updateDhcpOptions").serviceDetails("VirtualNetwork", "UpdateDhcpOptions", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/DhcpOptions/UpdateDhcpOptions").method(Method.PUT).requestBuilder(UpdateDhcpOptionsRequest::builder).basePath("/20160918").appendPathParam("dhcps").appendPathParam(request.getDhcpId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(DhcpOptions.class, UpdateDhcpOptionsResponse.Builder::dhcpOptions).handleResponseHeaderString("etag", UpdateDhcpOptionsResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateDhcpOptionsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateDrgResponse updateDrg(UpdateDrgRequest request) {
        Validate.notBlank((String)request.getDrgId(), (String)"drgId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateDrgDetails(), "updateDrgDetails is required");
        return (UpdateDrgResponse)this.clientCall(request, UpdateDrgResponse::builder).logger(LOG, "updateDrg").serviceDetails("VirtualNetwork", "UpdateDrg", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Drg/UpdateDrg").method(Method.PUT).requestBuilder(UpdateDrgRequest::builder).basePath("/20160918").appendPathParam("drgs").appendPathParam(request.getDrgId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(Drg.class, UpdateDrgResponse.Builder::drg).handleResponseHeaderString("etag", UpdateDrgResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateDrgResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateDrgAttachmentResponse updateDrgAttachment(UpdateDrgAttachmentRequest request) {
        Validate.notBlank((String)request.getDrgAttachmentId(), (String)"drgAttachmentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateDrgAttachmentDetails(), "updateDrgAttachmentDetails is required");
        return (UpdateDrgAttachmentResponse)this.clientCall(request, UpdateDrgAttachmentResponse::builder).logger(LOG, "updateDrgAttachment").serviceDetails("VirtualNetwork", "UpdateDrgAttachment", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/DrgAttachment/UpdateDrgAttachment").method(Method.PUT).requestBuilder(UpdateDrgAttachmentRequest::builder).basePath("/20160918").appendPathParam("drgAttachments").appendPathParam(request.getDrgAttachmentId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(DrgAttachment.class, UpdateDrgAttachmentResponse.Builder::drgAttachment).handleResponseHeaderString("etag", UpdateDrgAttachmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateDrgAttachmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateDrgRouteDistributionResponse updateDrgRouteDistribution(UpdateDrgRouteDistributionRequest request) {
        Validate.notBlank((String)request.getDrgRouteDistributionId(), (String)"drgRouteDistributionId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateDrgRouteDistributionDetails(), "updateDrgRouteDistributionDetails is required");
        return (UpdateDrgRouteDistributionResponse)this.clientCall(request, UpdateDrgRouteDistributionResponse::builder).logger(LOG, "updateDrgRouteDistribution").serviceDetails("VirtualNetwork", "UpdateDrgRouteDistribution", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/DrgRouteDistribution/UpdateDrgRouteDistribution").method(Method.PUT).requestBuilder(UpdateDrgRouteDistributionRequest::builder).basePath("/20160918").appendPathParam("drgRouteDistributions").appendPathParam(request.getDrgRouteDistributionId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(DrgRouteDistribution.class, UpdateDrgRouteDistributionResponse.Builder::drgRouteDistribution).handleResponseHeaderString("etag", UpdateDrgRouteDistributionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateDrgRouteDistributionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateDrgRouteDistributionStatementsResponse updateDrgRouteDistributionStatements(UpdateDrgRouteDistributionStatementsRequest request) {
        Validate.notBlank((String)request.getDrgRouteDistributionId(), (String)"drgRouteDistributionId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateDrgRouteDistributionStatementsDetails(), "updateDrgRouteDistributionStatementsDetails is required");
        return (UpdateDrgRouteDistributionStatementsResponse)this.clientCall(request, UpdateDrgRouteDistributionStatementsResponse::builder).logger(LOG, "updateDrgRouteDistributionStatements").serviceDetails("VirtualNetwork", "UpdateDrgRouteDistributionStatements", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/DrgRouteDistributionStatement/UpdateDrgRouteDistributionStatements").method(Method.POST).requestBuilder(UpdateDrgRouteDistributionStatementsRequest::builder).basePath("/20160918").appendPathParam("drgRouteDistributions").appendPathParam(request.getDrgRouteDistributionId()).appendPathParam("actions").appendPathParam("updateDrgRouteDistributionStatements").accept(new String[]{"application/json"}).hasBody().handleBodyList(DrgRouteDistributionStatement.class, UpdateDrgRouteDistributionStatementsResponse.Builder::items).handleResponseHeaderString("opc-request-id", UpdateDrgRouteDistributionStatementsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateDrgRouteRulesResponse updateDrgRouteRules(UpdateDrgRouteRulesRequest request) {
        Validate.notBlank((String)request.getDrgRouteTableId(), (String)"drgRouteTableId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateDrgRouteRulesDetails(), "updateDrgRouteRulesDetails is required");
        return (UpdateDrgRouteRulesResponse)this.clientCall(request, UpdateDrgRouteRulesResponse::builder).logger(LOG, "updateDrgRouteRules").serviceDetails("VirtualNetwork", "UpdateDrgRouteRules", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/DrgRouteRule/UpdateDrgRouteRules").method(Method.POST).requestBuilder(UpdateDrgRouteRulesRequest::builder).basePath("/20160918").appendPathParam("drgRouteTables").appendPathParam(request.getDrgRouteTableId()).appendPathParam("actions").appendPathParam("updateDrgRouteRules").accept(new String[]{"application/json"}).hasBody().handleBodyList(DrgRouteRule.class, UpdateDrgRouteRulesResponse.Builder::items).handleResponseHeaderString("opc-request-id", UpdateDrgRouteRulesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateDrgRouteTableResponse updateDrgRouteTable(UpdateDrgRouteTableRequest request) {
        Validate.notBlank((String)request.getDrgRouteTableId(), (String)"drgRouteTableId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateDrgRouteTableDetails(), "updateDrgRouteTableDetails is required");
        return (UpdateDrgRouteTableResponse)this.clientCall(request, UpdateDrgRouteTableResponse::builder).logger(LOG, "updateDrgRouteTable").serviceDetails("VirtualNetwork", "UpdateDrgRouteTable", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/DrgRouteTable/UpdateDrgRouteTable").method(Method.PUT).requestBuilder(UpdateDrgRouteTableRequest::builder).basePath("/20160918").appendPathParam("drgRouteTables").appendPathParam(request.getDrgRouteTableId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(DrgRouteTable.class, UpdateDrgRouteTableResponse.Builder::drgRouteTable).handleResponseHeaderString("etag", UpdateDrgRouteTableResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateDrgRouteTableResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateIPSecConnectionResponse updateIPSecConnection(UpdateIPSecConnectionRequest request) {
        Validate.notBlank((String)request.getIpscId(), (String)"ipscId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateIPSecConnectionDetails(), "updateIPSecConnectionDetails is required");
        return (UpdateIPSecConnectionResponse)this.clientCall(request, UpdateIPSecConnectionResponse::builder).logger(LOG, "updateIPSecConnection").serviceDetails("VirtualNetwork", "UpdateIPSecConnection", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/IPSecConnection/UpdateIPSecConnection").method(Method.PUT).requestBuilder(UpdateIPSecConnectionRequest::builder).basePath("/20160918").appendPathParam("ipsecConnections").appendPathParam(request.getIpscId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).operationUsesDefaultRetries().hasBody().handleBody(IPSecConnection.class, UpdateIPSecConnectionResponse.Builder::iPSecConnection).handleResponseHeaderString("etag", UpdateIPSecConnectionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateIPSecConnectionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateIPSecConnectionTunnelResponse updateIPSecConnectionTunnel(UpdateIPSecConnectionTunnelRequest request) {
        Validate.notBlank((String)request.getIpscId(), (String)"ipscId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTunnelId(), (String)"tunnelId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateIPSecConnectionTunnelDetails(), "updateIPSecConnectionTunnelDetails is required");
        return (UpdateIPSecConnectionTunnelResponse)this.clientCall(request, UpdateIPSecConnectionTunnelResponse::builder).logger(LOG, "updateIPSecConnectionTunnel").serviceDetails("VirtualNetwork", "UpdateIPSecConnectionTunnel", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/IPSecConnectionTunnel/UpdateIPSecConnectionTunnel").method(Method.PUT).requestBuilder(UpdateIPSecConnectionTunnelRequest::builder).basePath("/20160918").appendPathParam("ipsecConnections").appendPathParam(request.getIpscId()).appendPathParam("tunnels").appendPathParam(request.getTunnelId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(IPSecConnectionTunnel.class, UpdateIPSecConnectionTunnelResponse.Builder::iPSecConnectionTunnel).handleResponseHeaderString("etag", UpdateIPSecConnectionTunnelResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateIPSecConnectionTunnelResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateIPSecConnectionTunnelSharedSecretResponse updateIPSecConnectionTunnelSharedSecret(UpdateIPSecConnectionTunnelSharedSecretRequest request) {
        Validate.notBlank((String)request.getIpscId(), (String)"ipscId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTunnelId(), (String)"tunnelId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateIPSecConnectionTunnelSharedSecretDetails(), "updateIPSecConnectionTunnelSharedSecretDetails is required");
        return (UpdateIPSecConnectionTunnelSharedSecretResponse)this.clientCall(request, UpdateIPSecConnectionTunnelSharedSecretResponse::builder).logger(LOG, "updateIPSecConnectionTunnelSharedSecret").serviceDetails("VirtualNetwork", "UpdateIPSecConnectionTunnelSharedSecret", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/IPSecConnectionTunnelSharedSecret/UpdateIPSecConnectionTunnelSharedSecret").method(Method.PUT).requestBuilder(UpdateIPSecConnectionTunnelSharedSecretRequest::builder).basePath("/20160918").appendPathParam("ipsecConnections").appendPathParam(request.getIpscId()).appendPathParam("tunnels").appendPathParam(request.getTunnelId()).appendPathParam("sharedSecret").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).operationUsesDefaultRetries().hasBody().handleBody(IPSecConnectionTunnelSharedSecret.class, UpdateIPSecConnectionTunnelSharedSecretResponse.Builder::iPSecConnectionTunnelSharedSecret).handleResponseHeaderString("etag", UpdateIPSecConnectionTunnelSharedSecretResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateIPSecConnectionTunnelSharedSecretResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateInternetGatewayResponse updateInternetGateway(UpdateInternetGatewayRequest request) {
        Validate.notBlank((String)request.getIgId(), (String)"igId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateInternetGatewayDetails(), "updateInternetGatewayDetails is required");
        return (UpdateInternetGatewayResponse)this.clientCall(request, UpdateInternetGatewayResponse::builder).logger(LOG, "updateInternetGateway").serviceDetails("VirtualNetwork", "UpdateInternetGateway", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/InternetGateway/UpdateInternetGateway").method(Method.PUT).requestBuilder(UpdateInternetGatewayRequest::builder).basePath("/20160918").appendPathParam("internetGateways").appendPathParam(request.getIgId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(InternetGateway.class, UpdateInternetGatewayResponse.Builder::internetGateway).handleResponseHeaderString("etag", UpdateInternetGatewayResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateInternetGatewayResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateIpv6Response updateIpv6(UpdateIpv6Request request) {
        Validate.notBlank((String)request.getIpv6Id(), (String)"ipv6Id must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateIpv6Details(), "updateIpv6Details is required");
        return (UpdateIpv6Response)this.clientCall(request, UpdateIpv6Response::builder).logger(LOG, "updateIpv6").serviceDetails("VirtualNetwork", "UpdateIpv6", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Ipv6/UpdateIpv6").method(Method.PUT).requestBuilder(UpdateIpv6Request::builder).basePath("/20160918").appendPathParam("ipv6").appendPathParam(request.getIpv6Id()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Ipv6.class, UpdateIpv6Response.Builder::ipv6).handleResponseHeaderString("etag", UpdateIpv6Response.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateIpv6Response.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateLocalPeeringGatewayResponse updateLocalPeeringGateway(UpdateLocalPeeringGatewayRequest request) {
        Validate.notBlank((String)request.getLocalPeeringGatewayId(), (String)"localPeeringGatewayId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateLocalPeeringGatewayDetails(), "updateLocalPeeringGatewayDetails is required");
        return (UpdateLocalPeeringGatewayResponse)this.clientCall(request, UpdateLocalPeeringGatewayResponse::builder).logger(LOG, "updateLocalPeeringGateway").serviceDetails("VirtualNetwork", "UpdateLocalPeeringGateway", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/LocalPeeringGateway/UpdateLocalPeeringGateway").method(Method.PUT).requestBuilder(UpdateLocalPeeringGatewayRequest::builder).basePath("/20160918").appendPathParam("localPeeringGateways").appendPathParam(request.getLocalPeeringGatewayId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(LocalPeeringGateway.class, UpdateLocalPeeringGatewayResponse.Builder::localPeeringGateway).handleResponseHeaderString("etag", UpdateLocalPeeringGatewayResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateLocalPeeringGatewayResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateNatGatewayResponse updateNatGateway(UpdateNatGatewayRequest request) {
        Validate.notBlank((String)request.getNatGatewayId(), (String)"natGatewayId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateNatGatewayDetails(), "updateNatGatewayDetails is required");
        return (UpdateNatGatewayResponse)this.clientCall(request, UpdateNatGatewayResponse::builder).logger(LOG, "updateNatGateway").serviceDetails("VirtualNetwork", "UpdateNatGateway", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/NatGateway/UpdateNatGateway").method(Method.PUT).requestBuilder(UpdateNatGatewayRequest::builder).basePath("/20160918").appendPathParam("natGateways").appendPathParam(request.getNatGatewayId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(NatGateway.class, UpdateNatGatewayResponse.Builder::natGateway).handleResponseHeaderString("etag", UpdateNatGatewayResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateNatGatewayResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateNetworkSecurityGroupResponse updateNetworkSecurityGroup(UpdateNetworkSecurityGroupRequest request) {
        Validate.notBlank((String)request.getNetworkSecurityGroupId(), (String)"networkSecurityGroupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateNetworkSecurityGroupDetails(), "updateNetworkSecurityGroupDetails is required");
        return (UpdateNetworkSecurityGroupResponse)this.clientCall(request, UpdateNetworkSecurityGroupResponse::builder).logger(LOG, "updateNetworkSecurityGroup").serviceDetails("VirtualNetwork", "UpdateNetworkSecurityGroup", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/NetworkSecurityGroup/UpdateNetworkSecurityGroup").method(Method.PUT).requestBuilder(UpdateNetworkSecurityGroupRequest::builder).basePath("/20160918").appendPathParam("networkSecurityGroups").appendPathParam(request.getNetworkSecurityGroupId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(NetworkSecurityGroup.class, UpdateNetworkSecurityGroupResponse.Builder::networkSecurityGroup).handleResponseHeaderString("etag", UpdateNetworkSecurityGroupResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateNetworkSecurityGroupResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateNetworkSecurityGroupSecurityRulesResponse updateNetworkSecurityGroupSecurityRules(UpdateNetworkSecurityGroupSecurityRulesRequest request) {
        Validate.notBlank((String)request.getNetworkSecurityGroupId(), (String)"networkSecurityGroupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateNetworkSecurityGroupSecurityRulesDetails(), "updateNetworkSecurityGroupSecurityRulesDetails is required");
        return (UpdateNetworkSecurityGroupSecurityRulesResponse)this.clientCall(request, UpdateNetworkSecurityGroupSecurityRulesResponse::builder).logger(LOG, "updateNetworkSecurityGroupSecurityRules").serviceDetails("VirtualNetwork", "UpdateNetworkSecurityGroupSecurityRules", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/SecurityRule/UpdateNetworkSecurityGroupSecurityRules").method(Method.POST).requestBuilder(UpdateNetworkSecurityGroupSecurityRulesRequest::builder).basePath("/20160918").appendPathParam("networkSecurityGroups").appendPathParam(request.getNetworkSecurityGroupId()).appendPathParam("actions").appendPathParam("updateSecurityRules").accept(new String[]{"application/json"}).hasBody().handleBody(UpdatedNetworkSecurityGroupSecurityRules.class, UpdateNetworkSecurityGroupSecurityRulesResponse.Builder::updatedNetworkSecurityGroupSecurityRules).handleResponseHeaderString("opc-request-id", UpdateNetworkSecurityGroupSecurityRulesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdatePrivateIpResponse updatePrivateIp(UpdatePrivateIpRequest request) {
        Validate.notBlank((String)request.getPrivateIpId(), (String)"privateIpId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdatePrivateIpDetails(), "updatePrivateIpDetails is required");
        return (UpdatePrivateIpResponse)this.clientCall(request, UpdatePrivateIpResponse::builder).logger(LOG, "updatePrivateIp").serviceDetails("VirtualNetwork", "UpdatePrivateIp", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/PrivateIp/UpdatePrivateIp").method(Method.PUT).requestBuilder(UpdatePrivateIpRequest::builder).basePath("/20160918").appendPathParam("privateIps").appendPathParam(request.getPrivateIpId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(PrivateIp.class, UpdatePrivateIpResponse.Builder::privateIp).handleResponseHeaderString("etag", UpdatePrivateIpResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdatePrivateIpResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdatePublicIpResponse updatePublicIp(UpdatePublicIpRequest request) {
        Validate.notBlank((String)request.getPublicIpId(), (String)"publicIpId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdatePublicIpDetails(), "updatePublicIpDetails is required");
        return (UpdatePublicIpResponse)this.clientCall(request, UpdatePublicIpResponse::builder).logger(LOG, "updatePublicIp").serviceDetails("VirtualNetwork", "UpdatePublicIp", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/PublicIp/UpdatePublicIp").method(Method.PUT).requestBuilder(UpdatePublicIpRequest::builder).basePath("/20160918").appendPathParam("publicIps").appendPathParam(request.getPublicIpId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(PublicIp.class, UpdatePublicIpResponse.Builder::publicIp).handleResponseHeaderString("etag", UpdatePublicIpResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdatePublicIpResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdatePublicIpPoolResponse updatePublicIpPool(UpdatePublicIpPoolRequest request) {
        Validate.notBlank((String)request.getPublicIpPoolId(), (String)"publicIpPoolId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdatePublicIpPoolDetails(), "updatePublicIpPoolDetails is required");
        return (UpdatePublicIpPoolResponse)this.clientCall(request, UpdatePublicIpPoolResponse::builder).logger(LOG, "updatePublicIpPool").serviceDetails("VirtualNetwork", "UpdatePublicIpPool", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/PublicIpPool/UpdatePublicIpPool").method(Method.PUT).requestBuilder(UpdatePublicIpPoolRequest::builder).basePath("/20160918").appendPathParam("publicIpPools").appendPathParam(request.getPublicIpPoolId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(PublicIpPool.class, UpdatePublicIpPoolResponse.Builder::publicIpPool).handleResponseHeaderString("etag", UpdatePublicIpPoolResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdatePublicIpPoolResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateRemotePeeringConnectionResponse updateRemotePeeringConnection(UpdateRemotePeeringConnectionRequest request) {
        Validate.notBlank((String)request.getRemotePeeringConnectionId(), (String)"remotePeeringConnectionId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateRemotePeeringConnectionDetails(), "updateRemotePeeringConnectionDetails is required");
        return (UpdateRemotePeeringConnectionResponse)this.clientCall(request, UpdateRemotePeeringConnectionResponse::builder).logger(LOG, "updateRemotePeeringConnection").serviceDetails("VirtualNetwork", "UpdateRemotePeeringConnection", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/RemotePeeringConnection/UpdateRemotePeeringConnection").method(Method.PUT).requestBuilder(UpdateRemotePeeringConnectionRequest::builder).basePath("/20160918").appendPathParam("remotePeeringConnections").appendPathParam(request.getRemotePeeringConnectionId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).operationUsesDefaultRetries().hasBody().handleBody(RemotePeeringConnection.class, UpdateRemotePeeringConnectionResponse.Builder::remotePeeringConnection).handleResponseHeaderString("etag", UpdateRemotePeeringConnectionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateRemotePeeringConnectionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateRouteTableResponse updateRouteTable(UpdateRouteTableRequest request) {
        Validate.notBlank((String)request.getRtId(), (String)"rtId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateRouteTableDetails(), "updateRouteTableDetails is required");
        return (UpdateRouteTableResponse)this.clientCall(request, UpdateRouteTableResponse::builder).logger(LOG, "updateRouteTable").serviceDetails("VirtualNetwork", "UpdateRouteTable", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/RouteTable/UpdateRouteTable").method(Method.PUT).requestBuilder(UpdateRouteTableRequest::builder).basePath("/20160918").appendPathParam("routeTables").appendPathParam(request.getRtId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(RouteTable.class, UpdateRouteTableResponse.Builder::routeTable).handleResponseHeaderString("etag", UpdateRouteTableResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateRouteTableResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateSecurityListResponse updateSecurityList(UpdateSecurityListRequest request) {
        Validate.notBlank((String)request.getSecurityListId(), (String)"securityListId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateSecurityListDetails(), "updateSecurityListDetails is required");
        return (UpdateSecurityListResponse)this.clientCall(request, UpdateSecurityListResponse::builder).logger(LOG, "updateSecurityList").serviceDetails("VirtualNetwork", "UpdateSecurityList", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/SecurityList/UpdateSecurityList").method(Method.PUT).requestBuilder(UpdateSecurityListRequest::builder).basePath("/20160918").appendPathParam("securityLists").appendPathParam(request.getSecurityListId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(SecurityList.class, UpdateSecurityListResponse.Builder::securityList).handleResponseHeaderString("etag", UpdateSecurityListResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateSecurityListResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateServiceGatewayResponse updateServiceGateway(UpdateServiceGatewayRequest request) {
        Validate.notBlank((String)request.getServiceGatewayId(), (String)"serviceGatewayId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateServiceGatewayDetails(), "updateServiceGatewayDetails is required");
        return (UpdateServiceGatewayResponse)this.clientCall(request, UpdateServiceGatewayResponse::builder).logger(LOG, "updateServiceGateway").serviceDetails("VirtualNetwork", "UpdateServiceGateway", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ServiceGateway/UpdateServiceGateway").method(Method.PUT).requestBuilder(UpdateServiceGatewayRequest::builder).basePath("/20160918").appendPathParam("serviceGateways").appendPathParam(request.getServiceGatewayId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(ServiceGateway.class, UpdateServiceGatewayResponse.Builder::serviceGateway).handleResponseHeaderString("etag", UpdateServiceGatewayResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateServiceGatewayResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateSubnetResponse updateSubnet(UpdateSubnetRequest request) {
        Validate.notBlank((String)request.getSubnetId(), (String)"subnetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateSubnetDetails(), "updateSubnetDetails is required");
        return (UpdateSubnetResponse)this.clientCall(request, UpdateSubnetResponse::builder).logger(LOG, "updateSubnet").serviceDetails("VirtualNetwork", "UpdateSubnet", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Subnet/UpdateSubnet").method(Method.PUT).requestBuilder(UpdateSubnetRequest::builder).basePath("/20160918").appendPathParam("subnets").appendPathParam(request.getSubnetId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(Subnet.class, UpdateSubnetResponse.Builder::subnet).handleResponseHeaderString("etag", UpdateSubnetResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateSubnetResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateTunnelCpeDeviceConfigResponse updateTunnelCpeDeviceConfig(UpdateTunnelCpeDeviceConfigRequest request) {
        Validate.notBlank((String)request.getIpscId(), (String)"ipscId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTunnelId(), (String)"tunnelId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateTunnelCpeDeviceConfigDetails(), "updateTunnelCpeDeviceConfigDetails is required");
        return (UpdateTunnelCpeDeviceConfigResponse)this.clientCall(request, UpdateTunnelCpeDeviceConfigResponse::builder).logger(LOG, "updateTunnelCpeDeviceConfig").serviceDetails("VirtualNetwork", "UpdateTunnelCpeDeviceConfig", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/TunnelCpeDeviceConfig/UpdateTunnelCpeDeviceConfig").method(Method.PUT).requestBuilder(UpdateTunnelCpeDeviceConfigRequest::builder).basePath("/20160918").appendPathParam("ipsecConnections").appendPathParam(request.getIpscId()).appendPathParam("tunnels").appendPathParam(request.getTunnelId()).appendPathParam("tunnelDeviceConfig").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(TunnelCpeDeviceConfig.class, UpdateTunnelCpeDeviceConfigResponse.Builder::tunnelCpeDeviceConfig).handleResponseHeaderString("etag", UpdateTunnelCpeDeviceConfigResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateTunnelCpeDeviceConfigResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateVcnResponse updateVcn(UpdateVcnRequest request) {
        Validate.notBlank((String)request.getVcnId(), (String)"vcnId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateVcnDetails(), "updateVcnDetails is required");
        return (UpdateVcnResponse)this.clientCall(request, UpdateVcnResponse::builder).logger(LOG, "updateVcn").serviceDetails("VirtualNetwork", "UpdateVcn", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Vcn/UpdateVcn").method(Method.PUT).requestBuilder(UpdateVcnRequest::builder).basePath("/20160918").appendPathParam("vcns").appendPathParam(request.getVcnId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(Vcn.class, UpdateVcnResponse.Builder::vcn).handleResponseHeaderString("etag", UpdateVcnResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateVcnResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateVirtualCircuitResponse updateVirtualCircuit(UpdateVirtualCircuitRequest request) {
        Validate.notBlank((String)request.getVirtualCircuitId(), (String)"virtualCircuitId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateVirtualCircuitDetails(), "updateVirtualCircuitDetails is required");
        return (UpdateVirtualCircuitResponse)this.clientCall(request, UpdateVirtualCircuitResponse::builder).logger(LOG, "updateVirtualCircuit").serviceDetails("VirtualNetwork", "UpdateVirtualCircuit", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/VirtualCircuit/UpdateVirtualCircuit").method(Method.PUT).requestBuilder(UpdateVirtualCircuitRequest::builder).basePath("/20160918").appendPathParam("virtualCircuits").appendPathParam(request.getVirtualCircuitId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).operationUsesDefaultRetries().hasBody().handleBody(VirtualCircuit.class, UpdateVirtualCircuitResponse.Builder::virtualCircuit).handleResponseHeaderString("etag", UpdateVirtualCircuitResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateVirtualCircuitResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateVlanResponse updateVlan(UpdateVlanRequest request) {
        Validate.notBlank((String)request.getVlanId(), (String)"vlanId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateVlanDetails(), "updateVlanDetails is required");
        return (UpdateVlanResponse)this.clientCall(request, UpdateVlanResponse::builder).logger(LOG, "updateVlan").serviceDetails("VirtualNetwork", "UpdateVlan", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Vlan/UpdateVlan").method(Method.PUT).requestBuilder(UpdateVlanRequest::builder).basePath("/20160918").appendPathParam("vlans").appendPathParam(request.getVlanId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Vlan.class, UpdateVlanResponse.Builder::vlan).handleResponseHeaderString("etag", UpdateVlanResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateVlanResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateVnicResponse updateVnic(UpdateVnicRequest request) {
        Validate.notBlank((String)request.getVnicId(), (String)"vnicId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateVnicDetails(), "updateVnicDetails is required");
        return (UpdateVnicResponse)this.clientCall(request, UpdateVnicResponse::builder).logger(LOG, "updateVnic").serviceDetails("VirtualNetwork", "UpdateVnic", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Vnic/UpdateVnic").method(Method.PUT).requestBuilder(UpdateVnicRequest::builder).basePath("/20160918").appendPathParam("vnics").appendPathParam(request.getVnicId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(Vnic.class, UpdateVnicResponse.Builder::vnic).handleResponseHeaderString("etag", UpdateVnicResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateVnicResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateVtapResponse updateVtap(UpdateVtapRequest request) {
        Validate.notBlank((String)request.getVtapId(), (String)"vtapId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateVtapDetails(), "updateVtapDetails is required");
        return (UpdateVtapResponse)this.clientCall(request, UpdateVtapResponse::builder).logger(LOG, "updateVtap").serviceDetails("VirtualNetwork", "UpdateVtap", "").method(Method.PUT).requestBuilder(UpdateVtapRequest::builder).basePath("/20160918").appendPathParam("vtaps").appendPathParam(request.getVtapId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Vtap.class, UpdateVtapResponse.Builder::vtap).handleResponseHeaderString("etag", UpdateVtapResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateVtapResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateVtapResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public UpgradeDrgResponse upgradeDrg(UpgradeDrgRequest request) {
        Validate.notBlank((String)request.getDrgId(), (String)"drgId must not be blank", (Object[])new Object[0]);
        return (UpgradeDrgResponse)this.clientCall(request, UpgradeDrgResponse::builder).logger(LOG, "upgradeDrg").serviceDetails("VirtualNetwork", "UpgradeDrg", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Drg/UpgradeDrg").method(Method.POST).requestBuilder(UpgradeDrgRequest::builder).basePath("/20160918").appendPathParam("drgs").appendPathParam(request.getDrgId()).appendPathParam("actions").appendPathParam("upgrade").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-request-id", UpgradeDrgResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpgradeDrgResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public ValidateByoasnResponse validateByoasn(ValidateByoasnRequest request) {
        Validate.notBlank((String)request.getByoasnId(), (String)"byoasnId must not be blank", (Object[])new Object[0]);
        return (ValidateByoasnResponse)this.clientCall(request, ValidateByoasnResponse::builder).logger(LOG, "validateByoasn").serviceDetails("VirtualNetwork", "ValidateByoasn", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Byoasn/ValidateByoasn").method(Method.POST).requestBuilder(ValidateByoasnRequest::builder).basePath("/20160918").appendPathParam("byoasns").appendPathParam(request.getByoasnId()).appendPathParam("actions").appendPathParam("validate").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", ValidateByoasnResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ValidateByoasnResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public ValidateByoipRangeResponse validateByoipRange(ValidateByoipRangeRequest request) {
        Validate.notBlank((String)request.getByoipRangeId(), (String)"byoipRangeId must not be blank", (Object[])new Object[0]);
        return (ValidateByoipRangeResponse)this.clientCall(request, ValidateByoipRangeResponse::builder).logger(LOG, "validateByoipRange").serviceDetails("VirtualNetwork", "ValidateByoipRange", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ByoipRange/ValidateByoipRange").method(Method.POST).requestBuilder(ValidateByoipRangeRequest::builder).basePath("/20160918").appendPathParam("byoipRanges").appendPathParam(request.getByoipRangeId()).appendPathParam("actions").appendPathParam("validate").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", ValidateByoipRangeResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ValidateByoipRangeResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public WithdrawByoipRangeResponse withdrawByoipRange(WithdrawByoipRangeRequest request) {
        Validate.notBlank((String)request.getByoipRangeId(), (String)"byoipRangeId must not be blank", (Object[])new Object[0]);
        return (WithdrawByoipRangeResponse)this.clientCall(request, WithdrawByoipRangeResponse::builder).logger(LOG, "withdrawByoipRange").serviceDetails("VirtualNetwork", "WithdrawByoipRange", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ByoipRange/WithdrawByoipRange").method(Method.POST).requestBuilder(WithdrawByoipRangeRequest::builder).basePath("/20160918").appendPathParam("byoipRanges").appendPathParam(request.getByoipRangeId()).appendPathParam("actions").appendPathParam("withdraw").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", WithdrawByoipRangeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public VirtualNetworkWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public VirtualNetworkWaiters newWaiters(WorkRequest workRequestClient) {
        return new VirtualNetworkWaiters(this.executorService, this, workRequestClient);
    }

    @Override
    public VirtualNetworkPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public VirtualNetworkClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)VirtualNetworkClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public VirtualNetworkClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(VirtualNetworkClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public VirtualNetworkClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)VirtualNetworkClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public VirtualNetworkClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)VirtualNetworkClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public VirtualNetworkClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)VirtualNetworkClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public VirtualNetworkClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)VirtualNetworkClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public VirtualNetworkClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)VirtualNetworkClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public VirtualNetworkClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)VirtualNetworkClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, VirtualNetworkClient> {
        private boolean isStreamWarningEnabled = true;
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            String packageName = "core";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"core");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public Builder isStreamWarningEnabled(boolean isStreamWarningEnabled) {
            this.isStreamWarningEnabled = isStreamWarningEnabled;
            return this;
        }

        public VirtualNetworkClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new VirtualNetworkClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService, this.isStreamWarningEnabled);
        }
    }
}

