/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core;

import com.oracle.bmc.core.Blockstorage;
import com.oracle.bmc.core.model.BlockVolumeReplica;
import com.oracle.bmc.core.model.BootVolume;
import com.oracle.bmc.core.model.BootVolumeBackup;
import com.oracle.bmc.core.model.BootVolumeReplica;
import com.oracle.bmc.core.model.Volume;
import com.oracle.bmc.core.model.VolumeBackup;
import com.oracle.bmc.core.model.VolumeGroup;
import com.oracle.bmc.core.model.VolumeGroupBackup;
import com.oracle.bmc.core.model.VolumeGroupReplica;
import com.oracle.bmc.core.requests.CopyBootVolumeBackupRequest;
import com.oracle.bmc.core.requests.CopyVolumeBackupRequest;
import com.oracle.bmc.core.requests.GetBlockVolumeReplicaRequest;
import com.oracle.bmc.core.requests.GetBootVolumeBackupRequest;
import com.oracle.bmc.core.requests.GetBootVolumeReplicaRequest;
import com.oracle.bmc.core.requests.GetBootVolumeRequest;
import com.oracle.bmc.core.requests.GetVolumeBackupRequest;
import com.oracle.bmc.core.requests.GetVolumeGroupBackupRequest;
import com.oracle.bmc.core.requests.GetVolumeGroupReplicaRequest;
import com.oracle.bmc.core.requests.GetVolumeGroupRequest;
import com.oracle.bmc.core.requests.GetVolumeRequest;
import com.oracle.bmc.core.responses.CopyBootVolumeBackupResponse;
import com.oracle.bmc.core.responses.CopyVolumeBackupResponse;
import com.oracle.bmc.core.responses.GetBlockVolumeReplicaResponse;
import com.oracle.bmc.core.responses.GetBootVolumeBackupResponse;
import com.oracle.bmc.core.responses.GetBootVolumeReplicaResponse;
import com.oracle.bmc.core.responses.GetBootVolumeResponse;
import com.oracle.bmc.core.responses.GetVolumeBackupResponse;
import com.oracle.bmc.core.responses.GetVolumeGroupBackupResponse;
import com.oracle.bmc.core.responses.GetVolumeGroupReplicaResponse;
import com.oracle.bmc.core.responses.GetVolumeGroupResponse;
import com.oracle.bmc.core.responses.GetVolumeResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import com.oracle.bmc.workrequests.WorkRequest;
import com.oracle.bmc.workrequests.requests.GetWorkRequestRequest;
import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class BlockstorageWaiters {
    @Nonnull
    private final ExecutorService executorService;
    @Nonnull
    private final Blockstorage client;
    private final WorkRequest workRequestClient;

    @Deprecated
    public BlockstorageWaiters(@Nonnull ExecutorService executorService, @Nonnull Blockstorage client) {
        this(executorService, client, null);
    }

    public BlockstorageWaiters(@Nonnull ExecutorService executorService, @Nonnull Blockstorage client, WorkRequest workRequestClient) {
        if (executorService == null) {
            throw new NullPointerException("executorService is marked non-null but is null");
        }
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        this.executorService = executorService;
        this.client = client;
        this.workRequestClient = workRequestClient;
    }

    public Waiter<CopyBootVolumeBackupRequest, CopyBootVolumeBackupResponse> forCopyBootVolumeBackup(CopyBootVolumeBackupRequest request) {
        return this.forCopyBootVolumeBackup(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<CopyBootVolumeBackupRequest, CopyBootVolumeBackupResponse> forCopyBootVolumeBackup(final CopyBootVolumeBackupRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl(this.executorService, (Callable)new Callable<CopyBootVolumeBackupResponse>(){
            final /* synthetic */ BlockstorageWaiters this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public CopyBootVolumeBackupResponse call() throws Exception {
                CopyBootVolumeBackupResponse response = this.this$0.client.copyBootVolumeBackup(request);
                if (response.getOpcWorkRequestId() != null) {
                    GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                    this.this$0.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                }
                return response;
            }
        }, (Object)request);
    }

    public Waiter<CopyVolumeBackupRequest, CopyVolumeBackupResponse> forCopyVolumeBackup(CopyVolumeBackupRequest request) {
        return this.forCopyVolumeBackup(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<CopyVolumeBackupRequest, CopyVolumeBackupResponse> forCopyVolumeBackup(final CopyVolumeBackupRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl(this.executorService, (Callable)new Callable<CopyVolumeBackupResponse>(){
            final /* synthetic */ BlockstorageWaiters this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public CopyVolumeBackupResponse call() throws Exception {
                CopyVolumeBackupResponse response = this.this$0.client.copyVolumeBackup(request);
                if (response.getOpcWorkRequestId() != null) {
                    GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                    this.this$0.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                }
                return response;
            }
        }, (Object)request);
    }

    public Waiter<GetBlockVolumeReplicaRequest, GetBlockVolumeReplicaResponse> forBlockVolumeReplica(GetBlockVolumeReplicaRequest request, BlockVolumeReplica.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forBlockVolumeReplica(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetBlockVolumeReplicaRequest, GetBlockVolumeReplicaResponse> forBlockVolumeReplica(GetBlockVolumeReplicaRequest request, BlockVolumeReplica.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forBlockVolumeReplica(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetBlockVolumeReplicaRequest, GetBlockVolumeReplicaResponse> forBlockVolumeReplica(GetBlockVolumeReplicaRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, BlockVolumeReplica.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forBlockVolumeReplica(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetBlockVolumeReplicaRequest, GetBlockVolumeReplicaResponse> forBlockVolumeReplica(BmcGenericWaiter waiter, GetBlockVolumeReplicaRequest request, BlockVolumeReplica.LifecycleState ... targetStates) {
        final HashSet<BlockVolumeReplica.LifecycleState> targetStatesSet = new HashSet<BlockVolumeReplica.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetBlockVolumeReplicaRequest, GetBlockVolumeReplicaResponse>(){

            @Override
            public GetBlockVolumeReplicaResponse apply(GetBlockVolumeReplicaRequest request) {
                return BlockstorageWaiters.this.client.getBlockVolumeReplica(request);
            }
        }, (Predicate)new Predicate<GetBlockVolumeReplicaResponse>(){
            final /* synthetic */ BlockstorageWaiters this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean test(GetBlockVolumeReplicaResponse response) {
                return targetStatesSet.contains((Object)response.getBlockVolumeReplica().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)BlockVolumeReplica.LifecycleState.Terminated)), (Object)request);
    }

    public Waiter<GetBootVolumeRequest, GetBootVolumeResponse> forBootVolume(GetBootVolumeRequest request, BootVolume.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forBootVolume(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetBootVolumeRequest, GetBootVolumeResponse> forBootVolume(GetBootVolumeRequest request, BootVolume.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forBootVolume(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetBootVolumeRequest, GetBootVolumeResponse> forBootVolume(GetBootVolumeRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, BootVolume.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forBootVolume(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetBootVolumeRequest, GetBootVolumeResponse> forBootVolume(BmcGenericWaiter waiter, GetBootVolumeRequest request, BootVolume.LifecycleState ... targetStates) {
        final HashSet<BootVolume.LifecycleState> targetStatesSet = new HashSet<BootVolume.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetBootVolumeRequest, GetBootVolumeResponse>(){

            @Override
            public GetBootVolumeResponse apply(GetBootVolumeRequest request) {
                return BlockstorageWaiters.this.client.getBootVolume(request);
            }
        }, (Predicate)new Predicate<GetBootVolumeResponse>(){
            final /* synthetic */ BlockstorageWaiters this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean test(GetBootVolumeResponse response) {
                return targetStatesSet.contains((Object)response.getBootVolume().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)BootVolume.LifecycleState.Terminated)), (Object)request);
    }

    public Waiter<GetBootVolumeBackupRequest, GetBootVolumeBackupResponse> forBootVolumeBackup(GetBootVolumeBackupRequest request, BootVolumeBackup.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forBootVolumeBackup(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetBootVolumeBackupRequest, GetBootVolumeBackupResponse> forBootVolumeBackup(GetBootVolumeBackupRequest request, BootVolumeBackup.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forBootVolumeBackup(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetBootVolumeBackupRequest, GetBootVolumeBackupResponse> forBootVolumeBackup(GetBootVolumeBackupRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, BootVolumeBackup.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forBootVolumeBackup(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetBootVolumeBackupRequest, GetBootVolumeBackupResponse> forBootVolumeBackup(BmcGenericWaiter waiter, GetBootVolumeBackupRequest request, BootVolumeBackup.LifecycleState ... targetStates) {
        final HashSet<BootVolumeBackup.LifecycleState> targetStatesSet = new HashSet<BootVolumeBackup.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetBootVolumeBackupRequest, GetBootVolumeBackupResponse>(){

            @Override
            public GetBootVolumeBackupResponse apply(GetBootVolumeBackupRequest request) {
                return BlockstorageWaiters.this.client.getBootVolumeBackup(request);
            }
        }, (Predicate)new Predicate<GetBootVolumeBackupResponse>(){
            final /* synthetic */ BlockstorageWaiters this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean test(GetBootVolumeBackupResponse response) {
                return targetStatesSet.contains((Object)response.getBootVolumeBackup().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)BootVolumeBackup.LifecycleState.Terminated)), (Object)request);
    }

    public Waiter<GetBootVolumeReplicaRequest, GetBootVolumeReplicaResponse> forBootVolumeReplica(GetBootVolumeReplicaRequest request, BootVolumeReplica.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forBootVolumeReplica(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetBootVolumeReplicaRequest, GetBootVolumeReplicaResponse> forBootVolumeReplica(GetBootVolumeReplicaRequest request, BootVolumeReplica.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forBootVolumeReplica(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetBootVolumeReplicaRequest, GetBootVolumeReplicaResponse> forBootVolumeReplica(GetBootVolumeReplicaRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, BootVolumeReplica.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forBootVolumeReplica(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetBootVolumeReplicaRequest, GetBootVolumeReplicaResponse> forBootVolumeReplica(BmcGenericWaiter waiter, GetBootVolumeReplicaRequest request, BootVolumeReplica.LifecycleState ... targetStates) {
        final HashSet<BootVolumeReplica.LifecycleState> targetStatesSet = new HashSet<BootVolumeReplica.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetBootVolumeReplicaRequest, GetBootVolumeReplicaResponse>(){

            @Override
            public GetBootVolumeReplicaResponse apply(GetBootVolumeReplicaRequest request) {
                return BlockstorageWaiters.this.client.getBootVolumeReplica(request);
            }
        }, (Predicate)new Predicate<GetBootVolumeReplicaResponse>(){
            final /* synthetic */ BlockstorageWaiters this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean test(GetBootVolumeReplicaResponse response) {
                return targetStatesSet.contains((Object)response.getBootVolumeReplica().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)BootVolumeReplica.LifecycleState.Terminated)), (Object)request);
    }

    public Waiter<GetVolumeRequest, GetVolumeResponse> forVolume(GetVolumeRequest request, Volume.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forVolume(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetVolumeRequest, GetVolumeResponse> forVolume(GetVolumeRequest request, Volume.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forVolume(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetVolumeRequest, GetVolumeResponse> forVolume(GetVolumeRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Volume.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forVolume(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetVolumeRequest, GetVolumeResponse> forVolume(BmcGenericWaiter waiter, GetVolumeRequest request, Volume.LifecycleState ... targetStates) {
        final HashSet<Volume.LifecycleState> targetStatesSet = new HashSet<Volume.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetVolumeRequest, GetVolumeResponse>(){

            @Override
            public GetVolumeResponse apply(GetVolumeRequest request) {
                return BlockstorageWaiters.this.client.getVolume(request);
            }
        }, (Predicate)new Predicate<GetVolumeResponse>(){
            final /* synthetic */ BlockstorageWaiters this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean test(GetVolumeResponse response) {
                return targetStatesSet.contains((Object)response.getVolume().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Volume.LifecycleState.Terminated)), (Object)request);
    }

    public Waiter<GetVolumeBackupRequest, GetVolumeBackupResponse> forVolumeBackup(GetVolumeBackupRequest request, VolumeBackup.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forVolumeBackup(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetVolumeBackupRequest, GetVolumeBackupResponse> forVolumeBackup(GetVolumeBackupRequest request, VolumeBackup.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forVolumeBackup(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetVolumeBackupRequest, GetVolumeBackupResponse> forVolumeBackup(GetVolumeBackupRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, VolumeBackup.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forVolumeBackup(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetVolumeBackupRequest, GetVolumeBackupResponse> forVolumeBackup(BmcGenericWaiter waiter, GetVolumeBackupRequest request, VolumeBackup.LifecycleState ... targetStates) {
        final HashSet<VolumeBackup.LifecycleState> targetStatesSet = new HashSet<VolumeBackup.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetVolumeBackupRequest, GetVolumeBackupResponse>(){

            @Override
            public GetVolumeBackupResponse apply(GetVolumeBackupRequest request) {
                return BlockstorageWaiters.this.client.getVolumeBackup(request);
            }
        }, (Predicate)new Predicate<GetVolumeBackupResponse>(){
            final /* synthetic */ BlockstorageWaiters this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean test(GetVolumeBackupResponse response) {
                return targetStatesSet.contains((Object)response.getVolumeBackup().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)VolumeBackup.LifecycleState.Terminated)), (Object)request);
    }

    public Waiter<GetVolumeGroupRequest, GetVolumeGroupResponse> forVolumeGroup(GetVolumeGroupRequest request, VolumeGroup.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forVolumeGroup(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetVolumeGroupRequest, GetVolumeGroupResponse> forVolumeGroup(GetVolumeGroupRequest request, VolumeGroup.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forVolumeGroup(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetVolumeGroupRequest, GetVolumeGroupResponse> forVolumeGroup(GetVolumeGroupRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, VolumeGroup.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forVolumeGroup(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetVolumeGroupRequest, GetVolumeGroupResponse> forVolumeGroup(BmcGenericWaiter waiter, GetVolumeGroupRequest request, VolumeGroup.LifecycleState ... targetStates) {
        final HashSet<VolumeGroup.LifecycleState> targetStatesSet = new HashSet<VolumeGroup.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetVolumeGroupRequest, GetVolumeGroupResponse>(){

            @Override
            public GetVolumeGroupResponse apply(GetVolumeGroupRequest request) {
                return BlockstorageWaiters.this.client.getVolumeGroup(request);
            }
        }, (Predicate)new Predicate<GetVolumeGroupResponse>(){
            final /* synthetic */ BlockstorageWaiters this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean test(GetVolumeGroupResponse response) {
                return targetStatesSet.contains((Object)response.getVolumeGroup().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)VolumeGroup.LifecycleState.Terminated)), (Object)request);
    }

    public Waiter<GetVolumeGroupBackupRequest, GetVolumeGroupBackupResponse> forVolumeGroupBackup(GetVolumeGroupBackupRequest request, VolumeGroupBackup.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forVolumeGroupBackup(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetVolumeGroupBackupRequest, GetVolumeGroupBackupResponse> forVolumeGroupBackup(GetVolumeGroupBackupRequest request, VolumeGroupBackup.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forVolumeGroupBackup(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetVolumeGroupBackupRequest, GetVolumeGroupBackupResponse> forVolumeGroupBackup(GetVolumeGroupBackupRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, VolumeGroupBackup.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forVolumeGroupBackup(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetVolumeGroupBackupRequest, GetVolumeGroupBackupResponse> forVolumeGroupBackup(BmcGenericWaiter waiter, GetVolumeGroupBackupRequest request, VolumeGroupBackup.LifecycleState ... targetStates) {
        final HashSet<VolumeGroupBackup.LifecycleState> targetStatesSet = new HashSet<VolumeGroupBackup.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetVolumeGroupBackupRequest, GetVolumeGroupBackupResponse>(){

            @Override
            public GetVolumeGroupBackupResponse apply(GetVolumeGroupBackupRequest request) {
                return BlockstorageWaiters.this.client.getVolumeGroupBackup(request);
            }
        }, (Predicate)new Predicate<GetVolumeGroupBackupResponse>(){
            final /* synthetic */ BlockstorageWaiters this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean test(GetVolumeGroupBackupResponse response) {
                return targetStatesSet.contains((Object)response.getVolumeGroupBackup().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)VolumeGroupBackup.LifecycleState.Terminated)), (Object)request);
    }

    public Waiter<GetVolumeGroupReplicaRequest, GetVolumeGroupReplicaResponse> forVolumeGroupReplica(GetVolumeGroupReplicaRequest request, VolumeGroupReplica.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forVolumeGroupReplica(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetVolumeGroupReplicaRequest, GetVolumeGroupReplicaResponse> forVolumeGroupReplica(GetVolumeGroupReplicaRequest request, VolumeGroupReplica.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forVolumeGroupReplica(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetVolumeGroupReplicaRequest, GetVolumeGroupReplicaResponse> forVolumeGroupReplica(GetVolumeGroupReplicaRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, VolumeGroupReplica.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forVolumeGroupReplica(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetVolumeGroupReplicaRequest, GetVolumeGroupReplicaResponse> forVolumeGroupReplica(BmcGenericWaiter waiter, GetVolumeGroupReplicaRequest request, VolumeGroupReplica.LifecycleState ... targetStates) {
        final HashSet<VolumeGroupReplica.LifecycleState> targetStatesSet = new HashSet<VolumeGroupReplica.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetVolumeGroupReplicaRequest, GetVolumeGroupReplicaResponse>(){

            @Override
            public GetVolumeGroupReplicaResponse apply(GetVolumeGroupReplicaRequest request) {
                return BlockstorageWaiters.this.client.getVolumeGroupReplica(request);
            }
        }, (Predicate)new Predicate<GetVolumeGroupReplicaResponse>(){
            final /* synthetic */ BlockstorageWaiters this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean test(GetVolumeGroupReplicaResponse response) {
                return targetStatesSet.contains((Object)response.getVolumeGroupReplica().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)VolumeGroupReplica.LifecycleState.Terminated)), (Object)request);
    }
}

